<div class="row">
<nav class="col-md-2" id="actions-sidebar">
    <ul class="nav nav-pills nav-stacked">
        <li class="active"><a><?= __('Actions') ?></a></li>
        <li><?= $this->Html->link(__('New {0}', ['Surgical Tev Protocol']), ['action' => 'add']) ?></li>
        <li><?= $this->Html->link(__('List {0}', ['Hospitalizations']), ['controller' => 'Hospitalizations', 'action' => 'index']) ?></li>
        <li><?= $this->Html->link(__('New {0}', ['Hospitalization']), ['controller' => 'Hospitalizations', 'action' => 'add']) ?></li>
        <li><?= $this->Html->link(__('List {0}', ['Tev Options']), ['controller' => 'TevOptions', 'action' => 'index']) ?></li>
        <li><?= $this->Html->link(__('New {0}', ['Tev Option']), ['controller' => 'TevOptions', 'action' => 'add']) ?></li>
    </ul>
</nav>
<div class="surgicalTevProtocols index col-md-10 columns content">
    <h3>Surgical Tev Protocols</h3>
    <table class="table table-striped table-hover">
        <thead>
            <tr>
                <th><?= $this->Paginator->sort('id') ?></th>
                <th><?= $this->Paginator->sort('created') ?></th>
                <th><?= $this->Paginator->sort('hospitalization_id') ?></th>
                <th><?= $this->Paginator->sort('is_active') ?></th>
                <th><?= $this->Paginator->sort('risco_da_cirurgica') ?></th>
                <th><?= $this->Paginator->sort('duracao_da_cirurgia') ?></th>
                <th><?= $this->Paginator->sort('fatores_de_risco_tev') ?></th>
                <th class="actions"><?= __('Actions') ?></th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($surgicalTevProtocols as $surgicalTevProtocol): ?>
            <tr>
                <td><?= $this->Number->format($surgicalTevProtocol->id) ?></td>
                <td><?= h($surgicalTevProtocol->created) ?></td>
                <td><?= $surgicalTevProtocol->has('hospitalization') ? $this->Html->link($surgicalTevProtocol->hospitalization->id, ['controller' => 'Hospitalizations', 'action' => 'view', $surgicalTevProtocol->hospitalization->id]) : '' ?></td>
                <td><?= h($surgicalTevProtocol->is_active) ?></td>
                <td><?= h($surgicalTevProtocol->risco_da_cirurgica) ?></td>
                <td><?= h($surgicalTevProtocol->duracao_da_cirurgia) ?></td>
                <td><?= h($surgicalTevProtocol->fatores_de_risco_tev) ?></td>
                <td class="actions" style="white-space:nowrap">
                    <?= $this->Html->link(__('View'), ['action' => 'view', $surgicalTevProtocol->id], ['class'=>'btn btn-default btn-xs']) ?>
                    <?= $this->Html->link(__('Edit'), ['action' => 'edit', $surgicalTevProtocol->id], ['class'=>'btn btn-primary btn-xs']) ?>
                    <?= $this->Form->postLink(__('Delete'), ['action' => 'delete', $surgicalTevProtocol->id], ['confirm' => __('Are you sure you want to delete # {0}?', $surgicalTevProtocol->id), 'class'=>'btn btn-danger btn-xs']) ?>
                </td>
            </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
    <div class="paginator">
        <center>
            <ul class="pagination">
                <?= $this->Paginator->prev('&laquo; ' . __('previous'), ['escape'=>false]) ?>
                <?= $this->Paginator->numbers(['escape'=>false]) ?>
                <?= $this->Paginator->next(__('next') . ' &raquo;', ['escape'=>false]) ?>
            </ul>
            <p><?= $this->Paginator->counter(__('Page {{page}} of {{pages}}, showing {{current}} records out of
         {{count}} total, starting on record {{start}}, ending on {{end}}')) ?></p>
        </div>
    </center>
</div>
</div>