<?php
namespace App\Controller;

use App\Controller\AppController;

/**
 * ComorbiditiesDiagnostics Controller
 *
 * @property \App\Model\Table\ComorbiditiesDiagnosticsTable $ComorbiditiesDiagnostics
 */
class ComorbiditiesDiagnosticsController extends AppController
{

    /**
     * Index method
     *
     * @return \Cake\Network\Response|null
     */
    public function index()
    {
        $this->paginate = [
            'contain' => ['Comorbidities', 'Diagnostics']
        ];
        $comorbiditiesDiagnostics = $this->paginate($this->ComorbiditiesDiagnostics);

        $this->set(compact('comorbiditiesDiagnostics'));
        $this->set('_serialize', ['comorbiditiesDiagnostics']);
        
    }

    /**
     * View method
     *
     * @param string|null $id Comorbidities Diagnostic id.
     * @return \Cake\Network\Response|null
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function view($id = null)
    {
        $comorbiditiesDiagnostic = $this->ComorbiditiesDiagnostics->get($id, [
            'contain' => ['Comorbidities', 'Diagnostics']
        ]);

        $this->set('comorbiditiesDiagnostic', $comorbiditiesDiagnostic);
        $this->set('_serialize', ['comorbiditiesDiagnostic']);
    }

    /**
     * Add method
     *
     * @return \Cake\Network\Response|void Redirects on successful add, renders view otherwise.
     */
    public function add()
    {
        $comorbiditiesDiagnostic = $this->ComorbiditiesDiagnostics->newEntity();
        if ($this->request->is('post')) {
            $comorbiditiesDiagnostic = $this->ComorbiditiesDiagnostics->patchEntity($comorbiditiesDiagnostic, $this->request->data);
            if ($this->ComorbiditiesDiagnostics->save($comorbiditiesDiagnostic)) {
                $this->Flash->success(__('The comorbidities diagnostic has been saved.'));
                return $this->redirect(['action' => 'index']);
            } else {
                $this->Flash->error(__('The comorbidities diagnostic could not be saved. Please, try again.'));
            }
        }
        $comorbidities = $this->ComorbiditiesDiagnostics->Comorbidities->find('list', ['limit' => 200]);
        $diagnostics = $this->ComorbiditiesDiagnostics->Diagnostics->find('list', ['limit' => 200]);
        $this->set(compact('comorbiditiesDiagnostic', 'comorbidities', 'diagnostics'));
        $this->set('_serialize', ['comorbiditiesDiagnostic']);
    }

    /**
     * Edit method
     *
     * @param string|null $id Comorbidities Diagnostic id.
     * @return \Cake\Network\Response|void Redirects on successful edit, renders view otherwise.
     * @throws \Cake\Network\Exception\NotFoundException When record not found.
     */
    public function edit($id = null)
    {
        $comorbiditiesDiagnostic = $this->ComorbiditiesDiagnostics->get($id, [
            'contain' => []
        ]);
        if ($this->request->is(['patch', 'post', 'put'])) {
            $comorbiditiesDiagnostic = $this->ComorbiditiesDiagnostics->patchEntity($comorbiditiesDiagnostic, $this->request->data);
            if ($this->ComorbiditiesDiagnostics->save($comorbiditiesDiagnostic)) {
                $this->Flash->success(__('The comorbidities diagnostic has been saved.'));
                return $this->redirect(['action' => 'index']);
            } else {
                $this->Flash->error(__('The comorbidities diagnostic could not be saved. Please, try again.'));
            }
        }
        $comorbidities = $this->ComorbiditiesDiagnostics->Comorbidities->find('list', ['limit' => 200]);
        $diagnostics = $this->ComorbiditiesDiagnostics->Diagnostics->find('list', ['limit' => 200]);
        $this->set(compact('comorbiditiesDiagnostic', 'comorbidities', 'diagnostics'));
        $this->set('_serialize', ['comorbiditiesDiagnostic']);
    }

    /**
     * Delete method
     *
     * @param string|null $id Comorbidities Diagnostic id.
     * @return \Cake\Network\Response|null Redirects to index.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function delete($id = null)
    {
        $this->request->allowMethod(['post', 'delete']);
        $comorbiditiesDiagnostic = $this->ComorbiditiesDiagnostics->get($id);
        if ($this->ComorbiditiesDiagnostics->delete($comorbiditiesDiagnostic)) {
            $this->Flash->success(__('The comorbidities diagnostic has been deleted.'));
        } else {
            $this->Flash->error(__('The comorbidities diagnostic could not be deleted. Please, try again.'));
        }
        return $this->redirect(['action' => 'index']);
    }
}
