<?php
namespace App\Controller;

use App\Controller\AppController;

/**
 * MedicalOpinionAnswers Controller
 *
 * @property \App\Model\Table\MedicalOpinionAnswersTable $MedicalOpinionAnswers
 */
class MedicalOpinionAnswersController extends AppController
{
    public function initialize() {
        parent::initialize();

        $this->loadComponent('Permission');

        // View or Controller
        $this->set('title', 'Parecer Médico');

        $session = $this->request->session();
        $pacient_id = $session->read('selected-pacient');
        $this->set('pacient_id', $pacient_id);

        $unit_id = $session->read('selected-unit');
        $this->set('unit_id', $unit_id);
    }

    public function isAuthorized($user) 
    {
        $action = $this->request->params['action'];

        return $this->Permission->hasPermission($user['role_name'], 'MedicalOpinionAnswers', $action);
        //return parent::isAuthorized($user);
    }

    /**
     * Index method
     *
     * @return \Cake\Network\Response|null
     */
    public function index()
    {
        $this->paginate = [
            'contain' => ['MedicalOpinionRequests', 'Users']
        ];
        $medicalOpinionAnswers = $this->paginate($this->MedicalOpinionAnswers);

        $this->set(compact('medicalOpinionAnswers'));
        $this->set('_serialize', ['medicalOpinionAnswers']);
    }

    /**
     * View method
     *
     * @param string|null $id Medical Opinion Answer id.
     * @return \Cake\Network\Response|null
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function view($id = null)
    {
        $medicalOpinionAnswer = $this->MedicalOpinionAnswers->get($id, [
            'contain' => ['MedicalOpinionRequests', 'Users']
        ]);

        $this->set('medicalOpinionAnswer', $medicalOpinionAnswer);
        $this->set('_serialize', ['medicalOpinionAnswer']);
    }

    /**
     * Add method
     *
     * @return \Cake\Network\Response|void Redirects on successful add, renders view otherwise.
     */
    public function add($medicalOpinionRequest_id = null)
    {
        $medicalOpinionAnswer = $this->MedicalOpinionAnswers->newEntity();

        if ($this->request->is('post')) 
        {
            $medicalOpinionAnswer = $this->MedicalOpinionAnswers->patchEntity($medicalOpinionAnswer, $this->request->data);

            if ($this->MedicalOpinionAnswers->save($medicalOpinionAnswer)) 
            {
                $this->Flash->success(__('A sua resposta foi salva.'));
                return $this->redirect(['controller'=>'MedicalOpinionRequests','action' => 'view', $medicalOpinionRequest_id]);
            } 
            else 
            {
                $this->Flash->error(__('A sua resposta não pode ser salva. Por favor, tente novamente.'));
            }
        }

        $this->set('medicalOpinionRequest_id', $medicalOpinionRequest_id);
        $medicalOpinionRequests = $this->MedicalOpinionAnswers->MedicalOpinionRequests->find('list', ['limit' => 200]);
        $users = $this->MedicalOpinionAnswers->Users->find('list', ['limit' => 200]);
        $this->set(compact('medicalOpinionAnswer', 'medicalOpinionRequests', 'users'));
        $this->set('_serialize', ['medicalOpinionAnswer']);
    }

    /**
     * Edit method
     *
     * @param string|null $id Medical Opinion Answer id.
     * @return \Cake\Network\Response|void Redirects on successful edit, renders view otherwise.
     * @throws \Cake\Network\Exception\NotFoundException When record not found.
     */
    public function edit($request_id = null, $answer_id = null)
    {
        $medicalOpinionAnswer = '';
       
        if ($answer_id === null)
        {
                    $medicalOpinionAnswer = $this->MedicalOpinionAnswers->newEntity();
        }
        else
        {
             $medicalOpinionAnswer = $this->MedicalOpinionAnswers->get($answer_id, [
            'contain' => []
        ]);
        }

        if ($this->request->is(['patch', 'post', 'put'])) 
        {
            $medicalOpinionAnswer = $this->MedicalOpinionAnswers->patchEntity($medicalOpinionAnswer, $this->request->data);
            if ($this->MedicalOpinionAnswers->save($medicalOpinionAnswer)) 
            {
                $this->Flash->success(__('The medical opinion answer has been saved.'));
                return $this->redirect(['controller'=>'MedicalOpinionRequests','action' => 'view', $request_id]);
            } 
            else 
            {
                $this->Flash->error(__('The medical opinion answer could not be saved. Please, try again.'));
            }
        }

        $this->set('medicalOpinionRequest_id', $request_id);
        $medicalOpinionRequests = $this->MedicalOpinionAnswers->MedicalOpinionRequests->find('list', ['limit' => 200]);
        $users = $this->MedicalOpinionAnswers->Users->find('list', ['limit' => 200]);
        $this->set(compact('medicalOpinionAnswer', 'medicalOpinionRequests', 'users'));
        $this->set('_serialize', ['medicalOpinionAnswer']);
    }

    /**
     * Delete method
     *
     * @param string|null $id Medical Opinion Answer id.
     * @return \Cake\Network\Response|null Redirects to index.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function delete($id = null)
    {
        $this->request->allowMethod(['post', 'delete']);
        $medicalOpinionAnswer = $this->MedicalOpinionAnswers->get($id);
        if ($this->MedicalOpinionAnswers->delete($medicalOpinionAnswer)) {
            $this->Flash->success(__('The medical opinion answer has been deleted.'));
        } else {
            $this->Flash->error(__('The medical opinion answer could not be deleted. Please, try again.'));
        }
        return $this->redirect(['action' => 'index']);
    }
}
