<?php
namespace App\Controller;

use App\Controller\AppController;

/**
 * OtherComorbiditiesDiagnostics Controller
 *
 * @property \App\Model\Table\OtherComorbiditiesDiagnosticsTable $OtherComorbiditiesDiagnostics
 */
class OtherComorbiditiesDiagnosticsController extends AppController
{

    /**
     * Index method
     *
     * @return \Cake\Network\Response|null
     */
    public function index()
    {
        $this->paginate = [
            'contain' => ['OtherComorbidities', 'Diagnostics']
        ];
        $otherComorbiditiesDiagnostics = $this->paginate($this->OtherComorbiditiesDiagnostics);

        $this->set(compact('otherComorbiditiesDiagnostics'));
        $this->set('_serialize', ['otherComorbiditiesDiagnostics']);
    }

    /**
     * View method
     *
     * @param string|null $id Other Comorbidities Diagnostic id.
     * @return \Cake\Network\Response|null
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function view($id = null)
    {
        $otherComorbiditiesDiagnostic = $this->OtherComorbiditiesDiagnostics->get($id, [
            'contain' => ['OtherComorbidities', 'Diagnostics']
        ]);

        $this->set('otherComorbiditiesDiagnostic', $otherComorbiditiesDiagnostic);
        $this->set('_serialize', ['otherComorbiditiesDiagnostic']);
    }

    /**
     * Add method
     *
     * @return \Cake\Network\Response|void Redirects on successful add, renders view otherwise.
     */
    public function add()
    {
        $otherComorbiditiesDiagnostic = $this->OtherComorbiditiesDiagnostics->newEntity();
        if ($this->request->is('post')) {
            $otherComorbiditiesDiagnostic = $this->OtherComorbiditiesDiagnostics->patchEntity($otherComorbiditiesDiagnostic, $this->request->data);
            if ($this->OtherComorbiditiesDiagnostics->save($otherComorbiditiesDiagnostic)) {
                $this->Flash->success(__('The other comorbidities diagnostic has been saved.'));
                return $this->redirect(['action' => 'index']);
            } else {
                $this->Flash->error(__('The other comorbidities diagnostic could not be saved. Please, try again.'));
            }
        }
        $otherComorbidities = $this->OtherComorbiditiesDiagnostics->OtherComorbidities->find('list', ['limit' => 200]);
        $diagnostics = $this->OtherComorbiditiesDiagnostics->Diagnostics->find('list', ['limit' => 200]);
        $this->set(compact('otherComorbiditiesDiagnostic', 'otherComorbidities', 'diagnostics'));
        $this->set('_serialize', ['otherComorbiditiesDiagnostic']);
    }

    /**
     * Edit method
     *
     * @param string|null $id Other Comorbidities Diagnostic id.
     * @return \Cake\Network\Response|void Redirects on successful edit, renders view otherwise.
     * @throws \Cake\Network\Exception\NotFoundException When record not found.
     */
    public function edit($id = null)
    {
        $otherComorbiditiesDiagnostic = $this->OtherComorbiditiesDiagnostics->get($id, [
            'contain' => []
        ]);
        if ($this->request->is(['patch', 'post', 'put'])) {
            $otherComorbiditiesDiagnostic = $this->OtherComorbiditiesDiagnostics->patchEntity($otherComorbiditiesDiagnostic, $this->request->data);
            if ($this->OtherComorbiditiesDiagnostics->save($otherComorbiditiesDiagnostic)) {
                $this->Flash->success(__('The other comorbidities diagnostic has been saved.'));
                return $this->redirect(['action' => 'index']);
            } else {
                $this->Flash->error(__('The other comorbidities diagnostic could not be saved. Please, try again.'));
            }
        }
        $otherComorbidities = $this->OtherComorbiditiesDiagnostics->OtherComorbidities->find('list', ['limit' => 200]);
        $diagnostics = $this->OtherComorbiditiesDiagnostics->Diagnostics->find('list', ['limit' => 200]);
        $this->set(compact('otherComorbiditiesDiagnostic', 'otherComorbidities', 'diagnostics'));
        $this->set('_serialize', ['otherComorbiditiesDiagnostic']);
    }

    /**
     * Delete method
     *
     * @param string|null $id Other Comorbidities Diagnostic id.
     * @return \Cake\Network\Response|null Redirects to index.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function delete($id = null)
    {
        $this->request->allowMethod(['post', 'delete']);
        $otherComorbiditiesDiagnostic = $this->OtherComorbiditiesDiagnostics->get($id);
        if ($this->OtherComorbiditiesDiagnostics->delete($otherComorbiditiesDiagnostic)) {
            $this->Flash->success(__('The other comorbidities diagnostic has been deleted.'));
        } else {
            $this->Flash->error(__('The other comorbidities diagnostic could not be deleted. Please, try again.'));
        }
        return $this->redirect(['action' => 'index']);
    }
}
