<?php
namespace App\Controller;

use App\Controller\AppController;

/**
 * SafeSurgeryDiaryBundles Controller
 *
 * @property \App\Model\Table\SafeSurgeryDiaryBundlesTable $SafeSurgeryDiaryBundles
 */
class SafeSurgeryDiaryBundlesController extends AppController
{
    public function initialize()
    {
        parent::initialize();
        $this->loadComponent('Auth', [
            'authorize' => 'Controller',
        ]);
        $this->loadComponent('Permission');

        // View or Controller
        $this->set('title', 'Escores');

        $session = $this->request->session();

        $pacient_id = $session->read('selected-pacient');
        $this->set('pacient_id', $pacient_id);

        $unit_id = $session->read('selected-unit');
        $this->set('unit_id', $unit_id);

        $hospitalization_id = $session->read('selected-hospitalization');
        $this->set('hospitalization_id', $hospitalization_id);

        $bundle_id = $session->read('bundle_id');
        $this->set('bundle_id', $bundle_id);
    }

    public function isAuthorized($user)
    {
        $action = $this->request->params['action'];

        return $this->Permission->hasPermission($user['role_name'], 'ApacheIiScores', $action);
        //return parent::isAuthorized($user);
    }

    /**
     * Index method
     *
     * @return \Cake\Network\Response|null
     */
    public function index($bundle_id)
    {
        $session = $this->request->session();
        $session->write('bundle_id', $bundle_id);

        $this->paginate = [
            'contain'    => ['SafeSurgeryBundles'],
            'conditions' => ['SafeSurgeryDiaryBundles.safe_surgery_bundle_id' => $bundle_id],
        ];
        $safeSurgeryDiaryBundles = $this->paginate($this->SafeSurgeryDiaryBundles);

        $this->set(compact('safeSurgeryDiaryBundles', 'bundle_id'));
        $this->set('_serialize', ['safeSurgeryDiaryBundles']);
    }

    /**
     * View method
     *
     * @param string|null $id Safe Surgery Diary Bundle id.
     * @return \Cake\Network\Response|null
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function view($id = null)
    {
        $safeSurgeryDiaryBundle = $this->SafeSurgeryDiaryBundles->get($id, [
            'contain' => ['SafeSurgeryBundles'],
        ]);

        $this->set('safeSurgeryDiaryBundle', $safeSurgeryDiaryBundle);
        $this->set('_serialize', ['safeSurgeryDiaryBundle']);
    }

    /**
     * Add method
     *
     * @return \Cake\Network\Response|void Redirects on successful add, renders view otherwise.
     */
    public function add($id)
    {
        $session      = $this->request->session();
        $bundle_id    = $session->read('bundle_id');
        $hasSuspensao = false;

        $dummyBundle = $this->SafeSurgeryDiaryBundles->find('all', [
            'conditions' => [
                'SafeSurgeryDiaryBundles.safe_surgery_bundle_id'          => $bundle_id,
                'SafeSurgeryDiaryBundles.suspensao_antibioticoprofilaxia' => 1,
            ],
        ]);
        if (!$dummyBundle->isEmpty()) {
            // Query or result set is empty
            $hasSuspensao = true;
        }

        $safeSurgeryDiaryBundle = $this->SafeSurgeryDiaryBundles->newEntity();
        if ($this->request->is('post')) {
            $safeSurgeryDiaryBundle = $this->SafeSurgeryDiaryBundles->patchEntity($safeSurgeryDiaryBundle, $this->request->data);

            $safeSurgeryDiaryBundle->safe_surgery_bundle_id = $bundle_id;
            if ($this->SafeSurgeryDiaryBundles->save($safeSurgeryDiaryBundle)) {
                $this->Flash->success(__('The safe surgery diary bundle has been saved.'));
                return $this->redirect(['action' => 'index', $id]);
            } else {
                $this->Flash->error(__('The safe surgery diary bundle could not be saved. Please, try again.'));
            }
        }
        $this->set(compact('safeSurgeryDiaryBundle', 'safeSurgeryBundles', 'hasSuspensao'));
        $this->set('_serialize', ['safeSurgeryDiaryBundle']);
    }

    /**
     * Edit method
     *
     * @param string|null $id Safe Surgery Diary Bundle id.
     * @return \Cake\Network\Response|void Redirects on successful edit, renders view otherwise.
     * @throws \Cake\Network\Exception\NotFoundException When record not found.
     */
    public function edit($id = null)
    {
        $safeSurgeryDiaryBundle = $this->SafeSurgeryDiaryBundles->get($id, [
            'contain' => [],
        ]);

        $session   = $this->request->session();
        $bundle_id = $session->read('bundle_id');

        if ($this->request->is(['patch', 'post', 'put'])) {
            $safeSurgeryDiaryBundle = $this->SafeSurgeryDiaryBundles->patchEntity($safeSurgeryDiaryBundle, $this->request->data);
            if ($this->SafeSurgeryDiaryBundles->save($safeSurgeryDiaryBundle)) {
                $this->Flash->success(__('The safe surgery diary bundle has been saved.'));
                return $this->redirect(['action' => 'index', $bundle_id]);

            } else {
                $this->Flash->error(__('The safe surgery diary bundle could not be saved. Please, try again.'));
            }
        }
        $safeSurgeryBundles = $this->SafeSurgeryDiaryBundles->SafeSurgeryBundles->find('list', ['limit' => 200]);
        $this->set(compact('safeSurgeryDiaryBundle', 'safeSurgeryBundles'));
        $this->set('_serialize', ['safeSurgeryDiaryBundle']);
    }

    /**
     * Delete method
     *
     * @param string|null $id Safe Surgery Diary Bundle id.
     * @return \Cake\Network\Response|null Redirects to index.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function delete($id = null)
    {
        $this->request->allowMethod(['post', 'delete']);
        $safeSurgeryDiaryBundle = $this->SafeSurgeryDiaryBundles->get($id);
        if ($this->SafeSurgeryDiaryBundles->delete($safeSurgeryDiaryBundle)) {
            $this->Flash->success(__('The safe surgery diary bundle has been deleted.'));
        } else {
            $this->Flash->error(__('The safe surgery diary bundle could not be deleted. Please, try again.'));
        }
        return $this->redirect(['action' => 'index']);
    }
}
