<?php
namespace App\Controller;

use App\Controller\AppController;

/**
 * SurgicalComplications Controller
 *
 * @property \App\Model\Table\SurgicalComplicationsTable $SurgicalComplications
 */
class SurgicalComplicationsController extends AppController
{
    public function initialize()
    {
        parent::initialize();
        $this->loadComponent('Permission');
        $this->loadComponent('Upload');
        $this->set('title', 'Complicações Cirurgicas');
    }

    public function isAuthorized($user)
    {
        return true;
        $action = $this->request->params['action'];

        return $this->Permission->hasPermission($user['role_name'], 'units', $action);
    }

    /**
     * Index method
     *
     * @return \Cake\Network\Response|null
     */
    public function index()
    {
        $surgicalComplication = $this->SurgicalComplications->newEntity();

        $this->paginate = [
            'contain' => ['Units'],
        ];

        if ($this->request->is('post')) {
            $surgicalComplication = $this->SurgicalComplications->patchEntity($surgicalComplication, $this->request->data);
            if ($this->SurgicalComplications->save($surgicalComplication)) {
                $this->Flash->success(__('O registro foi salvo.'));
                return $this->redirect(['action' => 'index']);
            } else {
                $this->Flash->error(__('O registro não pode ser salvo. Por favor, tente novamente.'));
            }
        }

        $surgicalComplications = $this->paginate($this->SurgicalComplications);

        $this->set(compact('surgicalComplications', 'surgicalComplication'));
        $this->set('_serialize', ['surgicalComplications', 'surgicalComplication']);
    }

    /**
     * View method
     *
     * @param string|null $id Surgical Complication id.
     * @return \Cake\Network\Response|null
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function view($id = null)
    {
        $surgicalComplication = $this->SurgicalComplications->get($id, [
            'contain' => ['Units', 'Surgeries'],
        ]);

        $this->set('surgicalComplication', $surgicalComplication);
        $this->set('_serialize', ['surgicalComplication']);
    }

    /**
     * Add method
     *
     * @return \Cake\Network\Response|void Redirects on successful add, renders view otherwise.
     */
    public function add()
    {
        $surgicalComplication = $this->SurgicalComplications->newEntity();
        if ($this->request->is('post')) {
            $surgicalComplication = $this->SurgicalComplications->patchEntity($surgicalComplication, $this->request->data);
            if ($this->SurgicalComplications->save($surgicalComplication)) {
                $this->Flash->success(__('The surgical complication has been saved.'));
                return $this->redirect(['action' => 'index']);
            } else {
                $this->Flash->error(__('The surgical complication could not be saved. Please, try again.'));
            }
        }
        $units     = $this->SurgicalComplications->Units->find('list', ['limit' => 200]);
        $surgeries = $this->SurgicalComplications->Surgeries->find('list', ['limit' => 200]);
        $this->set(compact('surgicalComplication', 'units', 'surgeries'));
        $this->set('_serialize', ['surgicalComplication']);
    }

    /**
     * Edit method
     *
     * @param string|null $id Surgical Complication id.
     * @return \Cake\Network\Response|void Redirects on successful edit, renders view otherwise.
     * @throws \Cake\Network\Exception\NotFoundException When record not found.
     */
    public function edit($id = null)
    {
        $surgicalComplication = $this->SurgicalComplications->get($id, [
            'contain' => ['Surgeries'],
        ]);
        if ($this->request->is(['patch', 'post', 'put'])) {
            $surgicalComplication = $this->SurgicalComplications->patchEntity($surgicalComplication, $this->request->data);
            if ($this->SurgicalComplications->save($surgicalComplication)) {
                $this->Flash->success(__('The surgical complication has been saved.'));
                return $this->redirect(['action' => 'index']);
            } else {
                $this->Flash->error(__('The surgical complication could not be saved. Please, try again.'));
            }
        }
        $units     = $this->SurgicalComplications->Units->find('list', ['limit' => 200]);
        $surgeries = $this->SurgicalComplications->Surgeries->find('list', ['limit' => 200]);
        $this->set(compact('surgicalComplication', 'units', 'surgeries'));
        $this->set('_serialize', ['surgicalComplication']);
    }

    /**
     * Delete method
     *
     * @param string|null $id Surgical Complication id.
     * @return \Cake\Network\Response|null Redirects to index.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function delete($id = null)
    {
        $this->request->allowMethod(['post', 'delete']);
        $surgicalComplication = $this->SurgicalComplications->get($id);
        if ($this->SurgicalComplications->delete($surgicalComplication)) {
            $this->Flash->success(__('O registro foi deletado.'));
        } else {
            $this->Flash->error(__('O registro não pode ser deletado. Por favor, tente novamente.'));
        }
        return $this->redirect(['action' => 'index']);
    }
}
