<?php
namespace App\Model\Entity;

use Cake\ORM\Entity;

/**
 * Discharge Entity.
 *
 * @property int $id
 * @property \Cake\I18n\Time $data_previsao_alta_unidade
 * @property \Cake\I18n\Time $hora_previsao_alta_unidade
 * @property \Cake\I18n\Time $data_decisao_alta_unidade
 * @property \Cake\I18n\Time $hora_decisao_alta_unidade
 * @property \Cake\I18n\Time $data_saida_unidade
 * @property \Cake\I18n\Time $hora_saida_unidade
 * @property string $destino_apos_alta
 * @property string $nome_do_destino_apos_alta
 * @property string $condicao_clinica
 * @property bool $atendimento_ambulatorial
 * @property bool $entregue_o_resumo
 * @property bool $entregue_prescricao_domiciliar
 * @property bool $entregue_as_orientacoes
 * @property bool $houve_decisao_para_cuidados
 * @property \Cake\I18n\Time $data_decisao_para_cuidados
 * @property bool $realizado_pps2
 * @property string $resultado_pps
 * @property \Cake\I18n\Time $created
 * @property int $hospitalization_id
 * @property \App\Model\Entity\Hospitalization $hospitalization
 * @property int $sector_id
 * @property \App\Model\Entity\Specialty[] $specialties
 */
class Discharge extends Entity
{

    /**
     * Fields that can be mass assigned using newEntity() or patchEntity().
     *
     * Note that when '*' is set to true, this allows all unspecified fields to
     * be mass assigned. For security purposes, it is advised to set '*' to false
     * (or remove it), and explicitly make individual fields accessible as needed.
     *
     * @var array
     */
    protected $_accessible = [
        '*' => true,
        'id' => false,
    ];
}
