<?php
namespace App\Model\Entity;

use Cake\ORM\Entity;

/**
 * MedicalCare Entity.
 *
 * @property int $id
 * @property int $screening_id
 * @property \App\Model\Entity\Screening $screening
 * @property bool $is_active
 * @property \Cake\I18n\Time $created
 * @property string $hda
 * @property bool $isolamento
 * @property string $motivo_isolamento
 * @property string $hpp
 * @property string $outras_patologias
 * @property string $status
 * @property string $pre_deliric
 * @property string $glasgow
 * @property string $rass
 * @property string $cpot
 * @property string $sofa
 * @property string $plano_terapeutico
 * @property \App\Model\Entity\Diagnostic[] $diagnostics
 * @property \App\Model\Entity\MedicationReconciliation[] $medication_reconciliations
 */
class MedicalCare extends Entity
{

    /**
     * Fields that can be mass assigned using newEntity() or patchEntity().
     *
     * Note that when '*' is set to true, this allows all unspecified fields to
     * be mass assigned. For security purposes, it is advised to set '*' to false
     * (or remove it), and explicitly make individual fields accessible as needed.
     *
     * @var array
     */
    protected $_accessible = [
        '*' => true,
        'id' => false,
    ];
}
