<?php
namespace App\Model\Table;

use App\Model\Entity\Specialty;
use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * Specialties Model
 *
 * @property \Cake\ORM\Association\HasMany $MedicalOpinionRequests
 * @property \Cake\ORM\Association\BelongsToMany $Discharges
 * @property \Cake\ORM\Association\BelongsToMany $Professionals
 * @property \Cake\ORM\Association\BelongsToMany $Surgeries
 */
class AuxiliarySpecialtiesTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->table('specialties');
        $this->displayField('name');
        $this->primaryKey('id');

        $this->belongsToMany('Surgeries', [
            'foreignKey' => 'auxiliary_specialty_id',
            'targetForeignKey' => 'surgery_id',
            'joinTable' => 'auxiliary_specialties_surgeries'
        ]);
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('id')
            ->allowEmpty('id', 'create');

        $validator
            ->requirePresence('name', 'create')
            ->notEmpty('name');

        return $validator;
    }
}
