<?php
namespace App\Model\Table;

use App\Model\Entity\AuxiliarySpecialtiesSurgery;
use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * AuxiliarySpecialtiesSurgeries Model
 *
 * @property \Cake\ORM\Association\BelongsTo $Specialties
 * @property \Cake\ORM\Association\BelongsTo $Surgeries
 */
class ChangeSpecialtiesSurgeriesTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->table('change_specialties_surgeries');
        $this->displayField('id');
        $this->primaryKey('id');

        $this->belongsTo('ChangeSpecialties', [
            'foreignKey' => 'change_specialty_id',
            'joinType' => 'INNER'
        ]);

        $this->belongsTo('Surgeries', [
            'foreignKey' => 'surgery_id',
            'joinType' => 'INNER'
        ]);
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('id')
            ->allowEmpty('id', 'create');

        return $validator;
    }

    /**
     * Returns a rules checker object that will be used for validating
     * application integrity.
     *
     * @param \Cake\ORM\RulesChecker $rules The rules object to be modified.
     * @return \Cake\ORM\RulesChecker
     */
    public function buildRules(RulesChecker $rules)
    {
        $rules->add($rules->existsIn(['change_specialty_id'], 'ChangeSpecialties'));
        $rules->add($rules->existsIn(['surgery_id'], 'Surgeries'));
        return $rules;
    }
}
