<?php
namespace App\Model\Table;

use App\Model\Entity\ChangeTypeOfAnesthesiasSurgery;
use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * ChangeTypeOfAnesthesiasSurgeries Model
 *
 * @property \Cake\ORM\Association\BelongsTo $ChangeTypeOfAnesthesias
 * @property \Cake\ORM\Association\BelongsTo $Surgeries
 */
class ChangeTypeOfAnesthesiasSurgeriesTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->table('change_type_of_anesthesias_surgeries');
        $this->displayField('id');
        $this->primaryKey('id');

        $this->belongsTo('ChangeTypeOfAnesthesias', [
            'foreignKey' => 'change_type_of_anesthesia_id',
            'joinType' => 'INNER'
        ]);
        $this->belongsTo('Surgeries', [
            'foreignKey' => 'surgery_id',
            'joinType' => 'INNER'
        ]);
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('id')
            ->allowEmpty('id', 'create');

        return $validator;
    }

    /**
     * Returns a rules checker object that will be used for validating
     * application integrity.
     *
     * @param \Cake\ORM\RulesChecker $rules The rules object to be modified.
     * @return \Cake\ORM\RulesChecker
     */
    public function buildRules(RulesChecker $rules)
    {
        $rules->add($rules->existsIn(['change_type_of_anesthesia_id'], 'ChangeTypeOfAnesthesias'));
        $rules->add($rules->existsIn(['surgery_id'], 'Surgeries'));
        return $rules;
    }
}
