<?php
namespace App\Model\Table;

use App\Model\Entity\DailyItuPreventionBundle;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;
use MedidasDispersao\MedidasDispersao;

require_once ROOT . DS . "vendor" . DS . "Zurubabel" . DS . "MedidasDispersao.php";

/**
 * DailyItuPreventionBundles Model
 *
 * @property \Cake\ORM\Association\BelongsTo $ItuPreventionBundles
 */
class DailyItuPreventionBundlesTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->table('daily_itu_prevention_bundles');
        $this->displayField('id');
        $this->primaryKey('id');

        $this->addBehavior('Timestamp');

        $this->belongsTo('ItuPreventionBundles', [
            'foreignKey' => 'itu_prevention_bundle_id',
            'joinType' => 'INNER',
        ]);
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('id')
            ->allowEmpty('id', 'create');

        $validator
            ->boolean('curativo')
            ->allowEmpty('curativo');

        $validator
            ->boolean('presenca_sangue')
            ->allowEmpty('presenca_sangue');

        $validator
            ->boolean('presenca_secrecao')
            ->allowEmpty('presenca_secrecao');

        $validator
            ->boolean('cateter_devidamente')
            ->allowEmpty('cateter_devidamente');

        $validator
            ->boolean('conector_exposto')
            ->allowEmpty('conector_exposto');

        $validator
            ->boolean('via_cateter')
            ->allowEmpty('via_cateter');

        $validator
            ->boolean('administracao')
            ->allowEmpty('administracao');

        $validator
            ->boolean('avaliado_a_retirada')
            ->allowEmpty('avaliado_a_retirada');

        $validator
            ->boolean('active')
            ->allowEmpty('active');

        return $validator;
    }

    public function getRelatorioData($hospitalizations)
    {
        $calc_obj = new MedidasDispersao();

        $data =
            [
            'total_de_registros' => 0,
        ];
        $percentual = [];

        foreach ($hospitalizations as $hospitalization)
        {
            //$data = $hospitalization["neonatal_checklists"];
            foreach ($hospitalization['itu_prevention_bundles'] as $key_1 => $bundle)
            {
                foreach ($bundle["daily_itu_prevention_bundles"] as $daily_bundle)
                {
                    $bundle_arr = (array) $daily_bundle;
                    $i = 0;

                    $data['total_de_registros']++;

                    foreach ($bundle_arr as $key_2 => $value_2)
                    {
                        $i++;
                        if ($i == 2) //acessa as propriades do obj
                        {
                            foreach ($value_2 as $key_3 => $value_3)
                            {
                                formatArr($value_3, $data, $key_3);
                            }
                        }
                    }
                }
            }
        }

        foreach ($data as $key => $value)
        {
            $marcados = 0;

            $len = count($data[$key]['arr']);

            for ($i = 0; $i < $len; $i++)
            {
                if ($data[$key]['arr'][$i] || $data[$key]['arr'][$i] !== 0)
                {
                    $marcados++;
                }
            }

            if (isset($data[$key]['percentual']))
            {
                $data[$key]['total'] = count($data[$key]['arr']);
                $data[$key]['percentual'] = $calc_obj->calculate_percentage($marcados, $data['total_de_registros']);
                $data[$key]['media'] = $calc_obj->calc_average($data[$key]['arr']);
                $data[$key]['mediana'] = $calc_obj->calculate_median($data[$key]['arr']);
                $data[$key]['desvio_padrao'] = $calc_obj->standard_deviation($data[$key]['arr']);
            }
        }

        return $data;
    }

    /**
     * Returns a rules checker object that will be used for validating
     * application integrity.
     *
     * @param \Cake\ORM\RulesChecker $rules The rules object to be modified.
     * @return \Cake\ORM\RulesChecker
     */
    public function buildRules(RulesChecker $rules)
    {
        $rules->add($rules->existsIn(['itu_prevention_bundle_id'], 'ItuPreventionBundles'));
        return $rules;
    }
}
