<?php
namespace App\Model\Table;

use App\Model\Entity\ImmediateComplicationsPavPreventionBundle;
use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * ImmediateComplicationsPavPreventionBundles Model
 *
 * @property \Cake\ORM\Association\BelongsTo $ImmediateComplications
 * @property \Cake\ORM\Association\BelongsTo $PavPreventionBundles
 */
class ImmediateComplicationsPavPreventionBundlesTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->table('immediate_complications_pav_prevention_bundles');
        $this->displayField('id');
        $this->primaryKey('id');

        $this->belongsTo('ImmediateComplications', [
            'foreignKey' => 'immediate_complication_id',
            'joinType' => 'INNER'
        ]);
        $this->belongsTo('PavPreventionBundles', [
            'foreignKey' => 'pav_prevention_bundle_id',
            'joinType' => 'INNER'
        ]);
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('id')
            ->allowEmpty('id', 'create');

        return $validator;
    }

    /**
     * Returns a rules checker object that will be used for validating
     * application integrity.
     *
     * @param \Cake\ORM\RulesChecker $rules The rules object to be modified.
     * @return \Cake\ORM\RulesChecker
     */
    public function buildRules(RulesChecker $rules)
    {
        $rules->add($rules->existsIn(['immediate_complication_id'], 'ImmediateComplications'));
        $rules->add($rules->existsIn(['pav_prevention_bundle_id'], 'PavPreventionBundles'));
        return $rules;
    }
}
