<?php
namespace App\Model\Table;

use App\Model\Entity\IndicatorsUnit;
use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * IndicatorsUnits Model
 *
 * @property \Cake\ORM\Association\BelongsTo $Units
 */
class IndicatorsUnitsTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->table('indicators_units');
        $this->displayField('id');
        $this->primaryKey('id');

        $this->belongsTo('Units', [
            'foreignKey' => 'unit_id',
            'joinType' => 'INNER'
        ]);
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('id')
            ->allowEmpty('id', 'create');

        $validator
            ->numeric('taxa_de_ocupacao')
            ->allowEmpty('taxa_de_ocupacao');

        $validator
            ->numeric('indice_de_giro_de_leito')
            ->allowEmpty('indice_de_giro_de_leito');

        $validator
            ->numeric('intervalo_de_substituicao')
            ->allowEmpty('intervalo_de_substituicao');

        $validator
            ->numeric('consumo_medio')
            ->allowEmpty('consumo_medio');

        $validator
            ->numeric('consumo_diario')
            ->allowEmpty('consumo_diario');

        $validator
            ->numeric('consumo_diario_por_paciente')
            ->allowEmpty('consumo_diario_por_paciente');

        $validator
            ->numeric('ticket_medio')
            ->allowEmpty('ticket_medio');

        $validator
            ->numeric('ticket_diario')
            ->allowEmpty('ticket_diario');

        $validator
            ->numeric('ticket_diario_por_paciente')
            ->allowEmpty('ticket_diario_por_paciente');

        $validator
            ->numeric('ticket_por_internacao')
            ->allowEmpty('ticket_por_internacao');

        $validator
            ->numeric('glossa_total')
            ->allowEmpty('glossa_total');

        $validator
            ->numeric('glossa_por_paciente')
            ->allowEmpty('glossa_por_paciente');

        $validator
            ->numeric('faixa_de_internacao_menor_que_24h')
            ->allowEmpty('faixa_de_internacao_menor_que_24h');

        $validator
            ->numeric('taxa_de_reinternacao')
            ->allowEmpty('taxa_de_reinternacao');

        $validator
            ->numeric('taxa_internacoes')
            ->allowEmpty('taxa_internacoes');

        $validator
            ->integer('taxa_internacoes_advertencia')
            ->allowEmpty('taxa_internacoes_advertencia');

        $validator
            ->integer('taxa_de_ocupacao_advertencia')
            ->allowEmpty('taxa_de_ocupacao_advertencia');

        $validator
            ->integer('indice_de_giro_de_leito_advertencia')
            ->allowEmpty('indice_de_giro_de_leito_advertencia');

        $validator
            ->integer('intervalo_de_substituicao_advertencia')
            ->allowEmpty('intervalo_de_substituicao_advertencia');

        $validator
            ->integer('consumo_medio_advertencia')
            ->allowEmpty('consumo_medio_advertencia');

        $validator
            ->integer('consumo_diario_advertencia')
            ->allowEmpty('consumo_diario_advertencia');

        $validator
            ->integer('consumo_diario_por_paciente_advertencia')
            ->allowEmpty('consumo_diario_por_paciente_advertencia');

        $validator
            ->integer('ticket_medio_advertencia')
            ->allowEmpty('ticket_medio_advertencia');

        $validator
            ->integer('ticket_diario_advertencia')
            ->allowEmpty('ticket_diario_advertencia');

        $validator
            ->integer('ticket_diario_por_paciente_advertencia')
            ->allowEmpty('ticket_diario_por_paciente_advertencia');

        $validator
            ->integer('ticket_por_internacao_advertencia')
            ->allowEmpty('ticket_por_internacao_advertencia');

        $validator
            ->integer('glossa_total_advertencia')
            ->allowEmpty('glossa_total_advertencia');

        $validator
            ->integer('glossa_por_paciente_advertencia')
            ->allowEmpty('glossa_por_paciente_advertencia');

        $validator
            ->integer('faixa_de_internacao_menor_que_24h_advertencia')
            ->allowEmpty('faixa_de_internacao_menor_que_24h_advertencia');

        $validator
            ->integer('taxa_de_reinternacao_advertencia')
            ->allowEmpty('taxa_de_reinternacao_advertencia');

        $validator
            ->numeric('tempo_medio_permanencia')
            ->allowEmpty('tempo_medio_permanencia');

        $validator
            ->integer('tempo_medio_permanencia_advertencia')
            ->allowEmpty('tempo_medio_permanencia_advertencia');

        $validator
            ->time('tempo_cesariana')
            ->allowEmpty('tempo_cesariana');

        $validator
            ->integer('tempo_cesariana_advertencia')
            ->allowEmpty('tempo_cesariana_advertencia');

        $validator
            ->numeric('taxa_saida_hospitalar')
            ->allowEmpty('taxa_saida_hospitalar');

        $validator
            ->integer('taxa_saida_hospitalar_advertencia')
            ->allowEmpty('taxa_saida_hospitalar_advertencia');

        $validator
            ->numeric('taxa_mortalidade')
            ->allowEmpty('taxa_mortalidade');

        $validator
            ->integer('taxa_mortalidade_advertencia')
            ->allowEmpty('taxa_mortalidade_advertencia');

        $validator
            ->numeric('taxa_mortalidade_neonatal')
            ->allowEmpty('taxa_mortalidade_neonatal');

        $validator
            ->integer('taxa_mortalidade_neonatal_advertencia')
            ->allowEmpty('taxa_mortalidade_neonatal_advertencia');

        $validator
            ->numeric('taxa_mortalidade_pos_ope')
            ->allowEmpty('taxa_mortalidade_pos_ope');

        $validator
            ->integer('taxa_mortalidade_pos_ope_advertencia')
            ->allowEmpty('taxa_mortalidade_pos_ope_advertencia');

        $validator
            ->numeric('taxa_mortalidade_operatoria')
            ->allowEmpty('taxa_mortalidade_operatoria');

        $validator
            ->integer('taxa_mortalidade_operatoria_advertencia')
            ->allowEmpty('taxa_mortalidade_operatoria_advertencia');

        $validator
            ->numeric('taxa_letalidade')
            ->allowEmpty('taxa_letalidade');

        $validator
            ->allowEmpty('taxa_letalidade_advertencia');

        $validator
            ->numeric('taxa_infeccao_corrente')
            ->allowEmpty('taxa_infeccao_corrente');

        $validator
            ->integer('taxa_infeccao_corrente_advertencia')
            ->allowEmpty('taxa_infeccao_corrente_advertencia');

        $validator
            ->numeric('densidade_cateter_vascular')
            ->allowEmpty('densidade_cateter_vascular');

        $validator
            ->integer('densidade_cateter_vascular_advertencia')
            ->allowEmpty('densidade_cateter_vascular_advertencia');

        $validator
            ->numeric('taxa_infeccao_trato')
            ->allowEmpty('taxa_infeccao_trato');

        $validator
            ->integer('taxa_infeccao_trato_advertencia')
            ->allowEmpty('taxa_infeccao_trato_advertencia');

        $validator
            ->numeric('densidade_cateter_vesical')
            ->allowEmpty('densidade_cateter_vesical');

        $validator
            ->integer('densidade_cateter_vesical_advertencia')
            ->allowEmpty('densidade_cateter_vesical_advertencia');

        $validator
            ->numeric('taxa_pneumonia')
            ->allowEmpty('taxa_pneumonia');

        $validator
            ->integer('taxa_pneumonia_advertencia')
            ->allowEmpty('taxa_pneumonia_advertencia');

        $validator
            ->numeric('densidade_venti_mecanica')
            ->allowEmpty('densidade_venti_mecanica');

        $validator
            ->integer('densidade_venti_mecanica_advertencia')
            ->allowEmpty('densidade_venti_mecanica_advertencia');

        $validator
            ->numeric('taxa_infeccao_sitio')
            ->allowEmpty('taxa_infeccao_sitio');

        $validator
            ->integer('taxa_infeccao_sitio_advertencia')
            ->allowEmpty('taxa_infeccao_sitio_advertencia');

        $validator
            ->numeric('taxa_cirurgia_risco')
            ->allowEmpty('taxa_cirurgia_risco');

        $validator
            ->integer('taxa_cirurgia_risco_advertencia')
            ->allowEmpty('taxa_cirurgia_risco_advertencia');

        $validator
            ->numeric('taxa_captacao_morte')
            ->allowEmpty('taxa_captacao_morte');

        $validator
            ->integer('taxa_captacao_morte_advertencia')
            ->allowEmpty('taxa_captacao_morte_advertencia');

        $validator
            ->numeric('relacao_head_bed')
            ->allowEmpty('relacao_head_bed');

        $validator
            ->integer('relacao_head_bed_advertencia')
            ->allowEmpty('relacao_head_bed_advertencia');

        return $validator;
    }

    /**
     * Returns a rules checker object that will be used for validating
     * application integrity.
     *
     * @param \Cake\ORM\RulesChecker $rules The rules object to be modified.
     * @return \Cake\ORM\RulesChecker
     */
    public function buildRules(RulesChecker $rules)
    {
        $rules->add($rules->existsIn(['unit_id'], 'Units'));
        return $rules;
    }
}
