<?php
namespace App\Model\Table;

use App\Model\Entity\OtherComorbiditiesDiagnostic;
use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * OtherComorbiditiesDiagnostics Model
 *
 * @property \Cake\ORM\Association\BelongsTo $OtherComorbidities
 * @property \Cake\ORM\Association\BelongsTo $Diagnostics
 */
class OtherComorbiditiesDiagnosticsTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->table('other_comorbidities_diagnostics');
        $this->displayField('id');
        $this->primaryKey('id');

        $this->belongsTo('OtherComorbidities', [
            'foreignKey' => 'other_comorbidity_id',
            'joinType' => 'INNER'
        ]);
        $this->belongsTo('Diagnostics', [
            'foreignKey' => 'diagnostic_id',
            'joinType' => 'INNER'
        ]);
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('id')
            ->allowEmpty('id', 'create');

        return $validator;
    }

    /**
     * Returns a rules checker object that will be used for validating
     * application integrity.
     *
     * @param \Cake\ORM\RulesChecker $rules The rules object to be modified.
     * @return \Cake\ORM\RulesChecker
     */
    public function buildRules(RulesChecker $rules)
    {
        $rules->add($rules->existsIn(['other_comorbidity_id'], 'OtherComorbidities'));
        $rules->add($rules->existsIn(['diagnostic_id'], 'Diagnostics'));
        return $rules;
    }
}
