<?php
namespace App\Model\Table;

use App\Model\Entity\RouteOfAnesthesia;
use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * RouteOfAnesthesias Model
 *
 * @property \Cake\ORM\Association\BelongsTo $PreAnestheticVisits
 */
class RouteOfAnesthesiasTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->table('route_of_anesthesias');
        $this->displayField('id');
        $this->primaryKey('id');

        $this->addBehavior('Timestamp');

        /*$this->belongsTo('PreAnestheticVisits', [
            'foreignKey' => 'pre_anesthetic_visit_id',
            'joinType' => 'INNER'
        ]);*/
        $this->belongsToMany('PreAnestheticVisits', [
            'foreignKey' => 'route_of_anesthesia_id',
            'targetForeignKey' => 'pre_anesthetic_visit_id',
            'joinTable' => 'pre_anesthetic_visits_route_of_anesthesias'
        ]);
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('id')
            ->allowEmpty('id', 'create');

        $validator
            ->allowEmpty('nome');

        return $validator;
    }

    /**
     * Returns a rules checker object that will be used for validating
     * application integrity.
     *
     * @param \Cake\ORM\RulesChecker $rules The rules object to be modified.
     * @return \Cake\ORM\RulesChecker
     */
    /*public function buildRules(RulesChecker $rules)
    {
        $rules->add($rules->existsIn(['pre_anesthetic_visit_id'], 'PreAnestheticVisits'));
        return $rules;
    }*/
}
