<?php
namespace App\Model\Table;

use App\Model\Entity\Screening;
use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * Screenings Model
 *
 * @property \Cake\ORM\Association\BelongsTo $Patients
 * @property \Cake\ORM\Association\BelongsTo $Units
 * @property \Cake\ORM\Association\BelongsTo $Professionals
 * @property \Cake\ORM\Association\HasMany $Admissions
 * @property \Cake\ORM\Association\HasMany $Bundles
 * @property \Cake\ORM\Association\HasMany $ChestPainProtocols
 * @property \Cake\ORM\Association\HasMany $ClinicTevProtocols
 * @property \Cake\ORM\Association\HasMany $Hospitalizations
 * @property \Cake\ORM\Association\HasMany $ItuPreventionBundles
 * @property \Cake\ORM\Association\HasMany $MedicalCares
 * @property \Cake\ORM\Association\HasMany $PavPreventionBundles
 * @property \Cake\ORM\Association\HasMany $SafeSurgeryBundles
 * @property \Cake\ORM\Association\HasMany $SepseProtocols
 * @property \Cake\ORM\Association\HasMany $SurgicalTevProtocols
 * @property \Cake\ORM\Association\BelongsToMany $PainCharacteristics
 */
class ScreeningsTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->table('screenings');
        $this->displayField('id');
        $this->primaryKey('id');

        $this->addBehavior('Timestamp');

        $this->belongsTo('Patients', [
            'foreignKey' => 'patient_id',
            'joinType' => 'INNER'
        ]);
        $this->belongsTo('Units', [
            'foreignKey' => 'unit_id',
            'joinType' => 'INNER'
        ]);
        $this->belongsTo('Professionals', [
            'foreignKey' => 'professional_id'
        ]);
        $this->hasMany('Admissions', [
            'foreignKey' => 'screening_id'
        ]);
        $this->hasMany('Bundles', [
            'foreignKey' => 'screening_id'
        ]);
        $this->hasMany('ChestPainProtocols', [
            'foreignKey' => 'screening_id'
        ]);
        $this->hasMany('ClinicTevProtocols', [
            'foreignKey' => 'screening_id'
        ]);
        $this->hasMany('Hospitalizations', [
            'foreignKey' => 'screening_id'
        ]);
        $this->hasMany('ItuPreventionBundles', [
            'foreignKey' => 'screening_id'
        ]);
        $this->hasMany('MedicalCares', [
            'foreignKey' => 'screening_id'
        ]);
        $this->hasMany('PavPreventionBundles', [
            'foreignKey' => 'screening_id'
        ]);
        $this->hasMany('SafeSurgeryBundles', [
            'foreignKey' => 'screening_id'
        ]);
        $this->hasMany('SepseProtocols', [
            'foreignKey' => 'screening_id'
        ]);
        $this->hasMany('SurgicalTevProtocols', [
            'foreignKey' => 'screening_id'
        ]);
        $this->belongsToMany('PainCharacteristics', [
            'foreignKey' => 'screening_id',
            'targetForeignKey' => 'pain_characteristic_id',
            'joinTable' => 'pain_characteristics_screenings'
        ]);
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('id')
            ->allowEmpty('id', 'create');

        $validator
            ->boolean('is_active')
            ->allowEmpty('is_active');

        $validator
            ->allowEmpty('pas');

        $validator
            ->allowEmpty('temp');

        $validator
            ->allowEmpty('sato2');

        $validator
            ->allowEmpty('fc');

        $validator
            ->allowEmpty('fr');

        $validator
            ->allowEmpty('glicemia');

        $validator
            ->boolean('parada_cardiaca_ou_suspeita')
            ->allowEmpty('parada_cardiaca_ou_suspeita');

        $validator
            ->allowEmpty('fraquesa_muscular');

        $validator
            ->allowEmpty('fraquesa_muscular_tipo');

        $validator
            ->allowEmpty('perda_sensorial');

        $validator
            ->allowEmpty('perda_sensorial_tipo');

        $validator
            ->allowEmpty('alteracao_consciencia');

        $validator
            ->allowEmpty('queixa_principal');

        $validator
            ->boolean('tem_alergia')
            ->allowEmpty('tem_alergia');

        $validator
            ->allowEmpty('alergias');

        $validator
            ->boolean('uso_medicacao_regular')
            ->allowEmpty('uso_medicacao_regular');

        $validator
            ->allowEmpty('medicacao_regular');

        $validator
            ->allowEmpty('resumo_da_queixa');

        $validator
            ->allowEmpty('localizacao_da_dor');

        $validator
            ->allowEmpty('aparecimento_da_dor');

        $validator
            ->boolean('dor_toracica_em_aperto')
            ->allowEmpty('dor_toracica_em_aperto');

        $validator
            ->boolean('dor_toracica_dispineia')
            ->allowEmpty('dor_toracica_dispineia');

        $validator
            ->boolean('dor_toracica_assimetria_dos_pulsos')
            ->allowEmpty('dor_toracica_assimetria_dos_pulsos');

        $validator
            ->boolean('dor_toracica_historico_de_coronariopatia')
            ->allowEmpty('dor_toracica_historico_de_coronariopatia');

        $validator
            ->boolean('dor_toracica_historico_de_avc')
            ->allowEmpty('dor_toracica_historico_de_avc');

        $validator
            ->boolean('dor_toracica_trauma_toracico_antecedente')
            ->allowEmpty('dor_toracica_trauma_toracico_antecedente');

        $validator
            ->boolean('dor_abdominal_historico_de_trauma')
            ->allowEmpty('dor_abdominal_historico_de_trauma');

        $validator
            ->boolean('dor_abdominal_diarreia')
            ->allowEmpty('dor_abdominal_diarreia');

        $validator
            ->boolean('dor_abdominal_nausea')
            ->allowEmpty('dor_abdominal_nausea');

        $validator
            ->boolean('dor_abdominal_vomitos')
            ->allowEmpty('dor_abdominal_vomitos');

        $validator
            ->boolean('cefaleia_rigidez_da_nuca')
            ->allowEmpty('cefaleia_rigidez_da_nuca');

        $validator
            ->boolean('cefaleia_vomitos')
            ->allowEmpty('cefaleia_vomitos');

        $validator
            ->boolean('cefaleia_episodio_de_crise_convulsiva')
            ->allowEmpty('cefaleia_episodio_de_crise_convulsiva');

        $validator
            ->boolean('ceruicalgia_historico_progresso_calculo_renal')
            ->allowEmpty('ceruicalgia_historico_progresso_calculo_renal');

        $validator
            ->boolean('ceruicalgia_transplatandos_e_em_quimioterapia')
            ->allowEmpty('ceruicalgia_transplatandos_e_em_quimioterapia');

        $validator
            ->boolean('ceruicalgia_alteracao_de_esfincter')
            ->allowEmpty('ceruicalgia_alteracao_de_esfincter');

        $validator
            ->boolean('dispneia_desconforto')
            ->allowEmpty('dispneia_desconforto');

        $validator
            ->boolean('dispneia_cianose')
            ->allowEmpty('dispneia_cianose');

        $validator
            ->boolean('dispneia_utilizacao_da_musculatura')
            ->allowEmpty('dispneia_utilizacao_da_musculatura');

        $validator
            ->boolean('dispneia_dificuldade_para_falar')
            ->allowEmpty('dispneia_dificuldade_para_falar');

        $validator
            ->boolean('dispneia_historico_de_asma')
            ->allowEmpty('dispneia_historico_de_asma');

        $validator
            ->boolean('dispneia_alteracao_na_ausculta')
            ->allowEmpty('dispneia_alteracao_na_ausculta');

        $validator
            ->boolean('diarreia_sinais_de_desidratacao')
            ->allowEmpty('diarreia_sinais_de_desidratacao');

        $validator
            ->boolean('diarreia_dor_abdominal')
            ->allowEmpty('diarreia_dor_abdominal');

        $validator
            ->boolean('diarreia_nausea_e_vomito')
            ->allowEmpty('diarreia_nausea_e_vomito');

        $validator
            ->boolean('diarreia_sinais_vitais_normais')
            ->allowEmpty('diarreia_sinais_vitais_normais');

        $validator
            ->boolean('tosse_dispneia')
            ->allowEmpty('tosse_dispneia');

        $validator
            ->boolean('tosse_historico_de_hemoptise')
            ->allowEmpty('tosse_historico_de_hemoptise');

        $validator
            ->boolean('tosse_dor_toracica_ausente')
            ->allowEmpty('tosse_dor_toracica_ausente');

        $validator
            ->boolean('hemorragia_historico_de_enterorragia')
            ->allowEmpty('hemorragia_historico_de_enterorragia');

        $validator
            ->boolean('hemorragia_antecedente_de_cirrose')
            ->allowEmpty('hemorragia_antecedente_de_cirrose');

        $validator
            ->boolean('queixa_cronica_nao_agudizada')
            ->allowEmpty('queixa_cronica_nao_agudizada');

        $validator
            ->boolean('lesoes_de_pele_escabiose')
            ->allowEmpty('lesoes_de_pele_escabiose');

        $validator
            ->boolean('lesoes_de_pele_eczema')
            ->allowEmpty('lesoes_de_pele_eczema');

        $validator
            ->boolean('lesoes_de_pele_outras_lesoes')
            ->allowEmpty('lesoes_de_pele_outras_lesoes');

        $validator
            ->allowEmpty('intensidade_da_dor');

        $validator
            ->boolean('alt_estado_mental_ausencia_de_resposta')
            ->allowEmpty('alt_estado_mental_ausencia_de_resposta');

        $validator
            ->boolean('alt_estado_mental_alteracao_consciencia')
            ->allowEmpty('alt_estado_mental_alteracao_consciencia');

        $validator
            ->boolean('deficit_motor_inicio_subito')
            ->allowEmpty('deficit_motor_inicio_subito');

        $validator
            ->boolean('febre_alteracao_nivel_consciencia')
            ->allowEmpty('febre_alteracao_nivel_consciencia');

        $validator
            ->boolean('febre_dispneia')
            ->allowEmpty('febre_dispneia');

        $validator
            ->boolean('febre_imunossupressao')
            ->allowEmpty('febre_imunossupressao');

        $validator
            ->boolean('hiperglicemia_associada_alteracao')
            ->allowEmpty('hiperglicemia_associada_alteracao');

        $validator
            ->boolean('hipoglicemia_glicemia_capilar')
            ->allowEmpty('hipoglicemia_glicemia_capilar');

        $validator
            ->allowEmpty('glasgow');

        $validator
            ->allowEmpty('classificacao_sugerida');

        $validator
            ->allowEmpty('pad');

        $validator
            ->allowEmpty('classificacao_selecionada');

        $validator
            ->boolean('portador_necessidas_especiais')
            ->allowEmpty('portador_necessidas_especiais');

        $validator
            ->boolean('esta_gestente_ou_suspeita')
            ->allowEmpty('esta_gestente_ou_suspeita');

        $validator
            ->boolean('obstetricia')
            ->allowEmpty('obstetricia');

        $validator
            ->boolean('classificacao_obstetrica')
            ->allowEmpty('classificacao_obstetrica');

        $validator
            ->boolean('desmaio_nao_responsivo')
            ->allowEmpty('desmaio_nao_responsivo');

        $validator
            ->boolean('desmaio_choque')
            ->allowEmpty('desmaio_choque');

        $validator
            ->boolean('desmaio_saturacao')
            ->allowEmpty('desmaio_saturacao');

        $validator
            ->boolean('desmaio_nao_vermelho')
            ->allowEmpty('desmaio_nao_vermelho');

        $validator
            ->boolean('desmaio_alteracao_consciencia')
            ->allowEmpty('desmaio_alteracao_consciencia');

        $validator
            ->boolean('desmaio_padrao_respiratorio')
            ->allowEmpty('desmaio_padrao_respiratorio');

        $validator
            ->allowEmpty('desmaio_pas');

        $validator
            ->boolean('desmaio_pa')
            ->allowEmpty('desmaio_pa');

        $validator
            ->boolean('desmaio_prelatorio_diabetes')
            ->allowEmpty('desmaio_prelatorio_diabetes');

        $validator
            ->boolean('desmaio_febre')
            ->allowEmpty('desmaio_febre');

        $validator
            ->boolean('desmaio_pacientes_imunodeprimidas')
            ->allowEmpty('desmaio_pacientes_imunodeprimidas');

        $validator
            ->boolean('desmaio_encaminhamento_centro')
            ->allowEmpty('desmaio_encaminhamento_centro');

        $validator
            ->boolean('desmaio_atendimento_nao_prioritario')
            ->allowEmpty('desmaio_atendimento_nao_prioritario');

        $validator
            ->boolean('abdominal_periodo_expulsivo')
            ->allowEmpty('abdominal_periodo_expulsivo');

        $validator
            ->boolean('abdominal_prolapso')
            ->allowEmpty('abdominal_prolapso');

        $validator
            ->boolean('abdominal_exteriorizacao')
            ->allowEmpty('abdominal_exteriorizacao');

        $validator
            ->boolean('abdominal_sinais_choque')
            ->allowEmpty('abdominal_sinais_choque');

        $validator
            ->allowEmpty('abdominal_dor');

        $validator
            ->boolean('abdominal_contracoes')
            ->allowEmpty('abdominal_contracoes');

        $validator
            ->boolean('abdominal_hipertonia')
            ->allowEmpty('abdominal_hipertonia');

        $validator
            ->boolean('abdominal_pa')
            ->allowEmpty('abdominal_pa');

        $validator
            ->boolean('abdominal_perda_liquido')
            ->allowEmpty('abdominal_perda_liquido');

        $validator
            ->boolean('abdominal_portadora')
            ->allowEmpty('abdominal_portadora');

        $validator
            ->boolean('abdominal_portadora_hiv')
            ->allowEmpty('abdominal_portadora_hiv');

        $validator
            ->boolean('abdominal_pos_parto')
            ->allowEmpty('abdominal_pos_parto');

        $validator
            ->boolean('abdominal_dor_lombar')
            ->allowEmpty('abdominal_dor_lombar');

        $validator
            ->boolean('abdominal_contracoes_intervalo')
            ->allowEmpty('abdominal_contracoes_intervalo');

        $validator
            ->boolean('abdominal_ausencia')
            ->allowEmpty('abdominal_ausencia');

        $validator
            ->boolean('abdominal_vitima')
            ->allowEmpty('abdominal_vitima');

        $validator
            ->boolean('abdominal_febril')
            ->allowEmpty('abdominal_febril');

        $validator
            ->boolean('abdominal_perda_liquido_pequena')
            ->allowEmpty('abdominal_perda_liquido_pequena');

        $validator
            ->boolean('abdominal_encaminhamento')
            ->allowEmpty('abdominal_encaminhamento');

        $validator
            ->boolean('abdominal_atendimento_prioritario')
            ->allowEmpty('abdominal_atendimento_prioritario');

        $validator
            ->allowEmpty('ocular');

        $validator
            ->allowEmpty('verbal');

        $validator
            ->allowEmpty('motora');

        $validator
            ->boolean('dor_cabeca_apneia')
            ->allowEmpty('dor_cabeca_apneia');

        $validator
            ->boolean('dor_cabeca_choque')
            ->allowEmpty('dor_cabeca_choque');

        $validator
            ->allowEmpty('dor_cabeca_alteracao_consciencia');

        $validator
            ->allowEmpty('dor_cabeca_pas');

        $validator
            ->boolean('dor_cabeca_pa_maior_140')
            ->allowEmpty('dor_cabeca_pa_maior_140');

        $validator
            ->boolean('dor_cabeca_dor_intensa')
            ->allowEmpty('dor_cabeca_dor_intensa');

        $validator
            ->boolean('dor_cabeca_disturbios')
            ->allowEmpty('dor_cabeca_disturbios');

        $validator
            ->boolean('dor_cabeca_hipertermia')
            ->allowEmpty('dor_cabeca_hipertermia');

        $validator
            ->boolean('dor_cabeca_dor_forte')
            ->allowEmpty('dor_cabeca_dor_forte');

        $validator
            ->boolean('dor_cabeca_febre')
            ->allowEmpty('dor_cabeca_febre');

        $validator
            ->boolean('dor_cabeca_febril')
            ->allowEmpty('dor_cabeca_febril');

        $validator
            ->boolean('dor_cabeca_atendimento')
            ->allowEmpty('dor_cabeca_atendimento');

        $validator
            ->allowEmpty('falta_ar_saturacao');

        $validator
            ->boolean('falta_ar_estridor')
            ->allowEmpty('falta_ar_estridor');

        $validator
            ->boolean('falta_ar_choque')
            ->allowEmpty('falta_ar_choque');

        $validator
            ->boolean('falta_ar_padrao')
            ->allowEmpty('falta_ar_padrao');

        $validator
            ->allowEmpty('falta_ar_pas');

        $validator
            ->boolean('cefaleia_inicio_subito')
            ->allowEmpty('cefaleia_inicio_subito');

        $validator
            ->boolean('cefaleia_deficit_motor_agudo')
            ->allowEmpty('cefaleia_deficit_motor_agudo');

        $validator
            ->boolean('dor_toracica_dor_precordial')
            ->allowEmpty('dor_toracica_dor_precordial');

        $validator
            ->boolean('dor_toracica_irradiacao')
            ->allowEmpty('dor_toracica_irradiacao');

        $validator
            ->boolean('parada_ausecia_pulso')
            ->allowEmpty('parada_ausecia_pulso');

        $validator
            ->boolean('parada_ausecia_movimentos')
            ->allowEmpty('parada_ausecia_movimentos');

        $validator
            ->boolean('parada_inconsciencia')
            ->allowEmpty('parada_inconsciencia');

        return $validator;
    }

    /**
     * Returns a rules checker object that will be used for validating
     * application integrity.
     *
     * @param \Cake\ORM\RulesChecker $rules The rules object to be modified.
     * @return \Cake\ORM\RulesChecker
     */
    public function buildRules(RulesChecker $rules)
    {
        $rules->add($rules->existsIn(['patient_id'], 'Patients'));
        $rules->add($rules->existsIn(['unit_id'], 'Units'));
        $rules->add($rules->existsIn(['professional_id'], 'Professionals'));
        return $rules;
    }
}
