<?php
namespace App\Model\Table;

use App\Model\Entity\SurgeriesSurgicalComplication;
use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * SurgeriesSurgicalComplications Model
 *
 * @property \Cake\ORM\Association\BelongsTo $SurgicalComplications
 * @property \Cake\ORM\Association\BelongsTo $Surgeries
 */
class SurgeriesSurgicalComplicationsTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->table('surgeries_surgical_complications');
        $this->displayField('id');
        $this->primaryKey('id');

        $this->addBehavior('Timestamp');

        $this->belongsTo('SurgicalComplications', [
            'foreignKey' => 'surgical_complication_id',
            'joinType' => 'INNER'
        ]);
        $this->belongsTo('Surgeries', [
            'foreignKey' => 'surgery_id',
            'joinType' => 'INNER'
        ]);
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('id')
            ->allowEmpty('id', 'create');

        return $validator;
    }

    /**
     * Returns a rules checker object that will be used for validating
     * application integrity.
     *
     * @param \Cake\ORM\RulesChecker $rules The rules object to be modified.
     * @return \Cake\ORM\RulesChecker
     */
    public function buildRules(RulesChecker $rules)
    {
        $rules->add($rules->existsIn(['surgical_complication_id'], 'SurgicalComplications'));
        $rules->add($rules->existsIn(['surgery_id'], 'Surgeries'));
        return $rules;
    }
}
