<?php
namespace App\Model\Table;

use App\Model\Entity\SurgicalChecklist;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;
use MedidasDispersao\MedidasDispersao;

require_once ROOT . DS . "vendor" . DS . "Zurubabel" . DS . "MedidasDispersao.php";
/**
 * SurgicalChecklists Model
 *
 * @property \Cake\ORM\Association\BelongsTo $Hospitalizations
 */
class SurgicalChecklistsTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->table('surgical_checklists');
        $this->displayField('id');
        $this->primaryKey('id');

        $this->addBehavior('Timestamp');

        $this->belongsTo('Hospitalizations', [
            'foreignKey' => 'hospitalization_id',
            'joinType' => 'INNER',
        ]);
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('id')
            ->allowEmpty('id', 'create');

        $validator
            ->boolean('checar_dois_identificadores_do_paciente')
            ->allowEmpty('checar_dois_identificadores_do_paciente');

        $validator
            ->boolean('anexar_impresso_checklist_de_recepcao_de_orgao')
            ->allowEmpty('anexar_impresso_checklist_de_recepcao_de_orgao');

        $validator
            ->boolean('anamnese_e_exame_fisico')
            ->allowEmpty('anamnese_e_exame_fisico');

        $validator
            ->boolean('algoritmo_tromboembolismo_venoso')
            ->allowEmpty('algoritmo_tromboembolismo_venoso');

        $validator
            ->boolean('avaliacao_pre_anestesica')
            ->allowEmpty('avaliacao_pre_anestesica');

        $validator
            ->boolean('consentimento_cirurgico_sitio_lateralidade')
            ->allowEmpty('consentimento_cirurgico_sitio_lateralidade');

        $validator
            ->boolean('sitio_demarcado')
            ->allowEmpty('sitio_demarcado');

        $validator
            ->boolean('conferencia_paciente_agendamento')
            ->allowEmpty('conferencia_paciente_agendamento');

        $validator
            ->boolean('checar_identificadores_do_paciente')
            ->allowEmpty('checar_identificadores_do_paciente');

        $validator
            ->boolean('atb_profilatico_60_minutos_antes_da_incisao_cirurgica')
            ->allowEmpty('atb_profilatico_60_minutos_antes_da_incisao_cirurgica');

        $validator
            ->time('atb_horario')
            ->allowEmpty('atb_horario');

        $validator
            ->boolean('atb_terapeutico')
            ->allowEmpty('atb_terapeutico');

        $validator
            ->boolean('materiais_implantes_estao_funcionando_e_disponiveis')
            ->allowEmpty('materiais_implantes_estao_funcionando_e_disponiveis');

        $validator
            ->boolean('equipamentos_checados_pela_engenharia_clinica')
            ->allowEmpty('equipamentos_checados_pela_engenharia_clinica');

        $validator
            ->boolean('consentimento_anestesico')
            ->allowEmpty('consentimento_anestesico');

        $validator
            ->boolean('consentimento_cirurgico_com_lateralidade_se_aplicavel')
            ->allowEmpty('consentimento_cirurgico_com_lateralidade_se_aplicavel');

        $validator
            ->boolean('laringoscopio')
            ->allowEmpty('laringoscopio');

        $validator
            ->boolean('kts_ambu')
            ->allowEmpty('kts_ambu');

        $validator
            ->boolean('Aspirador')
            ->allowEmpty('Aspirador');

        $validator
            ->boolean('seringas_identificadoras')
            ->allowEmpty('seringas_identificadoras');

        $validator
            ->boolean('monitor_oximetro_de_pylso_no_paciente_e_funcionando')
            ->allowEmpty('monitor_oximetro_de_pylso_no_paciente_e_funcionando');

        $validator
            ->boolean('via_aerea_dificil')
            ->allowEmpty('via_aerea_dificil');

        $validator
            ->boolean('equipamento_vad_disponivel')
            ->allowEmpty('equipamento_vad_disponivel');

        $validator
            ->boolean('alergia')
            ->allowEmpty('alergia');

        $validator
            ->boolean('profilaxia_para_tev')
            ->allowEmpty('profilaxia_para_tev');

        $validator
            ->boolean('meias_elasticas')
            ->allowEmpty('meias_elasticas');

        $validator
            ->boolean('massageador_intermitente')
            ->allowEmpty('massageador_intermitente');

        $validator
            ->boolean('profilaxia_medicamentosa')
            ->allowEmpty('profilaxia_medicamentosa');

        $validator
            ->boolean('esperado_perda_sanguinea')
            ->allowEmpty('esperado_perda_sanguinea');

        $validator
            ->boolean('acesso_venoso_central')
            ->allowEmpty('acesso_venoso_central');

        $validator
            ->boolean('dois_acessos_disponiveis')
            ->allowEmpty('dois_acessos_disponiveis');

        $validator
            ->boolean('confirmacao_paciente_cirurgia_a_ser_realizado')
            ->allowEmpty('confirmacao_paciente_cirurgia_a_ser_realizado');

        $validator
            ->boolean('checagem_da_equipe_que_esta_em_saia')
            ->allowEmpty('checagem_da_equipe_que_esta_em_saia');

        $validator
            ->boolean('todos_os_materais_uncionando_e_disponiveis')
            ->allowEmpty('todos_os_materais_uncionando_e_disponiveis');

        $validator
            ->boolean('atb_profilático_realizado')
            ->allowEmpty('atb_profilático_realizado');

        $validator
            ->boolean('exames_de_imagens_e_laboratoriais_essenciais_em_saia')
            ->allowEmpty('exames_de_imagens_e_laboratoriais_essenciais_em_saia');

        $validator
            ->boolean('necessidades_de_congelacao_patologista')
            ->allowEmpty('necessidades_de_congelacao_patologista');

        $validator
            ->boolean('informacoes_do_paciente_foram_confirmadas')
            ->allowEmpty('informacoes_do_paciente_foram_confirmadas');

        $validator
            ->boolean('consentimentos_cirurgico_anestesico_foi_assinado')
            ->allowEmpty('consentimentos_cirurgico_anestesico_foi_assinado');

        $validator
            ->boolean('visualizacao_o_local_da_cirurgica_marcado_nao_aplicavel')
            ->allowEmpty('visualizacao_o_local_da_cirurgica_marcado_nao_aplicavel');

        $validator
            ->boolean('checklist_da_anestesia_foi_executado')
            ->allowEmpty('checklist_da_anestesia_foi_executado');

        $validator
            ->boolean('ficha_anestesica_esta_completa')
            ->allowEmpty('ficha_anestesica_esta_completa');

        $validator
            ->boolean('recursos_humanos_estao_disponiveis')
            ->allowEmpty('recursos_humanos_estao_disponiveis');

        $validator
            ->boolean('equipamentos_foram_verificados')
            ->allowEmpty('equipamentos_foram_verificados');

        $validator
            ->boolean('monitorizacao_standard_colocada_e_funcionante')
            ->allowEmpty('monitorizacao_standard_colocada_e_funcionante');

        $validator
            ->boolean('acesso_venoso_adequado')
            ->allowEmpty('acesso_venoso_adequado');

        $validator
            ->boolean('alguma_alergia_conhecida')
            ->allowEmpty('alguma_alergia_conhecida');

        $validator
            ->boolean('via_aerea_difícil_risco_de_aspiracao')
            ->allowEmpty('via_aerea_difícil_risco_de_aspiracao');

        $validator
            ->boolean('flurdoterapia_sangue_disponivel_de_acordo_com_o_protocolo')
            ->allowEmpty('flurdoterapia_sangue_disponivel_de_acordo_com_o_protocolo');

        $validator
            ->boolean('nome_e_funcao_de_pessoas_nao_habituais_na_sala_foi_confirmado')
            ->allowEmpty('nome_e_funcao_de_pessoas_nao_habituais_na_sala_foi_confirmado');

        $validator
            ->boolean('cirurgiao_anestesista_e_enfermeiro_confirmaram_verbalmente')
            ->allowEmpty('cirurgiao_anestesista_e_enfermeiro_confirmaram_verbalmente');

        $validator
            ->boolean('procedimento_cirurgico_realizado')
            ->allowEmpty('procedimento_cirurgico_realizado');

        $validator
            ->boolean('contagem_correta_de_instrumentos')
            ->allowEmpty('contagem_correta_de_instrumentos');

        $validator
            ->boolean('pecas_anatomicas_produtos_para_analie_corretamente_identificados')
            ->allowEmpty('pecas_anatomicas_produtos_para_analie_corretamente_identificados');

        $validator
            ->boolean('todos_revem_necessidades_pos_operatorias')
            ->allowEmpty('todos_revem_necessidades_pos_operatorias');

        return $validator;
    }

    public function getRelatorioData($hospitalizations)
    {
        $calc_obj = new MedidasDispersao();

        $data =
            [
            'total_de_registros' => 0,
            'tot_patient_suspeita_me' => [
                'arr' => [],
            ],
        ];
        $percentual = [];

        foreach ($hospitalizations as $hospitalization)
        {
            //$data = $hospitalization["neonatal_checklists"];
            foreach ($hospitalization["surgical_checklists"] as $key_1 => $protocol)
            {
                if (!in_array($hospitalization['patient_id'], $data['tot_patient_suspeita_me']['arr']))
                {
                    array_push($data['tot_patient_suspeita_me']['arr'], $hospitalization['patient_id']);
                }

                $arr = (array) $protocol;
                $i = 0;

                $data['total_de_registros']++;

                foreach ($arr as $key_2 => $value_2)
                {
                    $i++;
                    if ($i == 2) //acessa as propriades do obj
                    {
                        foreach ($value_2 as $key_3 => $value_3)
                        {
                            //$data[$key_3] = $value_3;
                            formatArr($value_3, $data, $key_3);
                        }
                    }
                }
            }
        }

        foreach ($data as $key => $value)
        {
            $marcados = 0;

            $len = count($data[$key]['arr']);

            for ($i = 0; $i < $len; $i++)
            {
                if ($data[$key]['arr'][$i] || $data[$key]['arr'][$i] !== 0)
                {
                    $marcados++;
                }
            }

            if (isset($data[$key]['percentual']))
            {
                $data[$key]['total'] = count($data[$key]['arr']);
                $data[$key]['percentual'] = $calc_obj->calculate_percentage($marcados, $data['total_de_registros']);
                $data[$key]['media'] = $calc_obj->calc_average($data[$key]['arr']);
                $data[$key]['mediana'] = $calc_obj->calculate_median($data[$key]['arr']);
                $data[$key]['desvio_padrao'] = $calc_obj->standard_deviation($data[$key]['arr']);
            }
        }

        return $data;
    }

    /**
     * Returns a rules checker object that will be used for validating
     * application integrity.
     *
     * @param \Cake\ORM\RulesChecker $rules The rules object to be modified.
     * @return \Cake\ORM\RulesChecker
     */
    public function buildRules(RulesChecker $rules)
    {
        $rules->add($rules->existsIn(['hospitalization_id'], 'Hospitalizations'));
        return $rules;
    }
}
