<?php
namespace App\Model\Table;

use App\Model\Entity\SurgicalMaterial;
use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * SurgicalMaterials Model
 *
 * @property \Cake\ORM\Association\BelongsToMany $Surgeries
 */
class SurgicalMaterialsTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->table('surgical_materials');
        $this->displayField('id');
        $this->primaryKey('id');

        $this->belongsToMany('Surgeries', [
            'foreignKey' => 'surgical_material_id',
            'targetForeignKey' => 'surgery_id',
            'joinTable' => 'surgical_materials_surgeries'
        ]);
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('id')
            ->allowEmpty('id', 'create');

        $validator
            ->requirePresence('nome', 'create')
            ->notEmpty('nome');

        return $validator;
    }
}
