<?php
namespace App\Model\Table;

use App\Model\Entity\SurgicalTevProtocolsContraindication;
use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * SurgicalTevProtocolsContraindications Model
 *
 * @property \Cake\ORM\Association\BelongsTo $SurgicalTevProtocols
 * @property \Cake\ORM\Association\BelongsTo $Contraindications
 */
class SurgicalTevProtocolsContraindicationsTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->table('surgical_tev_protocols_contraindications');
        $this->displayField('id');
        $this->primaryKey('id');

        $this->belongsTo('SurgicalTevProtocols', [
            'foreignKey' => 'surgical_tev_protocol_id',
            'joinType' => 'INNER'
        ]);
        $this->belongsTo('Contraindications', [
            'foreignKey' => 'contraindication_id',
            'joinType' => 'INNER'
        ]);
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('id')
            ->allowEmpty('id', 'create');

        return $validator;
    }

    /**
     * Returns a rules checker object that will be used for validating
     * application integrity.
     *
     * @param \Cake\ORM\RulesChecker $rules The rules object to be modified.
     * @return \Cake\ORM\RulesChecker
     */
    public function buildRules(RulesChecker $rules)
    {
        $rules->add($rules->existsIn(['surgical_tev_protocol_id'], 'SurgicalTevProtocols'));
        $rules->add($rules->existsIn(['contraindication_id'], 'Contraindications'));
        return $rules;
    }
}
