<?php
namespace App\Model\Table;

use App\Model\Entity\SuspectedMeProtocol;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;
use MedidasDispersao\MedidasDispersao;

require_once ROOT . DS . "vendor" . DS . "Zurubabel" . DS . "MedidasDispersao.php";

/**
 * SuspectedMeProtocols Model
 *
 * @property \Cake\ORM\Association\BelongsTo $Hospitalizations
 * @property \Cake\ORM\Association\HasMany $LaboratoryExaminations
 * @property \Cake\ORM\Association\HasMany $ObtainedOrgansFromCorpses
 * @property \Cake\ORM\Association\HasMany $SedativeDrugs
 * @property \Cake\ORM\Association\HasMany $SupplementaryExaminations
 * @property \Cake\ORM\Association\BelongsToMany $Organs
 * @property \Cake\ORM\Association\BelongsToMany $SedativeDrugs
 */
class SuspectedMeProtocolsTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->table('suspected_me_protocols');
        $this->displayField('id');
        $this->primaryKey('id');

        $this->addBehavior('Timestamp');

        $this->belongsTo('Hospitalizations', [
            'foreignKey' => 'hospitalization_id',
            'joinType' => 'INNER',
        ]);
        $this->hasMany('LaboratoryExaminations', [
            'foreignKey' => 'suspected_me_protocol_id',
        ]);
        $this->hasMany('ObtainedOrgansFromCorpses', [
            'foreignKey' => 'suspected_me_protocol_id',
        ]);
        $this->hasMany('SedativeDrugs', [
            'foreignKey' => 'suspected_me_protocol_id',
        ]);
        $this->hasMany('SupplementaryExaminations', [
            'foreignKey' => 'suspected_me_protocol_id',
        ]);

        $this->belongsToMany('Organs', [
            'foreignKey' => 'suspected_me_protocol_id',
            'targetForeignKey' => 'organ_id',
            'joinTable' => 'organs_suspected_me_protocols',
        ]);

        $this->belongsToMany('PotentialOrgans', [
            'foreignKey' => 'suspected_me_protocol_id',
            'targetForeignKey' => 'organ_id',
            'joinTable' => 'potential_organs_suspected_me_protocols',
        ]);
        // $this->belongsToMany('SedativeDrugs', [
        //     'foreignKey' => 'suspected_me_protocol_id',
        //     'targetForeignKey' => 'sedative_drug_id',
        //     'joinTable' => 'sedative_drugs_suspected_me_protocols'
        // ]);
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('id')
            ->allowEmpty('id', 'create');

        $validator
            ->allowEmpty('causa_do_coma');

        $validator
            ->boolean('uso_de_drogas_depressoras')
            ->allowEmpty('uso_de_drogas_depressoras');

        $validator
            ->boolean('hiportemia')
            ->allowEmpty('hiportemia');

        $validator
            ->allowEmpty('1_exame_data');

        $validator
        //->time('1_exame_hora')
        ->allowEmpty('1_exame_hora');

        $validator
            ->allowEmpty('1_exame_nome_medico');

        $validator
            ->allowEmpty('1_exame_endereco');

        $validator
            ->allowEmpty('1_exame_numero_conselho');

        $validator
            ->boolean('1_exame_coma_aperceptivo')
            ->allowEmpty('1_exame_coma_aperceptivo');

        $validator
            ->boolean('1_exame_ausencia_de_reflexo_corneo')
            ->allowEmpty('1_exame_ausencia_de_reflexo_corneo');

        $validator
            ->boolean('1_exame_ausencia_de_reflexos_oculocefalicos')
            ->allowEmpty('1_exame_ausencia_de_reflexos_oculocefalicos');

        $validator
            ->boolean('1_exame_ausencia_de_respostas_as_provas')
            ->allowEmpty('1_exame_ausencia_de_respostas_as_provas');

        $validator
            ->allowEmpty('2_exame_data');

        $validator
        //->time('2_exame_hora')
        ->allowEmpty('2_exame_hora');

        $validator
            ->allowEmpty('2_exame_nome_medico');

        $validator
            ->allowEmpty('2_exame_endereco');

        $validator
            ->allowEmpty('2_exame_numero_conselho');

        $validator
            ->allowEmpty('2_exame_coma_aperceptivo');

        $validator
            ->allowEmpty('2_exame_ausencia_de_reflexo_corneo');

        $validator
            ->allowEmpty('2_exame_ausencia_de_reflexos_oculocefalicos');

        $validator
            ->allowEmpty('2_exame_ausencia_de_respostas_as_provas');

        $validator
            ->boolean('is_active')
            ->allowEmpty('is_active');

        $validator
            ->boolean('ausencia_reflexo_pupilar')
            ->allowEmpty('ausencia_reflexo_pupilar');

        $validator
            ->boolean('ausencia_reflexo_oculovestibular')
            ->allowEmpty('ausencia_reflexo_oculovestibular');

        $validator
            ->boolean('ausencia_reflexo_tosse')
            ->allowEmpty('ausencia_reflexo_tosse');

        $validator
            ->boolean('ausencia_drive')
            ->allowEmpty('ausencia_drive');

        $validator
            ->boolean('1_acolhimento_realizacao')
            ->allowEmpty('1_acolhimento_realizacao');

        $validator
            ->boolean('1_acolhimento_aceitam')
            ->allowEmpty('1_acolhimento_aceitam');

        $validator
            ->allowEmpty('1_acolhimento_motivo');

        $validator
            ->boolean('2_acolhimento_realizacao')
            ->allowEmpty('2_acolhimento_realizacao');

        $validator
            ->boolean('2_acolhimento_aceitam')
            ->allowEmpty('2_acolhimento_aceitam');

        $validator
            ->allowEmpty('2_acolhimento_motivo');

        $validator
            ->boolean('fechamento_exame_colhido')
            ->allowEmpty('fechamento_exame_colhido');

        $validator
        //->date('2_acolhimento_data')
        ->allowEmpty('2_acolhimento_data');

        $validator
        //->time('2_acolhimento_hora')
        ->allowEmpty('2_acolhimento_hora');

        $validator
        //->date('1_acolhimento_data')
        ->allowEmpty('1_acolhimento_data');

        $validator
        //->time('1_acolhimento_hora')
        ->allowEmpty('1_acolhimento_hora');

        $validator
        //->time('fechamento_exame_colhido_hora')
        ->allowEmpty('fechamento_exame_colhido_hora');

        $validator
        //->date('fechamento_exame_colhido_data')
        ->allowEmpty('fechamento_exame_colhido_data');

        $validator
            ->boolean('fechamento_encaminhado_exame')
            ->allowEmpty('fechamento_encaminhado_exame');

        $validator
        //->date('fechamento_encaminhado_exame_data')
        ->allowEmpty('fechamento_encaminhado_exame_data');

        $validator
        //->time('fechamento_encaminhado_exame_hora')
        ->allowEmpty('fechamento_encaminhado_exame_hora');

        $validator
            ->boolean('fechamento_solicitado_agendamento')
            ->allowEmpty('fechamento_solicitado_agendamento');

        $validator
        //->date('fechamento_solicitado_agendamento_data')
        ->allowEmpty('fechamento_solicitado_agendamento_data');

        $validator
        //->time('fechamento_solicitado_agendamento_hora')
        ->allowEmpty('fechamento_solicitado_agendamento_hora');

        $validator
            ->boolean('orgaos_doar_cornea')
            ->allowEmpty('orgaos_doar_cornea');

        $validator
            ->boolean('orgaos_doar_coracao')
            ->allowEmpty('orgaos_doar_coracao');

        $validator
            ->boolean('orgaos_doar_pulmoes')
            ->allowEmpty('orgaos_doar_pulmoes');

        $validator
            ->boolean('orgaos_doar_rins')
            ->allowEmpty('orgaos_doar_rins');

        $validator
            ->boolean('orgaos_doar_figado')
            ->allowEmpty('orgaos_doar_figado');

        $validator
            ->boolean('orgaos_doar_pancreas')
            ->allowEmpty('orgaos_doar_pancreas');

        $validator
            ->boolean('orgaos_doar_ossos')
            ->allowEmpty('orgaos_doar_ossos');

        $validator
            ->boolean('orgaos_doar_cadaver_cornea')
            ->allowEmpty('orgaos_doar_cadaver_cornea');

        $validator
            ->boolean('orgaos_doar_cadaver_rin')
            ->allowEmpty('orgaos_doar_cadaver_rin');

        $validator
            ->boolean('orgaos_doar_cadaver_ossos')
            ->allowEmpty('orgaos_doar_cadaver_ossos');

        $validator
        //->date('data_captcao_orgaos')
        ->allowEmpty('data_captcao_orgaos');

        $validator
        //->time('hora_captcao_orgaos')
        ->allowEmpty('hora_captcao_orgaos');

        $validator
        //->date('data_liberacao_corpo')
        ->allowEmpty('data_liberacao_corpo');

        $validator
        //->time('hora_liberacao_corpo')
        ->allowEmpty('hora_liberacao_corpo');

        $validator
            ->boolean('paciente_fez_uso_droga_sedativo')
            ->allowEmpty('paciente_fez_uso_droga_sedativo');

        $validator
            ->boolean('captacao_de_orgaos_cadaver')
            ->allowEmpty('captacao_de_orgaos_cadaver');

        $validator
            ->boolean('potencial_orgao_cornea')
            ->allowEmpty('potencial_orgao_cornea');

        $validator
            ->boolean('potencial_orgao_pulmao')
            ->allowEmpty('potencial_orgao_pulmao');

        $validator
            ->boolean('potencial_orgao_coracao')
            ->allowEmpty('potencial_orgao_coracao');

        $validator
            ->boolean('potencial_orgao_rin')
            ->allowEmpty('potencial_orgao_rin');

        $validator
            ->boolean('potencial_orgao_figado')
            ->allowEmpty('potencial_orgao_figado');

        $validator
            ->boolean('potencial_orgao_pancreas')
            ->allowEmpty('potencial_orgao_pancreas');

        $validator
            ->boolean('potencial_orgao_ossos')
            ->allowEmpty('potencial_orgao_ossos');

        $validator
            ->allowEmpty('1_pas');

        $validator
            ->allowEmpty('1_pad');

        $validator
            ->allowEmpty('1_temp');

        $validator
            ->allowEmpty('1_sato2');

        $validator
            ->allowEmpty('1_fc');

        $validator
            ->allowEmpty('1_fr');

        $validator
            ->allowEmpty('1_glicemia');

        $validator
            ->allowEmpty('1_pam');

        $validator
            ->boolean('1_ausencia_reflexo_pupilar')
            ->allowEmpty('1_ausencia_reflexo_pupilar');

        $validator
            ->boolean('1_ausencia_reflexo_oculovestibular')
            ->allowEmpty('1_ausencia_reflexo_oculovestibular');

        $validator
            ->boolean('1_ausencia_reflexo_tosse')
            ->allowEmpty('1_ausencia_reflexo_tosse');

        $validator
            ->boolean('1_ausencia_drive')
            ->allowEmpty('1_ausencia_drive');

        $validator
            ->allowEmpty('2_pas');

        $validator
            ->allowEmpty('2_pad');

        $validator
            ->allowEmpty('2_temp');

        $validator
            ->allowEmpty('2_sato2');

        $validator
            ->allowEmpty('2_fc');

        $validator
            ->allowEmpty('2_fr');

        $validator
            ->allowEmpty('2_glicemia');

        $validator
            ->allowEmpty('2_pam');

        $validator
            ->boolean('2_ausencia_reflexo_pupilar')
            ->allowEmpty('2_ausencia_reflexo_pupilar');

        $validator
            ->boolean('2_ausencia_reflexo_oculovestibular')
            ->allowEmpty('2_ausencia_reflexo_oculovestibular');

        $validator
            ->boolean('2_ausencia_reflexo_tosse')
            ->allowEmpty('2_ausencia_reflexo_tosse');

        $validator
            ->boolean('2_ausencia_drive')
            ->allowEmpty('2_ausencia_drive');

        return $validator;
    }

    public function getRelatorioData($hospitalizations)
    {
        $calc_obj = new MedidasDispersao();

        $data =
            [
            'total_de_registros' => 0,
        ];
        $percentual = [];

        foreach ($hospitalizations as $hospitalization)
        {
            //$data = $hospitalization["neonatal_checklists"];
            foreach ($hospitalization["suspected_me_protocols"] as $key_1 => $neonatal)
            {
                $neonatal_arr = (array) $neonatal;
                $i = 0;

                $data['total_de_registros']++;

                foreach ($neonatal_arr as $key_2 => $value_2)
                {
                    $i++;
                    if ($i == 2) //acessa as propriades do obj
                    {
                        foreach ($value_2 as $key_3 => $value_3)
                        {
                            //$data[$key_3] = $value_3;
                            formatArr($value_3, $data, $key_3);
                        }
                    }
                }
            }
        }

        foreach ($data as $key => $value)
        {
            $marcados = 0;

            $len = count($data[$key]['arr']);

            for ($i = 0; $i < $len; $i++)
            {
                if ($data[$key]['arr'][$i] || $data[$key]['arr'][$i] !== 0)
                {
                    $marcados++;
                }
            }

            if (isset($data[$key]['percentual']))
            {
                $data[$key]['total'] = count($data[$key]['arr']);
                $data[$key]['percentual'] = $calc_obj->calculate_percentage($marcados, $data['total_de_registros']);
                $data[$key]['media'] = $calc_obj->calc_average($data[$key]['arr']);
                $data[$key]['mediana'] = $calc_obj->calculate_median($data[$key]['arr']);
                $data[$key]['desvio_padrao'] = $calc_obj->standard_deviation($data[$key]['arr']);
            }
        }

        return $data;
    }

    /**
     * Returns a rules checker object that will be used for validating
     * application integrity.
     *
     * @param \Cake\ORM\RulesChecker $rules The rules object to be modified.
     * @return \Cake\ORM\RulesChecker
     */
    public function buildRules(RulesChecker $rules)
    {
        $rules->add($rules->existsIn(['hospitalization_id'], 'Hospitalizations'));
        return $rules;
    }
}
