<nav class="large-3 medium-4 columns" id="actions-sidebar">
    <ul class="side-nav">
        <li class="heading"><?= __('Actions') ?></li>
        <li><?= $this->Html->link(__('New Clinic Tev Protocols Risk Factor'), ['action' => 'add']) ?></li>
        <li><?= $this->Html->link(__('List Risk Factors'), ['controller' => 'RiskFactors', 'action' => 'index']) ?></li>
        <li><?= $this->Html->link(__('New Risk Factor'), ['controller' => 'RiskFactors', 'action' => 'add']) ?></li>
        <li><?= $this->Html->link(__('List Clinic Tev Protocols'), ['controller' => 'ClinicTevProtocols', 'action' => 'index']) ?></li>
        <li><?= $this->Html->link(__('New Clinic Tev Protocol'), ['controller' => 'ClinicTevProtocols', 'action' => 'add']) ?></li>
    </ul>
</nav>
<div class="clinicTevProtocolsRiskFactors index large-9 medium-8 columns content">
    <h3><?= __('Clinic Tev Protocols Risk Factors') ?></h3>
    <table cellpadding="0" cellspacing="0">
        <thead>
            <tr>
                <th><?= $this->Paginator->sort('id') ?></th>
                <th><?= $this->Paginator->sort('risk_factors_id') ?></th>
                <th><?= $this->Paginator->sort('clinic_tev_protocols_id') ?></th>
                <th class="actions"><?= __('Actions') ?></th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($clinicTevProtocolsRiskFactors as $clinicTevProtocolsRiskFactor): ?>
            <tr>
                <td><?= $this->Number->format($clinicTevProtocolsRiskFactor->id) ?></td>
                <td><?= $clinicTevProtocolsRiskFactor->has('risk_factor') ? $this->Html->link($clinicTevProtocolsRiskFactor->risk_factor->id, ['controller' => 'RiskFactors', 'action' => 'view', $clinicTevProtocolsRiskFactor->risk_factor->id]) : '' ?></td>
                <td><?= $clinicTevProtocolsRiskFactor->has('clinic_tev_protocol') ? $this->Html->link($clinicTevProtocolsRiskFactor->clinic_tev_protocol->id, ['controller' => 'ClinicTevProtocols', 'action' => 'view', $clinicTevProtocolsRiskFactor->clinic_tev_protocol->id]) : '' ?></td>
                <td class="actions">
                    <?= $this->Html->link(__('View'), ['action' => 'view', $clinicTevProtocolsRiskFactor->id]) ?>
                    <?= $this->Html->link(__('Edit'), ['action' => 'edit', $clinicTevProtocolsRiskFactor->id]) ?>
                    <?= $this->Form->postLink(__('Delete'), ['action' => 'delete', $clinicTevProtocolsRiskFactor->id], ['confirm' => __('Are you sure you want to delete # {0}?', $clinicTevProtocolsRiskFactor->id)]) ?>
                </td>
            </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
    <div class="paginator">
        <ul class="pagination">
            <?= $this->Paginator->prev('< ' . __('previous')) ?>
            <?= $this->Paginator->numbers() ?>
            <?= $this->Paginator->next(__('next') . ' >') ?>
        </ul>
        <p><?= $this->Paginator->counter() ?></p>
    </div>
</div>
