<?php

$this->assign('title', $title);
?>

<div class="row">

<div class="patients index index col-md-12 col-lg columns content">

    <div class="row">
        <div class="col-sm-3 input-group pad-left-15" style="display:inline-block;" >
            <?=$this->Form->create('index', ['type' => 'get'])?>
            <?=$this->Form->input('cpf', ['label' => '', 'placeholder' => 'CPF']);?>
        </div>

        <div class="col-sm-3 input-group pad-left-15" style="display:inline-block;">
            <?=$this->Form->input('name', ['label' => '', 'placeholder' => 'Nome']);?>
        </div>

        <div class="col-sm-3 input-group pad-left-15" style="display:inline-block;">
            <?=$this->Form->input('sector_id', ['label' => '', 'options' => $sectors, 'empty' => 'Setor']);?>
        </div>

        <?=$this->Form->button(__('Pesquisar', true), array('class' => 'bt-search'))?>
        <?=$this->Form->end()?>
        <!--
            <?=$this->Form->input('search', ['label' => '', 'placeholder' => 'Filtrar pelo nome']);?>

            &nbsp;&nbsp;&nbsp;&nbsp;
                 <?php
echo $this->Html->link('Limpar filtros',
    ['controller' => 'Patients', 'action' => 'index']
    , array('class' => 'bt-search btn btn-success'));
?>
         -->
        </div>
        <br><br><br>
    </div>


    <?php
//if ($isLogged['role_name'] == " ")
echo $this->Html->link('Novo Paciente',
    ['controller' => 'Patients', 'action' => 'add']
    , array('class' => 'link-bt'));
?>
    <br><br>
    <div class="table-responsive">
    <table class="table table-striped table-hover">
        <thead>
            <tr>
                <th>leito</th>
                <th>Número do prontuário</th>
                <th>Nome</th>
                <th>Idade</th>
                <th>Estadia (dias)</th>
                <th>Precaução</th>
                <th>Alertas</th>
                <th class="actions"><?=__('Ações')?></th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($data as $value): ?>
                <?php
                    $value->patient->estadia = 0;
                    $value->patient->age     = 0;
                    $value->precaucao        = null;
                    // $len = count($value['cultures']);
                    // $i = 0;
                    foreach ($value['cultures'] as $key => $culture) {
                        $value->precaucao .=$culture['germe'] . '<br>';
                    }

                    //calcula a idade
                    if (isset($value->patient->birthday)) {
                        $from                = $value->patient->birthday;
                        $to                  = new DateTime('today');
                        $value->patient->age = $from->diff($to)->y;
                    }

                    //calcula o tempo de estadia
                    if (isset($value->date_of_hospitalization)) {
                        $from = new DateTime($value->date_of_hospitalization->i18nFormat('Y-m-d'));
                        $to   = new DateTime('today');

                        $value->patient->estadia = $from->diff($to)->format("%a");
                    }

                    ?>
            <tr>
                <td>
                    <?php //
                        if (isset($value->historic_patient_movements[0]->room->name)) {
                            echo $value->historic_patient_movements['0']->room->name;
                        }

                        if (isset($value->historic_patient_movements[0]['_matchingData']['Rooms']['name'])) {
                            echo $value->historic_patient_movements[0]['_matchingData']['Rooms']['name'];
                        }
                    ?>
                </td>
                <td><?=h($value->numero_do_prontuario)?></td>
                <td><?=h($value->patient->nome)?></td>


                <td><?=h($value->patient->age)?></td>
                <td><?=h($value->patient->estadia)?></td>
                <td data-toggle="tooltip" title="<?=$value->precaucao?>">
                <?=truncate($value->precaucao, 135)?>
                </td>
                <td></td>
                <td class="actions" style="white-space:nowrap">
                    <?=$this->Html->link(__('Internação'), ['action' => 'selectPatientHosp', $value->patient->id, $value->patient->nome, $value->id], ['class' => 'btn btn-primary btn-xs'])?>

                    <?=$this->Html->link(__('Paciente'), ['action' => 'edit', $value->patient->id], ['class' => 'btn btn-primary btn-xs'])?>
                </td>
            </tr>
            <?php endforeach;?>
        </tbody>
    </table>
    </div>
    <div class="paginator">
        <center>
            <ul class="pagination">
                <?=$this->Paginator->prev('&laquo; ' . __('Anterior'), ['escape' => false])?>
                <?=$this->Paginator->numbers(['escape' => false])?>
                <?=$this->Paginator->next(__('Próxima') . ' &raquo;', ['escape' => false])?>
            </ul>

        </div>
    </center>
</div>
</div>


<script >
(function() {
   // your page initialization code here
   // the DOM will be available here
   var link1 =' <?=$this->Html->link('<i class="glyphicon glyphicon-home"></i>&nbsp;Unidade(s)',
    array('controller' => 'Users', 'action' => 'login'), array('class' => 'btn btn-default ', 'escape' => false))?> ';

    var html = '';
        html+= '<div class="btn-group btn-breadcrumb custom-breadcumb">';
        html+= link1;
        html+= '<a href="#" class="breadcumb-active btn btn-default">Pacientes</a>';
        html+= '</div>';
            document.getElementById("breadcumb").innerHTML =html;
})();
</script>