<?php

if ($current_state == 'internacao')
{
    echo $this->element('internacao-menu');
}
else
{
    echo $this->element('screening-menu');
}

?>
<div class="row">

<div class="prescriptions index col-md-8 columns content">
    <a href="#" id="new-prescription" class="link-bt">Nova Prescrição</a>
    <br><br>
    <table class="table table-striped table-hover" id="prescription-table">
        <thead>
            <tr>
                <th><?=$this->Paginator->sort('created', ['label' => 'Data de Preenchimento'])?></th>
                <th class="actions"><?=__('Ações')?></th>
            </tr>
        </thead>
        <tbody>
            <?php

foreach ($prescriptions as $prescription): ?>
            <tr>
                <td><?=h($prescription->created)?></td>
                <td class="actions" style="white-space:nowrap">
                    <?=$this->Html->link(__('Editar'), ['action' => 'edit', $prescription->id], ['class' => 'btn btn-primary btn-xs'])?>
                    <?=$this->Form->postLink(__('Deletar'), ['action' => 'delete', $prescription->id], ['confirm' => __('Tem certeza que deseja deletar o registro?'), 'class' => 'btn btn-danger btn-xs'])?>
                </td>
            </tr>
            <?php endforeach;?>
        </tbody>
    </table>
    <div class="paginator">
        <center>
            <ul class="pagination">
                <?=$this->Paginator->prev('&laquo; ' . __('Anterior'), ['escape' => false])?>
                <?=$this->Paginator->numbers(['escape' => false])?>
                <?=$this->Paginator->next(__('Próximo') . ' &raquo;', ['escape' => false])?>
            </ul>

        </div>
    </center>
</div>
</div>


<script >
var lastPrescriptionId = <?=$lastPrescriptionId?>;
console.log('ultima prescription '+lastPrescriptionId);


$(document).ready(function() {
    $("#new-prescription").click(function() {
        var url = '<?=$this->Url->build(["controller" => "Prescriptions", "action" => "add"]);?>/';
        if (lastPrescriptionId == 0) {
            window.location.href = url;
        }
        else {
            $.confirm({
                title: '',
                confirmButton: 'Sim',
                cancelButton: 'Não',
                content: 'Deseja copiar a prescrição anterior ?',
                onOpen: function(){
                   // alert('after the modal is opened/rendered');
                },
                onClose: function() {
                    //console.log('before the modal is closed');
                },
                onAction: function(action) {
                    // action is either 'confirm', 'cancel' or 'close'
                    //console.log(action + ' was clicked');
                    //console.log( 'lastPrescriptionId = ' +  lastPrescriptionId);
                    if (action == "cancel") {
                        window.location.href = url;
                    }
                    else if (action == "confirm") {
                        window.location.href = url + lastPrescriptionId;
                    }
                }
            });
        }
    });
});



</script>




<?php

if ($current_state == "internacao"): ?>
    <script >
        (function() {
           // your page initialization code here
           // the DOM will be available here
            var link1 =' <?=$this->Html->link('<i class="glyphicon glyphicon-home"></i>&nbsp;Unidade(s)',
    ['controller' => 'Users', 'action' => 'login'], ['class' => 'btn btn-default ', 'escape' => false])?> ';

            var link2 =' <?=$this->Html->link('Pacientes', ['controller' => 'Patients', 'action' => 'index', '_full' => true], ['class' => 'btn btn-default ']);?> ';

            var link3 =' <?=$this->Html->link('Internações', ['controller' => 'Hospitalizations', 'action' => 'index', $hospitalization_id, '_full' => true], ['class' => 'btn btn-default ']);?> ';

            var html = '';
                html+= '<div class="btn-group btn-breadcrumb custom-breadcumb">';
                html+= link1;
                html+= link2;
                html+= link3;
                html+= '<a href="#" class="breadcumb-active btn btn-default">Prescrição</a>';
                html+= '</div>';
                    document.getElementById("breadcumb").innerHTML =html;
        })();
    </script>

<?php else: ?>
    <script >
        (function() {
           // your page initialization code here
           // the DOM will be available here
            var link1 =' <?=$this->Html->link('<i class="glyphicon glyphicon-home"></i>&nbsp;Unidade(s)',
    ['controller' => 'Users', 'action' => 'login'], ['class' => 'btn btn-default ', 'escape' => false])?> ';

            var link2 =' <?=$this->Html->link('Pacientes', ['controller' => 'Patients', 'action' => 'index', '_full' => true], ['class' => 'btn btn-default ']);?> ';

            var link3 =' <?=$this->Html->link('Triagem', ['controller' => 'Screenings', 'action' => 'index', $screening_id, '_full' => true], ['class' => 'btn btn-default ']);?> ';

            var html = '';
                html+= '<div class="btn-group btn-breadcrumb custom-breadcumb">';
                html+= link1;
                html+= link2;
                html+= link3;
                html+= '<a href="#" class="breadcumb-active btn btn-default">Prescrição</a>';
                html+= '</div>';
                    document.getElementById("breadcumb").innerHTML =html;
        })();
    </script>
<?php endif;?>

