<?php
echo $this->Html->script('prescription-forms-scripts.js');

if ($current_state == 'internacao')
{
    echo $this->element('internacao-menu');
}
else
{
    echo $this->element('screening-menu');
}

$via = [
  'CNG' => 'CNG',
  'Enteral' => 'Enteral',
  'GTT' => 'GTT',
  'IM' => 'IM',
  'IV' => 'IV',
  'Nasal' => 'Nasal',
  'NBZ' => 'NBZ',
  'Ocular' => 'Ocular',
  'Oral' => 'Oral',
  'Retal' => 'Retal',
  'SC'=> 'SC',
  'Spray' => 'Spray',
  'Tópico' => 'Tópico',
  'Tecal' => 'Tecal',
  'Intrauricular' => 'Intrauricular',
  'Intracavitária' => 'Intracavitária',
  'NSA' => 'NSA'
];

$frequencies =  [
     '1X SEM' => '1X SEM',
     'SEG QUA SEX' => 'SEG QUA SEX',
     'TER QUI SAB' => 'TER QUI SAB',
     'DIAS ALTERNADOS' => 'DIAS ALTERNADOS',
     '1X DIA' => '1X DIA',
     '12/12 H' => '12/12 H',
     '8/8 H' => '8/8 H',
     '6/6 H' => '6/6 H',
     '4/4 H' => '4/4 H',
     '3/3 H' => '3/3 H',
     '2/2 H' => '2/2 H',
     '1/1 H' =>'1/1 H',
     'ACM' => 'ACM',
     'SOS' => 'SOS',
     'BI' => 'BI',
     'NSA' => 'NSA',
];

$categories = [
  'Medicamentos' => 'Medicamentos',
  'Exame de Imagem' => 'Exame de Imagem',
  'Exame Laboratorial' => 'Exame Laboratorial',
  'Material'=> 'Material',
  'Assistencia' => 'Assistencia'
];

$surveillanceSignalings = [
  'Alta Vigilância' => 'Alta Vigilância',
  'Med. Potencialmente Perigosas' => 'Med. Potencialmente Perigosas',
  'Não Padronizada' => 'Não Padronizada'
];

$presentations = [
  'Bisnaga' => 'Bisnaga',
  'Cápsula' => 'Cápsula',
  'Comprimido' => 'Comprimido',
  'Frasco' => 'Frasco',
  'Gotas' => 'Gotas',
  'Microgotas' => 'Microgotas',
  'Pastilha' => 'Pastilha',
  'Puff' => 'Puff',
  'Sachê' => 'Sachê',
  'Spray' => 'Spray',
  'NSA' => 'NSA'
];

$scheduling = [
  "24H - 12H",
  "22H - 10H",
  "20H - 08H",
  "18H - 06H",
  "16H - 04H",
  "14H - 02H",
  "24H - 08H - 16H",
  "22H - 06H - 14H",
  "20H - 04H - 12H",
  "18H - 02H - 10H",
  "24H - 06H - 12H - 18H",
  "22H - 04H - 10H - 16 H",
  "20H - 02H - 08H - 14 H",
  "22H - 02H - 06H - 10H - 14H - 18H",
  "20H - 24H - 04H - 08H - 12H - 16H",
  "21H - 24H - 03H - 06H - 09H - 12H - 15H - 18H",
  "20H - 23H - 02H - 05H - 08H - 11H - 14H - 17H",
  "19H - 22H - 01H - 04H - 07H - 10H - 13H - 16H",
  "20H - 22H - 24H - 02H - 04H - 06H - 08H - 10H - 12H - 14H - 16H - 18H",
  "19H - 21H - 23H - 01H - 03H - 05H - 07H - 09H - 11H - 13H - 15H - 17H",
  "20H - 21H - 22H - 23H - 24H - 1H - 2H - 3H - 4H - 5H - 6H - 7H - 8H - 9H - 10H - 11H - 12H - 13H - 14H - 15H - 16H - 17H - 18H - 19H",
  "24H",
  "22H",
  "20H",
  "18H",
  "16H",
  "14H",
  "12H",
  "10H",
  "08H",
  "06H",
  "04H",
  "02H",
  "ACM",
  "SOS",
  "NO ALMOÇO",
  "EM JEJUM 06H",
  "NO JANTAR",
  "NAS REFEIÇÕES",
  "ESQUEMA",
  "EM BOMBA INFUSORA",
  "NAS 24 HORAS",
  "HOJE NÃO - DIA ALTERNADO",
  "500-500-500-500-500-500-500-500",
  "500-500-500-500-500-500-500",
  "500-500-500-500-500-500",
  "500-500-500-500-500",
  "500-500-500-500",
  "500-500-500",
  "500-500",
  "500"
];

$schdOpt = [];
foreach ($scheduling as $key => $value) {
  $schdOpt[$value] = $value;
}

$scheduling = $schdOpt;

?>

<style >
    td, th {
        text-align: left;
    }
</style>
<div  class="prescriptions form col-md-9 columns content">
   <?=$this->Form->create($prescription, ['id' => 'prescription-form'])?>
      <?php $this->Form->templates(['inputContainer' => '{{content}}']); ?>
      <?= $this->Form->hidden('professional_id',['value' => $professional['id']]);?>

        <?php

            if ($current_state == "internacao")
            {
                echo $this->Form->hidden('hospitalization_id', ['value' => $hospitalizationId]);
            }
            else
            {
                echo $this->Form->hidden('screening_id', ['value' => $screening_id]);
            }

            echo $this->Form->hidden('sector_id', ['value' => $currentSector['id']]);
         ?>

        <div id="inserir-aprazamento-div">
          <label  for="inserir_aprazamento">Inserir aprazamento neste momento?</label>
          <?= $this->Form->radio('inserir_aprazamento', ['Sim','Não']); ?>
        </div>

        <div>
          <button type="button" onclick="appendItem('commonPrescriptionsForm')" class="btn btn-success" >Novo Item</button>
        </div>
        <br><br>

        <p class="info-text"><i class="glyphicon glyphicon-info-sign"></i>Arraste os itens para organiza-los se necessário.</p>
        <div style="overflow-x:scroll;">
           <table class="table table-striped table-hover" id="medications-table">

               <thead>
                   <tr>
                       <th>Medicamento / Procedimento</th>
                       <th>Quantidade</th>
                       <th>Via de Administração</th>
                       <th>Frequência</th>
                       <th class="hidden-table-item">Horário</th>
                       <th>Inicio imediato</th>
                       <th>Horario - Aprazamento</th>
                       <th>Data de inicio</th>
                       <th>Tempo esperado de uso</th>
                       <th>Justifivativa</th>
                       <th>Observação</th>
                       <th class="actions"><?=__('Ações')?></th>
                   </tr>
               </thead>

               <tbody id='tbody'>

                     <?php
                        if(!empty($preSelectedMedications)):
                           foreach ($preSelectedMedications as $key => $medication):

                              $isAntibiotic = ($medication['system_medication']['is_antibiotic']) ? 1 : 0;
                              $surSign = $medication['surveillance_signaling'];
                              $isRequired = false;

                              if($isAntibiotic == 1) {
                                 $isRequired = true;
                              }
                              else if($surSign == "Não Padronizada") {
                                 $isRequired = true;
                              }

                     ?>
                           <tr id="medication-data-<?=$key?>" class="input-row">

                             <td class="medication-hidden-inputs">

                                <?= $this->Form->hidden('prescription_medications.'.$key.'.surveillance_signaling', ['value'=>$medication['surveillance_signaling'],'class'=>'surveillance-signaling']);?>

                                <div class="culture-ids"></div>

                             </td>

                             <td class="medication-name input-tds">
                                <?= $this->Form->input('prescription_medications.'.$key.'.system_medication_id',['class'=>'select-sytem-medication', 'required' => true, 'empty' => true, 'options' => $systemMedicationsOpt,'value'=>$medication['system_medication_id'], 'label' => false]);?>
                             </td>

                             <td class="medication-quantity input-tds">

                                <?= $this->Form->input('prescription_medications.'.$key.'.quantity', ['value'=> $medication['quantity'],'empty'=>true, 'label' => false]);?>

                             </td>

                             <td class="medication-channel input-tds">

                                <?= $this->Form->input('prescription_medications.'.$key.'.channel', ['options'=>$via,'value'=> $medication['channel'],'empty'=>true, 'label' => false]);?>

                             </td>

                             <td class="medication-frequency input-tds">

                                <?= $this->Form->input('prescription_medications.'.$key.'.frequency', ['options'=>$frequencies,'value'=> $medication['frequency'],'empty'=>true, 'label' => false]);?>

                             </td>

                             <td class="medication-scheduling input-tds hidden-table-item">

                                <?= $this->Form->input('prescription_medications.'.$key.'.schedule', ['options'=>$scheduling,'value'=> $medication['schedule'],'empty'=>true, 'label' => false]);?>

                             </td>

                             <td class="medication-imediate-start check-tds input-tds">
                               <div class="custom-check">
                                <?= $this->Form->input('prescription_medications.'.$key.'.imediate_start', ['checked'=> $medication['imediate_start'],'class'=>'imediate-start-check','label' => false]);?>
                                <label class="check-label" for="prescription-medications-<?=$key?>-imediate-start"></label>
                               </div>
                             </td>

                             <td class="medication-select-schedule check-tds input-tds">
                                <div class="custom-check">
                                  <?= $this->Form->input('prescription_medications.'.$key.'.select_schedule', ['checked'=> $medication['select_schedule'],'class'=>'select-schedule-check','label' => false]);?>
                                  <label class="check-label" for="prescription-medications-<?=$key?>-select-schedule"></label>
                                </div>
                             </td>

                             <td class="medication-start-date input-tds">

                                <?= $this->Form->input('prescription_medications.'.$key.'.start_date', ['value'=> $medication['start_date'],'class'=>'date', 'type'=>'text','empty'=>true, 'label' => false]);?>

                             </td>

                             <td class="medication-using-time input-tds">

                                <?= $this->Form->input('prescription_medications.'.$key.'.using_time', ['value'=> $medication['using_time'],'empty'=>true, 'label' => false]);?>

                             </td>

                             <td class="medication-justification input-tds">

                                <?= $this->Form->input('prescription_medications.'.$key.'.antibiotic_justification', ['value'=> $medication['antibiotic_justification'],'onclick'=>'showTextAreaModal("#medication-modal-'.$key.'",this)','type'=>'textarea',"required" => $isRequired,'empty'=>true, 'label' => false]);?>

                             </td>

                             <td class="medication-observation input-tds">

                                <?= $this->Form->input('prescription_medications.'.$key.'.observation', ['value'=> $medication['observation'],'onclick'=>'showTextAreaModal("#medication-modal-'.$key.'",this)','type'=>'textarea','empty'=>true, 'label' => false]);?>

                             </td>


                             <td class="actions" style="white-space:nowrap">
                                 <a href="#" class="btn btn-danger btn-xs" onclick="deleteMedication('<?=$key?>')">Deletar</a>
                             </td>

                           </tr>

                     <?php
                           endforeach;
                        endif;
                     ?>

               </tbody>

           </table>
        </div>

        <div class="action-buttons-div">
          <?=$this->Form->button(__('Salvar'), ['class'=>' btn btn-success'])?>
        </div>
        <div class="medication-modals">
        </div>
   <?=$this->Form->end()?>

</div>

<script>

  $(document).ready(function() {

      var culturesWithGerms    = <?= (isset($culturesWithGerms)) ? json_encode($culturesWithGerms): json_encode([]) ?>;
      var numberOfMedications  = <?= (isset($numberOfMedications)) ? $numberOfMedications : 0 ?>;
      var systemMedications  = <?= (isset($systemMedications)) ? json_encode($systemMedications): json_encode([]) ?>;


      initializeMedicationsCounter(numberOfMedications);
      initializeCulturesObj(culturesWithGerms);
      initializeSystemMedicationsObj(systemMedications);

      setTimeout(function() {
        if (numberOfMedications>0) {
          var i = 0;
          while (i < numberOfMedications) {
            $(".medication-modals").append(getModal(i));
            i++;
          }
          $('.multiselect').multiselect();
        }
      },2000);


  });

  <?php

  if ($current_state == "internacao"): ?>

           (function() {
              // your page initialization code here
              // the DOM will be available here

              var link1 =' <?=$this->Html->link('<i class="glyphicon glyphicon-home"></i>&nbsp;Unidade(s)',
              ['controller' => 'Users', 'action' => 'login'], ['class' => 'btn btn-default ', 'escape' => false])?> ';

              var link2 =' <?=$this->Html->link('Pacientes', ['controller' => 'Patients', 'action' => 'index', '_full' => true], ['class' => 'btn btn-default ']);?> ';

              var link3 =' <?=$this->Html->link('Internação', ['controller' => 'hospitalizations', 'action' => 'edit', $hospitalizationId, '_full' => true], ['class' => 'btn btn-default ']);?> ';

               var link4 =' <?=$this->Html->link('Prescrições', ['controller' => 'Prescriptions', 'action' => 'index', '_full' => true], ['class' => 'btn btn-default ']);?> ';

               var html = '';
                   html+= '<div class="btn-group btn-breadcrumb custom-breadcumb">';
                   html+= link1;
                   html+= link2;
                   html+= link3;
                   html+= link4;
                   html+= '<a href="#" class="breadcumb-active btn btn-default">Novo</a>';
                   html+= '</div>';
                       document.getElementById("breadcumb").innerHTML =html;
           })();

   <?php else: ?>

           (function() {
              // your page initialization code here
              // the DOM will be available here

              var link1 =' <?=$this->Html->link('<i class="glyphicon glyphicon-home"></i>&nbsp;Unidade(s)',
             ['controller' => 'Users', 'action' => 'login'], ['class' => 'btn btn-default ', 'escape' => false])?> ';

              var link2 =' <?=$this->Html->link('Pacientes', ['controller' => 'Patients', 'action' => 'index', '_full' => true], ['class' => 'btn btn-default ']);?> ';

              var link3 =' <?=$this->Html->link('Triagem', ['controller' => 'hospitalizations', 'action' => 'edit', $screening_id, '_full' => true], ['class' => 'btn btn-default ']);?> ';

               var link4 =' <?=$this->Html->link('Prescrições', ['controller' => 'Prescriptions', 'action' => 'index', '_full' => true], ['class' => 'btn btn-default ']);?> ';

               var html = '';
                   html+= '<div class="btn-group btn-breadcrumb custom-breadcumb">';
                   html+= link1;
                   html+= link2;
                   html+= link3;
                   html+= link4;
                   html+= '<a href="#" class="breadcumb-active btn btn-default">Novo</a>';
                   html+= '</div>';
                       document.getElementById("breadcumb").innerHTML =html;
           })();

   <?php endif;?>

</script>
