<div class="row">

<?php

   if ($current_state == 'internacao') {
       echo $this->element('internacao-menu');
   } else {
       echo $this->element('screening-menu');
   }

   $prescriptionTypes = [
      'Sepse',
      'Pós Operatório-Bariátrica',
      'Pós Operatório-Cardíaca',
      'Insuficiência Cardíaca',
      'IAM'
   ];
?>

<div class="medications index col-md-9 columns content">

   <div class="btn-group prescriptions-types">

      <button type="button" class="btn btn-default dropdown-toggle bt-menu-margin" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
           Prescrições Padrão
           <span class="caret"></span>
       </button>
       <ul class="dropdown-menu">
            <li>
                <?=$this->Html->link("Nova Prescrição Padrão", ['controller' => 'prescriptions', 'action' => 'addDefaultPrescription', '_full' => true]);?>
            </li>
            <li>
                <?=$this->Html->link("Utilizar Prescrição Padrão", ['controller' => 'prescriptions', 'action' => 'includeDefaultPrescriptions', '_full' => true]);?>
            </li>
       </ul>
   </div>
   <table class="table table-striped table-hover">
        <thead>
            <tr>
                <th><?= $this->Paginator->sort('name', 'Nome') ?></th>
                <th class="actions"><?= __('Ações') ?></th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($default_prescriptions as $prescription): ?>
            <tr>
                <td><?= ($prescription->name) ? $prescription->name : ''; ?></td>

                <td>
                  <?= $this->Html->link(__('Visualizar'), ['controller' => 'prescriptions', 'action' => 'viewDefaultPrescription', $prescription->id], ['class'=>'btn btn-primary btn-xs']) ?>
                  <?= $this->Html->link(__('Editar'), ['controller' => 'prescriptions', 'action' => 'editDefaultPrescription', $prescription->id], ['class'=>'btn btn-primary btn-xs']) ?>
              </td>
            </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
</div>
</div>

<script>

      $("#select-all").click(function() {
         $(".medication-check").prop('checked',$(this).prop('checked'));
      });


      $("#item-selection-form").on("submit",function() {
         var anyChecked = false;

         $(".medication-check").each(function() {
            if ($(this).prop('checked')) {
               anyChecked = true;
            }
         });

         if(anyChecked) {
            return true;
         }
         $.alert({
             title: 'Aviso!',
             confirmButton: 'Ok',
             content: 'Selecione ao menos um item para inclusão.',
         });
         return false;
      });



      <?php if ($current_state == "internacao"): ?>
           (function() {
              // your page initialization code here
              // the DOM will be available here
               var link1 =' <?= $this->Html->link('<i class="glyphicon glyphicon-home"></i>&nbsp;Unidade(s)',[
                  'controller' => 'Users', 'action' => 'login'],
                  ['class' => 'btn btn-default ', 'escape' => false
               ])?> ';

               var link2 =' <?=$this->Html->link('Pacientes', ['controller' => 'Patients', 'action' => 'index', '_full' => true], ['class' => 'btn btn-default ']);?> ';

               var link3 =' <?=$this->Html->link('Internações', ['controller' => 'Hospitalizations', 'action' => 'index', $hospitalization_id, '_full' => true], ['class' => 'btn btn-default ']);?> ';

               var html = '';
                   html+= '<div class="btn-group btn-breadcrumb custom-breadcumb">';
                   html+= link1;
                   html+= link2;
                   html+= link3;
                   html+= '<a href="#" class="breadcumb-active btn btn-default">Prescrição Padrão</a>';
                   html+= '</div>';
                       document.getElementById("breadcumb").innerHTML =html;
           })();
      <?php else: ?>

              (function() {
                 // your page initialization code here
                 // the DOM will be available here
                  var link1 =' <?=$this->Html->link(
              '<i class="glyphicon glyphicon-home"></i>&nbsp;Unidade(s)',
          ['controller' => 'Users', 'action' => 'login'],
              ['class' => 'btn btn-default ', 'escape' => false]
          )?> ';

                  var link2 =' <?=$this->Html->link('Pacientes', ['controller' => 'Patients', 'action' => 'index', '_full' => true], ['class' => 'btn btn-default ']);?> ';

                  var link3 =' <?=$this->Html->link('Triagem', ['controller' => 'Screenings', 'action' => 'index', $screening_id, '_full' => true], ['class' => 'btn btn-default ']);?> ';

                  var html = '';
                      html+= '<div class="btn-group btn-breadcrumb custom-breadcumb">';
                      html+= link1;
                      html+= link2;
                      html+= link3;
                      html+= '<a href="#" class="breadcumb-active btn btn-default">Prescrição Padrão</a>';
                      html+= '</div>';
                          document.getElementById("breadcumb").innerHTML =html;
              })();
      <?php endif;?>

   </script>
