
<div class="row">
   <?php

   if ($current_state == 'internacao')
   {
       echo $this->element('internacao-menu');
   }
   else
   {
       echo $this->element('screening-menu');
   }

   ?>
   <div class="col-md-9 dropdown-col">
   <div class="pull-right">
       <label>Filtro:</label>
       <div class="btn-group">
         <button type="button" class="btn btn-default dropdown-toggle bt-menu-margin" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
               Setores
               <span class="caret"></span>
           </button>
           <ul class="dropdown-menu">
             <li>
                  <?=$this->Html->link("Toda a unidade", [
                    'controller' => 'prescriptions',
                    'action' => 'prescriptions-dashboard',
                    '_full' => true]);
                  ?>
             </li>
             <?php foreach ($unitAvaiableSectors as $key => $value): ?>
               <li>
                     <?=$this->Html->link( $value, [
                      'controller' => 'prescriptions',
                       'action' => 'prescriptions-dashboard',
                       "?" => ["sector_id" => $key]
                       , '_full' => true]);
                     ?>
               </li>
            <?php endforeach; ?>
           </ul>
       </div>
   </div>
</div>
<div class="prescriptions index col-md-9 columns content">


    <div class="prescription-dashboard">

        <div class="item-wrpr">
           <h4 class="dash-item-label">Itens cadastrados</h4>
           <div class="prescriptions-dashboard-item">
             <?=
               $this->element('dashboard-metric', [
                  "metric" => $metrics['total_items']['value'],
                  "status" => $metrics['total_items']['status']
               ]);
             ?>
           </div>
        </div>

        <div class="item-wrpr">
           <h4 class="dash-item-label">Prescrições com medicações de alta vigilância</h4>
           <div class="prescriptions-dashboard-item">
             <?=
               $this->element('dashboard-metric', [
                  "metric" => $metrics['total_high_surveillance_items']['value'],
                  "status" => $metrics['total_high_surveillance_items']['status']
               ]);
             ?>
           </div>
        </div>

        <div class="item-wrpr">
           <h4 class="dash-item-label">Prescrições com medicações potiencialmente perigosas</h4>
           <div class="prescriptions-dashboard-item">
             <?=
               $this->element('dashboard-metric', [
                  "metric" => $metrics['total_potentially_dangerous_items']['value'],
                  "status" => $metrics['total_potentially_dangerous_items']['status']
               ]);
             ?>
           </div>
        </div>


        <div class="item-wrpr">
           <h4 class="dash-item-label">Prescrições ativas</h4>
           <div class="prescriptions-dashboard-item">
             <?=
               $this->element('dashboard-metric', [
                  "metric" => $metrics['total_active_prescriptions']['value'],
                  "status" => $metrics['total_active_prescriptions']['status']
               ]);
             ?>
           </div>
        </div>

        <div class="item-wrpr">
           <h4 class="dash-item-label">Prescrições com medicações em baixo estoque</h4>
           <div class="prescriptions-dashboard-item">
             <?=
               $this->element('dashboard-metric', [
                  "metric" => $metrics['prescription_with_meds_low_stock']['value'],
                  "status" => $metrics['prescription_with_meds_low_stock']['status']
               ]);
             ?>
           </div>
        </div>

        <div class="item-wrpr">
           <h4 class="dash-item-label">Prescrições com medicações de estoque zerado</h4>
           <div class="prescriptions-dashboard-item">
             <?=
               $this->element('dashboard-metric', [
                  "metric" => $metrics['prescription_with_meds_zero_stock']['value'],
                  "status" => $metrics['prescription_with_meds_zero_stock']['status']
               ]);
             ?>
           </div>
        </div>


        <div class="item-wrpr">
           <h4 class="dash-item-label">Prescrições com validação do farmacêutico</h4>
           <div class="prescriptions-dashboard-item">
             <?=
               $this->element('dashboard-metric', [
                  "metric" => $metrics['total_validated_prescriptions']['value'],
                  "status" => $metrics['total_validated_prescriptions']['status']
               ]);
             ?>
           </div>
        </div>

        <div class="item-wrpr">
           <h4 class="dash-item-label">Prescrições com itens não padronizados</h4>
           <div class="prescriptions-dashboard-item">
             <?=
               $this->element('dashboard-metric', [
                  "metric" => $metrics['prescription_with_standardized_meds']['value'],
                  "status" => $metrics['prescription_with_standardized_meds']['status']
               ]);
             ?>
           </div>
        </div>

        <div class="item-wrpr">
           <!-- <h4 class="dash-item-label">Prescrições com itens não padronizados</h4>
           <div class="prescriptions-dashboard-item">
             <span class="dash-item-data red-lbl">
                <?= $this->Html->image('decrease-arrow.png', ['class' => 'tick-box','alt' => 'GH', 'height'=>'40px', 'style'=>""]);?>
                <?= $prescriptionWithStandardizedMeds ?>
             </span>
           </div> -->
        </div>

    </div>
</div>


<script>
   <?php if ($current_state == "internacao"): ?>
        (function() {
           // your page initialization code here
           // the DOM will be available here
            var link1 =' <?=$this->Html->link('<i class="glyphicon glyphicon-home"></i>&nbsp;Unidade(s)',['controller' => 'Users', 'action' => 'login'], ['class' => 'btn btn-default ', 'escape' => false])?> ';

            var link2 =' <?=$this->Html->link('Pacientes', ['controller' => 'Patients', 'action' => 'index', '_full' => true], ['class' => 'btn btn-default ']);?> ';

            var link3 =' <?=$this->Html->link('Internações', ['controller' => 'Hospitalizations', 'action' => 'index', $hospitalization_id, '_full' => true], ['class' => 'btn btn-default ']);?> ';

            var html = '';
                html+= '<div class="btn-group btn-breadcrumb custom-breadcumb">';
                html+= link1;
                html+= link2;
                html+= link3;
                html+= '<a href="#" class="breadcumb-active btn btn-default">Prescrição</a>';
                html+= '</div>';
                    document.getElementById("breadcumb").innerHTML =html;
        })();

   <?php else: ?>
        (function() {
           // your page initialization code here
           // the DOM will be available here
            var link1 =' <?=$this->Html->link('<i class="glyphicon glyphicon-home"></i>&nbsp;Unidade(s)',['controller' => 'Users', 'action' => 'login'], ['class' => 'btn btn-default ', 'escape' => false])?> ';

            var link2 =' <?=$this->Html->link('Pacientes', ['controller' => 'Patients', 'action' => 'index', '_full' => true], ['class' => 'btn btn-default ']);?> ';

            var link3 =' <?=$this->Html->link('Triagem', ['controller' => 'Screenings', 'action' => 'index', $screening_id, '_full' => true], ['class' => 'btn btn-default ']);?> ';

            var html = '';
                html+= '<div class="btn-group btn-breadcrumb custom-breadcumb">';
                html+= link1;
                html+= link2;
                html+= link3;
                html+= '<a href="#" class="breadcumb-active btn btn-default">Prescrição</a>';
                html+= '</div>';
                    document.getElementById("breadcumb").innerHTML =html;
        })();

   <?php endif;?>
</script>
