<div class="row">

<?php

   if ($current_state == 'internacao') {
       echo $this->element('internacao-menu');
   } else {
       echo $this->element('screening-menu');
   }

   $prescriptionTypes = [
      'Sepse',
      'Pós Operatório-Bariátrica',
      'Pós Operatório-Cardíaca',
      'Insuficiência Cardíaca',
      'IAM'
   ];

   $from = $selected_patient_birthday;
   $to = new DateTime('today');
   $age = $from->diff($to)->y;

?>

<div class="medications index col-md-9 columns content">

   <div class="patient-info">
      <h4>Nome do paciente: <?= $patient_name ?></h4>
      <h4>Idade: <?= $age ?></h4>
      <h4>Prontuário: <?= $hospitalization['numero_do_prontuario']?></h4>
   </div>

   <div class="btn-group prescriptions-options">
     <button type="button" class="btn btn-default dropdown-toggle bt-menu-margin" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
           Nova Prescrição
           <span class="caret"></span>
       </button>
       <ul class="dropdown-menu">
           <li>
               <?=$this->Html->link('Nova Prescrição', ['controller' => 'prescriptions', 'action' => 'add', '_full' => true]);?>
           </li>
           <li>
               <?=$this->Html->link('Cópia de prescrição', ['controller' => 'prescriptions', 'action' => 'prescriptionCopy', '_full' => true]);?>
           </li>
           <li>
               <?=$this->Html->link('Prescrição padrão', ['controller' => 'prescriptions', 'action' => 'defaultPrescriptions', '_full' => true]);?>
           </li>
       </ul>
   </div>
   <br>
   <br>
   <br>
   <table class="table table-striped table-hover">
        <thead>
            <tr>
                <th><?= $this->Paginator->sort('Data') ?></th>
                <th><?= $this->Paginator->sort('Validada') ?></th>
                <th><?= $this->Paginator->sort('Ultima alteração') ?></th>
                <th><?= $this->Paginator->sort('Profissional') ?></th>
                <th class="actions"><?= __('Ações') ?></th>
            </tr>
        </thead>
        <tbody>

            <?php foreach ($prescriptions as $prescription): ?>
            <tr>
                <td><?= ($prescription->created) ? $prescription->created->i18nFormat('dd/MM/yyyy') : ''; ?></td>
                <td><?= ($prescription->validation_date) ? $prescription->validation_date->i18nFormat('HH:mm') : ''; ?></td>
                <td><?= ($prescription->modified) ? $prescription->modified->i18nFormat('dd/MM/yyyy') : ''; ?></td>
                <td><?= ($prescription->professional['user']) ? $prescription->professional['user']['name'] : '';?></td>

                <td><?= $this->Html->link(__('Visualizar'), ['controller' => 'prescriptions', 'action' => 'view', $prescription->id], ['class'=>'btn btn-primary btn-xs']) ?></td>
            </tr>
            <?php endforeach; ?>
        </tbody>
    </table>

</div>
</div>

<script>

      <?php if ($current_state == "internacao"): ?>
           (function() {
              // your page initialization code here
              // the DOM will be available here
               var link1 =' <?=$this->Html->link(
                '<i class="glyphicon glyphicon-home"></i>&nbsp;Unidade(s)',
       ['controller' => 'Users', 'action' => 'login'],
                ['class' => 'btn btn-default ', 'escape' => false]
            )?> ';

               var link2 =' <?=$this->Html->link('Pacientes', ['controller' => 'Patients', 'action' => 'index', '_full' => true], ['class' => 'btn btn-default ']);?> ';

               var link3 =' <?=$this->Html->link('Internações', ['controller' => 'Hospitalizations', 'action' => 'index', $hospitalization_id, '_full' => true], ['class' => 'btn btn-default ']);?> ';

               var html = '';
                   html+= '<div class="btn-group btn-breadcrumb custom-breadcumb">';
                   html+= link1;
                   html+= link2;
                   html+= link3;
                   html+= '<a href="#" class="breadcumb-active btn btn-default">Histórico de prescrições</a>';
                   html+= '</div>';
                       document.getElementById("breadcumb").innerHTML = html;
           })();
      <?php else: ?>

              (function() {
                 // your page initialization code here
                 // the DOM will be available here
                  var link1 =' <?=$this->Html->link(
              '<i class="glyphicon glyphicon-home"></i>&nbsp;Unidade(s)',
          ['controller' => 'Users', 'action' => 'login'],
              ['class' => 'btn btn-default ', 'escape' => false]
          )?> ';

                  var link2 =' <?=$this->Html->link('Pacientes', ['controller' => 'Patients', 'action' => 'index', '_full' => true], ['class' => 'btn btn-default ']);?> ';

                  var link3 =' <?=$this->Html->link('Triagem', ['controller' => 'Screenings', 'action' => 'index', $screening_id, '_full' => true], ['class' => 'btn btn-default ']);?> ';

                  var html = '';
                      html+= '<div class="btn-group btn-breadcrumb custom-breadcumb">';
                      html+= link1;
                      html+= link2;
                      html+= link3;
                      html+= '<a href="#" class="breadcumb-active btn btn-default">Histórico de prescrições</a>';
                      html+= '</div>';
                          document.getElementById("breadcumb").innerHTML =html;
              })();
      <?php endif;?>

   </script>
