<?php

    $from = ( isset($patient['birthday'])? new \DateTime($patient['birthday']->i18nFormat('dd-MM-yyyy')) : null );
    $to   = new DateTime('today');
    $age = null;
    $age = $from->diff($to)->y;

    $date_of_hospitalization    = ( isset($hospitalization['date_of_hospitalization'])?  new \DateTime($hospitalization['date_of_hospitalization']->format('Y-m-d')) : null);
    $dias_internacao = 0;

    if (isset($hospitalization['data_saida_unidade']) && $date_of_hospitalization) {

        //$date_of_hospitalization    = new \DateTime($hospitalization['date_of_hospitalization']->format('Y-m-d'));
        $data_saida_unidade         = new \DateTime($hospitalization['data_saida_unidade']->format('Y-m-d'));
        $dias_internacao            = $date_of_hospitalization->diff($data_saida_unidade)->days;
    }
    else if ($date_of_hospitalization) {
        //$date_of_hospitalization    = new \DateTime($hospitalization['date_of_hospitalization']->format('Y-m-d'));
        $dataAtual                  = new \DateTime(date ("Y-m-d"));
        $dias_internacao            = $date_of_hospitalization->diff($dataAtual)->days;
    }

//$via = ['IV'=>'IV', 'SC'=>'SC'];
$via = ['VO' => 'VO', 'CNE' => 'CNE', 'CNG' => 'CNG', 'GTT' => 'GTT', 'IV' => 'IV', 'IM' => 'IM', 'SC' => 'SC', 'Tópico' => 'Tópico', 'Retal' => 'Retal', 'Nasal' => 'Nasal', 'Ocular' => 'Ocular', 'NBZ' => 'NBZ'];

//$frequencies = ['1X DIA'=>'1X DIA','BI'=>'BI','12/12 H'=>'12/12 H','6/6 H'=>'6/6 H','SOS'=>'SOS'];
$frequencies = ['1X SEM' => '1X SEM', 'SEG QUA SEX' => 'SEG QUA SEX', 'TER QUI SAB' => 'TER QUI SAB', '1X DIA' => '1X DIA', '12/12 H' => '12/12 H', '8/8 H' => '8/8 H', '6/6 H' => '6/6 H', '4/4 H' => '4/4 H', '3/3 H' => '3/3 H', '2/2 H' => '2/2 H', '1/1 H' => '1/1 H', 'ACM' => 'ACM', 'SOS' => 'SOS', 'BI' => 'BI', 'DIA ALTERNADO' => 'DIA ALTERNADO'];

// $signs_opt = [];

// foreach ($signs as $key => $value) {

//     $signs_opt[$value['id']] =$this->Html->imageurl('uploads/' . $value['filename'], ['fullBase'=>true]);
// }
?>


<style>

    .mini-boxes{
      border: 1px solid #ddd;
      color: #ddd;
      font-size: 20px;
      min-width: 38.8%;
      min-height:150px;
      margin-bottom:30px!important;
      margin-left:30px!important;
      display: flex;
      align-items: center;
      justify-content: center;


    }

    .dpFlex{
      padding-left: 65%;
      display: inline-flex;
      align-items: center;
      justify-content: center;
    }

    .sticky-wrap{
      margin-top:0px!important;
     }


    .rotate {
      color:#ddd;
     /* margin-top: 50%;
      margin-left: 50%;*/
      -moz-transform: translateX(-50%) translateY(-50%) rotate(-90deg);
      -webkit-transform: translateX(-50%) translateY(-50%) rotate(-90deg);
      transform:  translateX(-50%) translateY(-50%) rotate(-90deg);
    }

    table{
        overflow:visible!important;
    }

  .header-labels{
    padding-top:10px;
    padding-bottom:10px;
    border: 1px solid #ddd;
  }
  .text-box{
    max-width:200px;
    min-width:200px;
    min-height:250px;
  }

  .text-nutricao{
    max-width:200px;
    min-width:200px;
    min-height: 175px;
  }

  .revalidacao{
    max-width:120px;
    min-width:120px;
    min-height:300px;
  }
  @page {size:landscape;}

</style>

<!-- Primeira Página  -->

<div class="page">

  <div class="container-fluid unit-header">
          <div class="bundles form col-sm-4 columns content">

              <?=
               $this->Html->image('uploads/'. $unit_logo, ['alt' => 'GH', 'height'=>'50px', 'style'=>"margin-top: 7px;"])
              ?>
              <br><br>
              <p class="unit-data"><b><?= $unit->name ?></b></p>
              <p class="unit-data"><b><?= $unit->telephone ?></b></p>
              <p class="unit-data"><b><?= $unit->street ?></b></p>
              <p class="unit-data"><b><?= $unit->city ?></b></p>
              <br>
          </div>
          <div class="col-sm-8">


              <table class="table table-bordered">
                <thead>
                  <tr>
                    <td><span><b>Paciente</b>:&nbsp; <?= $patient->nome ?></span></td>
                    <td><span><b>Prontuário:</b>&nbsp;<?= $hospitalization->numero_do_prontuario ?></span></td>
                    <td colspan="2"><span><b>Idade:</b>&nbsp;<?= $age ?></span></td>
                  </tr>
                </thead>
                <tbody>
                  <tr>
                    <td><span><b>Precaução:</b>&nbsp;</span></td>
                    <td><span><b>Germe:</b>&nbsp;<?= $top_resitence ?></span></td>
                    <td colspan="2"><span><b>&nbsp;Data de Internação:</b>&nbsp;<?= $hospitalization->date_of_hospitalization->format('d/m/Y') ?></span></td>
                  </tr>
                  <tr>
                    <td><span><b>Unidade:</b>&nbsp;<?= $unit->name ?></span></td>
                    <td><span><b>Leito:</b>&nbsp;<?= $hospitalization->roomName($hospitalization['id'])?></span></td>
                    <td><span><b>Dias de Internação:</b>&nbsp;<?= $dias_internacao ?> </span></td>
                    <td><span><b>Alergias:</b>&nbsp;</span></td>
                  </tr>
                </tbody>
              </table>
          </div>
  </div>



  <div class="container-fluid">


             <div class="col-sm-3">
                 <table class="table center-text table-bordered">
                    <thead>
                      <tr>
                        <th>Data</th>
                        <th></th>
                      </tr>
                    </thead>
                    <tbody>
                      <tr>
                        <td colspan="2">NUTRIÇÃO</td>
                      </tr>
                      <tr>
                        <td colspan="2" class="text-nutricao" ><div class="text-nutricao">Dieta oral para HAS e DM</div></td>
                      </tr>
                      <tr>
                        <th>HORÁRIO DE IMPRESSÃO</th>
                        <th>
                          <?= date("d/m/Y H:i:s"); ?>
                        </th>
                      </tr>
                    </tbody>
                  </table>
             </div>

             <div class="col-sm-9">
                     <table class="table table-bordered">

                          <tr>
                            <th>FONOAUDIOLOGIA</th>
                            <th>ODONTOLOGIA</th>
                            <th>ETIQUETA</th>
                            <th rowspan="2" class="text-box revalidacao">
                              <div class="text-box dpFlex">
                                 <span class='plHolder rotate'>REVALIDAÇÃO MÉDICA</span>
                              </div>
                            </th>
                          </tr>

                          <tr>

                            <td class="text-box">
                              <div class="text-box">
                              </div>
                            </td>

                            <td class="text-box">
                              <div class="text-box">
                              </div>
                            </td>

                            <td class="text-box">
                              <div class="text-box">
                              </div>
                            </td>

                          </tr>

                      </table>
             </div>
  </div>




  <div class="prescriptions form col-sm-12 columns content">
      <?=$this->Form->create($prescription)?>

          <div class="col-sm-12">
              <table class="table center-text table-bordered">
                  <thead>

                      <tr>
                          <th colspan="5">Prescrições</th>
                          <th style="padding-bottom: 25px;" rowspan="2">Horário</th>
                      </tr>
                      <tr>
                          <th>Inicio</th>
                          <th>Dias de Uso</th>
                          <th>Item</th>
                          <th>Via</th>
                          <th>Frequencia</th>
                      </tr>
                </thead>
                <tbody>

                      <?php
                        $medication = '';
                        $interval = 0;

                        for ($i=0; $i < 10 ; $i++) {

                          if(isset($prescription['medications'][$i])){

                            $medication = $prescription['medications'][$i];

                            if (isset($medication['end_date']) && isset($medication['start_date'])){

                              $datetime1 = new \DateTime($medication['start_date']->format('Y-m-d'));
                              $datetime2 = new \DateTime($medication['end_date']->format('Y-m-d'));

                              $interval  = $datetime1->diff($datetime2)->days;
                          }


                      ?>

                          <tr>
                              <td>
                                <?php if(isset($medication['start_date'])): ?>
                                   <?=h($medication['start_date']->format('d/m/Y'))?>
                                <?php endif; ?>
                              </td>
                              <td>
                                <?php

                                      echo $interval;

                                ?>
                              </td>
                              <td><?=h($medication->name)?></td>
                              <td><?=h($medication->channel)?></td>
                              <td><?=h($medication->frequency)?></td>
                              <td></td>
                          </tr>
                      <?php
                         }
                         $medication = '';
                         $interval = 0;
                        }
                      ?>
                </tbody>
             </table>
          </div>

      <?=$this->Form->end()?>
  </div>
</div>



<!-- Segunda Página  -->


<div class="page mTop">

  <div class="container-fluid unit-header">
          <div class="bundles form col-sm-4 columns content">

              <?=
               $this->Html->image('uploads/'. $unit_logo, ['alt' => 'GH', 'height'=>'50px', 'style'=>"margin-top: 7px;"])
              ?>
              <br><br>
              <p class="unit-data"><b><?= $unit->name ?></b></p>
              <p class="unit-data"><b><?= $unit->telephone ?></b></p>
              <p class="unit-data"><b><?= $unit->street ?></b></p>
              <p class="unit-data"><b><?= $unit->city ?></b></p>
              <br>
          </div>
          <div class="col-sm-8">


              <table class="table table-bordered">
                <thead>
                  <tr>
                    <td><span><b>Paciente</b>:&nbsp; <?= $patient->nome ?></span></td>
                    <td><span><b>Prontuário:</b>&nbsp;<?= $hospitalization->numero_do_prontuario ?></span></td>
                    <td colspan="2"><span><b>Idade:</b>&nbsp;<?= $age ?></span></td>
                  </tr>
                </thead>
                <tbody>
                  <tr>
                    <td><span><b>Precaução:</b>&nbsp;</span></td>
                    <td><span><b>Germe:</b>&nbsp;<?= $top_resitence ?></span></td>
                    <td colspan="2"><span><b>&nbsp;Data de Internação:</b>&nbsp;<?= $hospitalization->date_of_hospitalization->format('d/m/Y') ?></span></td>
                  </tr>
                  <tr>
                    <td><span><b>Unidade:</b>&nbsp;<?= $unit->name ?></span></td>
                    <td><span><b>Leito:</b>&nbsp;<?= $hospitalization->roomName($hospitalization['id'])?></span></td>
                    <td><span><b>Dias de Internação:</b>&nbsp;<?= $dias_internacao ?> </span></td>
                    <td><span><b>Alergias:</b>&nbsp;</span></td>
                  </tr>
                </tbody>
              </table>
          </div>
  </div>


  <div class="container-fluid">

             <div class="col-sm-2">
                 <table class="table center-text table-bordered">
                    <thead>
                      <tr>
                        <th>Data</th>
                        <th style="min-width:100px"></th>
                      </tr>
                    </thead>
                  </table>
             </div>

             <div class="col-sm-10">



                 <div class="col-sm-3 mini-boxes pull-right">
                    <span class='plHolder'>DIAS</span>
                 </div>

                 <div class="col-sm-3 mini-boxes pull-right">
                    <span class='plHolder'>ETIQUETA</span>
                 </div>

             </div>


  </div>


  <div class="prescriptions form col-sm-12 columns content">

      <?=$this->Form->create($prescription)?>

          <div class="col-sm-12">
              <table class="table center-text table-bordered">
                  <thead>

                      <tr>
                          <th colspan="5">Prescrições</th>
                          <th style="padding-bottom: 25px;" rowspan="2">Horário</th>
                      </tr>
                      <tr>
                          <th>Inicio</th>
                          <th>Dias de Uso</th>
                          <th>Item</th>
                          <th>Via</th>
                          <th>Frequencia</th>
                      </tr>
                </thead>
                <tbody>
                     <?php
                        $medication = '';
                        $interval = 0;

                        for ($i=10; $i < 20 ; $i++) {

                          if(isset($prescription['medications'][$i])){

                            $medication = $prescription['medications'][$i];

                            if (isset($medication['end_date']) && isset($medication['start_date'])){

                              $datetime1 = new \DateTime($medication['start_date']->format('Y-m-d'));
                              $datetime2 = new \DateTime($medication['end_date']->format('Y-m-d'));

                              $interval  = $datetime1->diff($datetime2)->days;
                          }


                      ?>

                          <tr>
                              <td>
                                <?php if(isset($medication['start_date'])): ?>
                                   <?=h($medication['start_date']->format('d/m/Y'))?>
                                <?php endif; ?>
                              </td>
                              <td>
                                <?php

                                      echo $interval;

                                ?>
                              </td>
                              <td><?=h($medication->name)?></td>
                              <td><?=h($medication->channel)?></td>
                              <td><?=h($medication->frequency)?></td>
                              <td></td>
                          </tr>
                      <?php
                         }
                         $medication = '';
                         $interval = 0;
                        }
                      ?>
                </tbody>
             </table>
          </div>

      <?=$this->Form->end()?>
  </div>
</div>


<!-- Terceira Página  -->


<div class="page mTop">

  <div class="container-fluid unit-header">
          <div class="bundles form col-sm-4 columns content">

              <?=
               $this->Html->image('uploads/'. $unit_logo, ['alt' => 'GH', 'height'=>'50px', 'style'=>"margin-top: 7px;"])
              ?>
              <br><br>
              <p class="unit-data"><b><?= $unit->name ?></b></p>
              <p class="unit-data"><b><?= $unit->telephone ?></b></p>
              <p class="unit-data"><b><?= $unit->street ?></b></p>
              <p class="unit-data"><b><?= $unit->city ?></b></p>
              <br>
          </div>
          <div class="col-sm-8">


              <table class="table table-bordered">
                <thead>
                  <tr>
                    <td><span><b>Paciente</b>:&nbsp; <?= $patient->nome ?></span></td>
                    <td><span><b>Prontuário:</b>&nbsp;<?= $hospitalization->numero_do_prontuario ?></span></td>
                    <td colspan="2"><span><b>Idade:</b>&nbsp;<?= $age ?></span></td>
                  </tr>
                </thead>
                <tbody>
                  <tr>
                    <td><span><b>Precaução:</b>&nbsp;</span></td>
                    <td><span><b>Germe:</b>&nbsp;<?= $top_resitence ?></span></td>
                    <td colspan="2"><span><b>&nbsp;Data de Internação:</b>&nbsp;<?= $hospitalization->date_of_hospitalization->format('d/m/Y') ?></span></td>
                  </tr>
                  <tr>
                    <td><span><b>Unidade:</b>&nbsp;<?= $unit->name ?></span></td>
                    <td><span><b>Leito:</b>&nbsp;<?= $hospitalization->roomName($hospitalization['id'])?></span></td>
                    <td><span><b>Dias de Internação:</b>&nbsp;<?= $dias_internacao ?> </span></td>
                    <td><span><b>Alergias:</b>&nbsp;</span></td>
                  </tr>
                </tbody>
              </table>
          </div>
  </div>


  <div class="container-fluid">

             <div class="col-sm-2">
                 <table class="table center-text table-bordered">
                    <thead>
                      <tr>
                        <th>Data</th>
                        <th style="min-width:100px"></th>
                      </tr>
                    </thead>
                  </table>
             </div>

             <div class="col-sm-10">



                 <div class="col-sm-3 mini-boxes pull-right">
                    <span class='plHolder'>REVALIDAÇÃO MÉDICA</span>
                 </div>

                 <div class="col-sm-3 mini-boxes pull-right">
                    <span class='plHolder'>ETIQUETA</span>
                 </div>

             </div>


  </div>


  <div class="prescriptions form col-sm-12 columns content">

      <?=$this->Form->create($prescription)?>

          <div class="col-sm-12">
              <table class="table center-text table-bordered">
                  <thead>

                      <tr>
                          <th colspan="5">Prescrições</th>
                          <th style="padding-bottom: 25px;" rowspan="2">Horário</th>
                      </tr>
                      <tr>
                          <th>Inicio</th>
                          <th>Dias de Uso</th>
                          <th>Item</th>
                          <th>Via</th>
                          <th>Frequencia</th>
                      </tr>
                </thead>
                <tbody>
                     <?php
                        $medication = '';

                        for ($i=20; $i < 30 ; $i++) {

                          if(isset($prescription['medications'][$i])){

                            $medication = $prescription['medications'][$i];

                            if (isset($medication['end_date']) && isset($medication['start_date'])){

                              $datetime1 = new \DateTime($medication['start_date']->format('Y-m-d'));
                              $datetime2 = new \DateTime($medication['end_date']->format('Y-m-d'));

                              $interval  = $datetime1->diff($datetime2)->days;
                          }


                      ?>

                          <tr>
                              <td>
                                <?php if (isset($medication['start_date'])): ?>
                                   <?=h($medication['start_date']->format('d/m/Y'))?>
                                <?php endif; ?>
                              </td>
                              <td>
                                <?php

                                      echo $interval;

                                ?>
                              </td>
                              <td><?=h($medication->name)?></td>
                              <td><?=h($medication->channel)?></td>
                              <td><?=h($medication->frequency)?></td>
                              <td></td>
                          </tr>
                      <?php
                         }
                         $medication = '';
                        }
                      ?>
                </tbody>
             </table>
          </div>

      <?=$this->Form->end()?>
  </div>
</div>


<script type="text/javascript">


window.onload = setTimeout(function(){$.LoadingOverlay("show",{'color':'rgba(255,255,255,255)'});},1);
  
  (function(){
    $(".pad-top-20").removeClass('container');
    $(".pad-top-20").addClass('container-fluid');
    
    $("form :input").prop('readonly', true);
    $("form :input").css('readonly', true);
    $('nav').css('display','none');

    // definindo a função de Print
    function PrintPage() {
        window.print();
        setTimeout(function () {
          $.LoadingOverlay("show",{'color':'rgba(255,255,255,255)'});
          window.close();
        },900);
    }

    // chamando a função de imprimir
    setTimeout(function(){ 
      PrintPage();
    },600);

  })();
</script>
