f<!DOCTYPE html>
<html>
	<head>
		<meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
		<?=$this->Html->css('pdf', ['fullBase' => true]);?>
		<?=$this->fetch('css')?>
	</head>
	<body>
		<?=$this->element('header-logo', ['report_title' => 'Relatório de Cateter Vascular']);?>
		<div class="container">
			<table class="aileron_thin" style="width:100%; border-collapse: collapse;">
				<thead>
					<tr>
						<th class="title th-left">Item</th>
						<th class="title th-middle" style="margin-left:100px;">Valor</th>
						<th class="title th-right" >%</th>
					</tr>
				</thead>

				<tbody>
					<tr >
	                    <td class="line-separator title" style="font-weight: bold" colspan=3>  Seção Geral</td>
	                </tr>
					<tr>
						<td>Total de bundles de passagem de cateter vascular </td>
						<td> <?=$data['total_de_bundles']?> </td>
						<td>-</td>
					</tr>
					<tr >
						<td>Bundles de cateter vascular por paciente</td>
						<td> - </td>
						<td> <?=$data['bundle_vascular_por_pacientes']?>% </td>
						</tr>
					<tr >
						<td>Pacientes com bundle de cateter vascular / Pacientes com cateter arterial</td>
						<td>-</td>
						<td> <?=$data['tot_internacao_vascular_por_arterial']?>% </td>
					</tr>

					<tr >
						<td>Pacientes com bundle de cateter vascular / Pacientes  venoso</td>
						<td> - </td>
						<td> <?=$data['tot_internacao_vascular_por_venoso']?>% </td>
					</tr>

					<tr >
						<td>Pacientes com bundle de cateter vascular / Pacientes com hemodiálise</td>
						<td> - </td>
						<td> <?=$data['tot_internacao_vascular_por_hemodialise']?>% </td>
					</tr >

					<tr >
						<td>Pacientes com bundle de cateter vascular / Pacientes com picc marcados em procedimentos</td>
						<td> - </td>
						<td> <?=$data['tot_internacao_vascular_por_picc']?>% </td>
					</tr>

					<tr >
						<td>Cateter venoso no período em relação ao total de bundles</td>
						<td>-</td>
						<td> <?=$data['tot_cateter_venoso_por_bundle']?>% </td>
					</tr>

					<tr >
						<td>Cateter arterial no período em relação ao total de bundles</td>
						<td>-</td>
						<td> <?=$data['tot_cateter_arterial_por_bundle']?>% </td>
					</tr>

					<tr>
						<td>Procedimentos realizados de forma emergencial</td>
						<td> <?=$data['emergency']['total']?> </td>
						<td> <?=$data['emergency']['percentual']?>% </td>
					</tr>

					<tr>
						<td>Número de lúmens</td>
						<td><?=$data['numero_lumen']['soma']?></td>
						<td><?=$data['numero_lumen']['percentual']?>%</td>
					</tr>

					<tr >
						<td>Procedimentos realizados com picc</td>
						<td> <?=$data['tot_procedimentos_utilizando_picc']?> </td>
						<td> <?=$data['percen_procedimentos_utilizando_picc']?>% </td>
					</tr>

					<tr >
						<td>Procedimentos realizados com hemodiálise</td>
						<td> <?=$data['tot_procedimentos_utilizando_hemodialise']?> </td>
						<td> <?=$data['percen_procedimentos_utilizando_hemodialise']?>% </td>
					</tr>

					<tr >
	                    <td class="line-separator title" style="font-weight: bold" colspan=3>  Checklist pré procedimento</td>
	                </tr>


					<tr>
						<td>Foi verificado o risco de sangramento</td>
						<td> <?=$data['is_risk_of_bleeding_verified']['total']?> </td>
						<td> <?=$data['is_risk_of_bleeding_verified']['percentual']?>% </td>
					</tr>

					<tr>
						<td>O tci foi preenchido</td>
						<td> <?=$data['tci_preenchido']['total']?> </td>
						<td> <?=$data['tci_preenchido']['percentual']?>% </td>
					</tr>

					<tr>
						<td>O procedimento foi prescrito</td>
						<td> <?=$data['is_the_procedure_prescribed']['total']?> </td>
						<td> <?=$data['is_the_procedure_prescribed']['percentual']?>% </td>
					</tr>

					<tr >
	                    <td class="line-separator title" style="font-weight: bold" colspan=3>  Checklist durante o procedimento</td>
	                </tr>

					<tr>
						<td>Realizado higienização adequada das mãos</td>
						<td> <?=$data['proper_handwashing']['total']?> </td>
						<td> <?=$data['proper_handwashing']['percentual']?>% </td>
					</tr>

					<tr>
						<td>Uso de paramentação: gorro, máscara e luvas estéreis</td>
						<td> <?=$data['use_of_paramentation']['total']?> </td>
						<td> <?=$data['use_of_paramentation']['percentual']?>% </td>
					</tr>

				<!-- 	<tr >
						<td>Uso de degermação da pele</td>
						<td> <?=$data['use_of_antisepsis']['total']?> </td>
						<td> <?=$data['use_of_antisepsis']['percentual']?>% </td>
						</tr> -->

					<tr>
						<td>Uso de anti-sepsia da pele</td>
						<td> <?=$data['use_of_antisepsis']['total']?> </td>
						<td> <?=$data['use_of_antisepsis']['percentual']?>% </td>
					</tr>
					<tr>
						<td>Uso de técnica asséptica durante o procedimento</td>
						<td> <?=$data['tecnica_asseptica']['total']?> </td>
						<td> <?=$data['tecnica_asseptica']['percentual']?>% </td>
						</tr>
					<!-- <tr>
						<td>Uso de campo barreira máxima</td>
						<td></td>
						<td> % </td>
						<td>-</td>
						<td>-</td>
						<td>-</td>

					</tr> -->
					<tr>
						<td>Confirmação da posição com ultrassom</td>
						<td> <?=$data['ultrasom_durante_procedimento']['total']?> </td>
						<td> <?=$data['ultrasom_durante_procedimento']['percentual']?>% </td>
					</tr>

					<tr >
						<!-- nao existe no sistema -->
						<td>Uso de gel estéril </td>
						<td></td>
						<td> % </td>
					</tr>
					<tr >
						<!-- nao existe no sistema -->
						<td>Progressão adequada de cateter</td>
						<td> </td>
						<td> % </td>
					</tr>

					<tr >
						<!-- nao existe no sistema -->
						<td>Fixação adequada de cateter</td>
						<td> </td>
						<td> % </td>
					</tr>

					<tr >
	                    <td class="line-separator title" style="font-weight: bold" colspan=3> Checklist após procedimento</td>
	                </tr>

	                <tr >
	                	<!-- nao existe no sistema -->
						<td>Curativo realizado com técnica estéril</td>
						<td> </td>
						<td> % </td>
					</tr>

					<tr >
						<!-- nao existe no sistema -->
						<td>Uso de conectores nas saídas do cateter</td>
						<td> </td>
						<td> % </td>
					</tr>

					<tr >
						<td>Solicitado radiografia de controle</td>
						<td> <?=$data['radiografia_de_controle']['total']?> </td>
						<td> <?=$data['radiografia_de_controle']['percentual']?>% </td>
					</tr>

					<tr >
	                    <td class="line-separator title" style="font-weight: bold" colspan=3> Descrição orientada</td>
	                </tr>

	                <tr >
	                    <td style="font-weight: bold; text-align: left; padding-left: 10px;" colspan=3>Local de inserção:</td>
	                </tr>

					<tr class="td-indent" >
						<td>&#8226; Artéria axilar</td>
						<td> <?=$data['local_insercao']['tot_arteria_axilar']?> </td>
						<td> <?=$data['local_insercao']['percen_arteria_axilar']?>% </td>
					</tr>

					<tr class="td-indent" >
						<td>&#8226; Artéria braquial</td>
						<td> <?=$data['local_insercao']['tot_arteria_braquial']?> </td>
						<td> <?=$data['local_insercao']['percen_arteria_braquial']?>% </td>
					</tr>

					<tr class="td-indent" >
						<td>&#8226; Artéria femoral </td>
						<td> <?=$data['local_insercao']['tot_arteria_femoral']?> </td>
						<td> <?=$data['local_insercao']['percen_arteria_femoral']?>% </td>
					</tr>

					<tr class="td-indent" >
						<td>&#8226; Artéria pediosa </td>
						<td> <?=$data['local_insercao']['tot_arteria_pediosa']?> </td>
						<td> <?=$data['local_insercao']['percen_arteria_pediosa']?>% </td>
					</tr>
					<tr class="td-indent" >
						<td>&#8226;  Artéria radial</td>
						<td> <?=$data['local_insercao']['tot_arteria_radial']?> </td>
						<td> <?=$data['local_insercao']['percen_arteria_radial']?>% </td>
					</tr>

					<tr class="td-indent" >
						<td>&#8226; Artéria ulnar</td>
						<td> <?=$data['local_insercao']['tot_arteria_ulnar']?> </td>
						<td> <?=$data['local_insercao']['percen_arteria_ulnar']?>% </td>
					</tr>

					<tr class="td-indent" >
						<td>&#8226; Artéria umeral</td>
						<td> <?=$data['local_insercao']['tot_arteria_umeral']?> </td>
						<td> <?=$data['local_insercao']['percen_arteria_umeral']?>% </td>
					</tr>

					<tr class="td-indent" >
						<td>&#8226; Veia jugular interna</td>
						<td> <?=$data['local_insercao']['tot_veia_jugular_inter']?> </td>
						<td> <?=$data['local_insercao']['percen_veia_jugular_inter']?>% </td>
					</tr>

					<tr class="td-indent" >
						<td>&#8226; Veia jugular externa</td>
						<td> <?=$data['local_insercao']['tot_veia_jugular_exter']?> </td>
						<td> <?=$data['local_insercao']['percen_veia_jugular_exter']?>% </td>
					</tr>

					<tr class="td-indent" >
						<td>&#8226; Veia radial</td>
						<td> <?=$data['local_insercao']['tot_veia_radial']?> </td>
						<td> <?=$data['local_insercao']['percen_veia_radial']?>% </td>
					</tr>

					<tr class="td-indent" >
						<td>&#8226; Veia subclávia</td>
						<td> <?=$data['local_insercao']['tot_veia_subclavia']?> </td>
						<td> <?=$data['local_insercao']['percen_veia_subclavia']?>% </td>
					</tr>

					<tr class="td-indent" >
						<td>&#8226; Veia basílica</td>
						<td> <?=$data['local_insercao']['tot_veia_basilica']?> </td>
						<td> <?=$data['local_insercao']['percen_veia_basilica']?>% </td>
					</tr>

					<tr class="td-indent" >
						<td>&#8226; Veia pediosa</td>
						<td> <?=$data['local_insercao']['tot_veia_pediosa']?> </td>
						<td> <?=$data['local_insercao']['percen_veia_pediosa']?>% </td>
					</tr>

					<tr class="td-indent" >
						<td>&#8226; Veia cefálica</td>
						<td> <?=$data['local_insercao']['tot_veia_cefalica']?> </td>
						<td> <?=$data['local_insercao']['percen_veia_cefalica']?>% </td>
					</tr>

					<tr class="td-indent" >
						<td>&#8226; Veia axilar</td>
						<td> <?=$data['local_insercao']['tot_veia_axilar']?> </td>
						<td> <?=$data['local_insercao']['percen_veia_axilar']?>% </td>
					</tr>

					<tr class="td-indent" >
						<td>&#8226; Veia femoral</td>
						<td> <?=$data['local_insercao']['tot_veia_femoral']?> </td>
						<td> <?=$data['local_insercao']['percen_veia_femoral']?>% </td>
					</tr>

					<tr class="td-indent" >
						<td>&#8226; Veia mediana</td>
						<td> <?=$data['local_insercao']['tot_veia_mediana']?> </td>
						<td> <?=$data['local_insercao']['percen_veia_mediana']?>% </td>
					</tr>

					<tr class="td-indent" >
						<td>&#8226; Veia subclávia infraclavicular</td>
						<td> <?=$data['local_insercao']['tot_veia_subclavia_infra']?> </td>
						<td> <?=$data['local_insercao']['percen_veia_subclavia_infra']?>% </td>
					</tr>

					<tr class="td-indent" >
						<td>&#8226; Veia subclávia supraclavicular</td>
						<td> <?=$data['local_insercao']['tot_veia_subclavia_supra']?> </td>
						<td> <?=$data['local_insercao']['percen_veia_subclavia_supra']?>% </td>
					</tr>

					<tr class="td-indent" >
						<td>&#8226; Veia temporal</td>
						<td> <?=$data['local_insercao']['tot_veia_temporal']?> </td>
						<td> <?=$data['local_insercao']['percen_veia_temporal']?>% </td>
					</tr>

					<tr class="td-indent" >
						<td>&#8226; Veia umbilical</td>
						<td> <?=$data['local_insercao']['tot_veia_umbilical']?> </td>
						<td> <?=$data['local_insercao']['percen_veia_umbilical']?>% </td>
					</tr>

					<tr class="td-indent" >
						<td>&#8226; Outra</td>
						<td> <?=$data['local_insercao']['tot_outra']?> </td>
						<td> <?=$data['local_insercao']['percen_outra']?>% </td>
					</tr>

					<tr >
	                    <td  style="font-weight: bold; text-align: left; padding-left: 10px;" colspan=3>Tentativas:</td>
	                </tr>

	                <tr >
						<td>&#8226; Média</td>
						<td> <?=$data['number_of_retries']['media']?> </td>
						<td>- </td>
					</tr>
					<tr >
						<td>&#8226; Mediana</td>
						<td> <?=$data['number_of_retries']['mediana']?> </td>
						<td>- </td>
					</tr>

					<tr >
						<td>&#8226; Desvio padrão</td>
						<td> <?=$data['number_of_retries']['desvio_padrao']?> </td>
						<td>- </td>
					</tr>

					<tr >
						<td>Procedimentos com uma única tentativa </td>
						<td> <?=$data['tot_tentativa_unica']?> </td>
						<td> <?=$data['percen_tentativa_unica']?>% </td>
					</tr>

					<tr >
						<td>Sucesso na inserção</td>
						<td> <?=$data['sucesso_na_insercao']['total']?></td>
						<td> <?=$data['sucesso_na_insercao']['percentual']?>%</td>
					</tr>

					<tr >
	                    <td  style="font-weight: bold; text-align: left; padding-left: 10px;" colspan=3>Profissionais participantes:</td>
	                </tr>

	                <tr >
						<td>&#8226; Média</td>
						<td> <?=$data['number_of_professionals']['media']?> </td>
						<td>- </td>
					</tr>
					<tr >
						<td>&#8226; Mediana</td>
						<td> <?=$data['number_of_professionals']['mediana']?> </td>
						<td>- </td>
					</tr>

					<tr >
						<td>&#8226; Desvio padrão</td>
						<td> <?=$data['number_of_professionals']['desvio_padrao']?> </td>
						<td>- </td>
					</tr>

					<tr >
						<td>Procedimentos com controle radiológico</td>
						<td> <?=$data['radiografia_de_controle']['total']?></td>
						<td> <?=$data['radiografia_de_controle']['percentual']?>%</td>
					</tr>

					<tr >
						<td>Procedimentos em que houve complicação imediata</td>
						<td> <?=$data['tot_houve_complicacao_imediata']?></td>
						<td> <?=$data['percen_houve_complicacao_imediata']?>%</td>
					</tr>
					<tr>
						<td>Total de das complicações imediatas</td>
						<td> <?=$data['tot_qtd_complicacao_imediata']?></td>
						<td> - </td>
					</tr>

					<!-- <tr class="yolo">
						<td>VALOR TOTAL E PERCENTUAL DAS COMPLICAÇÕES NO PERÍODO</td>
					</tr> -->

					<tr >
						<td class="line-separator title" style="font-weight: bold" colspan=3>  Retirada do cateter vesival ou citostomia</td>
	                </tr>

	                <!-- <tr >
						<td>Uso do dispositivo </td>
						<td>-</td>
						<td>-</td>
											</tr> -->

					<tr >
						<!-- Sandro falou pra desonsiderr tempo de uso nesse momento-->
						<td class="line-separator title" style="font-weight: bold" colspan=3> Pacientes com tempo de uso do dispositivo:</td>
	                </tr>

	                <tr class="tr-indent">
						<td >&#8226; inferior a 5 dias</td>
						<td>  </td>
						<td> - </td>
					</tr>

					<tr class="tr-indent">
						<td >&#8226; inferior a 7 dias</td>
						<td>  </td>
						<td> - </td>
					</tr>

					<tr class="tr-indent">
						<td >&#8226; inferior a 10 dias</td>
						<td>  </td>
						<td> - </td>
					</tr>

					<tr >
						<td>Pacientes com retirada acidental </td>
						<td> <?=$data['accidental_removal']['total']?></td>
						<td> <?=$data['accidental_removal']['percentual']?>%</td>
					</tr>

					<!--<tr >
						<td>Pacientes com retirada acidental sepradados por motivo </td>
						<td>-</td>
						<td>-</td>
											</tr> -->
				</tbody>
			</table>
		</div>
	</body>
</html>