<!--
R -> Realizado
i -> Indicador
m -> Meta
-->

<?php
// $circle_red_red = WWW_ROOT . 'img/red_circle_red.png' ;
// $circle_red_green = WWW_ROOT . 'img/green_circle_red.svg' ;

$converted_data = [
    'taxa_internacoes' => [
        'r' => 0,
        'm' => 0,
        'd' => 0,
    ],
    'total_de_internacoes' => [
        'r' => 0,
        'm' => 0,
        'd' => 0,
    ],
    'taxa_de_reinternacao' => [
        'r' => 0,
        'm' => 0,
        'd' => 0,
    ],
    'taxa_ocupacao' => [
        'r' => 0,
        'm' => 0,
        'd' => 0,
    ],
    'taxa_desocupacao' => [
        'r' => 0,
        'm' => 0,
        'd' => 0,
    ],

    'tempo_medio_permanencia' => [
        'r' => 0,
        'm' => 0,
        'd' => 0,
    ],

    'indice_de_giro_de_leito' => [
        'r' => 0,
        'm' => 0,
        'd' => 0,
    ],

    'densidade_cateter_vesical' => [
        'r' => 0,
        'm' => 0,
        'd' => 0,
    ],

    'densidade_cateter_vascular' => [
        'r' => 0,
        'm' => 0,
        'd' => 0,
    ],

    'intervalo_de_substituicao' => [
        'r' => 0,
        'm' => 0,
        'd' => 0,
    ],

    'faixa_de_internacao_menor_que_24h' => [
        'r' => 0,
        'm' => 0,
        'd' => 0,
    ],

    'taxa_mortalidade' => [
        'r' => 0,
        'm' => 0,
        'd' => 0,
    ],

    'taxa_cesariana' => [
        'r' => 0,
        'm' => 0,
        'd' => 0,
    ],

];

foreach ($data['dates'] as $key => $month)
{
    //yolo
    // $converted_data['taxa_internacoes']['r'] .= '<td>' . $data['dates'][$key]['taxa_ocupacao'] . '</td>';
    // $converted_data['taxa_internacoes']['m'] .= '<td>' . $data['unit']['indicators_unit']['taxa_de_ocupacao'] . '</td>';
    // $converted_data['taxa_internacoes']['d'] .= '<td class="' . $cicle_color . '"><div></div></td>';

    // $converted_data['taxa_ocupacao']['r'] .= '<td>' . $data['dates'][$key]['taxa_ocupacao'] . '</td>';
    // $converted_data['taxa_ocupacao']['m'] .= '<td>' . $data['unit']['indicators_unit']['taxa_de_ocupacao'] . '</td>';
    // $converted_data['taxa_ocupacao']['d'] .= '<td class="' . $cicle_color . '"><div></div></td>';

    foreach ($converted_data as $indicator_key => $indicator)
    {
        $cicle_color = "circle_green";

        //verifica se o indicador existe
        if (isset($data['dates'][$key][$indicator_key]) && isset($converted_data[$indicator_key]['r']))
        {
            $meta = 0.0;
            if ($data['unit']['indicators_unit'][$indicator_key])
            {
                $meta = $data['unit']['indicators_unit'][$indicator_key];
            }

            //verifica se atingiu a meta do indicador
            if ((float) $data['dates'][$key][$indicator_key] < (float) $meta)
            {
                $cicle_color = "circle_red";
            }

            $converted_data[$indicator_key]['r'] .= '<td>' . $data['dates'][$key][$indicator_key] . '</td>';
            $converted_data[$indicator_key]['m'] .= '<td>' . $meta . '</td>';
            $converted_data[$indicator_key]['d'] .= '<td class="' . $cicle_color . '"><div></div></td>';
        }
        else
        {
            $converted_data[$indicator_key]['r'] .= '<td></td>';
            $converted_data[$indicator_key]['m'] .= '<td>0</td>';
            $converted_data[$indicator_key]['d'] .= '<td class="circle_green"><div></div></td>';
        }
    }
}
?>



<style type="text/css">
	td, th {
		text-align: center;
	}

	tr td:first-child {
		text-align: left;
	}

	.circle_red div {
		margin: 0 auto;
		width: 16px;
		height: 16px;
		border-radius: 50%;
		background: #eb1b23
	}

	.circle_green div {
		margin: 0 auto;
		width: 16px;
		height: 16px;
		border-radius: 50%;
		background: #339933
	}
</style>

<!DOCTYPE html>
<html>
<head>
	<meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
	<?=$this->Html->css('pdf', ['fullBase' => true]);?>
	<?=$this->fetch('css')?>
</head>
<body>
<?=$this->element('header-logo', ['report_title' => 'Relatório de indicadores da unidade']);?>
	<div class="container">
		<table class="aileron_thin" style="width:100%; border-collapse: collapse;">
			<thead>
				<tr>
					 <th class="title  th-left">Tema / Objetivo / Indicador</th>
					 <th  class="title  th-left indicadores">Info&nbsp;</th>
					 <?php foreach ($data['dates'] as $key => $month): ?>
						 <th class="title th-spread"> <?=$month_name[$key];?>  </th>
					 <?php endforeach;?>
			  </tr>
			</thead>
			<tbody>
				<tr>
					<td rowspan="3">
						Total de Internações
					</td>
					<td class="indicadores" >R</td>
					<?=$converted_data['total_de_internacoes']['r']?>
				</tr>

				<tr>
					<td class="indicadores">M</td>
					<?=$converted_data['total_de_internacoes']['m']?>
				</tr>

				<tr >
					<td class="indicadores">D</td>
					<?=$converted_data['total_de_internacoes']['d']?>
				</tr>



				<tr>
					<td rowspan="3">
						Taxa de Ocupação
					</td>
					<td class="indicadores" >R</td>
					<?=$converted_data['taxa_ocupacao']['r']?>
				</tr>

				<tr>
					<td class="indicadores">M</td>
					<?=$converted_data['taxa_ocupacao']['m']?>
				</tr>

				<tr >
					<td class="indicadores">D</td>
					<?=$converted_data['taxa_ocupacao']['d']?>
				</tr>

				<tr>
					<td rowspan="3">
						Índice de Giro de Leito
					</td>
					<td class="indicadores" >R</td>
					<?=$converted_data['indice_de_giro_de_leito']['r']?>
				</tr>

				<tr>
					<td class="indicadores">M</td>
					<?=$converted_data['indice_de_giro_de_leito']['m']?>
				</tr>

				<tr >
					<td class="indicadores">D</td>
					<?=$converted_data['indice_de_giro_de_leito']['d']?>
				</tr>

				<tr>
					<td rowspan="3">
						Intervalo de Substituição
					</td>
					<td class="indicadores" >R</td>
					<?=$converted_data['intervalo_de_substituicao']['r']?>
				</tr>

				<tr>
					<td class="indicadores">M</td>
					<?=$converted_data['intervalo_de_substituicao']['m']?>
				</tr>

				<tr >
					<td class="indicadores">D</td>
					<?=$converted_data['intervalo_de_substituicao']['d']?>
				</tr>

				<tr>
					<td rowspan="3">
						Tempo Médio de Permanência
					</td>
					<td class="indicadores" >R</td>
					<?=$converted_data['tempo_medio_permanencia']['r']?>
				</tr>

				<tr>
					<td class="indicadores">M</td>
					<?=$converted_data['tempo_medio_permanencia']['m']?>
				</tr>

				<tr >
					<td class="indicadores">D</td>
					<?=$converted_data['tempo_medio_permanencia']['d']?>
				</tr>

				<tr>
					<td rowspan="3">
						Taxa de Reinternação
					</td>
					<td class="indicadores" >R</td>
					<?=$converted_data['taxa_de_reinternacao']['r']?>
				</tr>

				<tr>
					<td class="indicadores">M</td>
					<?=$converted_data['taxa_de_reinternacao']['m']?>
				</tr>

				<tr >
					<td class="indicadores">D</td>
					<?=$converted_data['taxa_de_reinternacao']['d']?>
				</tr>

				<tr>
					<td rowspan="3">
						Taxa de Reinternação em < 24 horas
					</td>
					<td class="indicadores" >R</td>
					<?=$converted_data['faixa_de_internacao_menor_que_24h']['r']?>
				</tr>

				<tr>
					<td class="indicadores">M</td>
					<?=$converted_data['faixa_de_internacao_menor_que_24h']['m']?>
				</tr>

				<tr >
					<td class="indicadores">D</td>
					<?=$converted_data['faixa_de_internacao_menor_que_24h']['d']?>
				</tr>


				<tr>
					<td rowspan="3">
						Taxa de Cesarianas
					</td>
					<td class="indicadores" >R</td>
					<?=$converted_data['taxa_cesariana']['r']?>%
				</tr>

				<tr>
					<td class="indicadores">M</td>
					<?=$converted_data['taxa_cesariana']['m']?>%
				</tr>

				<tr >
					<td class="indicadores">D</td>
					<?=$converted_data['taxa_cesariana']['d']?>
				</tr>

				<tr>
					<td rowspan="3">
						Taxa de Saída Hospitalar
					</td>
					<td class="indicadores" >R</td>
					<?=$converted_data['taxa_internacoes']['r']?>
				</tr>

				<tr>
					<td class="indicadores">M</td>
					<?=$converted_data['taxa_internacoes']['m']?>
				</tr>

				<tr >
					<td class="indicadores">D</td>
					<?=$converted_data['taxa_ocupacao']['d']?>
				</tr>

				<tr>
					<td rowspan="3">
						Taxa de Mortalidade Hospitalar
					</td>
					<td class="indicadores" >R</td>
					<?=$converted_data['taxa_mortalidade']['r']?>
				</tr>

				<tr>
					<td class="indicadores">M</td>
					<?=$converted_data['taxa_mortalidade']['m']?>
				</tr>

				<tr >
					<td class="indicadores">D</td>
					<?=$converted_data['taxa_mortalidade']['d']?>
				</tr>


				<tr>
					<td rowspan="3">
						Taxa de Mortalidade Neonatal Hospitalar
					</td>
					<td class="indicadores" >R</td>
					<?=$converted_data['taxa_internacoes']['r']?>
				</tr>

				<tr>
					<td class="indicadores">M</td>
					<?=$converted_data['taxa_internacoes']['m']?>
				</tr>

				<tr >
					<td class="indicadores">D</td>
					<?=$converted_data['taxa_ocupacao']['d']?>
				</tr>

				<tr>
					<td rowspan="3">
						Taxa de Mortalidade Pós-Operatória
					</td>
					<td class="indicadores" >R</td>
					<?=$converted_data['taxa_internacoes']['r']?>
				</tr>

				<tr>
					<td class="indicadores">M</td>
					<?=$converted_data['taxa_internacoes']['m']?>
				</tr>

				<tr >
					<td class="indicadores">D</td>
					<?=$converted_data['taxa_ocupacao']['d']?>
				</tr>

				<tr>
					<td rowspan="3">
						Taxa de Mortalidade Operatória
					</td>
					<td class="indicadores" >R</td>
					<?=$converted_data['taxa_internacoes']['r']?>
				</tr>

				<tr>
					<td class="indicadores">M</td>
					<?=$converted_data['taxa_internacoes']['m']?>
				</tr>

				<tr >
					<td class="indicadores">D</td>
					<?=$converted_data['taxa_ocupacao']['d']?>
				</tr>

				<tr>
					<td rowspan="3">
						Taxa de Letalidade Padronizada
					</td>
					<td class="indicadores" >R</td>
					<?=$converted_data['taxa_internacoes']['r']?>
				</tr>

				<tr>
					<td class="indicadores">M</td>
					<?=$converted_data['taxa_internacoes']['m']?>
				</tr>

				<tr >
					<td class="indicadores">D</td>
					<?=$converted_data['taxa_ocupacao']['d']?>
				</tr>

				<tr>
					<td rowspan="3">
						Taxa de Infecção de Corrente Sanguínea por Cateter Vascular
					</td>
					<td class="indicadores" >R</td>
					<?=$converted_data['taxa_internacoes']['r']?>
				</tr>

				<tr>
					<td class="indicadores">M</td>
					<?=$converted_data['taxa_internacoes']['m']?>
				</tr>

				<tr >
					<td class="indicadores">D</td>
					<?=$converted_data['taxa_ocupacao']['d']?>
				</tr>

				<tr>
					<td rowspan="3">
						Densidade de Uso de Cateter Vascular
					</td>
					<td class="indicadores" >R</td>
					<?=$converted_data['densidade_cateter_vascular']['r']?>
				</tr>

				<tr>
					<td class="indicadores">M</td>
					<?=$converted_data['densidade_cateter_vascular']['m']?>
				</tr>

				<tr >
					<td class="indicadores">D</td>
					<?=$converted_data['densidade_cateter_vascular']['d']?>
				</tr>

				<tr>
					<td rowspan="3">
						Taxa de Infecção de Trato Urinário por Cateter Vesical
					</td>
					<td class="indicadores" >R</td>
					<?=$converted_data['taxa_internacoes']['r']?>
				</tr>

				<tr>
					<td class="indicadores">M</td>
					<?=$converted_data['taxa_internacoes']['m']?>
				</tr>

				<tr >
					<td class="indicadores">D</td>
					<?=$converted_data['taxa_ocupacao']['d']?>
				</tr>

				<tr>
					<td rowspan="3">
						Densidade de Uso de Cateter Vesical
					</td>
					<td class="indicadores" >R</td>
					<?=$converted_data['densidade_cateter_vesical']['r']?>
				</tr>

				<tr>
					<td class="indicadores">M</td>
					<?=$converted_data['densidade_cateter_vesical']['m']?>
				</tr>

				<tr >
					<td class="indicadores">D</td>
					<?=$converted_data['densidade_cateter_vesical']['d']?>
				</tr>

				<tr>
					<td rowspan="3">
						Taxa de Pneumonia Associada a Ventilação Mecânica
					</td>
					<td class="indicadores" >R</td>
					<?=$converted_data['taxa_internacoes']['r']?>
				</tr>

				<tr>
					<td class="indicadores">M</td>
					<?=$converted_data['taxa_internacoes']['m']?>
				</tr>

				<tr >
					<td class="indicadores">D</td>
					<?=$converted_data['taxa_ocupacao']['d']?>
				</tr>

				<tr>
					<td rowspan="3">
						Densidade de Uso de Ventilação Mecânica
					</td>
					<td class="indicadores" >R</td>
					<?=$converted_data['taxa_internacoes']['r']?>
				</tr>

				<tr>
					<td class="indicadores">M</td>
					<?=$converted_data['taxa_internacoes']['m']?>
				</tr>

				<tr >
					<td class="indicadores">D</td>
					<?=$converted_data['taxa_ocupacao']['d']?>
				</tr>

				<tr>
					<td rowspan="3">
						Taxa de Infecção de Sítio Cirúrgico
					</td>
					<td class="indicadores" >R</td>
					<?=$converted_data['taxa_internacoes']['r']?>
				</tr>

				<tr>
					<td class="indicadores">M</td>
					<?=$converted_data['taxa_internacoes']['m']?>
				</tr>

				<tr >
					<td class="indicadores">D</td>
					<?=$converted_data['taxa_ocupacao']['d']?>
				</tr>

				<tr>
					<td rowspan="3">
						Total de Cirurgias com Risco de Infecção
					</td>
					<td class="indicadores" >R</td>
					<?=$converted_data['taxa_internacoes']['r']?>
				</tr>

				<tr>
					<td class="indicadores">M</td>
					<?=$converted_data['taxa_internacoes']['m']?>
				</tr>

				<tr >
					<td class="indicadores">D</td>
					<?=$converted_data['taxa_ocupacao']['d']?>
				</tr>

				<tr>
					<td rowspan="3">
						Taxa de Captação na Morte Encefálica
					</td>
					<td class="indicadores" >R</td>
					<?=$converted_data['taxa_internacoes']['r']?>
				</tr>

				<tr>
					<td class="indicadores">M</td>
					<?=$converted_data['taxa_internacoes']['m']?>
				</tr>

				<tr >
					<td class="indicadores">D</td>
					<?=$converted_data['taxa_ocupacao']['d']?>
				</tr>

				<tr>
					<td rowspan="3">
						Relação Head / Bed
					</td>
					<td class="indicadores" >R</td>
					<?=$converted_data['taxa_internacoes']['r']?>
				</tr>

				<tr>
					<td class="indicadores">M</td>
					<?=$converted_data['taxa_internacoes']['m']?>
				</tr>

				<tr >
					<td class="indicadores">D</td>
					<?=$converted_data['taxa_ocupacao']['d']?>
				</tr>

				<tr>
					<td rowspan="3">
						Consumo Total
					</td>
					<td class="indicadores" >R</td>
					<?=$converted_data['taxa_internacoes']['r']?>
				</tr>

				<tr>
					<td class="indicadores">M</td>
					<?=$converted_data['taxa_internacoes']['m']?>
				</tr>

				<tr >
					<td class="indicadores">D</td>
					<?=$converted_data['taxa_ocupacao']['d']?>
				</tr>

				<tr>
					<td rowspan="3">
						Consumo Diário
					</td>
					<td class="indicadores" >R</td>
					<?=$converted_data['taxa_internacoes']['r']?>
				</tr>

				<tr>
					<td class="indicadores">M</td>
					<?=$converted_data['taxa_internacoes']['m']?>
				</tr>

				<tr >
					<td class="indicadores">D</td>
					<?=$converted_data['taxa_ocupacao']['d']?>
				</tr>

				<tr>
					<td rowspan="3">
						Consumo Diário por Paciente
					</td>
					<td class="indicadores" >R</td>
					<?=$converted_data['taxa_internacoes']['r']?>
				</tr>

				<tr>
					<td class="indicadores">M</td>
					<?=$converted_data['taxa_internacoes']['m']?>
				</tr>

				<tr >
					<td class="indicadores">D</td>
					<?=$converted_data['taxa_ocupacao']['d']?>
				</tr>

				<tr>
					<td rowspan="3">
						Ticket Total
					</td>
					<td class="indicadores" >R</td>
					<?=$converted_data['taxa_internacoes']['r']?>
				</tr>

				<tr>
					<td class="indicadores">M</td>
					<?=$converted_data['taxa_internacoes']['m']?>
				</tr>

				<tr >
					<td class="indicadores">D</td>
					<?=$converted_data['taxa_ocupacao']['d']?>
				</tr>

				<tr>
					<td rowspan="3">
						Ticket Médio Diário
					</td>
					<td class="indicadores" >R</td>
					<?=$converted_data['taxa_internacoes']['r']?>
				</tr>

				<tr>
					<td class="indicadores">M</td>
					<?=$converted_data['taxa_internacoes']['m']?>
				</tr>

				<tr >
					<td class="indicadores">D</td>
					<?=$converted_data['taxa_ocupacao']['d']?>
				</tr>

				<tr>
					<td rowspan="3">
						Ticket Médio Diário por Paciente
					</td>
					<td class="indicadores" >R</td>
					<?=$converted_data['taxa_internacoes']['r']?>
				</tr>

				<tr>
					<td class="indicadores">M</td>
					<?=$converted_data['taxa_internacoes']['m']?>
				</tr>

				<tr >
					<td class="indicadores">D</td>
					<?=$converted_data['taxa_ocupacao']['d']?>
				</tr>

				<tr>
					<td rowspan="3">
						Ticket por Internação
					</td>
					<td class="indicadores" >R</td>
					<?=$converted_data['taxa_internacoes']['r']?>
				</tr>

				<tr>
					<td class="indicadores">M</td>
					<?=$converted_data['taxa_internacoes']['m']?>
				</tr>

				<tr >
					<td class="indicadores">D</td>
					<?=$converted_data['taxa_ocupacao']['d']?>
				</tr>


				<tr>
					<td rowspan="3">
						Ticket por Internação por Paciente
					</td>
					<td class="indicadores" >R</td>
					<?=$converted_data['taxa_internacoes']['r']?>
				</tr>

				<tr>
					<td class="indicadores">M</td>
					<?=$converted_data['taxa_internacoes']['m']?>
				</tr>

				<tr >
					<td class="indicadores">D</td>
					<?=$converted_data['taxa_ocupacao']['d']?>
				</tr>

				<tr>
					<td rowspan="3">
						Valor de Glossa Total
					</td>
					<td class="indicadores" >R</td>
					<?=$converted_data['taxa_internacoes']['r']?>
				</tr>

				<tr>
					<td class="indicadores">M</td>
					<?=$converted_data['taxa_internacoes']['m']?>
				</tr>

				<tr >
					<td class="indicadores">D</td>
					<?=$converted_data['taxa_ocupacao']['d']?>
				</tr>

				<tr>
					<td rowspan="3">
						Glossa Média por Paciente
					</td>
					<td class="indicadores" >R</td>
					<?=$converted_data['taxa_internacoes']['r']?>
				</tr>

				<tr>
					<td class="indicadores">M</td>
					<?=$converted_data['taxa_internacoes']['m']?>
				</tr>

				<tr >
					<td class="indicadores">D</td>
					<?=$converted_data['taxa_ocupacao']['d']?>
				</tr>


			</tbody>
		</table>
	</div>
</body>
</html>