<!DOCTYPE html>
<html>
<head>
	<meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
	<?=$this->Html->css('pdf', ['fullBase' => true]);?>
	<?=$this->fetch('css')?>
</head>
<body>
	<?= $this->element( 'header-logo', ['report_title'=>'Relatório de Neonatal'] ); ?>	
	<div class="container">
		<table class="aileron_thin" style="width:100%; border-collapse: collapse;">
			<thead>
				<tr>
					 <th class="title th-left">Item</th>
					 <th class="title th-right">VA</th>
					 <th class="title th-right">%</th>
					 <th class="title th-right">Média</th>
					 <th class="title th-right">Mediana</th>
					 <th class="title th-right">Desvio padrão</th>
			  </tr>
			</thead>		  
			<tbody>
				<tr >
                    <td class="line-separator title" style="font-weight: bold" colspan=6>  Histórico materno</td>
                </tr>

				<tr>
					<td >Paridade</td>
					<td> <?=$data['paridade']['total']?> </td>
					<td> <?=$data['paridade']['percentual']?>%</td>
					<td>-</td>
					<td>-</td>
					<td>-</td>					
			    </tr>

			  	<tr >
                    <td class="line-separator title" style="font-weight: bold" colspan=6> Histórico familiar </td>
                </tr>

			  <tr>
					<td >Enfermidades atuais e significantes em membros da família, consangüinidade.</td>
					<td> <?=$data['enfermidades_atuais']['total']?> </td>
					<td> <?=$data['enfermidades_atuais']['percentual']?>%</td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			  </tr>

			    <tr >
                    <td class="line-separator title" style="font-weight: bold" colspan=6> Histórico neonatal </td>
                </tr>

                <tr>
					<td >Intercorrências no pré-parto e sala de parto</td>
					<td> <?=$data['intercorren_pre_parto']['total']?> </td>
					<td> <?=$data['intercorren_pre_parto']['percentual']?>%</td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr>

			    <tr>
					<td >Boletim de Apgar</td>
					<td> <?=$data['boletim_apgar']['total']?> </td>
					<td> <?=$data['boletim_apgar']['percentual']?>%</td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr>

			    <tr>
					<td >Necessidade de reanimação</td>
					<td> <?=$data['necessidade_reanimacao']['total']?> </td>
					<td> <?=$data['necessidade_reanimacao']['percentual']?>%</td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr>

			    <tr>
					<td >Apto para amamentação</td>
					<td> <?=$data['apto_amamentacao']['total']?> </td>
					<td> <?=$data['apto_amamentacao']['percentual']?>%</td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr>			    



							
			    <tr >
                    <td class="line-separator title" style="font-weight: bold" colspan=6> Placenta </td>
                </tr>

                <tr>
					<td >Peso</td>
					<td>-</td>
					<td>-</td>
					<td> <?=$data['placenta_peso']['media']?> </td>
					<td> <?=$data['placenta_peso']['mediana']?> </td>
					<td> <?=$data['placenta_peso']['desvio_padrao']?> </td>
			    </tr>

			    <tr>
					<td >Coloração e odor alterados</td>
					<td>-</td>
					<td>-</td>
					<td> <?=$data['coloracao_odor_alterado']['media']?> </td>
					<td> <?=$data['coloracao_odor_alterado']['mediana']?> </td>
					<td> <?=$data['coloracao_odor_alterado']['desvio_padrao']?> </td>
			    </tr>

			    <tr>
			    	<td >A relação do peso da placenta com peso do RN está adequada</td>
			    	<td>-</td>
					<td>-</td>					
					<td> <?=$data['relacao_do_peso_placenta']['media']?> </td>
					<td> <?=$data['relacao_do_peso_placenta']['mediana']?> </td>
					<td> <?=$data['relacao_do_peso_placenta']['desvio_padrao']?> </td>
			    </tr>

			    <tr>
			    	<td >Cordão umbilical presente com três vasos</td>
			    	<td>-</td>
					<td>-</td>					
					<td>  </td>
					<td>  </td>
					<td>  </td>
			    </tr>

			    <tr >			    
                    <td class="line-separator title" style="font-weight: bold" colspan=6> Medidas e condição ao Nascer </td>
                </tr>

                <tr>
					<td >Peso</td>
					<td>-</td>
					<td>-</td>
					<td> <?=$data['ao_nascer_peso']['media']?> </td>
					<td> <?=$data['ao_nascer_peso']['mediana']?> </td>
					<td> <?=$data['ao_nascer_peso']['desvio_padrao']?> </td>
			    </tr>

			    <tr>
					<td >Comprimento</td>
					<td>-</td>
					<td>-</td>
					<td> <?=$data['ao_nascer_comprimento']['media']?> </td>
					<td> <?=$data['ao_nascer_comprimento']['mediana']?> </td>
					<td> <?=$data['ao_nascer_comprimento']['desvio_padrao']?> </td>
			    </tr>

			    <tr>
					<td >Classificação do RN</td>
					<td>-</td>
					<td>-</td>
					<td> <?=$data['ao_nascer_classificacao_rn']['media']?> </td>
					<td> <?=$data['ao_nascer_classificacao_rn']['mediana']?> </td>
					<td> <?=$data['ao_nascer_classificacao_rn']['desvio_padrao']?> </td>
			    </tr>

			    <tr>
					<td >Iluminação e aquecimentos estão adequados</td>
					<td>-</td>
					<td>-</td>
					<td> <?=$data['ao_nascer_classificacao_rn']['media']?> </td>
					<td> <?=$data['ao_nascer_classificacao_rn']['mediana']?> </td>
					<td> <?=$data['ao_nascer_classificacao_rn']['desvio_padrao']?> </td>
			    </tr>

			     <tr >			    
                    <td class="line-separator title" style="font-weight: bold" colspan=6>Pele </td>
                </tr>

			    <tr>
					<td >Icterícia (Zonas de Krammer)</td>
					<td> <?=$data['ictericia']['total']?> </td>
					<td> <?=$data['ictericia']['percentual']?>%</td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr>

			    <tr>
					<td >Palidez</td>
					<td> <?=$data['palidez']['total']?> </td>
					<td> <?=$data['palidez']['percentual']?>%</td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr>

			    <tr>
					<td >Descamação fisiológica em pós maturos (pés e mãos) e escamas endurecidas na ictiose congênita</td>
					<td> <?=$data['descamacao_fisiologica']['total']?> </td>
					<td> <?=$data['descamacao_fisiologica']['percentual']?>%</td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr>

			    <tr>
					<td >Nevos pigmentosus (mancha mongólica)</td>
					<td> <?=$data['nevos_pgmentosus']['total']?> </td>
					<td> <?=$data['nevos_pgmentosus']['percentual']?>%</td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr>

			    <tr>
					<td >Linfomas císticos: presentes em qualquer parte do corpo</td>
					<td> <?=$data['linfomas_cisticos']['total']?> </td>
					<td> <?=$data['linfomas_cisticos']['percentual']?>%</td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr>

			    <tr>
					<td >Escleredema</td>
					<td> <?=$data['escleredema']['total']?> </td>
					<td> <?=$data['escleredema']['percentual']?>%</td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr>

			    <tr>
					<td >Petéquias e púrpuras</td>
					<td> <?=$data['petequias_e_purpuras']['total']?> </td>
					<td> <?=$data['petequias_e_purpuras']['percentual']?>%</td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr>

			    <tr>
					<td >Hemangioma</td>
					<td> <?=$data['hemangioma']['total']?> </td>
					<td> <?=$data['hemangioma']['percentual']?>%</td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr>

			    <tr>
					<td >Pele espessa, opaca e queratinizada</td>
					<td> <?=$data['pele_espessa']['total']?> </td>
					<td> <?=$data['pele_espessa']['percentual']?>%</td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr>

			    <tr>
					<td >Visibilidade dos vasos e sulcos</td>
					<td> <?=$data['visibilidade_vasos_sulcos']['total']?> </td>
					<td> <?=$data['visibilidade_vasos_sulcos']['percentual']?>%</td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr>

			    <tr>
					<td >Lanugem</td>
					<td> <?=$data['lanugem']['total']?> </td>
					<td> <?=$data['lanugem']['percentual']?>%</td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr>

			    <tr>
					<td >Superfície plantar com rugas que se dirigem dos dedos para o calcanhar</td>
					<td> <?=$data['superficie_plantar']['total']?> </td>
					<td> <?=$data['superficie_plantar']['percentual']?>%</td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr>

			    <tr >			    
                    <td class="line-separator title" style="font-weight: bold" colspan=6>Crânio</td>
                </tr>

                <tr>
                	<td>Distância antero-posterior (DAP)</td>
                	<td>-</td>
					<td>-</td>
					<td> <?=$data['distancia_antero_posterior']['media']?> </td>
					<td> <?=$data['distancia_antero_posterior']['mediana']?> </td>
					<td> <?=$data['distancia_antero_posterior']['desvio_padrao']?> </td>	
                </tr>
                	
                <tr>
                	<td>Distância biauricular (DBA)</td>
                	<td>-</td>
					<td>-</td>
					<td> <?=$data['distancia_biauricular']['media']?> </td>
					<td> <?=$data['distancia_biauricular']['mediana']?> </td>
					<td> <?=$data['distancia_biauricular']['desvio_padrao']?> </td>	
                </tr>

                <tr>
                	<td>Perímetro cefálico</td>
                	<td>-</td>
					<td>-</td>
					<td> <?=$data['perimetro_cefalico']['media']?> </td>
					<td> <?=$data['perimetro_cefalico']['mediana']?> </td>
					<td> <?=$data['perimetro_cefalico']['desvio_padrao']?> </td>	
                </tr>

                <tr>
                	<td>Índice cefálico</td>
                	<td>-</td>
					<td>-</td>
					<td> <?=$data['indice_cefalico']['media']?> </td>
					<td> <?=$data['indice_cefalico']['mediana']?> </td>
					<td> <?=$data['indice_cefalico']['desvio_padrao']?> </td>	
                </tr>

                <!-- <tr>
                	<td>Perímetro cefálico</td>
                	<td>-</td>
					<td>-</td>
					<td> <?=$data['perimetro_cefalico']['media']?> </td>
					<td> <?=$data['perimetro_cefalico']['mediana']?> </td>
					<td> <?=$data['perimetro_cefalico']['desvio_padrao']?> </td>	
                </tr> -->

                <tr>
					<td >Craniossinostose</td>
					<td> <?=$data['craniossinostose']['total']?> </td>
					<td> <?=$data['craniossinostose']['percentual']?>%</td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr>

			    <tr>
					<td >Céfalo-hematoma</td>
					<td> <?=$data['cefalo_hematoma']['total']?> </td>
					<td> <?=$data['cefalo_hematoma']['percentual']?>%</td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr>

			    <tr>
					<td >Bossa serossanguínea </td>
					<td> <?=$data['bossa_serossanguinea']['total']?> </td>
					<td> <?=$data['bossa_serossanguinea']['percentual']?>%</td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr>

			    <tr>
					<td >Fontanelas adequadas</td>
					<td> <?=$data['fontanelas_adequadas']['total']?> </td>
					<td> <?=$data['fontanelas_adequadas']['percentual']?>%</td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr>
			    <tr>
					<td >Crânio- tabes </td>
					<td> <?=$data['ruidos_intracranianos']['total']?> </td>
					<td> <?=$data['ruidos_intracranianos']['percentual']?>%</td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr>

			    <tr>
					<td >Ruídos intracranianos  </td>
					<td> <?=$data['superficie_plantar']['total']?> </td>
					<td> <?=$data['superficie_plantar']['percentual']?>%</td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr>

			    <tr>
					<td >Encefalocele</td>
					<td> <?=$data['encefalocele']['total']?> </td>
					<td> <?=$data['encefalocele']['percentual']?>%</td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr>

			    <tr>
					<td > Cartilagem da orelha e pálpebras com localização e formato adequado  </td>
					<td> <?=$data['cartilagem_da_orelha']['total']?> </td>
					<td> <?=$data['cartilagem_da_orelha']['percentual']?>%</td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr>
			    <tr>
					<td >Crânio- tabes </td>
					<td> <?=$data['superficie_plantar']['total']?> </td>
					<td> <?=$data['superficie_plantar']['percentual']?>%</td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr>

			    <tr >			    
                    <td class="line-separator title" style="font-weight: bold" colspan=6>Face</td>
                </tr>

                <tr>
					<td >Simetria</td>
					<td> <?=$data['face_simetria']['total']?> </td>
					<td> <?=$data['face_simetria']['percentual']?>%</td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr>

			    <tr>
					<td >Aparência sindrômica</td>
					<td> <?=$data['aparencia_sindromica']['total']?> </td>
					<td> <?=$data['aparencia_sindromica']['percentual']?>%</td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr>

			    <tr>
					<td >Implantação das orelhas com localização e formato adequado</td>
					<td> <?=$data['implantacao_das_orelhas']['total']?> </td>
					<td> <?=$data['implantacao_das_orelhas']['percentual']?>%</td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr>

			    <!-- <tr>
					<td >Distância entre os olhos (LISTA SUSPENSA: normal, hipetelorismo ou hipotelorismo)</td>
					<td> <?=$data['simetria']['total']?> </td>
					<td> <?=$data['simetria']['percentual']?>%</td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr> -->

			    <tr>
					<td >Tamanho do queixo, nariz e língua adequados</td>
					<td> <?=$data['tamanho_do_queixo']['total']?> </td>
					<td> <?=$data['tamanho_do_queixo']['percentual']?>%</td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr>

			    <tr >			    
                    <td class="line-separator title" style="font-weight: bold" colspan=6>Olhos</td>
                </tr>

                <tr>
					<td >Reflexo da lux vermelha</td>
					<td> <?=$data['reflexo_luz_vermelha']['total']?> </td>
					<td> <?=$data['reflexo_luz_vermelha']['percentual']?>%</td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr>

			    <tr>
					<td >Hemorragia subconjuntival</td>
					<td> <?=$data['hemorragia_subconjuntival']['total']?> </td>
					<td> <?=$data['hemorragia_subconjuntival']['percentual']?>%</td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr>

			    <tr>
					<td > Estrabismo </td>
					<td> <?=$data['estrabismo']['total']?> </td>
					<td> <?=$data['estrabismo']['percentual']?>%</td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr>

			    <tr>
					<td > Pupila branca </td>
					<td> <?=$data['pupila_branca']['total']?> </td>
					<td> <?=$data['pupila_branca']['percentual']?>%</td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr>

			    <tr>
					<td > Opacificação da córnea </td>
					<td> <?=$data['opacificacao_cornea']['total']?> </td>
					<td> <?=$data['opacificacao_cornea']['percentual']?>%</td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr>

			    <tr>
					<td >  Secreção ocular presente </td>
					<td> <?=$data['secrecao_ocular_presente']['total']?> </td>
					<td> <?=$data['secrecao_ocular_presente']['percentual']?>%</td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr>

			    <tr >			    
                    <td class="line-separator title" style="font-weight: bold" colspan=6>Ouvidos</td>
                </tr>

                <tr>
					<td > Forma, tamanho, implantação das orelhas adequadas </td>
					<td> <?=$data['forma_tamanho_implantacao']['total']?> </td>
					<td> <?=$data['forma_tamanho_implantacao']['percentual']?>%</td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr>

			    <tr>
					<td >  Suspeita de alteração na audição </td>
					<td> <?=$data['suspeita_alteracao_audicao']['total']?> </td>
					<td> <?=$data['suspeita_alteracao_audicao']['percentual']?>%</td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr>

			    <tr>
					<td > Apêndices pré-auriculares presentes </td>
					<td> <?=$data['apendices_pre_auriculares']['total']?> </td>
					<td> <?=$data['apendices_pre_auriculares']['percentual']?>%</td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr>

			    <tr >			    
                    <td class="line-separator title" style="font-weight: bold" colspan=6>Nariz</td>
                </tr>

                <tr>
					<td > Forma e tamanho adequados</td>
					<td> <?=$data['forma_tamanho_adequados']['total']?> </td>
					<td> <?=$data['forma_tamanho_adequados']['percentual']?>%</td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr>

			    <tr>
					<td >Permeabilidade nasal</td>
					<td> <?=$data['permeabilidade_nasal']['total']?> </td>
					<td> <?=$data['permeabilidade_nasal']['percentual']?>%</td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr>

			    <tr>
					<td > Canal nasolacrimal patente</td>
					<td> <?=$data['canal_nasolacrimal']['total']?> </td>
					<td> <?=$data['canal_nasolacrimal']['percentual']?>%</td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr>

			    <tr>
					<td >Secreção nasal serossanguinolenta </td>
					<td> <?=$data['secrecao_nasal']['total']?> </td>
					<td> <?=$data['secrecao_nasal']['percentual']?>%</td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr>

			    <tr >			    
                    <td class="line-separator title" style="font-weight: bold" colspan=6>Boca</td>
                </tr>

                <tr>
					<td > Coloração dos lábios alterada  </td>
					<td> <?=$data['coloracao_dos_labios']['total']?> </td>
					<td> <?=$data['coloracao_dos_labios']['percentual']?>%</td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr>

			    <tr>
					<td >Alteração na integridade - lábio leporino</td>
					<td> <?=$data['alteracao_integridade']['total']?> </td>
					<td> <?=$data['alteracao_integridade']['percentual']?>%</td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr>

			    <tr>
					<td > Fenda palatina </td>
					<td> <?=$data['fenda_palatina']['total']?> </td>
					<td> <?=$data['fenda_palatina']['percentual']?>%</td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr>

			    <tr>
					<td >Língua com tamanho e mobilização adequada </td>
					<td> <?=$data['lingua_com_tamanho']['total']?> </td>
					<td> <?=$data['lingua_com_tamanho']['percentual']?>%</td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr>

			    <tr>
					<td > Dentes congênitos  </td>
					<td> <?=$data['dentes_congenitos']['total']?> </td>
					<td> <?=$data['dentes_congenitos']['percentual']?>%</td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr>

			    <tr>
					<td >  Rânula </td>
					<td> <?=$data['ranula']['total']?> </td>
					<td> <?=$data['ranula']['percentual']?>%</td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr>

			    <tr>
					<td >Pérolas de Epstein</td>
					<td> <?=$data['perolas_de_epstein']['total']?> </td>
					<td> <?=$data['perolas_de_epstein']['percentual']?>%</td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr>

			    <tr>
					<td > Úvula bífida </td>
					<td> <?=$data['uvula_bifida']['total']?> </td>
					<td> <?=$data['uvula_bifida']['percentual']?>%</td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr>

			    <tr>
					<td >Língua com tamanho e mobilização adequada </td>
					<td> <?=$data['lingua_com_tamanho']['total']?> </td>
					<td> <?=$data['lingua_com_tamanho']['percentual']?>%</td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr>

			    <tr>
					<td > Retrognatia </td>
					<td> <?=$data['retrognatia']['total']?> </td>
					<td> <?=$data['retrognatia']['percentual']?>%</td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr>

			    <tr>
					<td > Arqueamento do palato (ogival) </td>
					<td> <?=$data['arqueamento_do_palato']['total']?> </td>
					<td> <?=$data['arqueamento_do_palato']['percentual']?>%</td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr>

			    <tr >			    
                    <td class="line-separator title" style="font-weight: bold" colspan=6>Boca</td>
                </tr>

                <tr>
					<td > Ausência de massas, fístulas e excesso de pele </td>
					<td> <?=$data['ausencia_de_massas']['total']?> </td>
					<td> <?=$data['ausencia_de_massas']['percentual']?>%</td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr>

			    <tr>
					<td > Torcicolo congênito </td>
					<td> <?=$data['torcicolo_congenito']['total']?> </td>
					<td> <?=$data['torcicolo_congenito']['percentual']?>%</td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr>

			    <tr>
					<td > Teratoma cervical </td>
					<td> <?=$data['teratoma_cervical']['total']?> </td>
					<td> <?=$data['teratoma_cervical']['percentual']?>%</td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr>

			    <tr>
					<td > Higroma cístico </td>
					<td>  </td>
					<td>  %</td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr>

			    <tr>
					<td > Bócio congênito </td>
					<td>  </td>
					<td>  %</td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr>

			    <tr >			    
                    <td class="line-separator title" style="font-weight: bold" colspan=6>Tórax</td>
                </tr>

                <tr>
                	<td>Perímetro torácico</td>
                	<td>-</td>
					<td>-</td>
					<td> <?=$data['perimetro_toracico']['media']?> </td>
					<td> <?=$data['perimetro_toracico']['mediana']?> </td>
					<td> <?=$data['perimetro_toracico']['desvio_padrao']?> </td>	
                </tr>

                <tr>
					<td > Simetria </td>
					<td> <?=$data['torax_simetria']['total']?> </td>
					<td> <?=$data['torax_simetria']['percentual']?>%</td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr>

			    <tr>
					<td > Retrações sub e intercostais </td>
					<td> <?=$data['retracoes_sub_intercostais']['total']?> </td>
					<td> <?=$data['retracoes_sub_intercostais']['percentual']?>%</td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr>

			     <tr>
					<td > Retrações supra-claviculares </td>
					<td> <?=$data['retracoes_supra_claviculares']['total']?> </td>
					<td> <?=$data['retracoes_supra_claviculares']['percentual']?>%</td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr>

			    <tr >			    
                    <td class="line-separator title" style="font-weight: bold" colspan=6>Tórax</td>
                </tr>

                <tr>
					<td > Ausência de clavículas </td>
					<td> <?=$data['ausencia_claviculas']['total']?> </td>
					<td> <?=$data['ausencia_claviculas']['percentual']?>%</td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr>

			    <tr>
					<td > Disostose cleido craniana (cleidocrâniodisostose) </td>
					<td> <?=$data['disostose_cleido']['total']?> </td>
					<td> <?=$data['disostose_cleido']['percentual']?>%</td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr>

			    <tr>
					<td > Fraturas </td>
					<td> <?=$data['fraturas']['total']?> </td>
					<td> <?=$data['fraturas']['percentual']?>%</td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr>

			    <tr >			    
                    <td class="line-separator title" style="font-weight: bold" colspan=6>Mamas</td>
                </tr>

                <tr>
					<td> Assimetria </td>
					<td> <?=$data['assimetria']['total']?> </td>
					<td> <?=$data['assimetria']['percentual']?>%</td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr>

			    <tr>
					<td> Exame cardiovascular </td>
					<td> <?=$data['distancia_intermamilar']['total']?> </td>
					<td> <?=$data['distancia_intermamilar']['percentual']?>%</td>
					<td>-</td>
					<td>-</td>	
					<td>-</td>
			    </tr>

			    <tr>
					<td > Presença de mamilos extranumerários </td>
					<td> <?=$data['presencao_de_mamilos']['total']?> </td>
					<td> <?=$data['presencao_de_mamilos']['percentual']?>%</td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr>

			    <tr >			    
                    <td class="line-separator title" style="font-weight: bold" colspan=6>Exame cardiovascular</td>
                </tr>

               <!--  <tr>
					<td > Inspeção</td>
					<td> <?=$data['presencao_de_mamilos']['total']?> </td>
					<td> <?=$data['presencao_de_mamilos']['percentual']?>%</td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr> -->
			    <tr>
					<td > Pulsos com sincronia, ritmo e intensidade nos quatro membros </td>
					<td> <?=$data['presencao_de_mamilos']['total']?> </td>
					<td> <?=$data['presencao_de_mamilos']['percentual']?>%</td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr>

			</tbody>
		  

		</table>
	</div>
</body>
</html>