<nav class="large-3 medium-4 columns" id="actions-sidebar">
    <ul class="side-nav">
        <li class="heading"><?= __('Actions') ?></li>
        <li><?= $this->Html->link(__('Edit System Medication'), ['action' => 'edit', $systemMedication->id]) ?> </li>
        <li><?= $this->Form->postLink(__('Delete System Medication'), ['action' => 'delete', $systemMedication->id], ['confirm' => __('Are you sure you want to delete # {0}?', $systemMedication->id)]) ?> </li>
        <li><?= $this->Html->link(__('List System Medications'), ['action' => 'index']) ?> </li>
        <li><?= $this->Html->link(__('New System Medication'), ['action' => 'add']) ?> </li>
        <li><?= $this->Html->link(__('List Medication Descriptions'), ['controller' => 'MedicationDescriptions', 'action' => 'index']) ?> </li>
        <li><?= $this->Html->link(__('New Medication Description'), ['controller' => 'MedicationDescriptions', 'action' => 'add']) ?> </li>
        <li><?= $this->Html->link(__('List Professionals'), ['controller' => 'Professionals', 'action' => 'index']) ?> </li>
        <li><?= $this->Html->link(__('New Professional'), ['controller' => 'Professionals', 'action' => 'add']) ?> </li>
    </ul>
</nav>
<div class="systemMedications view large-9 medium-8 columns content">
    <h3><?= h($systemMedication->id) ?></h3>
    <table class="vertical-table">
        <tr>
            <th><?= __('Medication Description') ?></th>
            <td><?= $systemMedication->has('medication_description') ? $this->Html->link($systemMedication->medication_description->name, ['controller' => 'MedicationDescriptions', 'action' => 'view', $systemMedication->medication_description->id]) : '' ?></td>
        </tr>
        <tr>
            <th><?= __('Professional') ?></th>
            <td><?= $systemMedication->has('professional') ? $this->Html->link($systemMedication->professional->id, ['controller' => 'Professionals', 'action' => 'view', $systemMedication->professional->id]) : '' ?></td>
        </tr>
        <tr>
            <th><?= __('Id') ?></th>
            <td><?= $this->Number->format($systemMedication->id) ?></td>
        </tr>
        <tr>
            <th><?= __('Created') ?></th>
            <td><?= h($systemMedication->created) ?></td>
        </tr>
        <tr>
            <th><?= __('Modified') ?></th>
            <td><?= h($systemMedication->modified) ?></td>
        </tr>
        <tr>
            <th><?= __('Is Active') ?></th>
            <td><?= $systemMedication->is_active ? __('Yes') : __('No'); ?></td>
        </tr>
    </table>
</div>
