<?php
namespace App\Controller;

use App\Controller\AppController;

/**
 * TciTypes Controller
 *
 * @property \App\Model\Table\TciTypesTable $TciTypes
 */
class TciTypesController extends AppController
{

    public function initialize()
    {
        parent::initialize();
        $this->loadComponent('Permission');
        $this->loadComponent('Upload');
        $this->set('title', 'TCI');
    }

    public function isAuthorized($user)
    {
        $action = $this->request->params['action'];

        return $this->Permission->hasPermission($user['role_name'], 'TciTypes', $action);
    }

    /**
     * Index method
     *
     * @return \Cake\Network\Response|null
     */
    public function index()
    {
        $tciType = $this->TciTypes->newEntity();

        $this->paginate = [
            'contain' => ['Units'],
        ];
        $tciTypes = $this->paginate($this->TciTypes);

        if ($this->request->is('post')) {
            $tciType = $this->TciTypes->patchEntity($tciType, $this->request->data);
            if ($this->TciTypes->save($tciType)) {
                $this->Flash->success(__('O registro foi salvo.'));
                return $this->redirect(['action' => 'index']);
            } else {
                $this->Flash->error(__('O registro não pode ser salvo. Por favor, tente novamente.'));
            }
        }

        $this->set(compact('tciTypes', 'tciType'));
        $this->set('_serialize', ['tciTypes', 'tciType']);
    }

    /**
     * View method
     *
     * @param string|null $id Tci Type id.
     * @return \Cake\Network\Response|null
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function view($id = null)
    {
        $tciType = $this->TciTypes->get($id, [
            'contain' => ['Units'],
        ]);

        $this->set('tciType', $tciType);
        $this->set('_serialize', ['tciType']);
    }

    /**
     * Add method
     *
     * @return \Cake\Network\Response|void Redirects on successful add, renders view otherwise.
     */
    public function add()
    {
        $tciType = $this->TciTypes->newEntity();
        if ($this->request->is('post')) {
            $tciType = $this->TciTypes->patchEntity($tciType, $this->request->data);
            if ($this->TciTypes->save($tciType)) {
                $this->Flash->success(__('O registro foi salvo.'));
                return $this->redirect(['action' => 'index']);
            } else {
                $this->Flash->error(__('O registro não pode ser salvo. Por favor, tente novamente.'));
            }
        }
        $units = $this->TciTypes->Units->find('list', ['limit' => 200]);
        $this->set(compact('tciType', 'units'));
        $this->set('_serialize', ['tciType']);
    }

    /**
     * Edit method
     *
     * @param string|null $id Tci Type id.
     * @return \Cake\Network\Response|void Redirects on successful edit, renders view otherwise.
     * @throws \Cake\Network\Exception\NotFoundException When record not found.
     */
    public function edit($id = null)
    {
        $tciType = $this->TciTypes->get($id, [
            'contain' => [],
        ]);
        if ($this->request->is(['patch', 'post', 'put'])) {
            $tciType = $this->TciTypes->patchEntity($tciType, $this->request->data);
            if ($this->TciTypes->save($tciType)) {
                $this->Flash->success(__('O registro foi salvo.'));
                return $this->redirect(['action' => 'index']);
            } else {
                $this->Flash->error(__('O registro não pode ser salvo. Por favor, tente novamente.'));
            }
        }
        //$units = $this->TciTypes->Units->find('list', ['limit' => 200]);
        $this->set(compact('tciType'));
        $this->set('_serialize', ['tciType']);
    }

    /**
     * Delete method
     *
     * @param string|null $id Tci Type id.
     * @return \Cake\Network\Response|null Redirects to index.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function delete($id = null)
    {
        $this->request->allowMethod(['post', 'delete']);
        $tciType = $this->TciTypes->get($id);
        if ($this->TciTypes->delete($tciType)) {
            $this->Flash->success(__('O registro foi deletado.'));
        } else {
            $this->Flash->error(__('O registro não pode ser deletado. Por favor, tente novamente.'));
        }
        return $this->redirect(['action' => 'index']);
    }
}
