<?php
namespace App\Model\Entity;

use Cake\ORM\Entity;

/**
 * ItuPreventionBundle Entity.
 *
 * @property int $id
 * @property \Cake\I18n\Time $date_instalation
 * @property string $type_of_device
 * @property \Cake\I18n\Time $created
 * @property bool $emergency
 * @property bool $is_risk_of_bleeding_verified
 * @property bool $is_the_procedure_prescribed
 * @property string $device_observation
 * @property bool $proper_handwashing
 * @property bool $use_of_paramentation
 * @property bool $use_of_antisepsis
 * @property bool $use_of_field_with_maxium_barrier
 * @property bool $use_of_sterile_gel
 * @property bool $suitable_catheter_progression
 * @property bool $urine_output_cauterization
 * @property bool $adequate_catheter_fixation
 * @property bool $confirmation_of_position_with_us
 * @property int $checklist_observation
 * @property int $number_of_retries
 * @property bool $single_procedure
 * @property int $number_of_professionals
 * @property bool $blood_on_catheter
 * @property bool $successful_integration
 * @property string $immediate_complications
 * @property \Cake\I18n\Time $date_of_withdrawal
 * @property \Cake\I18n\Time $withdrawal_time
 * @property bool $accidental_removal
 * @property string $reason_for_inclusion
 * @property \Cake\I18n\Time $reinsert_time
 * @property \Cake\I18n\Time $reinsert_date
 * @property bool $citostimia
 * @property string $type
 * @property bool $degermacao_pele_clorohexidine
 * @property bool $antisepsia_pele_clorohexidine
 * @property bool $asseptica_durante_procedimento
 * @property bool $ultrasom_durante_procedimento
 * @property bool $troca_introducar_picc
 * @property bool $curativo_tecnica_esteril
 * @property bool $verificado_risco_dificuldade
 * @property string $risco_de_dificuldade
 * @property bool $tci_preenchido
 * @property bool $degermacao_da_genitalia
 * @property bool $curativo_tecnica_steril
 * @property bool $conectores_cvc
 * @property bool $radiografia_de_controle
 * @property string $apos_proce_observacao
 * @property string $pontuation
 * @property int $hospitalization_id
 * @property \App\Model\Entity\Hospitalization $hospitalization
 * @property int $screening_id
 * @property \App\Model\Entity\Screening $screening
 * @property \App\Model\Entity\DailyItuPreventionBundle[] $daily_itu_prevention_bundles
 */
class ItuPreventionBundle extends Entity
{

    /**
     * Fields that can be mass assigned using newEntity() or patchEntity().
     *
     * Note that when '*' is set to true, this allows all unspecified fields to
     * be mass assigned. For security purposes, it is advised to set '*' to false
     * (or remove it), and explicitly make individual fields accessible as needed.
     *
     * @var array
     */
    protected $_accessible = [
        '*' => true,
        'id' => false,
    ];
}
