<?php
namespace App\Model\Table;

use App\Model\Entity\PhysicalExam;
use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * PhysicalExams Model
 *
 * @property \Cake\ORM\Association\BelongsTo $MedicalCares
 */
class PhysicalExamsTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->table('physical_exams');
        $this->displayField('id');
        $this->primaryKey('id');

        $this->addBehavior('Timestamp');

        $this->belongsTo('MedicalCares', [
            'foreignKey' => 'medical_care_id',
            'joinType' => 'INNER'
        ]);
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('id')
            ->allowEmpty('id', 'create');

        $validator
            ->allowEmpty('pa');

        $validator
            ->allowEmpty('fr');

        $validator
            ->allowEmpty('ectoscopia');

        $validator
            ->allowEmpty('acv');

        $validator
            ->allowEmpty('abd');

        $validator
            ->allowEmpty('mmii');

        $validator
            ->allowEmpty('neuro');

        $validator
            ->allowEmpty('acessos');

        $validator
            ->allowEmpty('irpm');

        $validator
            ->allowEmpty('kg');

        $validator
            ->allowEmpty('mmhg');

        $validator
            ->allowEmpty('so2');

        $validator
            ->allowEmpty('alt');

        $validator
            ->allowEmpty('fc');

        $validator
            ->allowEmpty('so2_percent');

        $validator
            ->allowEmpty('so2_tax');

        $validator
            ->allowEmpty('so2_temp');

        $validator
            ->allowEmpty('alt_m');

        $validator
            ->allowEmpty('alt_imc');

        return $validator;
    }

    /**
     * Returns a rules checker object that will be used for validating
     * application integrity.
     *
     * @param \Cake\ORM\RulesChecker $rules The rules object to be modified.
     * @return \Cake\ORM\RulesChecker
     */
    public function buildRules(RulesChecker $rules)
    {
        $rules->add($rules->existsIn(['medical_care_id'], 'MedicalCares'));
        return $rules;
    }
}
