<?php
namespace App\Model\Table;

use App\Model\Entity\PreDeliricScore;
use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * PreDeliricScores Model
 *
 * @property \Cake\ORM\Association\BelongsTo $Hospitalizations
 */
class PreDeliricScoresTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->table('pre_deliric_scores');
        $this->displayField('id');
        $this->primaryKey('id');

        $this->addBehavior('Timestamp');

        $this->belongsTo('Hospitalizations', [
            'foreignKey' => 'hospitalization_id',
            'joinType' => 'INNER'
        ]);
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('id')
            ->allowEmpty('id', 'create');

        $validator
            ->allowEmpty('grupo_diagnostico');

        $validator
            ->allowEmpty('hospitalizacao_urgente');

        $validator
            ->allowEmpty('grupo_de_morfina');

        $validator
            ->allowEmpty('infeccao');

        $validator
            ->allowEmpty('coma');

        $validator
            ->allowEmpty('sedacao');

        $validator
            ->allowEmpty('ureia');

        $validator
            ->allowEmpty('acidose_metabolico');

        $validator
            ->allowEmpty('contagem_apache_ii');

        $validator
            ->requirePresence('data_de_realizacao', 'create')
            ->notEmpty('data_de_realizacao');

        $validator
            ->allowEmpty('risco_de_evolucao_para_delirium');

        $validator
            ->boolean('active')
            ->allowEmpty('active');

        return $validator;
    }

    /**
     * Returns a rules checker object that will be used for validating
     * application integrity.
     *
     * @param \Cake\ORM\RulesChecker $rules The rules object to be modified.
     * @return \Cake\ORM\RulesChecker
     */
    public function buildRules(RulesChecker $rules)
    {
        $rules->add($rules->existsIn(['hospitalization_id'], 'Hospitalizations'));
        return $rules;
    }
}
