<?php
namespace App\Model\Table;

use App\Model\Entity\SafeSurgeryBundle;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * SafeSurgeryBundles Model
 *
 * @property \Cake\ORM\Association\BelongsTo $Hospitalizations
 * @property \Cake\ORM\Association\BelongsTo $Rooms
 * @property \Cake\ORM\Association\HasMany $SafeSurgeryDiaryBundles
 */
class SafeSurgeryBundlesTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->table('safe_surgery_bundles');
        $this->displayField('id');
        $this->primaryKey('id');

        $this->addBehavior('Timestamp');

        $this->belongsTo('Hospitalizations', [
            'foreignKey' => 'hospitalization_id',
            'joinType'   => 'INNER',
        ]);
        $this->belongsTo('Screenings', [
            'foreignKey' => 'screening_id',
            'joinType'   => 'INNER',
        ]);
        $this->belongsTo('Rooms', [
            'foreignKey' => 'room_id',
        ]);
        $this->hasMany('SafeSurgeryDiaryBundles', [
            'foreignKey' => 'safe_surgery_bundle_id',
        ]);
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('id')
            ->allowEmpty('id', 'create');

        $validator
            ->boolean('is_active')
            ->allowEmpty('is_active');

        $validator
            ->boolean('tci_cirurgico')
            ->allowEmpty('tci_cirurgico');

        $validator
            ->boolean('ficha_pre_anestesica')
            ->allowEmpty('ficha_pre_anestesica');

        $validator
            ->boolean('tci_anestesico')
            ->allowEmpty('tci_anestesico');

        $validator
            ->boolean('precaucao')
            ->allowEmpty('precaucao');

        $validator
            ->boolean('marcacao_lateralidade')
            ->allowEmpty('marcacao_lateralidade');

        $validator
            ->boolean('jejum')
            ->allowEmpty('jejum');

        $validator
            ->date('data_inicio_jejum')
            ->allowEmpty('data_inicio_jejum');

        $validator
            ->time('hora_inicio_jejum')
            ->allowEmpty('hora_inicio_jejum');

        $validator
            ->boolean('estado_de_desnutricao')
            ->allowEmpty('estado_de_desnutricao');

        $validator
            ->boolean('realizacao_de_swab')
            ->allowEmpty('realizacao_de_swab');

        $validator
            ->boolean('paciente_colonizado_staphy')
            ->allowEmpty('paciente_colonizado_staphy');

        $validator
            ->boolean('germe_apresenta_resistencia')
            ->allowEmpty('germe_apresenta_resistencia');

        $validator
            ->boolean('banho_com_cleoxidine')
            ->allowEmpty('banho_com_cleoxidine');

        $validator
            ->boolean('uso_de_mupirocina')
            ->allowEmpty('uso_de_mupirocina');

        $validator
            ->boolean('2_pulseira_identificacao')
            ->allowEmpty('2_pulseira_identificacao');

        $validator
            ->boolean('2_marcacao_lateralidade')
            ->allowEmpty('2_marcacao_lateralidade');

        $validator
            ->boolean('2_tci_cirurgico')
            ->allowEmpty('2_tci_cirurgico');

        $validator
            ->boolean('2_ficha_pre_anestesica')
            ->allowEmpty('2_ficha_pre_anestesica');

        $validator
            ->boolean('2_tci_anestesico')
            ->allowEmpty('2_tci_anestesico');

        $validator
            ->boolean('2_risco_de_queda')
            ->allowEmpty('2_risco_de_queda');

        $validator
            ->boolean('2_precaucoes')
            ->allowEmpty('2_precaucoes');

        $validator
            ->allowEmpty('2_precaucoes_tipo');

        $validator
            ->boolean('2_proteses')
            ->allowEmpty('2_proteses');

        $validator
            ->boolean('2_adorno')
            ->allowEmpty('2_adorno');

        $validator
            ->boolean('2_roupa_intima')
            ->allowEmpty('2_roupa_intima');

        $validator
            ->boolean('2_prontuario')
            ->allowEmpty('2_prontuario');

        $validator
            ->boolean('2_prescricao_bh')
            ->allowEmpty('2_prescricao_bh');

        $validator
            ->boolean('2_exame_imagem')
            ->allowEmpty('2_exame_imagem');

        $validator
            ->boolean('2_exame_laboratorio')
            ->allowEmpty('2_exame_laboratorio');

        $validator
            ->boolean('3_pulseira_identificacao')
            ->allowEmpty('3_pulseira_identificacao');

        $validator
            ->boolean('3_marcacao_lateraliidade')
            ->allowEmpty('3_marcacao_lateraliidade');

        $validator
            ->boolean('3_pulseira_vermelha')
            ->allowEmpty('3_pulseira_vermelha');

        $validator
            ->boolean('3_precaucoes')
            ->allowEmpty('3_precaucoes');

        $validator
            ->allowEmpty('3_precaucoes_tipo');

        $validator
            ->boolean('3_proteses')
            ->allowEmpty('3_proteses');

        $validator
            ->boolean('3_tci')
            ->allowEmpty('3_tci');

        $validator
            ->boolean('3_roupa_intima')
            ->allowEmpty('3_roupa_intima');

        $validator
            ->boolean('4_confirmado_nome_paciente')
            ->allowEmpty('4_confirmado_nome_paciente');

        $validator
            ->boolean('4_confimado_tipo_procedimento')
            ->allowEmpty('4_confimado_tipo_procedimento');

        $validator
            ->boolean('4_marcacao_lateralidade')
            ->allowEmpty('4_marcacao_lateralidade');

        $validator
            ->boolean('4_checagem_equipamento')
            ->allowEmpty('4_checagem_equipamento');

        $validator
            ->boolean('4_oximetro_em_funcionamento')
            ->allowEmpty('4_oximetro_em_funcionamento');

        $validator
            ->boolean('4_alergia')
            ->allowEmpty('4_alergia');

        $validator
            ->allowEmpty('4_alergia_tipo');

        $validator
            ->boolean('4_via_aerea_dificil')
            ->allowEmpty('4_via_aerea_dificil');

        $validator
            ->boolean('4_disponibilizado_equip_vad')
            ->allowEmpty('4_disponibilizado_equip_vad');

        $validator
            ->boolean('4_risco_pera_sanguinea')
            ->allowEmpty('4_risco_pera_sanguinea');

        $validator
            ->boolean('4_acesso_venoso_adequado')
            ->allowEmpty('4_acesso_venoso_adequado');

        $validator
            ->boolean('4_reserva_de_sangue')
            ->allowEmpty('4_reserva_de_sangue');

        $validator
            ->allowEmpty('4_total_reserva_de_sangue');

        $validator
            ->boolean('4_manutencao_normotemia')
            ->allowEmpty('4_manutencao_normotemia');

        $validator
            ->boolean('4_controle_glicemia')
            ->allowEmpty('4_controle_glicemia');

        $validator
            ->boolean('5_confimacao_equipe_nome')
            ->allowEmpty('5_confimacao_equipe_nome');

        $validator
            ->boolean('5_confirmado_tipo_procedimento')
            ->allowEmpty('5_confirmado_tipo_procedimento');

        $validator
            ->boolean('5_antibiocoprofilaxia')
            ->allowEmpty('5_antibiocoprofilaxia');

        $validator
            ->allowEmpty('5_antibiocoprofilaxia_texto');

        $validator
            ->boolean('5_dose_antibiotico_ajuistada')
            ->allowEmpty('5_dose_antibiotico_ajuistada');

        $validator
            ->boolean('5_repique')
            ->allowEmpty('5_repique');

        $validator
            ->boolean('5_tricotomia_previa')
            ->allowEmpty('5_tricotomia_previa');

        $validator
            ->boolean('5_uso_do_bisturi')
            ->allowEmpty('5_uso_do_bisturi');

        $validator
            ->allowEmpty('5_localizacao_da_placa');

        $validator
            ->allowEmpty('5_tipo_anestesia');

        $validator
            ->boolean('5_uso_fracao_inspirada')
            ->allowEmpty('5_uso_fracao_inspirada');

        $validator
            ->boolean('5_porta_cirurgica_fechada')
            ->allowEmpty('5_porta_cirurgica_fechada');

        $validator
            ->boolean('6_houve_alteracao_procedimento')
            ->allowEmpty('6_houve_alteracao_procedimento');

        $validator
            ->boolean('6_houve_mudanca_diagnostico')
            ->allowEmpty('6_houve_mudanca_diagnostico');

        $validator
            ->boolean('2_pulseira_vermelha')
            ->allowEmpty('2_pulseira_vermelha');

        $validator
            ->boolean('3_nome_correto')
            ->allowEmpty('3_nome_correto');

        $validator
            ->boolean('3_ficha_pre')
            ->allowEmpty('3_ficha_pre');

        $validator
            ->boolean('3_tci_anestesico')
            ->allowEmpty('3_tci_anestesico');

        $validator
            ->time('5_antibiocoprofilaxia_hora')
            ->allowEmpty('5_antibiocoprofilaxia_hora');

        $validator
            ->allowEmpty('precaucoes_tipo');

        $validator
            ->allowEmpty('6_houve_mudanca_diagnostico_qual');

        $validator
            ->boolean('6_tempo_cirurgia_adequado')
            ->allowEmpty('6_tempo_cirurgia_adequado');

        $validator
            ->boolean('6_contagem_de_compressas')
            ->allowEmpty('6_contagem_de_compressas');

        $validator
            ->boolean('6_encaminhamento_introdutor_arterial')
            ->allowEmpty('6_encaminhamento_introdutor_arterial');

        $validator
            ->boolean('6_presenca_hematoma')
            ->allowEmpty('6_presenca_hematoma');

        $validator
            ->allowEmpty('6_qual_lateralidade');

        $validator
            ->boolean('6_peca_anatomica_identificada')
            ->allowEmpty('6_peca_anatomica_identificada');

        $validator
            ->boolean('6_curativo')
            ->allowEmpty('6_curativo');

        $validator
            ->allowEmpty('6_curativo_localidade');

        $validator
            ->boolean('6_integridade_da_pele')
            ->allowEmpty('6_integridade_da_pele');

        $validator
            ->allowEmpty('6_integridade_da_pele_local');

        $validator
            ->boolean('7_acesso_periferico')
            ->allowEmpty('7_acesso_periferico');

        $validator
            ->allowEmpty('7_acesso_periferico_local');

        $validator
            ->boolean('7_acesso_venoso_central')
            ->allowEmpty('7_acesso_venoso_central');

        $validator
            ->allowEmpty('7_acesso_venoso_central_local');

        $validator
            ->boolean('7_curativo_acesso_periferico')
            ->allowEmpty('7_curativo_acesso_periferico');

        $validator
            ->boolean('7_curativo_acesso_venoso_central')
            ->allowEmpty('7_curativo_acesso_venoso_central');

        $validator
            ->boolean('7_acesso_arterial')
            ->allowEmpty('7_acesso_arterial');

        $validator
            ->allowEmpty('7_acesso_arterial_local');

        $validator
            ->boolean('7_curativo_acesso_arterial')
            ->allowEmpty('7_curativo_acesso_arterial');

        $validator
            ->boolean('7_sonda_nasogastrica')
            ->allowEmpty('7_sonda_nasogastrica');

        $validator
            ->boolean('7_nasogastrica_confirmada_posicao')
            ->allowEmpty('7_nasogastrica_confirmada_posicao');

        $validator
            ->boolean('7_sonda_nasoenteral')
            ->allowEmpty('7_sonda_nasoenteral');

        $validator
            ->boolean('7_nasoenteral_confirmada_posicao')
            ->allowEmpty('7_nasoenteral_confirmada_posicao');

        $validator
            ->boolean('7_sonda_vesical_demora')
            ->allowEmpty('7_sonda_vesical_demora');

        $validator
            ->boolean('7_vesical_confirmada_posicao')
            ->allowEmpty('7_vesical_confirmada_posicao');

        $validator
            ->boolean('7_intubacao_endotraqueal')
            ->allowEmpty('7_intubacao_endotraqueal');

        $validator
            ->allowEmpty('7_intubacao_tipo');

        $validator
            ->boolean('7_intubacao_confirmado_posicionamento')
            ->allowEmpty('7_intubacao_confirmado_posicionamento');

        $validator
            ->boolean('7_dreno_torax')
            ->allowEmpty('7_dreno_torax');

        $validator
            ->allowEmpty('7_dreno_torax_local');

        $validator
            ->boolean('7_dreno_torax_confirmado_posicionamento')
            ->allowEmpty('7_dreno_torax_confirmado_posicionamento');

        $validator
            ->boolean('7_dreno_mediastino')
            ->allowEmpty('7_dreno_mediastino');

        $validator
            ->boolean('7_curativo_dreno_mediastino')
            ->allowEmpty('7_curativo_dreno_mediastino');

        $validator
            ->boolean('7_cateter_pic')
            ->allowEmpty('7_cateter_pic');

        $validator
            ->boolean('7_cateter_pic_pressao_zerada')
            ->allowEmpty('7_cateter_pic_pressao_zerada');

        $validator
            ->boolean('7_cateter_drenagem_ventricular')
            ->allowEmpty('7_cateter_drenagem_ventricular');

        $validator
            ->boolean('7_sistema_coletor_funcionante')
            ->allowEmpty('7_sistema_coletor_funcionante');

        $validator
            ->boolean('7_dreno_cavitario')
            ->allowEmpty('7_dreno_cavitario');

        $validator
            ->boolean('7_curativo_dreno_cavitario')
            ->allowEmpty('7_curativo_dreno_cavitario');

        $validator
            ->boolean('7_fio_marcapasso')
            ->allowEmpty('7_fio_marcapasso');

        $validator
            ->boolean('7_curativo_fio_marcapasso')
            ->allowEmpty('7_curativo_fio_marcapasso');

        $validator
            ->boolean('7_colostomia')
            ->allowEmpty('7_colostomia');

        $validator
            ->boolean('7_bolsa_de_colostomia')
            ->allowEmpty('7_bolsa_de_colostomia');

        $validator
            ->boolean('7_compressor_pneumatico')
            ->allowEmpty('7_compressor_pneumatico');

        $validator
            ->boolean('7_mante_termica')
            ->allowEmpty('7_mante_termica');

        $validator
            ->boolean('7_curativos_datados')
            ->allowEmpty('7_curativos_datados');

        $validator
            ->boolean('7_drenos_sondas_datados')
            ->allowEmpty('7_drenos_sondas_datados');

        $validator
            ->allowEmpty('7_exames_laboratoriais');

        $validator
            ->allowEmpty('7_hemocomponentes');

        $validator
            ->boolean('7_paciente_manutencao')
            ->allowEmpty('7_paciente_manutencao');

        $validator
            ->boolean('7_paciente_controle_glicemia')
            ->allowEmpty('7_paciente_controle_glicemia');

        $validator
            ->boolean('7_uso_de_fracao')
            ->allowEmpty('7_uso_de_fracao');

        $validator
            ->allowEmpty('7_drogas_em_curso_1');

        $validator
            ->allowEmpty('7_drogas_em_curso_2');

        $validator
            ->allowEmpty('7_drogas_em_curso_3');

        $validator
            ->allowEmpty('7_drogas_em_curso_4');

        $validator
            ->allowEmpty('7_drogas_em_curso_5');

        $validator
            ->allowEmpty('7_drogas_em_curso_6');

        $validator
            ->boolean('7_intercorrencias_cirurgica')
            ->allowEmpty('7_intercorrencias_cirurgica');

        $validator
            ->allowEmpty('7_inter_cirurgica_cite');

        $validator
            ->allowEmpty('7_inter_cirurgica_motivo');

        $validator
            ->boolean('7_inter_anestesica')
            ->allowEmpty('7_inter_anestesica');

        $validator
            ->allowEmpty('7_inter_anestesica_cite');

        $validator
            ->allowEmpty('7_inter_anestesica_motivo');

        $validator
            ->boolean('7_pertences_arrumados')
            ->allowEmpty('7_pertences_arrumados');

        $validator
            ->allowEmpty('7_dreno_cavitario_local');

        return $validator;
    }

    /**
     * Returns a rules checker object that will be used for validating
     * application integrity.
     *
     * @param \Cake\ORM\RulesChecker $rules The rules object to be modified.
     * @return \Cake\ORM\RulesChecker
     */
    public function buildRules(RulesChecker $rules)
    {
        $rules->add($rules->existsIn(['hospitalization_id'], 'Hospitalizations'));
        $rules->add($rules->existsIn(['room_id'], 'Rooms'));
        return $rules;
    }
}
