<?php
namespace App\Model\Table;

use App\Model\Entity\SafeSurgeryDiaryBundle;
use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * SafeSurgeryDiaryBundles Model
 *
 * @property \Cake\ORM\Association\BelongsTo $SafeSurgeryBundles
 */
class SafeSurgeryDiaryBundlesTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->table('safe_surgery_diary_bundles');
        $this->displayField('id');
        $this->primaryKey('id');

        $this->addBehavior('Timestamp');

        $this->belongsTo('SafeSurgeryBundles', [
            'foreignKey' => 'safe_surgery_bundle_id',
            'joinType' => 'INNER'
        ]);
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('id')
            ->allowEmpty('id', 'create');

        $validator
            ->boolean('suspensao_antibioticoprofilaxia')
            ->allowEmpty('suspensao_antibioticoprofilaxia');

        $validator
            ->boolean('controle_glicemico')
            ->allowEmpty('controle_glicemico');

        $validator
            ->boolean('controle_temperatura')
            ->allowEmpty('controle_temperatura');

        $validator
            ->boolean('profilaxia_embolia_venosa')
            ->allowEmpty('profilaxia_embolia_venosa');

        $validator
            ->boolean('profilaxia_lesao_gastica')
            ->allowEmpty('profilaxia_lesao_gastica');

        $validator
            ->boolean('curativo_diario')
            ->allowEmpty('curativo_diario');

        $validator
            ->boolean('curativo_datado')
            ->allowEmpty('curativo_datado');

        $validator
            ->boolean('possibilitade_retirada')
            ->allowEmpty('possibilitade_retirada');

        $validator
            ->boolean('paciente_com_mobilizacao')
            ->allowEmpty('paciente_com_mobilizacao');

        $validator
            ->boolean('is_active')
            ->allowEmpty('is_active');

        return $validator;
    }

    /**
     * Returns a rules checker object that will be used for validating
     * application integrity.
     *
     * @param \Cake\ORM\RulesChecker $rules The rules object to be modified.
     * @return \Cake\ORM\RulesChecker
     */
    public function buildRules(RulesChecker $rules)
    {
        $rules->add($rules->existsIn(['safe_surgery_bundle_id'], 'SafeSurgeryBundles'));
        return $rules;
    }
}
