<?php
namespace App\Model\Table;

use App\Model\Entity\Screening;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * Screenings Model
 *
 * @property \Cake\ORM\Association\BelongsTo $Patients
 * @property \Cake\ORM\Association\BelongsTo $Units
 * @property \Cake\ORM\Association\HasMany $Admissions
 * @property \Cake\ORM\Association\HasMany $Bundles
 * @property \Cake\ORM\Association\HasMany $Hospitalizations
 * @property \Cake\ORM\Association\HasMany $MedicalCares
 * @property \Cake\ORM\Association\HasMany $PavPreventionBundles
 * @property \Cake\ORM\Association\BelongsToMany $PainCharacteristics
 */
class ScreeningsTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->table('screenings');
        $this->displayField('id');
        $this->primaryKey('id');

        $this->addBehavior('Timestamp');

        $this->belongsTo('Patients', [
            'foreignKey' => 'patient_id',
            'joinType'   => 'INNER',
        ]);
        $this->belongsTo('Units', [
            'foreignKey' => 'unit_id',
            'joinType'   => 'INNER',
        ]);
        $this->belongsTo('Professionals', [
            'foreignKey' => 'professional_id',
            'joinType'   => 'LEFT',
        ]);
        $this->hasMany('Admissions', [
            'foreignKey' => 'screening_id',
        ]);
        $this->hasMany('Bundles', [
            'foreignKey' => 'screening_id',
        ]);
        $this->hasMany('Hospitalizations', [
            'foreignKey' => 'screening_id',
        ]);
        $this->hasMany('MedicalCares', [
            'foreignKey' => 'screening_id',
        ]);
        $this->hasMany('PavPreventionBundles', [
            'foreignKey' => 'screening_id',
        ]);
        $this->hasMany('ItuPreventionBundles', [
            'foreignKey' => 'screening_id',
        ]);
        $this->hasMany('SafeSurgeryBundles', [
            'foreignKey' => 'screening_id',
        ]);
        $this->belongsToMany('PainCharacteristics', [
            'foreignKey'       => 'screening_id',
            'targetForeignKey' => 'pain_characteristic_id',
            'joinTable'        => 'pain_characteristics_screenings',
        ]);
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('id')
            ->allowEmpty('id', 'create');

        $validator
            ->boolean('is_active')
            ->allowEmpty('is_active');

        $validator
            ->allowEmpty('pa');

        $validator
            ->allowEmpty('temp');

        $validator
            ->allowEmpty('sato2');

        $validator
            ->allowEmpty('fc');

        $validator
            ->allowEmpty('fr');

        $validator
            ->allowEmpty('glicemia');

        $validator
            ->boolean('parada_cardiaca_ou_suspeita')
            ->allowEmpty('parada_cardiaca_ou_suspeita');

        $validator
            ->allowEmpty('fraquesa_muscular');

        $validator
            ->allowEmpty('fraquesa_muscular_tipo');

        $validator
            ->allowEmpty('perda_sensorial');

        $validator
            ->allowEmpty('perda_sensorial_tipo');

        $validator
            ->allowEmpty('alteracao_consciencia');

        $validator
            ->allowEmpty('queixa_principal');

        $validator
            ->boolean('tem_alergia')
            ->allowEmpty('tem_alergia');

        $validator
            ->allowEmpty('alergias');

        $validator
            ->boolean('uso_medicacao_regular')
            ->allowEmpty('uso_medicacao_regular');

        $validator
            ->allowEmpty('medicacao_regular');

        $validator
            ->allowEmpty('resumo_da_queixa');

        $validator
            ->allowEmpty('localizacao_da_dor');

        $validator
            ->allowEmpty('aparecimento_da_dor');

        $validator
            ->boolean('dor_toracica_em_aperto')
            ->allowEmpty('dor_toracica_em_aperto');

        $validator
            ->boolean('dor_toracica_dispineia')
            ->allowEmpty('dor_toracica_dispineia');

        $validator
            ->boolean('dor_toracica_assimetria_dos_pulsos')
            ->allowEmpty('dor_toracica_assimetria_dos_pulsos');

        $validator
            ->boolean('dor_toracica_historico_de_coronariopatia')
            ->allowEmpty('dor_toracica_historico_de_coronariopatia');

        $validator
            ->boolean('dor_toracica_historico_de_avc')
            ->allowEmpty('dor_toracica_historico_de_avc');

        $validator
            ->boolean('dor_toracica_trauma_toracico_antecedente')
            ->allowEmpty('dor_toracica_trauma_toracico_antecedente');

        $validator
            ->boolean('dor_abdominal_historico_de_trauma')
            ->allowEmpty('dor_abdominal_historico_de_trauma');

        $validator
            ->boolean('dor_abdominal_diarreia')
            ->allowEmpty('dor_abdominal_diarreia');

        $validator
            ->boolean('dor_abdominal_nausea')
            ->allowEmpty('dor_abdominal_nausea');

        $validator
            ->boolean('dor_abdominal_vomitos')
            ->allowEmpty('dor_abdominal_vomitos');

        $validator
            ->boolean('cefaleia_rigidez_da_nuca')
            ->allowEmpty('cefaleia_rigidez_da_nuca');

        $validator
            ->boolean('cefaleia_vomitos')
            ->allowEmpty('cefaleia_vomitos');

        $validator
            ->boolean('cefaleia_episodio_de_crise_convulsiva')
            ->allowEmpty('cefaleia_episodio_de_crise_convulsiva');

        $validator
            ->boolean('ceruicalgia_historico_progresso_calculo_renal')
            ->allowEmpty('ceruicalgia_historico_progresso_calculo_renal');

        $validator
            ->boolean('ceruicalgia_transplatandos_e_em_quimioterapia')
            ->allowEmpty('ceruicalgia_transplatandos_e_em_quimioterapia');

        $validator
            ->boolean('ceruicalgia_alteracao_de_esfincter')
            ->allowEmpty('ceruicalgia_alteracao_de_esfincter');

        $validator
            ->boolean('dispneia_desconforto')
            ->allowEmpty('dispneia_desconforto');

        $validator
            ->boolean('dispneia_cianose')
            ->allowEmpty('dispneia_cianose');

        $validator
            ->boolean('dispneia_utilizacao_da_musculatura')
            ->allowEmpty('dispneia_utilizacao_da_musculatura');

        $validator
            ->boolean('dispneia_dificuldade_para_falar')
            ->allowEmpty('dispneia_dificuldade_para_falar');

        $validator
            ->boolean('dispneia_historico_de_asma')
            ->allowEmpty('dispneia_historico_de_asma');

        $validator
            ->boolean('dispneia_alteracao_na_ausculta')
            ->allowEmpty('dispneia_alteracao_na_ausculta');

        $validator
            ->boolean('diarreia_sinais_de_desidratacao')
            ->allowEmpty('diarreia_sinais_de_desidratacao');

        $validator
            ->boolean('diarreia_dor_abdominal')
            ->allowEmpty('diarreia_dor_abdominal');

        $validator
            ->boolean('diarreia_nausea_e_vomito')
            ->allowEmpty('diarreia_nausea_e_vomito');

        $validator
            ->boolean('diarreia_sinais_vitais_normais')
            ->allowEmpty('diarreia_sinais_vitais_normais');

        $validator
            ->boolean('tosse_dispneia')
            ->allowEmpty('tosse_dispneia');

        $validator
            ->boolean('tosse_historico_de_hemoptise')
            ->allowEmpty('tosse_historico_de_hemoptise');

        $validator
            ->boolean('tosse_dor_toracica_ausente')
            ->allowEmpty('tosse_dor_toracica_ausente');

        $validator
            ->boolean('hemorragia_historico_de_enterorragia')
            ->allowEmpty('hemorragia_historico_de_enterorragia');

        $validator
            ->boolean('hemorragia_antecedente_de_cirrose')
            ->allowEmpty('hemorragia_antecedente_de_cirrose');

        $validator
            ->boolean('queixa_cronica_nao_agudizada')
            ->allowEmpty('queixa_cronica_nao_agudizada');

        $validator
            ->boolean('lesoes_de_pele_escabiose')
            ->allowEmpty('lesoes_de_pele_escabiose');

        $validator
            ->boolean('lesoes_de_pele_eczema')
            ->allowEmpty('lesoes_de_pele_eczema');

        $validator
            ->boolean('lesoes_de_pele_outras_lesoes')
            ->allowEmpty('lesoes_de_pele_outras_lesoes');

        $validator
            ->allowEmpty('intensidade_da_dor');

        $validator
            ->boolean('alt_estado_mental_ausencia_de_resposta')
            ->allowEmpty('alt_estado_mental_ausencia_de_resposta');

        $validator
            ->boolean('alt_estado_mental_alteracao_consciencia')
            ->allowEmpty('alt_estado_mental_alteracao_consciencia');

        $validator
            ->boolean('deficit_motor_inicio_subito')
            ->allowEmpty('deficit_motor_inicio_subito');

        $validator
            ->boolean('febre_pa_menor_100')
            ->allowEmpty('febre_pa_menor_100');

        $validator
            ->boolean('febre_fc_maior_100')
            ->allowEmpty('febre_fc_maior_100');

        $validator
            ->boolean('febre_alteracao_nivel_consciencia')
            ->allowEmpty('febre_alteracao_nivel_consciencia');

        $validator
            ->boolean('febre_fr_maior_25')
            ->allowEmpty('febre_fr_maior_25');

        $validator
            ->boolean('febre_dispneia')
            ->allowEmpty('febre_dispneia');

        $validator
            ->boolean('febre_imunossupressao')
            ->allowEmpty('febre_imunossupressao');

        $validator
            ->boolean('hiperglicemia_associada_alteracao')
            ->allowEmpty('hiperglicemia_associada_alteracao');

        $validator
            ->boolean('hipoglicemia_associada_alteracao')
            ->allowEmpty('hipoglicemia_associada_alteracao');

        $validator
            ->boolean('hipoglicemia_glicemia_capilar')
            ->allowEmpty('hipoglicemia_glicemia_capilar');

        $validator
            ->allowEmpty('glasgow');

        $validator
            ->allowEmpty('classificacao_sugerida');

        $validator
            ->allowEmpty('classificacao_selecionada');

        return $validator;
    }

    /**
     * Returns a rules checker object that will be used for validating
     * application integrity.
     *
     * @param \Cake\ORM\RulesChecker $rules The rules object to be modified.
     * @return \Cake\ORM\RulesChecker
     */
    public function buildRules(RulesChecker $rules)
    {
        $rules->add($rules->existsIn(['patient_id'], 'Patients'));
        $rules->add($rules->existsIn(['unit_id'], 'Units'));
        return $rules;
    }
}
