<?php
namespace App\Model\Table;

use App\Model\Entity\SedativeDrug;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * SedativeDrugs Model
 *
 * @property \Cake\ORM\Association\BelongsTo $SuspectedMeProtocols
 * @property \Cake\ORM\Association\BelongsToMany $SuspectedMeProtocols
 */
class SedativeDrugsTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->table('sedative_drugs');
        $this->displayField('id');
        $this->primaryKey('id');

        $this->addBehavior('Timestamp');

        $this->belongsTo('SuspectedMeProtocols', [
            'foreignKey' => 'suspected_me_protocol_id',
            'joinType'   => 'INNER',
        ]);
        // $this->belongsToMany('SuspectedMeProtocols', [
        //     'foreignKey'       => 'sedative_drug_id',
        //     'targetForeignKey' => 'suspected_me_protocol_id',
        //     'joinTable'        => 'sedative_drugs_suspected_me_protocols',
        // ]);
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('id')
            ->allowEmpty('id', 'create');

        $validator
            ->allowEmpty('nome');

        $validator
        // ->date('data')
        ->allowEmpty('data');

        $validator
        // ->time('hora')
        ->allowEmpty('hora');

        $validator
            ->boolean('is_active')
            ->allowEmpty('is_active');

        return $validator;
    }

    /**
     * Returns a rules checker object that will be used for validating
     * application integrity.
     *
     * @param \Cake\ORM\RulesChecker $rules The rules object to be modified.
     * @return \Cake\ORM\RulesChecker
     */
    public function buildRules(RulesChecker $rules)
    {
        $rules->add($rules->existsIn(['suspected_me_protocol_id'], 'SuspectedMeProtocols'));
        return $rules;
    }
}
