<?php
namespace App\Model\Table;

use App\Model\Entity\Specialty;
use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * Specialties Model
 *
 * @property \Cake\ORM\Association\HasMany $MedicalOpinionRequests
 * @property \Cake\ORM\Association\BelongsToMany $Discharges
 * @property \Cake\ORM\Association\BelongsToMany $Professionals
 * @property \Cake\ORM\Association\BelongsToMany $Surgeries
 */
class SpecialtiesTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->table('specialties');
        $this->displayField('name');
        $this->primaryKey('id');

        $this->hasMany('MedicalOpinionRequests', [
            'foreignKey' => 'specialty_id'
        ]);
        $this->belongsToMany('Discharges', [
            'foreignKey' => 'specialty_id',
            'targetForeignKey' => 'discharge_id',
            'joinTable' => 'discharges_specialties'
        ]);
        $this->belongsToMany('Professionals', [
            'foreignKey' => 'specialty_id',
            'targetForeignKey' => 'professional_id',
            'joinTable' => 'professionals_specialties'
        ]);
        $this->belongsToMany('Surgeries', [
            'foreignKey' => 'specialty_id',
            'targetForeignKey' => 'surgery_id',
            'joinTable' => 'specialties_surgeries'
        ]);
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('id')
            ->allowEmpty('id', 'create');

        $validator
            ->requirePresence('name', 'create')
            ->notEmpty('name');

        return $validator;
    }
}
