<?php 
	$queixa_principal       = ['alteracao_estado_mental' => 'Alteração de estado mental', 'dispneia' => 'Dispneia', 'hiperglicemia' => 'Hiperglicemia', 'alt_sinais_vitais' => 'Alt. sinais vitais isolados', 'tosse' => 'Tosse', 'lesoes_de_pele' => 'Lesões de pele', 'dor' => 'Dor', 'febre' => 'Febre', 'hipoglicemia' => 'Hipoglicemia', 'diarreia' => 'Diarreia', 'casos_especiais' => 'Casos especiais', 'procura_da_unidade' => 'Procura da unidade p/ procedimentos', 'hemorragia' => 'Hemorragia', 'alteracao_de_pressao' => 'Alteração de pressão', 'parada_cardiorrespiratoria' => 'Parada cardiorrespiratória', 'hemorragia_digestiva' => 'Hemorragia digestiva', 'queixas_cronicas' => 'Queixas crônicas'];
	$room =null;
	$diagnostico_principal =null;
?>
<!DOCTYPE html>
<html>
<head>	
	<meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>	
	<?=  $this->Html->css('pdf', ['fullBase' => true]); ?>
	<?= $this->fetch('css') ?>
</head>
<body>
	<div class="container">		
		<div class="logo">
			<img src="/var/www/html/gh-backoffice/webroot/img/Logo-GH.png">
		</div>
		
		<p class="title f-size-32 t-center">
			 <span class='underline_text'>Visualização dos pacientes na internação</span>
	 	</p>
		
		<table class="aileron_thin" style="width:100%">

		<thead>
		  	<tr >
				 <th class="title th-left">Leito</th>
				 <th class="title th-middle" ">Nome</th>
				 <th class="title th-right" >Idade</th>
				 <th class="title th-right" >Diagnostico principal</th>
				 <th class="title th-right" >Tipo de internacao</th>
				 <th class="title th-right" >Previsao de alta</th>
				 <th class="title th-right" >Riscos identificados</th>
				 <th class="title th-right" >Alertas</th>
		  	</tr>
		</thead>
		
		<tbody>
		 <?php 
		 	foreach ($data as $key => $hospitalization) {
		 		echo "<tr>";		 		

		 		foreach ($hospitalization["historic_patient_movements"] as $key => $historic_patient_movements) {
		 			$room = $historic_patient_movements['room_id'];
		 		}
	 			echo "<td>" . $room . "</td>";	
		 			 		

		 		if ( isset($hospitalization['patient']["nome"]) ) {
		 			echo "<td>". $hospitalization['patient']["nome"] . "</td>";	
		 		} else {
		 			echo "<td></td>";
		 		}

		 		if ( isset($hospitalization['patient']["birthday"]) ) {
					$_age = floor((time() - strtotime($hospitalization['patient']["birthday"])) / 31556926);

		 			echo "<td>". $_age . "</td>";	
		 		} else {
		 			echo "<td></td>";
		 		}

		 		foreach ($hospitalization["diagnostics"] as $key => $diagnostics) {
		 			
	 				if ( $diagnostics['type'] == "Principal") {
	 					$diagnostico_principal = $diagnostics['description'];
		 			}
		 		}


		 		echo "<td>" . $diagnostico_principal . "</td>";

		 		echo "<td>" . $hospitalization["type"] . "</td>";

		 		echo "<td>" . $hospitalization["expected_discharge_day"] . "</td>";

		 		echo "<td>";
		 		foreach ($hospitalization["identification_of_risks"] as $key => $identification_of_risks) {
		 			
	 				if ( $diagnostics['type'] == "Principal") {
	 					$diagnostico_principal = $diagnostics['description'];
		 			}
		 			

		 			if ($identification_of_risks["ignorancia"]) {
		 				echo "Ignorancia; ";
		 			}
		 			if ($identification_of_risks["administracao"]) {
		 				echo "Administracao; ";
		 			}
		 			if ($identification_of_risks["reconcializacao"]) {
		 				echo "Reconcializacao; ";
		 			}
		 			if ($identification_of_risks["transporte_inseguro"]) {
		 				echo "Transporte inseguro; ";
		 			}if ($identification_of_risks["identificacao_errada_do_paciente"]) {
		 				echo "Identificacao errada do paciente; ";
		 			}if ($identification_of_risks["controle_inadequado"]) {
		 				echo "Controle inadequado; ";
		 			}if ($identification_of_risks["perda_da_passagem"]) {
		 				echo "Perda da passagem; ";
		 			}if ($identification_of_risks["que_do_leito"]) {
		 				echo "Queda do leito; ";
		 			}if ($identification_of_risks["turnover"]) {
		 				echo "Turnover";
		 			}if ($identification_of_risks["absenteismo"]) {
		 				echo "Absenteismo";
		 			}if ($identification_of_risks["nao_parametrizacao_da_monitorizacao"]) {
		 				echo "nao parametrizacao da monitorizacao";
		 			}if ($identification_of_risks["contaminacao_de_culturas"]) {
		 				echo "Contaminacao de culturas";
		 			}if ($identification_of_risks["coleta_inadequada_de_culturas"]) {
		 				echo "Coleta inadequada de culturas";
		 			}
		 			
		 			
		 		}
		 		echo "</td>";

		 	
		 		echo "<td>". '' ."</td>";

		 		echo "</tr>";
		 	}
		 ?>		
		 </tbody>
		</table>
	</div> 
</body>
</html>