<?php
namespace App\Controller;

use App\Controller\AppController;
use Cake\ORM\TableRegistry;

/**
 * ClinicTevProtocols Controller
 *
 * @property \App\Model\Table\ClinicTevProtocolsTable $ClinicTevProtocols
 */
class ClinicTevProtocolsController extends AppController
{
    public function initialize()
    {
        parent::initialize();
        $this->loadComponent('Auth', [
            'authorize' => 'Controller',
        ]);
        $this->loadComponent('Permission');

        // View or Controller
        $this->set('title', 'TEV clínico');

        $session = $this->request->session();

        $current_state = $session->read('current-state');
        $this->set('current_state', $current_state);

    }

    public function isAuthorized($user)
    {
        $action = $this->request->params['action'];

        return $this->Permission->hasPermission($user['role_name'], 'Bundles', $action);
        //return parent::isAuthorized($user);
    }

    /**
     * Index method
     *
     * @return \Cake\Network\Response|null
     */
    public function index()
    {
        $this->paginate = [
            'contain' => ['Hospitalizations'],
        ];
        $clinicTevProtocols = $this->paginate($this->ClinicTevProtocols);

        $this->set(compact('clinicTevProtocols'));
        $this->set('_serialize', ['clinicTevProtocols']);
    }

    /**
     * View method
     *
     * @param string|null $id Clinic Tev Protocol id.
     * @return \Cake\Network\Response|null
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function view($id = null)
    {

        $pacient_table = TableRegistry::get('Patients');
        $session       = $this->request->session();
        $pacient_id    = $session->read('selected-pacient');
        $pacient       = $pacient_table->findById($pacient_id);

        $clinicTevProtocol = $this->ClinicTevProtocols->get($id, [
            //'contain' => ['Hospitalizations', 'RiskFactors'],
        ]);

        $this->set('pacient', $pacient);
        $this->set('clinicTevProtocol', $clinicTevProtocol);
        $this->set('_serialize', ['clinicTevProtocol']);
    }

    /**
     * Add method
     *
     * @return \Cake\Network\Response|void Redirects on successful add, renders view otherwise.
     */
    public function add()
    {
        $pacient_table = TableRegistry::get('Patients');
        $session       = $this->request->session();
        $pacient_id    = $session->read('selected-pacient');

        $pacient = $pacient_table->findById($pacient_id);
        //$pacient = $pacient->toArray();

        $clinicTevProtocol = $this->ClinicTevProtocols->newEntity();
        if ($this->request->is('post')) {
            $clinicTevProtocol = $this->ClinicTevProtocols->patchEntity($clinicTevProtocol, $this->request->data);

            if ($this->ClinicTevProtocols->save($clinicTevProtocol)) {
                $this->Flash->success(__('The clinic tev protocol has been saved.'));
                return $this->redirect(['controller' => 'SepseProtocols', 'action' => 'index']);
            } else {
                $this->Flash->error(__('The clinic tev protocol could not be saved. Please, try again.'));
            }
        }

        $hospitalizations = $this->ClinicTevProtocols->Hospitalizations->find('list', ['limit' => 200]);
        $riskFactors      = $this->ClinicTevProtocols->RiskFactors->find('list', ['fields' => ['id', 'nome'], 'limit' => 200]);
        $this->set(compact('clinicTevProtocol', 'hospitalizations', 'riskFactors', 'pacient'));
        $this->set('_serialize', ['clinicTevProtocol']);
    }

    /**
     * Edit method
     *
     * @param string|null $id Clinic Tev Protocol id.
     * @return \Cake\Network\Response|void Redirects on successful edit, renders view otherwise.
     * @throws \Cake\Network\Exception\NotFoundException When record not found.
     */
    public function edit($id = null)
    {
        $pacient_table = TableRegistry::get('Patients');
        $session       = $this->request->session();
        $pacient_id    = $session->read('selected-pacient');

        $pacient = $pacient_table->findById($pacient_id);
        //$pacient = $pacient->toArray();

        $clinicTevProtocol = $this->ClinicTevProtocols->get($id, [
            'contain' => ['RiskFactors'],
        ]);
        if ($this->request->is(['patch', 'post', 'put'])) {
            $clinicTevProtocol = $this->ClinicTevProtocols->patchEntity($clinicTevProtocol, $this->request->data);
            if ($this->ClinicTevProtocols->save($clinicTevProtocol)) {
                $this->Flash->success(__('The clinic tev protocol has been saved.'));
                return $this->redirect(['controller' => 'SepseProtocols', 'action' => 'index']);
            } else {
                $this->Flash->error(__('The clinic tev protocol could not be saved. Please, try again.'));
            }
        }
        $hospitalizations = $this->ClinicTevProtocols->Hospitalizations->find('list', ['limit' => 200]);
        $riskFactors      = $this->ClinicTevProtocols->RiskFactors->find('list', ['limit' => 200]);
        $this->set(compact('clinicTevProtocol', 'hospitalizations', 'riskFactors', 'pacient'));
        $this->set('_serialize', ['clinicTevProtocol']);
    }

    public function printView($id = null)
    {
        $is_print_view = true;

        $session       = $this->request->session();

        $patientTable             = TableRegistry::get('Patients');
        $hospitalizations_table   = TableRegistry::get('Hospitalizations');
        $units_table              = TableRegistry::get('Units');

        $unit_id               = $session->read('selected-unit');
        $pacient_id            = $session->read('selected-pacient');
        $hospitalization_id    = $session->read('selected-hospitalization');

        $unit                    = $units_table->get($unit_id);
        $hospitalization         = $hospitalizations_table->get($hospitalization_id,['contain'=>['Discharges','Sectors']]);
        $patient                 = $patientTable->get($pacient_id);

        $clinicTevProtocol = $this->ClinicTevProtocols->get($id,[
            //'contain' => ['Hospitalizations', 'RiskFactors'],
        ]);

        $this->set(compact('patient','hospitalization','unit','is_print_view','clinicTevProtocol'));
        $this->set('_serialize', ['clinicTevProtocol']);
    }

    /**
     * Delete method
     *
     * @param string|null $id Clinic Tev Protocol id.
     * @return \Cake\Network\Response|null Redirects to index.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function delete($id = null)
    {
        $this->request->allowMethod(['post', 'delete']);
        $clinicTevProtocol = $this->ClinicTevProtocols->get($id);
        if ($this->ClinicTevProtocols->delete($clinicTevProtocol)) {
            $this->Flash->success(__('The clinic tev protocol has been deleted.'));
        } else {
            $this->Flash->error(__('The clinic tev protocol could not be deleted. Please, try again.'));
        }
        return $this->redirect(['action' => 'index']);
    }
}
