<?php
namespace App\Controller;

use App\Controller\AppController;
use Cake\ORM\TableRegistry;

/**
 * StrengthAssessmentScales Controller
 *
 * @property \App\Model\Table\StrengthAssessmentScalesTable $StrengthAssessmentScales
 */
class StrengthAssessmentScalesController extends AppController
{
    public function initialize()
    {
        parent::initialize();
        $this->loadComponent('Auth', [
            'authorize' => 'Controller',
        ]);
        $this->loadComponent('Permission');

        // View or Controller
        $this->set('title', 'Fisioterapia');

        $session = $this->request->session();

        $pacient_id = $session->read('selected-pacient');
        $this->set('pacient_id', $pacient_id);

        $unit_id = $session->read('selected-unit');
        $this->set('unit_id', $unit_id);

        $hospitalization_id = $session->read('selected-hospitalization');
        $this->set('hospitalization_id', $hospitalization_id);
    }

    public function isAuthorized($user)
    {
        $action = $this->request->params['action'];

        return $this->Permission->hasPermission($user['role_name'], 'Bundles', $action);
        //return parent::isAuthorized($user);
    }

    /**
     * Index method
     *
     * @return \Cake\Network\Response|null
     */
    public function index()
    {

        $hospitalizations_id = $this->request->session()->read('selected-hospitalization');
        $screening_id = $this->request->session()->read('screening_id');
        $current_state = $this->request->session()->read('current-state');
        $patient_id = $this->request->session()->read('selected-pacient');

        // $this->paginate = [
        //     'contain' => ['Hospitalizations'],
        // ];
        // $strengthAssessmentScales = $this->paginate($this->StrengthAssessmentScales);
        $this->paginate = [
            'contain' => ['StrengthAssessmentScales', 'VentilatoryCarePlans', 'BarthelIndexes'],
            'conditions' => ['Hospitalizations.id =' => $hospitalizations_id],

        ];
        $entity_table = TableRegistry::get('Hospitalizations');
        $hospitalizations = $this->paginate($entity_table);

        $this->set(compact('hospitalizations'));
        $this->set('_serialize', ['hospitalizations']);
    }

    /**
     * View method
     *
     * @param string|null $id Strength Assessment Scale id.
     * @return \Cake\Network\Response|null
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function view($id = null)
    {
        $strengthAssessmentScale = $this->StrengthAssessmentScales->get($id, [
            'contain' => ['Hospitalizations'],
        ]);

        $this->set('strengthAssessmentScale', $strengthAssessmentScale);
        $this->set('_serialize', ['strengthAssessmentScale']);
    }

    /**
     * Add method
     *
     * @return \Cake\Network\Response|void Redirects on successful add, renders view otherwise.
     */
    public function add()
    {
        $historic_table = TableRegistry::get('HistoricPatientMovements');
        $historic = $historic_table->find()
            ->contain(['Rooms'])
            ->order(['HistoricPatientMovements.created' => 'DESC'])
            ->first()
            ->toArray();
        // echo "<pre>";
        // var_dump($historic['room']['sector_id']);
        // exit;

        $strengthAssessmentScale = $this->StrengthAssessmentScales->newEntity();
        if ($this->request->is('post'))
        {
            $strengthAssessmentScale = $this->StrengthAssessmentScales->patchEntity($strengthAssessmentScale, $this->request->data);
            $strengthAssessmentScale->sector_id = $historic['room']['sector_id'];
            if ($this->StrengthAssessmentScales->save($strengthAssessmentScale))
            {
                $this->Flash->success(__('O registro foi salvo.'));
                return $this->redirect(['action' => 'index']);
            }
            else
            {
                $this->Flash->error(__('O registro não pode ser salvo.'));
            }
        }
        $this->set(compact('strengthAssessmentScale'));
        $this->set('_serialize', ['strengthAssessmentScale']);
    }

    /**
     * Edit method
     *
     * @param string|null $id Strength Assessment Scale id.
     * @return \Cake\Network\Response|void Redirects on successful edit, renders view otherwise.
     * @throws \Cake\Network\Exception\NotFoundException When record not found.
     */
    public function edit($id = null)
    {
        $strengthAssessmentScale = $this->StrengthAssessmentScales->get($id, [
            'contain' => [],
        ]);
        if ($this->request->is(['patch', 'post', 'put']))
        {
            $strengthAssessmentScale = $this->StrengthAssessmentScales->patchEntity($strengthAssessmentScale, $this->request->data);
            if ($this->StrengthAssessmentScales->save($strengthAssessmentScale))
            {
                $this->Flash->success(__('O registro foi salvo.'));
                return $this->redirect(['action' => 'index']);
            }
            else
            {
                $this->Flash->error(__('O registro não pode ser salvo.'));
            }
        }
        $hospitalizations = $this->StrengthAssessmentScales->Hospitalizations->find('list', ['limit' => 200]);
        $this->set(compact('strengthAssessmentScale', 'hospitalizations'));
        $this->set('_serialize', ['strengthAssessmentScale']);
    }

    /**
     * Delete method
     *
     * @param string|null $id Strength Assessment Scale id.
     * @return \Cake\Network\Response|null Redirects to index.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function delete($id = null)
    {
        $this->request->allowMethod(['post', 'delete']);
        $strengthAssessmentScale = $this->StrengthAssessmentScales->get($id);
        if ($this->StrengthAssessmentScales->delete($strengthAssessmentScale))
        {
            $this->Flash->success(__('O registro foi deletado.'));
        }
        else
        {
            $this->Flash->error(__('O registro não pode ser deletado.'));
        }
        return $this->redirect(['action' => 'index']);
    }
}
