<?php
namespace App\Controller;

use App\Controller\AppController;
use Cake\ORM\TableRegistry;
/**
 * SurgicalRisks Controller
 *
 * @property \App\Model\Table\SurgicalRisksTable $SurgicalRisks
 */
class SurgicalRisksController extends AppController
{

    public function initialize()
    {
        parent::initialize();

        $this->loadComponent('Permission');
        $this->loadComponent('RequestHandler');

        // View or Controller
        $this->set('title', 'Risco Cirúrgico');

        $session    = $this->request->session();
        $pacient_id = $session->read('selected-pacient');
        $this->set('pacient_id', $pacient_id);

        $unit_id = $session->read('selected-unit');
        $this->set('unit_id', $unit_id);
    }

    public function isAuthorized($user)
    {
        $action = $this->request->params['action'];

        return $this->Permission->hasPermission($user['role_name'], 'Bundles', $action);
        //return parent::isAuthorized($user);
    }

    /**
     * Index method
     *
     * @return \Cake\Network\Response|null
     */
    public function index()
    {
        $session = $this->request->session();
        $hospitalization_id = $session->read('selected-hospitalization');

        $this->paginate = [
            'contain' => ['Hospitalizations'],
            'conditions' => ['SurgicalRisks.hospitalization_id' => $hospitalization_id],
            'order' => ['created' => 'desc'],
        ];
        $surgicalRisks = $this->paginate($this->SurgicalRisks);

        $this->set(compact('surgicalRisks'));
        $this->set('_serialize', ['surgicalRisks']);
    }

    /**
     * View method
     *
     * @param string|null $id Surgical Risk id.
     * @return \Cake\Network\Response|null
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function view($id = null)
    {
        $surgicalRisk = $this->SurgicalRisks->get($id, [
            'contain' => [],
        ]);

        $this->set('surgicalRisk', $surgicalRisk);
        $this->set('_serialize', ['surgicalRisk']);
    }

    /**
     * Add method
     *
     * @return \Cake\Network\Response|void Redirects on successful add, renders view otherwise.
     */
    public function add()
    {
        $surgicalRisk = $this->SurgicalRisks->newEntity();
        if ($this->request->is('post')) {
            $surgicalRisk = $this->SurgicalRisks->patchEntity($surgicalRisk, $this->request->data);
            if ($this->SurgicalRisks->save($surgicalRisk)) {
                $this->Flash->success(__('The surgical risk has been saved.'));
                return $this->redirect(['action' => 'index']);
            } else {
                $this->Flash->error(__('The surgical risk could not be saved. Please, try again.'));
            }
        }
        $this->set(compact('surgicalRisk'));
        $this->set('_serialize', ['surgicalRisk']);
    }

    /**
     * Edit method
     *
     * @param string|null $id Surgical Risk id.
     * @return \Cake\Network\Response|void Redirects on successful edit, renders view otherwise.
     * @throws \Cake\Network\Exception\NotFoundException When record not found.
     */
    public function edit($id = null)
    {
        $surgicalRisk = $this->SurgicalRisks->get($id, [
            'contain' => [],
        ]);
        if ($this->request->is(['patch', 'post', 'put'])) {
            $surgicalRisk = $this->SurgicalRisks->patchEntity($surgicalRisk, $this->request->data);
            if ($this->SurgicalRisks->save($surgicalRisk)) {
                $this->Flash->success(__('The surgical risk has been saved.'));
                return $this->redirect(['action' => 'index']);
            } else {
                $this->Flash->error(__('The surgical risk could not be saved. Please, try again.'));
            }
        }
        $this->set(compact('surgicalRisk'));
        $this->set('_serialize', ['surgicalRisk']);
    }

    /**
     * Delete method
     *
     * @param string|null $id Surgical Risk id.
     * @return \Cake\Network\Response|null Redirects to index.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function delete($id = null)
    {
        $this->request->allowMethod(['post', 'delete']);
        $surgicalRisk = $this->SurgicalRisks->get($id);
        if ($this->SurgicalRisks->delete($surgicalRisk)) {
            $this->Flash->success(__('The surgical risk has been deleted.'));
        } else {
            $this->Flash->error(__('The surgical risk could not be deleted. Please, try again.'));
        }
        return $this->redirect(['action' => 'index']);
    }

    public function printView($id = null)
    {
        
        $is_print_view = true;
       
        $session       = $this->request->session();

        $patientTable             = TableRegistry::get('Patients');
        $hospitalizations_table   = TableRegistry::get('Hospitalizations');    
        $units_table              = TableRegistry::get('Units');

        $unit_id               = $session->read('selected-unit');
        $pacient_id            = $session->read('selected-pacient');
        $hospitalization_id    = $session->read('selected-hospitalization');

        $unit                    = $units_table->get($unit_id);
        $hospitalization         = $hospitalizations_table->get($hospitalization_id,['contain'=>['Discharges','Sectors']]);
        $patient                 = $patientTable->get($pacient_id);

        $surgicalRisk = $this->SurgicalRisks->get($id, [
            'contain' => [],
        ]);

        if ($this->request->is(['patch', 'post', 'put']))
        {
            $surgicalRisk = $this->SurgicalRisks->patchEntity($surgicalRisk, $this->request->data);
            if ($this->SurgicalRisks->save($surgicalRisk))
            {
                $this->Flash->success(__('The surgical risk has been saved.'));
                return $this->redirect(['action' => 'index']);
            }
            else
            {
                $this->Flash->error(__('The surgical risk could not be saved. Please, try again.'));
            }
        }

        $this->set(compact('unit','is_print_view','hospitalization','patient','surgicalRisk'));
        $this->set('_serialize', ['surgicalRisk']);
    }
}