<?php
namespace App\Controller;

use App\Controller\AppController;
use Cake\Datasource\ConnectionManager;
use Cake\Event\Event;
use Cake\Log\Log;
use Cake\ORM\TableRegistry;

/**
 * Users Controller
 *
 * @property \App\Model\Table\UsersTable $Users
 */
class UsersController extends AppController
{
    public $components = ['Auth'];

    public function initialize()
    {
        parent::initialize();
        $this->loadComponent('Auth', [
            'authorize' => 'Controller',
        ]);
        $this->loadComponent('Permission');

        // View or Controller
        $this->set('title', 'Usuário');
    }

    public function isAuthorized($user)
    {
        $action = $this->request->params['action'];

        return $this->Permission->hasPermission($user['role_name'], 'users', $action);

        //return parent::isAuthorized($user);
    }

    public function beforeFilter(Event $event)
    {
        parent::beforeFilter($event);

        $this->Auth->allow(['logout', 'recuperateEmail', 'changePassword', 'getUserByCpf']);
    }

    public function login()
    {
        //$this->layout = 'login';
        $this->viewBuilder()->layout('login');
        $this->set('title', 'Login');

        if ($this->Auth->user()) {
            $session = $this->request->session();
            $role_name = $session->read('Auth.User.role_name');

            if ($role_name == "Administrador") {
                return $this->redirect($this->Auth->redirectUrl(['controller' => 'Users', 'action' => 'index']));
            } else {
                return $this->redirect($this->Auth->redirectUrl(['controller' => 'units', 'action' => 'selectUnit']));
            }
        }

        if ($this->request->is('post')) {
            $user = $this->Auth->identify();

            if ($user && !$user['is_active']) {
                $this->Flash->error(__('Esta conta está suspensa. Por favor, entre em contato com o administrador do sistema.'));
            } elseif ($user && $user['is_active']) {
                $roles = TableRegistry::get('Roles');
                $result = $roles->findById($user['role_id']);
                $results = $result->toArray();

                $user['role_name'] = $results[0]['name'];

                // Log::write('debug', '$user');
                // Log::write('debug', $user );
                // if ( !$user['is_active'] )
                // {
                //     $this->Flash->error(__('Esta conta está suspensa.'));
                //     return;
                // }

                //return;
                $unitsTable = TableRegistry::get('Units');
                $usersTable = TableRegistry::get('Users');

                //       $query = $unitsTable->find()
                //  ->contain(['Users'])
                // ;

                // $query->innerJoinWith('Users')
                //      ->where(['Users.id' => $user['id'] ])
                //    ;

                $units = $usersTable->get($user['id'], [
                    'contain' => ['Units'],
                ]);

                // $units = $usersTable->find()
                //     ->where(['Users.id =' => $user['id']])
                //     ->contain(['Units'=>['Privileges']])
                //     ->distinct(['Privileges'])
                //     ->toArray();

                // ->innerJoinWith('Privileges')

                //        ->where(['units_users.id' = > $unit_id])
                //    ->autoFields(true);

                $units_ids = [];

                // Log::write('debug', '$units');
                //    Log::write('debug', $units );
                //    echo "<pre>";
                //    print_r($units);
                //    exit;
                // return;
                foreach ($units->units as $key => $value) {
                    // $units_ids[$key] = $value['id'];
                    // Log::write('debug', '$value[privilege_id]');
                    // Log::write('debug', $value);

                    $units_ids[$key] = ['unit_id' => $value['id'], 'privilege' => $value['_joinData']['privilege_id']];
                }
                //return;
                $user['units'] = $units_ids;

                //    $query->toArray();

                //          Log::write('debug', '$units');
                // Log::write('debug', $units);

                $this->Auth->setUser($user);
                // Log::write('debug', '$user');
                // Log::write('debug', $user);
                // Log::write('debug', $user['units']);
                //return;

                switch ($results[0]['name']) {
                    case 'Administrador':
                        return $this->redirect($this->Auth->redirectUrl(['controller' => 'users', 'action' => 'index']));
                        break;

                    case 'Qualidade':
                        return $this->redirect($this->Auth->redirectUrl(['controller' => 'units', 'action' => 'selectUnit']));
                        break;

                    case 'Usuário':
                        return $this->redirect($this->Auth->redirectUrl(['controller' => 'units', 'action' => 'selectUnit']));
                        break;

                    default:
                        return $this->redirect($this->Auth->redirectUrl(['controller' => 'units', 'action' => 'selectUnit']));
                        break;
                }

                return $this->redirect(['action' => 'index']);
            } else {
                $this->Flash->error(__('Senha ou usuário inválido, tente novamente.'));
            }
        }
    }

    public function logout()
    {
        $this->Flash->success('Você foi deslogado.');
        $this->request->session()->destroy();
        return $this->redirect($this->Auth->logout());
    }

    /**
     * Index method
     *
     * @return \Cake\Network\Response|null
     */
    public function index($admin = null)
    {
        if ($admin !== null) {
            $this->set('title', 'AdminGH');
        }

        $session = $this->request->session();

        $this->set('authUser', $this->Auth->user());

        $units_id = $session->read('Auth.User.units');

        $unitsTable = TableRegistry::get('Units');

        if ($admin !== null) {
            $query = $this->Users->find()
                ->where(['Users.role_id =' => 1])
                ->contain(['Units'])
            ;
        } else {
            $query = $this->Users->find()
                ->where(['Users.role_id =' => 2])
                ->contain(['Units'])
            ;
        }

        if (isset($units_id)) {
            // $query->innerJoinWith('Units')
            //     ->distinct(['Users.id'])
            //        ->where(['Units.id IN' =>  $units_id])
            //       ;
        }

        // $users = $this->paginate($this->Users);
        $users = $this->paginate($query);

        $this->set(compact('users'));
        $this->set('_serialize', ['users']);
    }

    /**
     * View method
     *
     * @param string|null $id User id.
     * @return \Cake\Network\Response|null
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function view($id = null)
    {
        $session = $this->request->session();
        $role_name = $session->read('Auth.User.role_name');

        $user = $this->Users->get($id, [
            'contain' => ['Log', 'Roles'],
        ]);

        //      $roles = TableRegistry::get('Roles');
        // $result = $roles->find();
        // $results = $result->toArray();
        // $this->set('roles', $results);

        $this->set('user', $user);
        $this->set('_serialize', ['user']);
    }

    public function recuperateEmail($email = null)
    {
        $this->autoRender = false;
        $users = TableRegistry::get('Users');

        if ($this->request->is('post')) {
            $email = $this->request->data['email'];
            // $result = $this->Users->find('all', [
            //     ['conditions' => ['email' => $email]],
            // ]);

            $result = $this->Users->find('all', [
                'conditions' => ['email = ' => $email],
            ]);

            $userID = $result->first()['id'];

            // $query = $users->findByEmail($email);
            //$userID = $query->first()['id'];
            Log::write('debug', 'email =' . $email);

            Log::write('debug', 'userID =');
            Log::write('debug', $userID);

            //checa se o usuario existe
            if ($userID) {
                $user = $this->Users->get($userID);

                //gera uma senha
                $password = $this->Users->randomPassword(6);
                //$hasher = new DefaultPasswordHasher();
                //$password_encrypted = $hasher->hash($password);

                $user_obj = ['email' => $user['email'], 'unencrypted_password' => $password, 'name' => $user['name']];

                $user->hiddenProperties(['password' => $password]);

                $user = $this->Users->patchEntity($user, [
                    'password' => $password,
                ]
                );
                if ($this->Users->save($user)) {
                    $user['password'] = $password;
                    $this->Users->sendPassByEmail($user_obj);
                    $this->Flash->success('Sua nova senha foi enviada para o email cadastrado.');

                    $this->redirect(['action' => 'login']);
                } else {
                    $this->Flash->error(__('Ocorreu um erro, tente novamente.'));
                }
            } else {
                $this->Flash->error(__('Não existe nenhuma conta com esse email.'));
            }
        }
        // $this->set('user', $user);
        // $this->set('_serialize', ['user']);
    }

    /**
     * Add method
     *
     * @return \Cake\Network\Response|void Redirects on successful add, renders view otherwise.
     */
    public function add($admin = null)
    {
        if ($admin !== null) {
            $this->set('title', 'AdminGH');
        }

        $user = $this->Users->newEntity();

        $roles = TableRegistry::get('Roles');
        $result = $roles->find();
        $results = $result->toArray();

        if ($this->request->is('post')) {
            //Log::write('debug', '$this->request->data');
            //Log::write('debug', $this->request->data);
            $user = $this->Users->patchEntity($user, $this->request->data);
            $user->username = $user->email;

            //gera uma senha aleatoria
            $password = $this->Users->randomPassword(6);
            $user['password'] = $password;
            $user->hiddenProperties(['password' => $password]);
            $user['unencrypted_password'] = $password;

            //$x = $user->errors();

            if ($this->Users->save($user)) {
                //envia a senha por email
                $this->Users->sendPassByEmail($user);

                $this->Flash->success(__('O usuário foi salvo.'));
                return $this->redirect(['action' => 'index']);
            } else {
                $this->Flash->error(__('O usuário não pode ser salvo. Por favor, tente novamente.'));
            }
        }
        $this->set(compact('user'));
        $this->set('_serialize', ['user']);
        $this->set('roles', $results);
    }

    public function changePassword()
    {
        $user = $this->Users->get($this->Auth->user('id'));

        if (!empty($this->request->data)) {
            $user = $this->Users->patchEntity($user, [
                'old_password' => $this->request->data['old_password'],
                'password' => $this->request->data['password1'],
                'password1' => $this->request->data['password1'],
                'password2' => $this->request->data['password2'],
            ],
                ['validate' => 'password']
            );
            Log::write('debug', $user);

            if ($this->Users->save($user)) {
                $this->Flash->success('A senha foi salva com sucesso.');
                //$this->redirect('/users/');
            } else {
                $this->Flash->error('Ocorreu um erro, tente novamente.');
            }
        }
        $this->set('user', $user);
        $this->set('_serialize', ['user']);
    }

    /**
     * Edit method
     *
     * @param string|null $id User id.
     * @return \Cake\Network\Response|void Redirects on successful edit, renders view otherwise.
     * @throws \Cake\Network\Exception\NotFoundException When record not found.
     */
    public function edit($id = null)
    {
        // $user = $this->Users->get($id, [
        //     'contain' => ['Roles', 'Units']
        //     ]);
        //$usersTable = TableRegistry::get('Users');

        $user = $this->Users->find()
            ->where(['Users.id =' => $id])
            ->contain(['Units', 'Roles'])
            ->first()
        ;

        $unitsTable = TableRegistry::get('Units');
        $units = $unitsTable->find()
            ->contain(['Groups'])
        ;

        $units = $this->paginate($units);
        Log::write('debug', 'units');
        Log::write('debug', $units);

        // $unitsTable = TableRegistry::get('Units');
        // $user = $unitsTable->find();
        // $user->contain(['Users']);

        // $user->leftJoinWith('Users')
        //     ->where(['Users.id =' => $id])
        //      ;

        $can_edit_privilege = false;
        $session = $this->request->session();
        $role_name = $session->read('Auth.User.role_name');
        //$can_edit_privilege = $this->Permission->canEditUser($role_name, $user['role']['name']);

        $roles = TableRegistry::get('Roles');
        $result = $roles->find();
        $results = $result->toArray();

        if ($this->request->is(['patch', 'post', 'put'])) {
            $user = $this->Users->get($id);
            $user = $this->Users->patchEntity($user, $this->request->data);

            // $user = $this->Users->patchEntity($user,
            //     [
            //                  'old_password'    => $this->request->data['old_password'],
            //                  'password'        => $this->request->data['password1'],
            //                  'password1'     => $this->request->data['password1'],
            //                  'password2'     => $this->request->data['password2']
            //                 ],
            //                        ['validate' => 'password']
            //          );

            //}
            // echo "<pre>";
            // print_r($user);
            // exit;
            if ($this->Users->save($user)) {
                $this->Flash->success(__('As alterações foram salvas.'));

                if ($role_name == "Administrador") {
                    return $this->redirect(['action' => 'index']);
                } elseif ($role_name == "Usuário") {
                    return $this->redirect(['action' => 'listUsersFromUnit']);
                }
            } else {
                $this->Flash->error(__('O usuário não pode ser salvo. Por favor, tente novamente.'));
            }
        }

        $this->set('roles', $results);
        $this->set('can_edit_ ', $can_edit_privilege);
        $this->set(compact('user', 'units'));
        $this->set('_serialize', ['user', 'units']);
    }

    /**
     * Delete method
     *
     * @param string|null $id User id.
     * @return \Cake\Network\Response|null Redirects to index.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function delete($id = null)
    {
        $this->request->allowMethod(['post', 'delete']);
        $user = $this->Users->get($id);
        $user['is_active'] = false;

        if ($this->Users->save($user)) {
            $this->Flash->success(__('O usuário foi desativado.'));
        } else {
            $this->Flash->error(__('O usuário não pode ser desativado. Por favor, tente novamente.'));
        }

        return $this->redirect(['action' => 'index']);
    }

    public function desactivate($id = null, $title = null)
    {
        $this->request->allowMethod(['post', 'desactivate']);
        $session = $this->request->session();
        $role_name = $session->read('Auth.User.role_name');
        $user = $this->Users->get($id);

        $user['is_active'] = false;

        if ($this->Users->save($user)) {
            $this->Flash->success(__('O usuario foi suspenso com sucesso.'));
        } else {
            $this->Flash->error(__('O usuario não pode ser suspenso. Por favor, tente novamente.'));
        }

        if ($role_name == "Administrador") {
            if ($title == "AdminGH") {
                return $this->redirect(['action' => 'index', 'admin']);
            } else {
                return $this->redirect(['action' => 'index']);
            }
        } elseif ($role_name == "Usuário") {
            return $this->redirect(['action' => 'listUsersFromUnit']);
        }
    }

    public function activate($id = null, $title = null)
    {

        $this->request->allowMethod(['post', 'desactivate']);
        $session = $this->request->session();
        //$role_name = $session->read('selected-unit-role-name');
        $role_name = $session->read('Auth.User.role_name');

        $user = $this->Users->get($id);
        $user->is_active = true;

        if ($this->Users->save($user)) {
            $this->Flash->success(__('O usuário foi ativado com sucesso.'));
        } else {
            $this->Flash->error(__('O usuário não pode ser ativado. Por favor, tente novamente.'));
        }

        if ($role_name == "Administrador") {
            if ($title == "AdminGH") {
                return $this->redirect(['action' => 'index', 'admin']);
            } else {
                return $this->redirect(['action' => 'index']);
            }
        } elseif ($role_name == "Usuário") {
            return $this->redirect(['action' => 'listUsersFromUnit']);
        } else {
            return $this->redirect(['action' => 'listUsersFromUnit']);
        }
    }

    public function indexAdmin()
    {
        $session = $this->request->session();

        $this->set('authUser', $this->Auth->user());

        $units_id = $session->read('Auth.User.units');

        $unitsTable = TableRegistry::get('Units');

        $query = $this->Users->find()
            ->where(['Users.role_id =' => 1])
            ->contain(['Units'])
        ;

        $query->innerJoinWith('Units')
            ->distinct(['Users.id'])
            ->where(['Units.id IN' => $units_id])
        ;

        // $users = $this->paginate($this->Users);
        $users = $this->paginate($query);

        $this->set(compact('users'));
        $this->set('_serialize', ['users']);
    }

    public function listUsersFromUnit()
    {
        // if ($admin !== null)
        //     $this->set('title', 'AdminGH');
        //$this->set('authUser', $this->Auth->user());

        $session = $this->request->session();
        $unit_id = $session->read('selected-unit');
        $query = null;
        $name = null;
        $cpf = null;
        $param = $this->request;

        $unit_role_name = $session->read('selected-unit-role-name');
        $this->set('unit_role_name', $unit_role_name);

        $unitsTable = TableRegistry::get('Units');
        $sectorsTable = TableRegistry::get('Sectors');
        $privilegesTable = TableRegistry::get('Privileges');

        $sectors = $sectorsTable->find('list', ['keyField' => 'id', 'valueField' => 'name'])
            ->where(['Sectors.unit_id' => $unit_id]);

        $privileges = $privilegesTable->find('list');

        if (isset($param->query['name']) || isset($param->query['privilege_id']) || isset($param->query['sector_id'])) {
            $name = $param->query['name'];
            $privilege_id = $param->query['privilege_id'];
            $sector_id = $param->query['sector_id'];

            //echo "$name = " . $name . " privilege_id = " . $privilege_id . " sector_id = " . $sector_id;

            $cond[] = 'Users.role_id =' . 2;

            if ($name != "") {
                $cond[] = 'Users.name LIKE "%' . $name . '%"';
            }

            if ($privilege_id != "") {
                $cond[] = 'UnitsUsers.privilege_id = ' . $privilege_id;
            }

            if ($sector_id != "") {
                $cond[] = 'Sectors.id = ' . $sector_id;
            }

            //[, , 'UnitsUsers.privilege_id = ' . $privilege_id
            //   ]

            $query = $this->Users->find()
                ->where($cond)
                ->contain(['Units'])
                ->leftJoinWith('Units.Sectors')
                ->order(['Users.created' => 'desc']);
        } else {

            $query = $this->Users->find()
                ->where(['Users.role_id =' => 2])
                ->contain(['Units'])
                ->order(['Users.created' => 'desc']);
        }

        $query->innerJoinWith('Units')
            ->distinct(['Users.id'])
            ->where(['Units.id =' => $unit_id])
        ;

        // $users = $this->paginate($this->Users);
        $users = $this->paginate($query);

        $this->set(compact('users'));
        $this->set('unit_id', $unit_id);
        $this->set('sectors', $sectors);
        $this->set('privileges', $privileges);
        $this->set('_serialize', ['users']);
    }

    public function addUserToUnit()
    {
        $professionalsTable = TableRegistry::get('Professionals');
        $privilegesTable = TableRegistry::get('Privileges');
        $rolesTable = TableRegistry::get('Roles');
        $usersTable = TableRegistry::get('Users');
        $modulesTable = TableRegistry::get('Users');
        

        $session = $this->request->session();
        $unit_id = $session->read('selected-unit');

        //create entity
        $user = $this->Users->newEntity();
        $professional = $professionalsTable->newEntity();

        //get roles
        $roles = $rolesTable->find('list', ['limit' => 200]);

        //get privileges
        $privileges = $privilegesTable->find('list', ['limit' => 200]);

        if ($this->request->is('post')) {
            //monta a entidade usuário
            $users = $usersTable->newEntity($this->request->data);
            $multidisciplinary_team_participant = $this->request->query('multidisciplinary_team_participant');

            Log::write('debug', 'users');
            Log::write('debug', $users);

            //monta a entidade profissional
            $professionals = $professionalsTable->patchEntity($professional, $this->request->data);

            Log::write('debug', '$professionals');
            Log::write('debug', $professionals);

            //verifica se tem erro
            $z = $user->errors();
            Log::write('debug', '$z');
            Log::write('debug', $z);

            //preenche a entidade usuario
            $user = $this->Users->patchEntity($user, $this->request->data);
            $user->username = $user->email;

            //gera uma senha aleatoria
            $password = $this->Users->randomPassword(6);
            $user['password'] = $password;
            $user->hiddenProperties(['password' => $password]);
            $user['unencrypted_password'] = $password;

            //define o tipo de usuário
            $user['role_id'] = 2;
            Log::write('debug', '$user');
            Log::write('debug', $user);

            //verifica se tem erro
            $x = $user->errors();
            Log::write('debug', '$x');
            Log::write('debug', $x);

            //verifica se o usuário ja está cadastrado
            $userExists = $usersTable->exists(['cpf' => $user->cpf]);

            Log::write('debug', '$userExists');
            Log::write('debug', $userExists);

            if (!$userExists) {
                if ($this->Users->save($user)) {
                    Log::write('debug', '$user after save');
                    Log::write('debug', $user);
                    $professionals->user_id = $user->id;

                    Log::write('debug', '$professionals before save');
                    Log::write('debug', $professionals);

                    if ($professionalsTable->save($professionals)) {
                        $conn = ConnectionManager::get('default');
                        $stmt = $conn->execute(
                            'INSERT INTO units_users (user_id, unit_id, privilege_id, professional_id) values (?, ?, ?, ?)',
                            [$user->id, $unit_id, $user->privilege_id, $professionals->id]
                        );

                        $this->Users->sendPassByEmail($user);
                        $this->Flash->success(__('O usuário foi salvo.'));
                        return $this->redirect(['action' => 'listUsersFromUnit']);
                    } else {
                        $this->Flash->error(__('O usuário não pode ser salvo. Por favor, tente novamente.'));
                        $result = $this->Users->delete($user);
                    }
                } else {
                    $this->Flash->error(__('O usuário não pode ser salvo. Por favor, tente novamente.'));
                }
            } else {
                //usuário já existe
                Log::write('debug', 'Usuário já existe.');
                $userFromDb = $this->Users->find()
                    ->where(['Users.cpf =' => $user->cpf])
                    ->first();

                //verifica se o usuário já está cadastrado na unidade
                $professionalExists = $professionalsTable->exists(['user_id' => $userFromDb->id, 'unit_id' => $unit_id]);
                if (!$professionalExists) {
                    $professionals->user_id = $userFromDb->id;

                    if ($professionalsTable->save($professionals)) {
                        $conn = ConnectionManager::get('default');
                        $stmt = $conn->execute(
                            'INSERT INTO units_users (user_id, unit_id, privilege_id, professional_id) values (?, ?, ?, ?)',
                            [$userFromDb->id, $unit_id, $user->privilege_id, $professionals->id]);

                        $this->Flash->success(__('O usuário foi salvo.'));
                        return $this->redirect(['action' => 'listUsersFromUnit']);
                    } else {
                        $professionals_error = $professionals->errors();
                        Log::write('debug', $professionals_error);
                        $this->Flash->error(__('O usuário não pode ser salvo. Por favor, tente novamente.'));
                    }
                } else {
                    $this->Flash->error(__('O usuário já está cadastrado  nessa unidade.'));
                }
            }
        }

        $sectors = $professionalsTable->Sectors->find('list', ['fields' => ['id', 'name'], 'limit' => 200]);
        $participating_users = $professionalsTable->ParticipatingUsers->find('all', ['fields' => ['id', 'name', 'type'], 'limit' => 200]);
        $specialties = $professionalsTable->Specialties->find('list', ['limit' => 200]);
        $areas_of_occupation = $professionalsTable->AreasOfOccupation->find('list', ['limit' => 200]);
        $areas_of_occupation = $areas_of_occupation->toArray();
        $modules = $professionalsTable->Modules->find('list', ['limit' => 200]);

        $this->set('unit_id', $unit_id);
        $this->set('roles', $roles);
        $this->set('privileges', $privileges);
        $this->set(compact('user', 'professional', 'specialties', 'areas_of_occupation', 'sectors', 'participating_users', 'modules'));
        $this->set('_serialize', ['user', 'professional']);
    }

    public function editUserFromUnit($id = null)
    {
        //set privileges to edit
        $can_edit_privilege = false;
        $session = $this->request->session();
        $role_name = $session->read('Auth.User.role_name');
        $unit_id = $session->read('selected-unit');

        $professionalsTable = TableRegistry::get('Professionals');
        $modulesProfTable = TableRegistry::get('ModulesProfessionals');

        //get user
        $user = $this->Users->find()
            ->where(['Users.id =' => $id])
            ->contain([
                'Roles',
                'Units',                
                'Professionals' => function ($q) {
                    return $q->where(['Professionals.unit_id' => $this->request->session()->read('selected-unit')]);
                },
                'Professionals.Specialties',
                'Professionals.Sectors',
                'Professionals.Modules',
                //'Professionals.ModulesProfessionals',
                'Professionals.ParticipatingUsers',
            ])
            ->first();

        //get privileges
        $privilegesTable = TableRegistry::get('Privileges');
        $privileges = $privilegesTable->find('list', ['limit' => 200]);

        //get selected privilege
        $unitsUsersTable = TableRegistry::get('UnitsUsers');
        $units_users = $unitsUsersTable->find()
            ->where(['UnitsUsers.professional_id' => $user['professionals'][0]['id'],
                    'UnitsUsers.user_id' => $user['id'] ])
            ->first();

        //get selected paroticipating users
        $selected_participating_users = array();
        foreach ($user['professionals'][0]['participating_users'] as $participating_user) {
            array_push($selected_participating_users, $participating_user['id']);
        }
        

        // //get module permissions
        $module_permissions = $modulesProfTable->find()
            ->where(['ModulesProfessionals.professional_id' => $user['professionals'][0]['id']]);
        


        //get units
        $unitsTable = TableRegistry::get('Units');
        $units = $unitsTable->find()
            ->contain(['Groups']);

        $units = $this->paginate($units);

        //get roles
        $rolesTable = TableRegistry::get('Roles');
        $roles = $rolesTable->find('list', ['limit' => 200]);

        if ($this->request->is(['patch', 'post', 'put'])) {

            //unset($this->request->data['professionals'][0]['modules']);

            // echo "<pre>";
            // print_r($this->request->data);
            // exit;
            //$modulesProfTable->deleteAll(['professional_id' => $id]);
            
            // foreach ($this->request->data['modules-permission'] as $key => $module_prof) {
            //     //$this->request->data['modules-permission'][$key]['professional_id'] = $id;   
            //     $conn = ConnectionManager::get('default');   
            //     $stmt = $conn->execute('UPDATE modules_professionals SET privilege_level = ? WHERE professional_id = ? AND module_id = ?', [$module_prof['privilege_level'], $id, $module_prof['module_id'] ]);    
            //         // 'INSERT INTO modules_professionals (privilege_level, professional_id, module_id) VALUES (?, ?, ?)',
            //         // [$module_prof['privilege_level'], $id, $module_prof['module_id']]);      

                    
            // }

            // echo "<pre>";
            // print_r($this->request->data);
            // exit;

            //$modules_profs = $modulesProfTable->newEntity($this->request->data['modules-permission']);

            
            

            // echo "<pre>";
            // print_r($modules_profs);
            // exit;
            // if ($modulesProfTable->save($modules_profs)) {

            // }
            //
            
            $participating_users = array();

            foreach ($this->request->data['professionals'][0]['participating_users'] as $key => $participating_user) {
                if (isset($participating_users, $participating_user['_ids'][0])) { 
                    array_push($participating_users, $participating_user['_ids'][0]);                    
                }        
                unset($this->request->data['professionals'][0]['participating_users'][$key]);
            }

            $this->request->data['professionals'][0]['participating_users']['_ids'] = $participating_users;

            // echo "<pre>";
            // print_r( $this->request->data);
            // exit;
        
            $user = $this->Users->patchEntity($user, $this->request->data);
            //    echo "<pre>";
            // print_r( $user);
            // exit;

           // unset($user['professionals'][0]['modules']);

            $professional_data = $professionalsTable->find()
                ->contain(['Specialties', 'Sectors'])
                ->where(['Professionals.user_id =' => $id])
                ->first();

            if ($this->Users->save($user)) {
                $this->Flash->success(__('As alterações foram salvas.'));

                if (!empty($professional_data) && $this->request->data['privilege_id'] == 2) {                
                    $professional = $professionalsTable->patchEntity($professional_data, $this->request->data['professionals'][0]);
                    $professionalsTable->save($professional);
                }

                $conn = ConnectionManager::get('default');
                $stmt = $conn->execute('UPDATE units_users SET privilege_id = ? WHERE user_id = ? AND unit_id = ?',
                    [$this->request->data['privilege_id'], $id, $unit_id]);

                foreach ($this->request->data['modules-permission'] as $key => $module_prof) {
                    //$this->request->data['modules-permission'][$key]['professional_id'] = $id;   
                    $stmt = $conn->execute('UPDATE modules_professionals SET privilege_level = ? WHERE professional_id = ? AND module_id = ?', [$module_prof['privilege_level'], $user['professionals'][0]['id'], $module_prof['module_id'] ]);
                }

                

                if ($role_name == "Administrador") {
                    return $this->redirect(['action' => 'index']);
                } elseif ($role_name == "Usuário") {
                    return $this->redirect(['action' => 'listUsersFromUnit']);
                }
            } else {
                $x = $user->errors();
                Log::write('debug', 'x');
                Log::write('debug', $x);
                $this->Flash->error(__('O usuário não pode ser salvo. Por favor, tente novamente.'));
            }
        }

        $specialties = $professionalsTable->Specialties->find('list', ['limit' => 200]);
        $sectors = $professionalsTable->Sectors->find('list', ['fields' => ['id', 'name'], 'limit' => 200]);
        $participating_users = $professionalsTable->ParticipatingUsers->find('all', ['fields' => ['id', 'name', 'type'], 'limit' => 200]);

        $modules = $professionalsTable->Modules->find('list', ['limit' => 200]);
        $areas_of_occupation = $professionalsTable->AreasOfOccupation->find('list', ['limit' => 200]);
        $areas_of_occupation = $areas_of_occupation->toArray();
        $modules = $professionalsTable->Modules->find('list', ['limit' => 200]);

        $this->set('module_permissions', $module_permissions);
        $this->set('selected_participating_users', $selected_participating_users);
        $this->set('selected_privilege', $units_users->privilege_id);
        $this->set('unit_id', $unit_id);
        $this->set('roles', $roles);
        $this->set('privileges', $privileges);
        $this->set(compact('user', 'professional', 'specialties', 'areas_of_occupation', 'sectors', 'participating_users', 'modules'));
        $this->set('_serialize', ['user', 'units']);
    }

    public function getUserByCpf()
    {
        $this->autoRender = false;

        if ($this->request->is(['post', 'get'])) {
            if (isset($this->request->data['cpf'])) {
                $cpf = $this->request->data['cpf'];

                $userTable = TableRegistry::get('Users');

                $user = $userTable->find()
                    ->where(['Users.cpf =' => $cpf])
                    ->contain(['Units', 'Roles'])
                    ->first()
                ;

                echo json_encode($user, true);
            } else {
                echo "The param was not defined";
                echo "<pre>";
                print_r($this->request);
            }
        } else {
            echo "This action only accepts POST requests.";
        }
    }
}
