<?php
namespace App\Model\Table;

use App\Model\Entity\AnomaliasNeonatalChecklist;
use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * AnomaliasNeonatalChecklists Model
 *
 * @property \Cake\ORM\Association\BelongsTo $Anomalias
 * @property \Cake\ORM\Association\BelongsTo $NeonatalChecklists
 */
class AnomaliasNeonatalChecklistsTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->table('anomalias_neonatal_checklists');
        $this->displayField('id');
        $this->primaryKey('id');

        $this->belongsTo('Anomalias', [
            'foreignKey' => 'anomalia_id',
            'joinType' => 'INNER'
        ]);
        $this->belongsTo('NeonatalChecklists', [
            'foreignKey' => 'neonatal_checklist_id',
            'joinType' => 'INNER'
        ]);
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('id')
            ->allowEmpty('id', 'create');

        return $validator;
    }

    /**
     * Returns a rules checker object that will be used for validating
     * application integrity.
     *
     * @param \Cake\ORM\RulesChecker $rules The rules object to be modified.
     * @return \Cake\ORM\RulesChecker
     */
    public function buildRules(RulesChecker $rules)
    {
        $rules->add($rules->existsIn(['anomalia_id'], 'Anomalias'));
        $rules->add($rules->existsIn(['neonatal_checklist_id'], 'NeonatalChecklists'));
        return $rules;
    }
}
