<?php
namespace App\Model\Table;

use App\Model\Entity\ApacheIiScore;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;
use MedidasDispersao\MedidasDispersao;
use Cake\ORM\TableRegistry;

/**
 * ApacheIiScores Model
 *
 * @property \Cake\ORM\Association\BelongsTo $Hospitalizations
 */
class ApacheIiScoresTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->table('apache_ii_scores');
        $this->displayField('id');
        $this->primaryKey('id');

        $this->addBehavior('Timestamp');

        $this->belongsTo('Hospitalizations', [
            'foreignKey' => 'hospitalization_id',
            'joinType'   => 'INNER',
        ]);
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('id')
            ->allowEmpty('id', 'create');

        $validator
            ->allowEmpty('temperatura_retal');

        $validator
            ->allowEmpty('pressao_arterial_media_mmhg');

        $validator
            ->allowEmpty('frequencia_cardiaca_bpm');

        $validator
            ->allowEmpty('frequencia_respiratoria_irpm');

        $validator
            ->allowEmpty('apache_ii_scorescol');

        $validator
            ->allowEmpty('oxigenacao');

        $validator
            ->allowEmpty('fio2_maior_que_0_5_a_ado2');

        $validator
            ->allowEmpty('fio2_menor_que_pao2');

        $validator
            ->allowEmpty('ph_arterial');

        $validator
            ->allowEmpty('sodio_serico');

        $validator
            ->allowEmpty('potassio_serico');

        $validator
            ->allowEmpty('creatinina_serica_dobrar_pontos_se_ira');

        $validator
            ->allowEmpty('hematocrito');

        $validator
            ->allowEmpty('numero_de_leucocitos');

        $validator
            ->allowEmpty('escala_de_glasgow_para_o_coma_escore');

        $validator
            ->allowEmpty('total_do_escore_fisiologico_agudo');

        $validator
            ->allowEmpty('bicarbonato_serico');

        $validator
            ->allowEmpty('paciente_nao_cirurgicos_ou_pos_operatorios');

        $validator
            ->boolean('active')
            ->allowEmpty('active');

        $validator
            ->requirePresence('data_realizacao', 'create')
            ->notEmpty('data_realizacao');

        return $validator;
    }

    public function getRelatorioData($hospitalizations, $date_before, $date_after){

        $calc_obj = new MedidasDispersao();

        $curb_scores_table = TableRegistry::get('CurbScores');
        $sofa_scores_table = TableRegistry::get('SofaEscores');
        $pre_deliric_scores_table = TableRegistry::get('PreDeliricScores');
        $crib_scores_table = TableRegistry::get('CribScores');
        $nas_scores_table = TableRegistry::get('NasScores');
        $apache_ii_scores_table = TableRegistry::get('ApacheIiScores');
        $snap_ii_scores_table = TableRegistry::get('SnapIiScores');
        $saps_iii_scores_table = TableRegistry::get('SapsIiiScores');

        $origins_table = TableRegistry::get('Origins');
        $origins = $origins_table->find("all");

        $array_origin = [];
        foreach ($origins as $key => $origin)
        {
            $array_origin[$origin['id']]['name'] = $origin['name'];
            $array_origin[$origin['id']]['value'] = 0;
        }

        $arry_gravidade = [
            '0 - 9' => 0,
            '10 - 19' => 0,
            '20 - 29' => 0,
            '30 - 39' => 0,
            '40 - 49' => 0,
            '50 - 59' => 0,
            '60 - 69' => 0,
            '70 - 79' => 0,
            '80 - 89' => 0,
            '90 - 100' => 0,
        ];
        $array_comorbidades = ['1' => 0, '2' => 0, '3' => 0];
        $medida_suporte = ["Cateter venoso central curta permanência" => $arry_gravidade,
                            "Cateter venoso central longa permanência" => $arry_gravidade,
                            'Cateter de artéria pulmonar' => $arry_gravidade,
                            'Cateter venoso central de inserção periférica' => $arry_gravidade,
                            'Cateter de átrio esquerda' => $arry_gravidade,
                            'Cateter de átrio esquerda' => $arry_gravidade,
                            'Cateter vesical' => $arry_gravidade,
                            'Cateter venoso periférico' => $arry_gravidade,
                            'Cateter arterial' => $arry_gravidade,
                            'Cateter venoso para diálise' => $arry_gravidade,
                            'Cateter de monitorização da pressão' => $arry_gravidade,
                            'intracraniana' => $arry_gravidade,
                            'Derivação ventricular externa' => $arry_gravidade,
                            'Cateter de mensuração da SjVO2' => $arry_gravidade,
                            'Cateter de PtiO2' => $arry_gravidade,
                            'Cateter de microdiálise' => $arry_gravidade,
                            'Ventilação mecânica invasiva' => $arry_gravidade,
                            'Traqueostomia' => $arry_gravidade,
                            'Bioimpedância' => $arry_gravidade,
                            'Ventilação não-invasiva' => $arry_gravidade,
                            'Macronebulização' => $arry_gravidade,
                            'Marcapasso transvenoso' => $arry_gravidade,
                            'Aminas hipertensoras' => $arry_gravidade,
                            'Marcapasso transcutâneo' => $arry_gravidade,
                            'Drogas hipotensoras em BI' => $arry_gravidade,
                            'Monitoração hemodinâmica minimamente' => $arry_gravidade,
                            'invasiva' => $arry_gravidade,
                            'ECMO' => $arry_gravidade,
                            'Balão intra-aórtico' => $arry_gravidade,
                            'Drogas inotrópicas em BI' => $arry_gravidade,
                            'Fator VIII' => $arry_gravidade,
                            'Fator IX' => $arry_gravidade,
                            'Fator VIIa' => $arry_gravidade,
                            'Estreptoquinase' => $arry_gravidade,
                            'Alteplase' => $arry_gravidade,
                            'Tenecteplase' => $arry_gravidade,
                            'Abciximab' => $arry_gravidade,
                            'Eptifibatide' => $arry_gravidade,
                            'Tirofiban' => $arry_gravidade,
                            'Complexo protrombínico' => $arry_gravidade,
                            'Concentrado de Hemácias' => $arry_gravidade,
                            'Concentrado de Plaquetas' => $arry_gravidade,
                            'Concentrado de Fibrinogênio liofilizado' => $arry_gravidade,
                            'Plasma fresco' => $arry_gravidade,
                            'Criopreciptado' => $arry_gravidade,
                            'Albumina' => $arry_gravidade,
                            'Imunoglobulina' => $arry_gravidade,
                            'Complemento' => $arry_gravidade,
                            'Tubo orotraqueal' => $arry_gravidade,
                            'Outros hemocomponentes' => $arry_gravidade,
                            'Cateter venoso central por dissecção venosa' => $arry_gravidade,
                            'Cateter de átrio esquerdo' => $arry_gravidade,
                            'Cateter umbilical' => $arry_gravidade,
                            'Cateter de monitorização da pressão intracraniana' => $arry_gravidade,
                            'Cateter para diálise peritoneal' => $arry_gravidade,
                            'Dreno torácico' => $arry_gravidade,
                            'Dreno pericárdico' => $arry_gravidade,
                            'Dreno abdominal' => $arry_gravidade,
                            'Dreno cavitário' => $arry_gravidade
                        ];
        $gravidade_faixa_etaria = ['0 - 9' => 0, '10 - 19' => 0, '20 - 29' => 0, '30 - 39' => 0, '40 - 49' => 0, '50 - 59' => 0, '60 - 69' => 0, '70 - 79' => 0, '80 - 89' => 0, '90 - 99' => 0, '> 100' => 0];
        $tempo_permanencia = ["< 24h" => 0, "< 72h" => 0, "> 12 dias" => 0];

        $data = [
            'total_pacientes' => 0,
            'pre_deliric' => [
                'escore' =>
                [
                    'media' => 0,
                    'mediana' => 0,
                    'valores' => [],
                    'desvio_padrao' => 0,
                ],
                'total_pacientes' => 0,
                'percentual_pacientes' => 0,
                'total_score' => 0,
                'minimo_score' => 0,
                'maximo_score' => 0,
                'total_superior_2' => 0,
                'percentual_superior_2' => 0,
                'probabilidade_de_obito_acima_40' =>
                [
                    'total' => 0,
                    'percentual' => 0,
                    'arr_probabilidade_obito' => [],
                ],
            ],
            'sofa' => [
                'escore' =>
                [
                    'media' => 0,
                    'mediana' => 0,
                    'valores' => [],
                    'desvio_padrao' => 0,
                ],
                'total_pacientes' => 0,
                'percentual_pacientes' => 0,
                'total_score' => 0,
                'minimo_score' => 0,
                'maximo_score' => 0,
                //'total_superior_2' => 0,
                //'percentual_superior_2' => 0,
                'total_aumento_maior_igual_2' => 0,
                'percentual_aumento_maior_igual_2' => 0,
                'pacientes_aumento' => [
                    'total' => 0,
                    'percentual' => 0,
                    'arr_pacientes_aumento' => [
                        'pontuacao' => [],
                    ],
                ],
                'gravidade_faixa_etaria' =>  [
                    '0 - 9' => $gravidade_faixa_etaria,
                    '10 - 19' => $gravidade_faixa_etaria,
                    '20 - 29' => $gravidade_faixa_etaria,
                    '30 - 39' => $gravidade_faixa_etaria,
                    '40 - 49' => $gravidade_faixa_etaria,
                    '50 - 59' => $gravidade_faixa_etaria,
                    '60 - 69' => $gravidade_faixa_etaria,
                    '70 - 79' => $gravidade_faixa_etaria,
                    '80 - 89' => $gravidade_faixa_etaria,
                    '90 - 100' => $gravidade_faixa_etaria,
                ],
                'origem' => [
                    '0 - 9' => [$array_origin],
                    '10 - 19' => [$array_origin],
                    '20 - 29' => [$array_origin],
                    '30 - 39' => [$array_origin],
                    '40 - 49' => [$array_origin],
                    '50 - 59' => [$array_origin],
                    '60 - 69' => [$array_origin],
                    '70 - 79' => [$array_origin],
                    '80 - 89' => [$array_origin],
                    '90 - 100' => [$array_origin],
                ],
                'medida_suporte' => $medida_suporte,
                'obito_alta' =>  [
                    '0 - 9' => ['obito' => 0, 'alta' => 0],
                    '10 - 19' => ['obito' => 0, 'alta' => 0],
                    '20 - 29' => ['obito' => 0, 'alta' => 0],
                    '30 - 39' => ['obito' => 0, 'alta' => 0],
                    '40 - 49' => ['obito' => 0, 'alta' => 0],
                    '50 - 59' => ['obito' => 0, 'alta' => 0],
                    '60 - 69' => ['obito' => 0, 'alta' => 0],
                    '70 - 79' => ['obito' => 0, 'alta' => 0],
                    '80 - 89' => ['obito' => 0, 'alta' => 0],
                    '90 - 100' => ['obito' => 0, 'alta' => 0],
                ],
                'comorbidades' => [
                    '0 - 9' => $array_comorbidades,
                    '10 - 19' => $array_comorbidades,
                    '20 - 29' => $array_comorbidades,
                    '30 - 39' => $array_comorbidades,
                    '40 - 49' => $array_comorbidades,
                    '50 - 59' => $array_comorbidades,
                    '60 - 69' => $array_comorbidades,
                    '70 - 79' => $array_comorbidades,
                    '80 - 89' => $array_comorbidades,
                    '90 - 100' => $array_comorbidades,
                ],
                'tempo_permanencia' => [
                    '0 - 9' => $tempo_permanencia,
                    '10 - 19' => $tempo_permanencia,
                    '20 - 29' => $tempo_permanencia,
                    '30 - 39' => $tempo_permanencia,
                    '40 - 49' => $tempo_permanencia,
                    '50 - 59' => $tempo_permanencia,
                    '60 - 69' => $tempo_permanencia,
                    '70 - 79' => $tempo_permanencia,
                    '80 - 89' => $tempo_permanencia,
                    '90 - 100' => $tempo_permanencia,
                ],
            ],
            'curb' => [
                'escore' =>
                [
                    'media' => 0,
                    'mediana' => 0,
                    'valores' => [],
                    'desvio_padrao' => 0,
                ],
                'total_pacientes' => 0,
                'percentual_pacientes' => 0,
                'total_score' => 0,
                'minimo_score' => 0,
                'maximo_score' => 0,
                'total_superior_2' => 0,
                'percentual_superior_2' => 0,
                'total_superior_3' => 0,
                'percentual_superior_3' => 0,
                'total_superior_4' => 0,
                'percentual_superior_4' => 0,

            ],
            'crib' => [
                'escore' =>
                [
                    'media' => 0,
                    'mediana' => 0,
                    'valores' => [],
                    'desvio_padrao' => 0,
                ],
                 'taxa_letalidade' =>
                [
                    'taxa' => 0,
                    'arr_probabilidade_obito' => [],
                    'media' => 0,
                    'mediana' => 0,
                    'minimo' => 0,
                    'maximo' => 0,
                ],
                'total_pacientes' => 0,
                'total_pacientes_obito' => 0,
                'percentual_pacientes' => 0,
                'total_score' => 0,
                'minimo_score' => 0,
                'maximo_score' => 0,
                'total_superior_2' => 0,
                'percentual_superior_2' => 0,
                'probabilidade_de_obito_acima_40' =>
                [
                    'total' => 0,
                    'percentual' => 0,
                    'arr_probabilidade_obito' => [],
                ],
                'gravidade_faixa_etaria' =>  [
                    '0 - 9' => $gravidade_faixa_etaria,
                    '10 - 19' => $gravidade_faixa_etaria,
                    '20 - 29' => $gravidade_faixa_etaria,
                    '30 - 39' => $gravidade_faixa_etaria,
                    '40 - 49' => $gravidade_faixa_etaria,
                    '50 - 59' => $gravidade_faixa_etaria,
                    '60 - 69' => $gravidade_faixa_etaria,
                    '70 - 79' => $gravidade_faixa_etaria,
                    '80 - 89' => $gravidade_faixa_etaria,
                    '90 - 100' => $gravidade_faixa_etaria,
                ],
                'origem' => [
                    '0 - 9' => [$array_origin],
                    '10 - 19' => [$array_origin],
                    '20 - 29' => [$array_origin],
                    '30 - 39' => [$array_origin],
                    '40 - 49' => [$array_origin],
                    '50 - 59' => [$array_origin],
                    '60 - 69' => [$array_origin],
                    '70 - 79' => [$array_origin],
                    '80 - 89' => [$array_origin],
                    '90 - 100' => [$array_origin],
                ],
                'medida_suporte' => $medida_suporte,
                'obito_alta' =>  [
                    '0 - 9' => ['obito' => 0, 'alta' => 0],
                    '10 - 19' => ['obito' => 0, 'alta' => 0],
                    '20 - 29' => ['obito' => 0, 'alta' => 0],
                    '30 - 39' => ['obito' => 0, 'alta' => 0],
                    '40 - 49' => ['obito' => 0, 'alta' => 0],
                    '50 - 59' => ['obito' => 0, 'alta' => 0],
                    '60 - 69' => ['obito' => 0, 'alta' => 0],
                    '70 - 79' => ['obito' => 0, 'alta' => 0],
                    '80 - 89' => ['obito' => 0, 'alta' => 0],
                    '90 - 100' => ['obito' => 0, 'alta' => 0],
                ],
                'comorbidades' => [
                    '0 - 9' => $array_comorbidades,
                    '10 - 19' => $array_comorbidades,
                    '20 - 29' => $array_comorbidades,
                    '30 - 39' => $array_comorbidades,
                    '40 - 49' => $array_comorbidades,
                    '50 - 59' => $array_comorbidades,
                    '60 - 69' => $array_comorbidades,
                    '70 - 79' => $array_comorbidades,
                    '80 - 89' => $array_comorbidades,
                    '90 - 100' => $array_comorbidades,
                ],
                'tempo_permanencia' => [
                    '0 - 9' => $tempo_permanencia,
                    '10 - 19' => $tempo_permanencia,
                    '20 - 29' => $tempo_permanencia,
                    '30 - 39' => $tempo_permanencia,
                    '40 - 49' => $tempo_permanencia,
                    '50 - 59' => $tempo_permanencia,
                    '60 - 69' => $tempo_permanencia,
                    '70 - 79' => $tempo_permanencia,
                    '80 - 89' => $tempo_permanencia,
                    '90 - 100' => $tempo_permanencia,
                ],
            ],
            'nas' => [
                'escore' =>
                [
                    'media' => 0,
                    'mediana' => 0,
                    'valores' => [],
                    'desvio_padrao' => 0,
                ],
                'total_pacientes' => 0,
                'percentual_pacientes' => 0,
                'total_score' => 0,
                'minimo_score' => 0,
                'maximo_score' => 0,
                'total_pacientes_superior_25_pontos' => 0,
                'percentual_pacientes_superior_25_pontos' => 0,
                'pacientes_superior_25_pontos' => [
                    'total' => 0,
                    'percentual' => 0,
                    'arr_pacientes_superior_25_pontos' => [
                        'pontuacao' => [],
                    ],
                ],
            ],
            'apache' => [
                'escore' =>
                [
                    'media' => 0,
                    'mediana' => 0,
                    'valores' => [],
                    'desvio_padrao' => 0,
                ],
                'taxa_letalidade' =>
                [
                    'taxa' => 0,
                    'arr_probabilidade_obito' => [],
                    'media' => 0,
                    'mediana' => 0,
                    'minimo' => 0,
                    'maximo' => 0,
                ],
                'taxa_letalidade_america_latina' =>
                [
                    'taxa' => 0,
                    'arr_probabilidade_obito' => [],
                    'media' => 0,
                    'mediana' => 0,
                    'minimo' => 0,
                    'maximo' => 0,
                ],
                'total_pacientes' => 0,
                'total_pacientes_obito' => 0,
                'percentual_pacientes' => 0,
                'total_score' => 0,
                'minimo_score' => 0,
                'maximo_score' => 0,
                'probabilidade_de_obito_acima_40' =>
                [
                    'total' => 0,
                    'percentual' => 0,
                    'arr_probabilidade_obito' => [],
                ],
                'gravidade_faixa_etaria' =>  [
                    '0 - 9' => $gravidade_faixa_etaria,
                    '10 - 19' => $gravidade_faixa_etaria,
                    '20 - 29' => $gravidade_faixa_etaria,
                    '30 - 39' => $gravidade_faixa_etaria,
                    '40 - 49' => $gravidade_faixa_etaria,
                    '50 - 59' => $gravidade_faixa_etaria,
                    '60 - 69' => $gravidade_faixa_etaria,
                    '70 - 79' => $gravidade_faixa_etaria,
                    '80 - 89' => $gravidade_faixa_etaria,
                    '90 - 100' => $gravidade_faixa_etaria,
                ],
                'origem' => [
                    '0 - 9' => [$array_origin],
                    '10 - 19' => [$array_origin],
                    '20 - 29' => [$array_origin],
                    '30 - 39' => [$array_origin],
                    '40 - 49' => [$array_origin],
                    '50 - 59' => [$array_origin],
                    '60 - 69' => [$array_origin],
                    '70 - 79' => [$array_origin],
                    '80 - 89' => [$array_origin],
                    '90 - 100' => [$array_origin],
                ],
                'medida_suporte' => $medida_suporte,
                'obito_alta' =>  [
                    '0 - 9' => ['obito' => 0, 'alta' => 0],
                    '10 - 19' => ['obito' => 0, 'alta' => 0],
                    '20 - 29' => ['obito' => 0, 'alta' => 0],
                    '30 - 39' => ['obito' => 0, 'alta' => 0],
                    '40 - 49' => ['obito' => 0, 'alta' => 0],
                    '50 - 59' => ['obito' => 0, 'alta' => 0],
                    '60 - 69' => ['obito' => 0, 'alta' => 0],
                    '70 - 79' => ['obito' => 0, 'alta' => 0],
                    '80 - 89' => ['obito' => 0, 'alta' => 0],
                    '90 - 100' => ['obito' => 0, 'alta' => 0],
                ],
                'comorbidades' => [
                    '0 - 9' => $array_comorbidades,
                    '10 - 19' => $array_comorbidades,
                    '20 - 29' => $array_comorbidades,
                    '30 - 39' => $array_comorbidades,
                    '40 - 49' => $array_comorbidades,
                    '50 - 59' => $array_comorbidades,
                    '60 - 69' => $array_comorbidades,
                    '70 - 79' => $array_comorbidades,
                    '80 - 89' => $array_comorbidades,
                    '90 - 100' => $array_comorbidades,
                ],
                'tempo_permanencia' => [
                    '0 - 9' => $tempo_permanencia,
                    '10 - 19' => $tempo_permanencia,
                    '20 - 29' => $tempo_permanencia,
                    '30 - 39' => $tempo_permanencia,
                    '40 - 49' => $tempo_permanencia,
                    '50 - 59' => $tempo_permanencia,
                    '60 - 69' => $tempo_permanencia,
                    '70 - 79' => $tempo_permanencia,
                    '80 - 89' => $tempo_permanencia,
                    '90 - 100' => $tempo_permanencia,
                ],
            ],
            'snap' => [
                'escore' =>
                [
                    'media' => 0,
                    'mediana' => 0,
                    'valores' => [],
                    'desvio_padrao' => 0,
                ],
                'taxa_letalidade' =>
                [
                    'taxa' => 0,
                    'arr_probabilidade_obito' => [],
                    'media' => 0,
                    'mediana' => 0,
                    'minimo' => 0,
                    'maximo' => 0,
                ],
                'total_pacientes' => 0,
                'total_pacientes_obito' => 0,
                'percentual_pacientes' => 0,
                'total_score' => 0,
                'minimo_score' => 0,
                'maximo_score' => 0,
                'total_superior_2' => 0,
                'percentual_superior_2' => 0,
                'probabilidade_de_obito_acima_40' =>
                [
                    'total' => 0,
                    'percentual' => 0,
                    'arr_probabilidade_obito' => [],
                ],
               'gravidade_faixa_etaria' =>  [
                    '0 - 9' => $gravidade_faixa_etaria,
                    '10 - 19' => $gravidade_faixa_etaria,
                    '20 - 29' => $gravidade_faixa_etaria,
                    '30 - 39' => $gravidade_faixa_etaria,
                    '40 - 49' => $gravidade_faixa_etaria,
                    '50 - 59' => $gravidade_faixa_etaria,
                    '60 - 69' => $gravidade_faixa_etaria,
                    '70 - 79' => $gravidade_faixa_etaria,
                    '80 - 89' => $gravidade_faixa_etaria,
                    '90 - 100' => $gravidade_faixa_etaria,
                ],
                'origem' => [
                    '0 - 9' => [$array_origin],
                    '10 - 19' => [$array_origin],
                    '20 - 29' => [$array_origin],
                    '30 - 39' => [$array_origin],
                    '40 - 49' => [$array_origin],
                    '50 - 59' => [$array_origin],
                    '60 - 69' => [$array_origin],
                    '70 - 79' => [$array_origin],
                    '80 - 89' => [$array_origin],
                    '90 - 100' => [$array_origin],
                ],
                'medida_suporte' => $medida_suporte,
                'obito_alta' =>  [
                    '0 - 9' => ['obito' => 0, 'alta' => 0],
                    '10 - 19' => ['obito' => 0, 'alta' => 0],
                    '20 - 29' => ['obito' => 0, 'alta' => 0],
                    '30 - 39' => ['obito' => 0, 'alta' => 0],
                    '40 - 49' => ['obito' => 0, 'alta' => 0],
                    '50 - 59' => ['obito' => 0, 'alta' => 0],
                    '60 - 69' => ['obito' => 0, 'alta' => 0],
                    '70 - 79' => ['obito' => 0, 'alta' => 0],
                    '80 - 89' => ['obito' => 0, 'alta' => 0],
                    '90 - 100' => ['obito' => 0, 'alta' => 0],
                ],
                'comorbidades' => [
                    '0 - 9' => $array_comorbidades,
                    '10 - 19' => $array_comorbidades,
                    '20 - 29' => $array_comorbidades,
                    '30 - 39' => $array_comorbidades,
                    '40 - 49' => $array_comorbidades,
                    '50 - 59' => $array_comorbidades,
                    '60 - 69' => $array_comorbidades,
                    '70 - 79' => $array_comorbidades,
                    '80 - 89' => $array_comorbidades,
                    '90 - 100' => $array_comorbidades,
                ],
                'tempo_permanencia' => [
                    '0 - 9' => $tempo_permanencia,
                    '10 - 19' => $tempo_permanencia,
                    '20 - 29' => $tempo_permanencia,
                    '30 - 39' => $tempo_permanencia,
                    '40 - 49' => $tempo_permanencia,
                    '50 - 59' => $tempo_permanencia,
                    '60 - 69' => $tempo_permanencia,
                    '70 - 79' => $tempo_permanencia,
                    '80 - 89' => $tempo_permanencia,
                    '90 - 100' => $tempo_permanencia,
                ],
            ],
            'saps' => [
                'escore' =>
                [
                    'media' => 0,
                    'mediana' => 0,
                    'valores' => [],
                    'desvio_padrao' => 0,
                ],
                'taxa_letalidade' =>
                [
                    'taxa' => 0,
                    'arr_probabilidade_obito' => [],
                ],
                'total_pacientes' => 0,
                'percentual_pacientes' => 0,
                'total_score' => 0,
                'minimo_score' => 0,
                'maximo_score' => 0,
                'probabilidade_de_obito_acima_40' =>
                [
                    'total' => 0,
                    'percentual' => 0,
                    'arr_probabilidade_obito' => [],
                ],
                'gravidade_faixa_etaria' =>  [
                    '0 - 9' => $gravidade_faixa_etaria,
                    '10 - 19' => $gravidade_faixa_etaria,
                    '20 - 29' => $gravidade_faixa_etaria,
                    '30 - 39' => $gravidade_faixa_etaria,
                    '40 - 49' => $gravidade_faixa_etaria,
                    '50 - 59' => $gravidade_faixa_etaria,
                    '60 - 69' => $gravidade_faixa_etaria,
                    '70 - 79' => $gravidade_faixa_etaria,
                    '80 - 89' => $gravidade_faixa_etaria,
                    '90 - 100' => $gravidade_faixa_etaria,
                ],
                'origem' => [
                    '0 - 9' => [$array_origin],
                    '10 - 19' => [$array_origin],
                    '20 - 29' => [$array_origin],
                    '30 - 39' => [$array_origin],
                    '40 - 49' => [$array_origin],
                    '50 - 59' => [$array_origin],
                    '60 - 69' => [$array_origin],
                    '70 - 79' => [$array_origin],
                    '80 - 89' => [$array_origin],
                    '90 - 100' => [$array_origin],
                ],
                'medida_suporte' => $medida_suporte,
                'obito_alta' =>  [
                    '0 - 9' => ['obito' => 0, 'alta' => 0],
                    '10 - 19' => ['obito' => 0, 'alta' => 0],
                    '20 - 29' => ['obito' => 0, 'alta' => 0],
                    '30 - 39' => ['obito' => 0, 'alta' => 0],
                    '40 - 49' => ['obito' => 0, 'alta' => 0],
                    '50 - 59' => ['obito' => 0, 'alta' => 0],
                    '60 - 69' => ['obito' => 0, 'alta' => 0],
                    '70 - 79' => ['obito' => 0, 'alta' => 0],
                    '80 - 89' => ['obito' => 0, 'alta' => 0],
                    '90 - 100' => ['obito' => 0, 'alta' => 0],
                ],
                'comorbidades' => [
                    '0 - 9' => $array_comorbidades,
                    '10 - 19' => $array_comorbidades,
                    '20 - 29' => $array_comorbidades,
                    '30 - 39' => $array_comorbidades,
                    '40 - 49' => $array_comorbidades,
                    '50 - 59' => $array_comorbidades,
                    '60 - 69' => $array_comorbidades,
                    '70 - 79' => $array_comorbidades,
                    '80 - 89' => $array_comorbidades,
                    '90 - 100' => $array_comorbidades,
                ],
                'tempo_permanencia' => [
                    '0 - 9' => $tempo_permanencia,
                    '10 - 19' => $tempo_permanencia,
                    '20 - 29' => $tempo_permanencia,
                    '30 - 39' => $tempo_permanencia,
                    '40 - 49' => $tempo_permanencia,
                    '50 - 59' => $tempo_permanencia,
                    '60 - 69' => $tempo_permanencia,
                    '70 - 79' => $tempo_permanencia,
                    '80 - 89' => $tempo_permanencia,
                    '90 - 100' => $tempo_permanencia,
                ],
            ],
        ];
        $arr_global = [];
        $hospitalization_ids = [];
        $pacient_ids = [
            'total' => [],
            'curb' => [],
            'sofa' => [],
            'pre_deliric' => [],
            'crib' => [],
            'nas' => [],
            'apache' => [],
            'snap' => [],
            'saps' => [],

        ];

        foreach ($hospitalizations as $key => $value)
        {
            array_push($hospitalization_ids, $value->id);

            if (!in_array($value->patient_id, $pacient_ids['total']))
            {
                array_push($pacient_ids['total'], $value->patient_id);
                $data['total_pacientes']++;
            }
        }

        $curb = $curb_scores_table
            ->find('all', [
                'contain' => ['Hospitalizations'],
                'conditions' =>
                [
                    'CurbScores.hospitalization_id in ' => $hospitalization_ids,
                    'CurbScores.created >' => $date_before,
                    'CurbScores.created < ' => $date_after,
                ],
            ])->toArray();

        $sofa = $sofa_scores_table
            ->find('all', [
                'contain' => ['Hospitalizations.Patients', 'Hospitalizations.SupportiveMeasures', 'Hospitalizations.Discharges'],
                'conditions' =>
                [
                    'SofaEscores.hospitalization_id in ' => $hospitalization_ids,
                    'SofaEscores.created >' => $date_before,
                    'SofaEscores.created < ' => $date_after,
                ],
            ])->toArray();

        $pre_deliric = $pre_deliric_scores_table
            ->find('all', [
                'contain' => ['Hospitalizations'],
                'conditions' =>
                [
                    'PreDeliricScores.hospitalization_id in ' => $hospitalization_ids,
                    'PreDeliricScores.created >' => $date_before,
                    'PreDeliricScores.created < ' => $date_after,
                ],
            ])->toArray();

        $crib = $crib_scores_table
            ->find('all', [
                'contain' => ['Hospitalizations.Patients', 'Hospitalizations.Discharges'],
                'conditions' =>
                [
                    'CribScores.hospitalization_id in ' => $hospitalization_ids,
                    'CribScores.created >' => $date_before,
                    'CribScores.created < ' => $date_after,
                ],
            ])->toArray();

        $nas = $nas_scores_table
            ->find('all', [
                'contain' => ['Hospitalizations'],
                'conditions' =>
                [
                    'NasScores.hospitalization_id in ' => $hospitalization_ids,
                    'NasScores.created >' => $date_before,
                    'NasScores.created < ' => $date_after,
                ],
            ])->toArray();

        $apache = $apache_ii_scores_table
            ->find('all', [
                'contain' => ['Hospitalizations.Patients', 'Hospitalizations.Diagnostics.Comorbidities', 'Hospitalizations.Discharges'],
                'conditions' =>
                [
                    'ApacheIiScores.hospitalization_id in ' => $hospitalization_ids,
                    'ApacheIiScores.created >' => $date_before,
                    'ApacheIiScores.created < ' => $date_after,
                ],
            ])->toArray();

        $snap = $snap_ii_scores_table
            ->find('all', [
                'contain' => ['Hospitalizations.Patients', 'Hospitalizations.Discharges'],
                'conditions' =>
                [
                    'SnapIiScores.hospitalization_id in ' => $hospitalization_ids,
                    'SnapIiScores.created >' => $date_before,
                    'SnapIiScores.created < ' => $date_after,
                ],
            ])->toArray();

        $saps = $saps_iii_scores_table
            ->find('all', [
                'contain' => ['Hospitalizations.Patients', 'Hospitalizations.Diagnostics.Comorbidities', 'Hospitalizations.Discharges'],
                'conditions' =>
                [
                    'SapsIiiScores.hospitalization_id in ' => $hospitalization_ids,
                    'SapsIiiScores.created >' => $date_before,
                    'SapsIiiScores.created < ' => $date_after,
                ],
            ])->toArray();

        $arr_global['sofa'] = $sofa;
        $arr_global['curb'] = $curb;
        $arr_global['pre_deliric'] = $pre_deliric;
        $arr_global['crib'] = $crib;
        $arr_global['nas'] = $nas;
        $arr_global['apache'] = $apache;
        $arr_global['snap'] = $snap;
        $arr_global['saps'] = $saps;

        $arr_gravidade = ['sofa', 'crib', 'apache', 'snap', 'saps'];
        //$arr_gravidade = ['apache', 'saps'];

        //$data['escore_gravidade'] = $arr_gravidade;

        foreach ($arr_global as $key_global => $value_global)
        {
            if (!is_array($value_global))
            {
                return;
            }

            $count = 0;
            $len = count($value_global);

            foreach ($value_global as $key => $value)
            {
                //echo "<pre>";
                //print_r($value->hospitalization);
                $total_score = 0;

                $from = $value['hospitalization']['patient']['birthday'];
               // $from = $from->format('Y-m-d H:m:s');

                if (isset($from))
                {
                    $from = new \Datetime($from->i18nFormat('dd-MM-yyyy'));
                    //echo "<pre>";
                    //print_r($from);
                    $to = new \DateTime('today');
                    //echo "<pre>";
                    //print_r($to);
                    $age = $from->diff($to)->y;
                }
                else
                {
                    $age = 0;
                }


                $origin_id = $value->hospitalization->origin_id;
                //echo "anos = " . $age;


                if (in_array($key_global, $arr_gravidade)) {

                    if($key_global == 'apache' || $key_global == 'saps' |  $key_global == 'crib'|| $key_global == 'snap' || $key_global == 'sofa'  ){
                        //echo $key_global;
                        $probabilidade_obito = $value->probabilidade_de_obito;
                        $status = $value->hospitalization->status;
                        if($probabilidade_obito >=0 && $probabilidade_obito <= 9){

                            //obito
                            if ($status == 'obito'){
                                $data[$key_global]['obito_alta']['0 - 9']['obito']++;
                            }
                            else if ($status == 'alta') {
                                $data[$key_global]['obito_alta']['0 - 9']['alta']++;
                            }

                            // faixa etaria
                            if($age >=0 && $age <= 9){
                                $data[$key_global]['gravidade_faixa_etaria']['0 - 9']['0 - 9']++;
                            }
                            else if($age >=10 && $age <= 19){
                                $data[$key_global]['gravidade_faixa_etaria']['0 - 9']['10 - 19']++;
                            }
                            else if($age >=20 && $age <= 29){
                                $data[$key_global]['gravidade_faixa_etaria']['0 - 9']['20 - 29']++;
                            }
                            else if($age >=30 && $age <= 39){
                                $data[$key_global]['gravidade_faixa_etaria']['0 - 9']['30 - 39']++;
                            }
                            else if ($age >=40 && $age <= 49) {
                                $data[$key_global]['gravidade_faixa_etaria']['0 - 9']['40 - 49']++;
                            }
                            else if ($age >=50 && $age <= 59) {
                                $data[$key_global]['gravidade_faixa_etaria']['0 - 9']['50 - 59']++;
                            }
                            else if ($age >=60 && $age <= 69) {
                                $data[$key_global]['gravidade_faixa_etaria']['0 - 9']['60 - 69']++;
                            }
                            else if ($age >=70 && $age <= 79) {
                                $data[$key_global]['gravidade_faixa_etaria']['0 - 9']['70 - 79']++;
                            }
                            else if ($age >=80 && $age <= 89) {
                                $data[$key_global]['gravidade_faixa_etaria']['0 - 9']['80 - 89']++;
                            }
                            else if ($age >=90 && $age <= 99) {
                                $data[$key_global]['gravidade_faixa_etaria']['0 - 9']['90 - 99']++;
                            }
                            else {
                                $data[$key_global]['gravidade_faixa_etaria']['0 - 9']['> 100']++;
                            }

                            if (isset($value->hospitalization->origin_id)) {
                                $data[$key_global]['origem']['0 - 9']['0'][$origin_id]['value']++;
                            }

                            if(isset($value->hospitalization->diagnostics)){
                                foreach ($value->hospitalization->diagnostics as $key => $diagnostic) {
                                    if(count($diagnostic->comorbidities) >= 3){
                                        $data[$key_global]['comorbidades']['0 - 9']['3']++;
                                    }
                                    else if(count($diagnostic->comorbidities) > 0){
                                       $data[$key_global]['comorbidades']['0 - 9'][count($diagnostic->comorbidities)]++;
                                    }
                                }
                            }

                            if(isset($value->hospitalization->discharges)){
                                foreach ($value->hospitalization->discharges as $key => $discharges) {
                                    if($value->hospitalization->status != 'internado' && $discharges['data_saida_unidade'] != ""){
                                        $data_saida_unidade = explode("/", $discharges['data_saida_unidade']);

                                        $data_entrada = new \Datetime($value->hospitalization->date_of_hospitalization->i18nFormat('dd-MM-yyyy'));
                                        $data_saida = new \Datetime($data_saida_unidade[0].'-'.$data_saida_unidade[1].'-'.$data_saida_unidade[2]);

                                        $data_intervalo = $data_saida->diff($data_entrada);

                                        //echo "<pre>";
                                        //print_r($data_intervalo->days);
                                        //echo $key_global . " - " .  $data_intervalo->days . "<br>";

                                        if($data_intervalo->days > 12){
                                            $data[$key_global]['tempo_permanencia']['0 - 9']['> 12 dias']++;
                                        }
                                        else if($data_intervalo->days < 1 ){
                                            $data[$key_global]['tempo_permanencia']['0 - 9']['< 24h']++;
                                        }
                                        else if($data_intervalo->days < 3){
                                            $data[$key_global]['tempo_permanencia']['0 - 9']['< 72h']++;
                                        }

                                    }
                                }
                            }

                            if (isset($value->hospitalization->supportive_measures))
                            {
                                foreach ($value->hospitalization->supportive_measures as $key_suporte => $medida_suporte)
                                {
                                    //echo "<pre>";
                                    //print_r($medida_suporte);
                                    $data[$key_global]['medida_suporte'][$medida_suporte['type']]['0 - 9']++;
                                }
                            }

                        }
                        else if($probabilidade_obito >=10 && $probabilidade_obito <= 19){
                            if ($status == 'obito'){
                                $data[$key_global]['obito_alta']['10 - 19']['obito']++;
                            }
                            else if ($status == 'alta') {
                                $data[$key_global]['obito_alta']['10 - 19']['alta']++;
                            }

                            if($age >=0 && $age <= 9){
                                $data[$key_global]['gravidade_faixa_etaria']['10 - 19']['0 - 9']++;
                            }
                            else if($age >=10 && $age <= 19){
                                $data[$key_global]['gravidade_faixa_etaria']['10 - 19']['10 - 19']++;
                            }
                            else if($age >=20 && $age <= 29){
                                $data[$key_global]['gravidade_faixa_etaria']['10 - 19']['20 - 29']++;
                            }
                            else if($age >=30 && $age <= 39){
                                $data[$key_global]['gravidade_faixa_etaria']['10 - 19']['30 - 39']++;
                            }
                            else if ($age >=40 && $age <= 49) {
                                $data[$key_global]['gravidade_faixa_etaria']['10 - 19']['40 - 49']++;
                            }
                            else if ($age >=50 && $age <= 59) {
                                $data[$key_global]['gravidade_faixa_etaria']['10 - 19']['50 - 59']++;
                            }
                            else if ($age >=60 && $age <= 69) {
                                $data[$key_global]['gravidade_faixa_etaria']['10 - 19']['60 - 69']++;
                            }
                            else if ($age >=70 && $age <= 79) {
                                $data[$key_global]['gravidade_faixa_etaria']['10 - 19']['70 - 79']++;
                            }
                            else if ($age >=80 && $age <= 89) {
                                $data[$key_global]['gravidade_faixa_etaria']['10 - 19']['80 - 89']++;
                            }
                            else if ($age >=90 && $age <= 99) {
                                $data[$key_global]['gravidade_faixa_etaria']['10 - 19']['90 - 99']++;
                            }
                            else {
                                $data[$key_global]['gravidade_faixa_etaria']['10 - 19']['> 100']++;
                            }

                            if(isset($value->hospitalization->diagnostics)){
                                foreach ($value->hospitalization->diagnostics as $key => $diagnostic) {
                                    if(count($diagnostic->comorbidities) >= 3){
                                        $data[$key_global]['comorbidades']['10 - 19']['3']++;
                                    }
                                    else if(count($diagnostic->comorbidities) > 0){
                                       $data[$key_global]['comorbidades']['10 - 19'][count($diagnostic->comorbidities)]++;
                                    }
                                }
                            }

                            if(isset($value->hospitalization->discharges)){
                                foreach ($value->hospitalization->discharges as $key => $discharges) {
                                    if($value->hospitalization->status != 'internado' && $discharges['data_saida_unidade'] != ""){
                                        $data_saida_unidade = explode("/", $discharges['data_saida_unidade']);

                                        $data_entrada = new \Datetime($value->hospitalization->date_of_hospitalization->i18nFormat('dd-MM-yyyy'));
                                        $data_saida = new \Datetime($data_saida_unidade[0].'-'.$data_saida_unidade[1].'-'.$data_saida_unidade[2]);

                                        $data_intervalo = $data_saida->diff($data_entrada);

                                        if($data_intervalo->days > 12){
                                            $data[$key_global]['tempo_permanencia']['10 - 19']['> 12 dias']++;
                                        }
                                        else if($data_intervalo->days < 1 ){
                                            $data[$key_global]['tempo_permanencia']['10 -19']['< 24h']++;
                                        }
                                        else if($data_intervalo->days < 3){
                                            $data[$key_global]['tempo_permanencia']['10 - 19']['< 72h']++;
                                        }

                                    }
                                }
                            }

                            if (isset($value->hospitalization->supportive_measures))
                            {
                                foreach ($value->hospitalization->supportive_measures as $key_suporte => $medida_suporte)
                                {
                                    //echo "<pre>";
                                    //print_r($medida_suporte);
                                    $data[$key_global]['medida_suporte'][$medida_suporte['type']]['10 - 19']++;
                                }
                            }

                        }
                        else if($probabilidade_obito >=20 && $probabilidade_obito <= 29){
                            if ($status == 'obito'){
                                $data[$key_global]['obito_alta']['20 - 29']['obito']++;
                            }
                            else if ($status == 'alta') {
                                $data[$key_global]['obito_alta']['20 - 29']['alta']++;
                            }

                            if($age >=0 && $age <= 9){
                                $data[$key_global]['gravidade_faixa_etaria']['20 - 29']['0 - 9']++;
                            }
                            else if($age >=10 && $age <= 19){
                                $data[$key_global]['gravidade_faixa_etaria']['20 - 29']['10 - 19']++;
                            }
                            else if($age >=20 && $age <= 29){
                                $data[$key_global]['gravidade_faixa_etaria']['20 - 29']['20 - 29']++;
                            }
                            else if($age >=30 && $age <= 39){
                                $data[$key_global]['gravidade_faixa_etaria']['20 - 29']['30 - 39']++;
                            }
                            else if ($age >=40 && $age <= 49) {
                                $data[$key_global]['gravidade_faixa_etaria']['20 - 29']['40 - 49']++;
                            }
                            else if ($age >=50 && $age <= 59) {
                                $data[$key_global]['gravidade_faixa_etaria']['20 - 29']['50 - 59']++;
                            }
                            else if ($age >=60 && $age <= 69) {
                                $data[$key_global]['gravidade_faixa_etaria']['20 - 29']['60 - 69']++;
                            }
                            else if ($age >=70 && $age <= 79) {
                                $data[$key_global]['gravidade_faixa_etaria']['20 - 29']['70 - 79']++;
                            }
                            else if ($age >=80 && $age <= 89) {
                                $data[$key_global]['gravidade_faixa_etaria']['20 - 29']['80 - 89']++;
                            }
                            else if ($age >=90 && $age <= 99) {
                                $data[$key_global]['gravidade_faixa_etaria']['20 - 29']['90 - 99']++;
                            }
                            else {
                                $data[$key_global]['gravidade_faixa_etaria']['20 - 29']['> 100']++;
                            }

                            //echo count($value->hospitalization->diagnostics->comorbidities);
                            //echo "<pre>";
                           // print_r($value->hospitalization);

                            if(isset($value->hospitalization->diagnostics)){
                                foreach ($value->hospitalization->diagnostics as $key => $diagnostic) {
                                    if(isset($data[$key_global]['comorbidades']['20 - 29'][count($diagnostic->comorbidities)])){
                                        $count_comorbidities = count($diagnostic->comorbidities);
                                        if($count_comorbidities != 0){
                                            $data[$key_global]['comorbidades']['20 - 29'][$count_comorbidities] = $data[$key_global]['comorbidades']['20 - 29'][$count_comorbidities] + 1 ;
                                        }
                                    }
                                    else{
                                        $data[$key_global]['comorbidades']['20 - 29'][count($diagnostic->comorbidities)] = 1 ;
                                    }
                                }
                            }

                            if(isset($value->hospitalization->discharges)){
                                foreach ($value->hospitalization->discharges as $key => $discharges) {
                                    if($value->hospitalization->status != 'internado' && $discharges['data_saida_unidade'] != ""){
                                        $data_saida_unidade = explode("/", $discharges['data_saida_unidade']);

                                        $data_entrada = new \Datetime($value->hospitalization->date_of_hospitalization->i18nFormat('dd-MM-yyyy'));
                                        $data_saida = new \Datetime($data_saida_unidade[0].'-'.$data_saida_unidade[1].'-'.$data_saida_unidade[2]);

                                        $data_intervalo = $data_saida->diff($data_entrada);

                                        if($data_intervalo->days > 12){
                                            $data[$key_global]['tempo_permanencia']['20 - 29']['> 12 dias']++;
                                        }
                                        else if($data_intervalo->days < 1 ){
                                            $data[$key_global]['tempo_permanencia']['20 - 29']['< 24h']++;
                                        }
                                        else if($data_intervalo->days < 3){
                                            $data[$key_global]['tempo_permanencia']['20 - 29']['< 72h']++;
                                        }

                                    }
                                }
                            }

                            if (isset($value->hospitalization->supportive_measures))
                            {
                                foreach ($value->hospitalization->supportive_measures as $key_suporte => $medida_suporte)
                                {
                                    //echo "<pre>";
                                    //print_r($medida_suporte);
                                    $data[$key_global]['medida_suporte'][$medida_suporte['type']]['20 - 29']++;
                                }
                            }
                        }
                        else if($probabilidade_obito >=30 && $probabilidade_obito <= 39){
                            if ($status == 'obito'){
                                $data[$key_global]['obito_alta']['30 - 39']['obito']++;
                            }
                            else if ($status == 'alta') {
                                $data[$key_global]['obito_alta']['30 - 39']['alta']++;
                            }

                            if($age >=0 && $age <= 9){
                                $data[$key_global]['gravidade_faixa_etaria']['30 - 39']['0 - 9']++;
                            }
                            else if($age >=10 && $age <= 19){
                                $data[$key_global]['gravidade_faixa_etaria']['30 - 39']['10 - 19']++;
                            }
                            else if($age >=20 && $age <= 29){
                                $data[$key_global]['gravidade_faixa_etaria']['30 - 39']['20 - 29']++;
                            }
                            else if($age >=30 && $age <= 39){
                                $data[$key_global]['gravidade_faixa_etaria']['30 - 39']['30 - 39']++;
                            }
                            else if ($age >=40 && $age <= 49) {
                                $data[$key_global]['gravidade_faixa_etaria']['30 - 39']['40 - 49']++;
                            }
                            else if ($age >=50 && $age <= 59) {
                                $data[$key_global]['gravidade_faixa_etaria']['30 - 39']['50 - 59']++;
                            }
                            else if ($age >=60 && $age <= 69) {
                                $data[$key_global]['gravidade_faixa_etaria']['30 - 39']['60 - 69']++;
                            }
                            else if ($age >=70 && $age <= 79) {
                                $data[$key_global]['gravidade_faixa_etaria']['30 - 39']['70 - 79']++;
                            }
                            else if ($age >=80 && $age <= 89) {
                                $data[$key_global]['gravidade_faixa_etaria']['30 - 39']['80 - 89']++;
                            }
                            else if ($age >=90 && $age <= 99) {
                                $data[$key_global]['gravidade_faixa_etaria']['30 - 39']['90 - 99']++;
                            }
                            else {
                                $data[$key_global]['gravidade_faixa_etaria']['30 - 39']['> 100']++;
                            }

                            if(isset($value->hospitalization->diagnostics)){
                                foreach ($value->hospitalization->diagnostics as $key => $diagnostic) {
                                    if(isset($data[$key_global]['comorbidades']['30 - 39'][count($diagnostic->comorbidities)])){
                                        $count_comorbidities = count($diagnostic->comorbidities);
                                        if($count_comorbidities != 0){
                                            $data[$key_global]['comorbidades']['30 - 39'][$count_comorbidities] = $data[$key_global]['comorbidades']['30 - 39'][$count_comorbidities] + 1 ;
                                        }
                                    }
                                    else{
                                        $data[$key_global]['comorbidades']['30 - 39'][count($diagnostic->comorbidities)] = 1 ;
                                    }
                                }
                            }

                            if(isset($value->hospitalization->discharges)){
                                foreach ($value->hospitalization->discharges as $key => $discharges) {
                                    if($value->hospitalization->status != 'internado' && $discharges['data_saida_unidade'] != ""){
                                        $data_saida_unidade = explode("/", $discharges['data_saida_unidade']);

                                        $data_entrada = new \Datetime($value->hospitalization->date_of_hospitalization->i18nFormat('dd-MM-yyyy'));
                                        $data_saida = new \Datetime($data_saida_unidade[0].'-'.$data_saida_unidade[1].'-'.$data_saida_unidade[2]);

                                        $data_intervalo = $data_saida->diff($data_entrada);

                                        if($data_intervalo->days > 12){
                                            $data[$key_global]['tempo_permanencia']['30 - 39']['> 12 dias']++;
                                        }
                                        else if($data_intervalo->days < 1 ){
                                            $data[$key_global]['tempo_permanencia']['30 - 39']['< 24h']++;
                                        }
                                        else if($data_intervalo->days < 3){
                                            $data[$key_global]['tempo_permanencia']['30 - 39']['< 72h']++;
                                        }

                                    }
                                }
                            }

                            if (isset($value->hospitalization->supportive_measures))
                            {
                                foreach ($value->hospitalization->supportive_measures as $key_suporte => $medida_suporte)
                                {
                                    //echo "<pre>";
                                    //print_r($medida_suporte);
                                    $data[$key_global]['medida_suporte'][$medida_suporte['type']]['30 - 39']++;
                                }
                            }
                        }
                        else if ($probabilidade_obito >=40 && $probabilidade_obito <= 49) {
                            if ($status == 'obito'){
                                $data[$key_global]['obito_alta']['40 - 49']['obito']++;
                            }
                            else if ($status == 'alta') {
                                $data[$key_global]['obito_alta']['40 - 49']['alta']++;
                            }

                            if($age >=0 && $age <= 9){
                                $data[$key_global]['gravidade_faixa_etaria']['40 - 49']['0 - 9']++;
                            }
                            else if($age >=10 && $age <= 19){
                                $data[$key_global]['gravidade_faixa_etaria']['40 - 49']['10 - 19']++;
                            }
                            else if($age >=20 && $age <= 29){
                                $data[$key_global]['gravidade_faixa_etaria']['40 - 49']['20 - 29']++;
                            }
                            else if($age >=30 && $age <= 39){
                                $data[$key_global]['gravidade_faixa_etaria']['40 - 49']['30 - 39']++;
                            }
                            else if ($age >=40 && $age <= 49) {
                                $data[$key_global]['gravidade_faixa_etaria']['40 - 49']['40 - 49']++;
                            }
                            else if ($age >=50 && $age <= 59) {
                                $data[$key_global]['gravidade_faixa_etaria']['40 - 49']['50 - 59']++;
                            }
                            else if ($age >=60 && $age <= 69) {
                                $data[$key_global]['gravidade_faixa_etaria']['40 - 49']['60 - 69']++;
                            }
                            else if ($age >=70 && $age <= 79) {
                                $data[$key_global]['gravidade_faixa_etaria']['40 - 49']['70 - 79']++;
                            }
                            else if ($age >=80 && $age <= 89) {
                                $data[$key_global]['gravidade_faixa_etaria']['40 - 49']['80 - 89']++;
                            }
                            else if ($age >=90 && $age <= 99) {
                                $data[$key_global]['gravidade_faixa_etaria']['40 - 49']['90 - 99']++;
                            }
                            else {
                                $data[$key_global]['gravidade_faixa_etaria']['40 - 49']['> 100']++;
                            }

                            if(isset($value->hospitalization->diagnostics)){
                                foreach ($value->hospitalization->diagnostics as $key => $diagnostic) {
                                    if(isset($data[$key_global]['comorbidades']['40 - 49'][count($diagnostic->comorbidities)])){
                                        $count_comorbidities = count($diagnostic->comorbidities);
                                        if($count_comorbidities != 0){
                                            $data[$key_global]['comorbidades']['40 - 49'][$count_comorbidities] = $data[$key_global]['comorbidades']['40 - 49'][$count_comorbidities] + 1 ;
                                        }
                                    }
                                    else{
                                        $data[$key_global]['comorbidades']['40 - 49'][count($diagnostic->comorbidities)] = 1 ;
                                    }
                                }
                            }

                            if(isset($value->hospitalization->discharges)){
                                foreach ($value->hospitalization->discharges as $key => $discharges) {
                                    if($value->hospitalization->status != 'internado' && $discharges['data_saida_unidade'] != ""){
                                        $data_saida_unidade = explode("/", $discharges['data_saida_unidade']);

                                        $data_entrada = new \Datetime($value->hospitalization->date_of_hospitalization->i18nFormat('dd-MM-yyyy'));
                                        $data_saida = new \Datetime($data_saida_unidade[0].'-'.$data_saida_unidade[1].'-'.$data_saida_unidade[2]);

                                        $data_intervalo = $data_saida->diff($data_entrada);

                                        if($data_intervalo->days > 12){
                                            $data[$key_global]['tempo_permanencia']['40 - 49']['> 12 dias']++;
                                        }
                                        else if($data_intervalo->days < 1 ){
                                            $data[$key_global]['tempo_permanencia']['40 - 49']['< 24h']++;
                                        }
                                        else if($data_intervalo->days < 3){
                                            $data[$key_global]['tempo_permanencia']['40 - 49']['< 72h']++;
                                        }

                                    }
                                }
                            }

                            if (isset($value->hospitalization->supportive_measures))
                            {
                                foreach ($value->hospitalization->supportive_measures as $key_suporte => $medida_suporte)
                                {
                                    //echo "<pre>";
                                    //print_r($medida_suporte);
                                    $data[$key_global]['medida_suporte'][$medida_suporte['type']]['40 - 49']++;
                                }
                            }
                        }
                        else if ($probabilidade_obito >=50 && $probabilidade_obito <= 59) {
                            if ($status == 'obito'){
                                $data[$key_global]['obito_alta']['50 - 59']['obito']++;
                            }
                            else if ($status == 'alta') {
                                $data[$key_global]['obito_alta']['50 - 59']['alta']++;
                            }

                            if($age >=0 && $age <= 9){
                                $data[$key_global]['gravidade_faixa_etaria']['50 - 59']['0 - 9']++;
                            }
                            else if($age >=10 && $age <= 19){
                                $data[$key_global]['gravidade_faixa_etaria']['50 - 59']['10 - 19']++;
                            }
                            else if($age >=20 && $age <= 29){
                                $data[$key_global]['gravidade_faixa_etaria']['50 - 59']['20 - 29']++;
                            }
                            else if($age >=30 && $age <= 39){
                                $data[$key_global]['gravidade_faixa_etaria']['50 - 59']['30 - 39']++;
                            }
                            else if ($age >=40 && $age <= 49) {
                                $data[$key_global]['gravidade_faixa_etaria']['50 - 59']['40 - 49']++;
                            }
                            else if ($age >=50 && $age <= 59) {
                                $data[$key_global]['gravidade_faixa_etaria']['50 - 59']['50 - 59']++;
                            }
                            else if ($age >=60 && $age <= 69) {
                                $data[$key_global]['gravidade_faixa_etaria']['50 - 59']['60 - 69']++;
                            }
                            else if ($age >=70 && $age <= 79) {
                                $data[$key_global]['gravidade_faixa_etaria']['50 - 59']['70 - 79']++;
                            }
                            else if ($age >=80 && $age <= 89) {
                                $data[$key_global]['gravidade_faixa_etaria']['50 - 59']['80 - 89']++;
                            }
                            else if ($age >=90 && $age <= 99) {
                                $data[$key_global]['gravidade_faixa_etaria']['50 - 59']['90 - 99']++;
                            }
                            else {
                                $data[$key_global]['gravidade_faixa_etaria']['50 - 59']['> 100']++;
                            }

                            if(isset($value->hospitalization->diagnostics)){
                                foreach ($value->hospitalization->diagnostics as $key => $diagnostic) {
                                    if(isset($data[$key_global]['comorbidades']['50 - 59'][count($diagnostic->comorbidities)])){
                                        $count_comorbidities = count($diagnostic->comorbidities);
                                        if($count_comorbidities != 0){
                                            $data[$key_global]['comorbidades']['50 - 59'][$count_comorbidities] = $data[$key_global]['comorbidades']['50 - 59'][$count_comorbidities] + 1 ;
                                        }
                                    }
                                    else{
                                        $data[$key_global]['comorbidades']['50 - 59'][count($diagnostic->comorbidities)] = 1 ;
                                    }
                                }
                            }

                            if(isset($value->hospitalization->discharges)){
                                foreach ($value->hospitalization->discharges as $key => $discharges) {
                                    if($value->hospitalization->status != 'internado' && $discharges['data_saida_unidade'] != ""){
                                        $data_saida_unidade = explode("/", $discharges['data_saida_unidade']);

                                        $data_entrada = new \Datetime($value->hospitalization->date_of_hospitalization->i18nFormat('dd-MM-yyyy'));
                                        $data_saida = new \Datetime($data_saida_unidade[0].'-'.$data_saida_unidade[1].'-'.$data_saida_unidade[2]);

                                        $data_intervalo = $data_saida->diff($data_entrada);

                                        if($data_intervalo->days > 12){
                                            $data[$key_global]['tempo_permanencia']['50 - 59']['> 12 dias']++;
                                        }
                                        else if($data_intervalo->days < 1 ){
                                            $data[$key_global]['tempo_permanencia']['50 - 59']['< 24h']++;
                                        }
                                        else if($data_intervalo->days < 3){
                                            $data[$key_global]['tempo_permanencia']['50 - 59']['< 72h']++;
                                        }

                                    }
                                }
                            }

                            if (isset($value->hospitalization->supportive_measures))
                            {
                                foreach ($value->hospitalization->supportive_measures as $key_suporte => $medida_suporte)
                                {
                                    //echo "<pre>";
                                    //print_r($medida_suporte);
                                    $data[$key_global]['medida_suporte'][$medida_suporte['type']]['50 - 59']++;
                                }
                            }
                        }
                        else if ($probabilidade_obito >=60 && $probabilidade_obito <= 69) {
                            if ($status == 'obito'){
                                $data[$key_global]['obito_alta']['60 - 69']['obito']++;
                            }
                            else if ($status == 'alta') {
                                $data[$key_global]['obito_alta']['60 - 69']['alta']++;
                            }

                            if($age >=0 && $age <= 9){
                                $data[$key_global]['gravidade_faixa_etaria']['60 - 69']['0 - 9']++;
                            }
                            else if($age >=10 && $age <= 19){
                                $data[$key_global]['gravidade_faixa_etaria']['60 - 69']['10 - 19']++;
                            }
                            else if($age >=20 && $age <= 29){
                                $data[$key_global]['gravidade_faixa_etaria']['60 - 69']['20 - 29']++;
                            }
                            else if($age >=30 && $age <= 39){
                                $data[$key_global]['gravidade_faixa_etaria']['60 - 69']['30 - 39']++;
                            }
                            else if ($age >=40 && $age <= 49) {
                                $data[$key_global]['gravidade_faixa_etaria']['60 - 69']['40 - 49']++;
                            }
                            else if ($age >=50 && $age <= 59) {
                                $data[$key_global]['gravidade_faixa_etaria']['60 - 69']['50 - 59']++;
                            }
                            else if ($age >=60 && $age <= 69) {
                                $data[$key_global]['gravidade_faixa_etaria']['60 - 69']['60 - 69']++;
                            }
                            else if ($age >=70 && $age <= 79) {
                                $data[$key_global]['gravidade_faixa_etaria']['60 - 69']['70 - 79']++;
                            }
                            else if ($age >=80 && $age <= 89) {
                                $data[$key_global]['gravidade_faixa_etaria']['60 - 69']['80 - 89']++;
                            }
                            else if ($age >=90 && $age <= 99) {
                                $data[$key_global]['gravidade_faixa_etaria']['60 - 69']['90 - 99']++;
                            }
                            else {
                                $data[$key_global]['gravidade_faixa_etaria']['60 - 69']['> 100']++;
                            }

                            if(isset($value->hospitalization->diagnostics)){
                                foreach ($value->hospitalization->diagnostics as $key => $diagnostic) {
                                    if(isset($data[$key_global]['comorbidades']['60 - 69'][count($diagnostic->comorbidities)])){
                                        $count_comorbidities = count($diagnostic->comorbidities);
                                        if($count_comorbidities != 0){
                                            $data[$key_global]['comorbidades']['60 - 69'][$count_comorbidities] = $data[$key_global]['comorbidades']['60 - 69'][$count_comorbidities] + 1 ;
                                        }
                                    }
                                    else{
                                        $data[$key_global]['comorbidades']['60 - 69'][count($diagnostic->comorbidities)] = 1 ;
                                    }
                                }
                            }

                            if(isset($value->hospitalization->discharges)){
                                foreach ($value->hospitalization->discharges as $key => $discharges) {
                                    if($value->hospitalization->status != 'internado' && $discharges['data_saida_unidade'] != ""){
                                        $data_saida_unidade = explode("/", $discharges['data_saida_unidade']);

                                        $data_entrada = new \Datetime($value->hospitalization->date_of_hospitalization->i18nFormat('dd-MM-yyyy'));
                                        $data_saida = new \Datetime($data_saida_unidade[0].'-'.$data_saida_unidade[1].'-'.$data_saida_unidade[2]);

                                        $data_intervalo = $data_saida->diff($data_entrada);

                                        if($data_intervalo->days > 12){
                                            $data[$key_global]['tempo_permanencia']['60 - 69']['> 12 dias']++;
                                        }
                                        else if($data_intervalo->days < 1 ){
                                            $data[$key_global]['tempo_permanencia']['60 - 69']['< 24h']++;
                                        }
                                        else if($data_intervalo->days < 3){
                                            $data[$key_global]['tempo_permanencia']['60 - 69']['< 72h']++;
                                        }

                                    }
                                }
                            }

                            if (isset($value->hospitalization->supportive_measures))
                            {
                                foreach ($value->hospitalization->supportive_measures as $key_suporte => $medida_suporte)
                                {
                                    //echo "<pre>";
                                    //print_r($medida_suporte);
                                    $data[$key_global]['medida_suporte'][$medida_suporte['type']]['60 - 69']++;
                                }
                            }
                        }
                        else if ($probabilidade_obito >=70 && $probabilidade_obito <= 79) {
                            if ($status == 'obito'){
                                $data[$key_global]['obito_alta']['70 - 79']['obito']++;
                            }
                            else if ($status == 'alta') {
                                $data[$key_global]['obito_alta']['70 - 79']['alta']++;
                            }

                            if($age >=0 && $age <= 9){
                                $data[$key_global]['gravidade_faixa_etaria']['70 - 79']['0 - 9']++;
                            }
                            else if($age >=10 && $age <= 19){
                                $data[$key_global]['gravidade_faixa_etaria']['70 - 79']['10 - 19']++;
                            }
                            else if($age >=20 && $age <= 29){
                                $data[$key_global]['gravidade_faixa_etaria']['70 - 79']['20 - 29']++;
                            }
                            else if($age >=30 && $age <= 39){
                                $data[$key_global]['gravidade_faixa_etaria']['70 - 79']['30 - 39']++;
                            }
                            else if ($age >=40 && $age <= 49) {
                                $data[$key_global]['gravidade_faixa_etaria']['70 - 79']['40 - 49']++;
                            }
                            else if ($age >=50 && $age <= 59) {
                                $data[$key_global]['gravidade_faixa_etaria']['70 - 79']['50 - 59']++;
                            }
                            else if ($age >=60 && $age <= 69) {
                                $data[$key_global]['gravidade_faixa_etaria']['70 - 79']['60 - 69']++;
                            }
                            else if ($age >=70 && $age <= 79) {
                                $data[$key_global]['gravidade_faixa_etaria']['70 - 79']['70 - 79']++;
                            }
                            else if ($age >=80 && $age <= 89) {
                                $data[$key_global]['gravidade_faixa_etaria']['70 - 79']['80 - 89']++;
                            }
                            else if ($age >=90 && $age <= 99) {
                                $data[$key_global]['gravidade_faixa_etaria']['70 - 79']['90 - 99']++;
                            }
                            else {
                                $data[$key_global]['gravidade_faixa_etaria']['70 - 79']['> 100']++;
                            }

                            if(isset($value->hospitalization->diagnostics)){
                                foreach ($value->hospitalization->diagnostics as $key => $diagnostic) {
                                    if(isset($data[$key_global]['comorbidades']['70 - 79'][count($diagnostic->comorbidities)])){
                                        $count_comorbidities = count($diagnostic->comorbidities);
                                        if($count_comorbidities != 0){
                                            $data[$key_global]['comorbidades']['70 - 79'][$count_comorbidities] = $data[$key_global]['comorbidades']['70 - 79'][$count_comorbidities] + 1 ;
                                        }
                                    }
                                    else{
                                        $data[$key_global]['comorbidades']['70 - 79'][count($diagnostic->comorbidities)] = 1 ;
                                    }
                                }
                            }

                            if(isset($value->hospitalization->discharges)){
                                foreach ($value->hospitalization->discharges as $key => $discharges) {
                                    if($value->hospitalization->status != 'internado' && $discharges['data_saida_unidade'] != ""){
                                        $data_saida_unidade = explode("/", $discharges['data_saida_unidade']);

                                        $data_entrada = new \Datetime($value->hospitalization->date_of_hospitalization->i18nFormat('dd-MM-yyyy'));
                                        $data_saida = new \Datetime($data_saida_unidade[0].'-'.$data_saida_unidade[1].'-'.$data_saida_unidade[2]);

                                        $data_intervalo = $data_saida->diff($data_entrada);

                                        if($data_intervalo->days > 12){
                                            $data[$key_global]['tempo_permanencia']['70 - 79']['> 12 dias']++;
                                        }
                                        else if($data_intervalo->days < 1 ){
                                            $data[$key_global]['tempo_permanencia']['70 - 79']['< 24h']++;
                                        }
                                        else if($data_intervalo->days < 3){
                                            $data[$key_global]['tempo_permanencia']['70 - 79']['< 72h']++;
                                        }

                                    }
                                }
                            }

                            if (isset($value->hospitalization->supportive_measures))
                            {
                                foreach ($value->hospitalization->supportive_measures as $key_suporte => $medida_suporte)
                                {
                                    //echo "<pre>";
                                    //print_r($medida_suporte);
                                    $data[$key_global]['medida_suporte'][$medida_suporte['type']]['70 - 79']++;
                                }
                            }
                        }
                        else if ($probabilidade_obito >=80 && $probabilidade_obito <= 89) {
                            if ($status == 'obito'){
                                $data[$key_global]['obito_alta']['80 - 89']['obito']++;
                            }
                            else if ($status == 'alta') {
                                $data[$key_global]['obito_alta']['80 - 89']['alta']++;
                            }

                            if($age >=0 && $age <= 9){
                                $data[$key_global]['gravidade_faixa_etaria']['80 - 89']['0 - 9']++;
                            }
                            else if($age >=10 && $age <= 19){
                                $data[$key_global]['gravidade_faixa_etaria']['80 - 89']['10 - 19']++;
                            }
                            else if($age >=20 && $age <= 29){
                                $data[$key_global]['gravidade_faixa_etaria']['80 - 89']['20 - 29']++;
                            }
                            else if($age >=30 && $age <= 39){
                                $data[$key_global]['gravidade_faixa_etaria']['80 - 89']['30 - 39']++;
                            }
                            else if ($age >=40 && $age <= 49) {
                                $data[$key_global]['gravidade_faixa_etaria']['80 - 89']['40 - 49']++;
                            }
                            else if ($age >=50 && $age <= 59) {
                                $data[$key_global]['gravidade_faixa_etaria']['80 - 89']['50 - 59']++;
                            }
                            else if ($age >=60 && $age <= 69) {
                                $data[$key_global]['gravidade_faixa_etaria']['80 - 89']['60 - 69']++;
                            }
                            else if ($age >=70 && $age <= 79) {
                                $data[$key_global]['gravidade_faixa_etaria']['80 - 89']['70 - 79']++;
                            }
                            else if ($age >=80 && $age <= 89) {
                                $data[$key_global]['gravidade_faixa_etaria']['80 - 89']['80 - 89']++;
                            }
                            else if ($age >=90 && $age <= 99) {
                                $data[$key_global]['gravidade_faixa_etaria']['80 - 89']['90 - 99']++;
                            }
                            else {
                                $data[$key_global]['gravidade_faixa_etaria']['80 - 89']['> 100']++;
                            }

                            if(isset($value->hospitalization->diagnostics)){
                                foreach ($value->hospitalization->diagnostics as $key => $diagnostic) {
                                    if(isset($data[$key_global]['comorbidades']['80 - 89'][count($diagnostic->comorbidities)])){
                                        $count_comorbidities = count($diagnostic->comorbidities);
                                        if($count_comorbidities != 0){
                                            $data[$key_global]['comorbidades']['80 - 89'][$count_comorbidities] = $data[$key_global]['comorbidades']['80 - 89'][$count_comorbidities] + 1 ;
                                        }
                                    }
                                    else{
                                        $data[$key_global]['comorbidades']['80 - 89'][count($diagnostic->comorbidities)] = 1 ;
                                    }
                                }
                            }

                            if(isset($value->hospitalization->discharges)){
                                foreach ($value->hospitalization->discharges as $key => $discharges) {
                                    if($value->hospitalization->status != 'internado' && $discharges['data_saida_unidade'] != ""){
                                        $data_saida_unidade = explode("/", $discharges['data_saida_unidade']);

                                        $data_entrada = new \Datetime($value->hospitalization->date_of_hospitalization->i18nFormat('dd-MM-yyyy'));
                                        $data_saida = new \Datetime($data_saida_unidade[0].'-'.$data_saida_unidade[1].'-'.$data_saida_unidade[2]);

                                        $data_intervalo = $data_saida->diff($data_entrada);

                                        if($data_intervalo->days > 12){
                                            $data[$key_global]['tempo_permanencia']['80 - 89']['> 12 dias']++;
                                        }
                                        else if($data_intervalo->days < 1 ){
                                            $data[$key_global]['tempo_permanencia']['80 - 89']['< 24h']++;
                                        }
                                        else if($data_intervalo->days < 3){
                                            $data[$key_global]['tempo_permanencia']['80 - 89']['< 72h']++;
                                        }

                                    }
                                }
                            }

                            if (isset($value->hospitalization->supportive_measures))
                            {
                                foreach ($value->hospitalization->supportive_measures as $key_suporte => $medida_suporte)
                                {
                                    //echo "<pre>";
                                    //print_r($medida_suporte);
                                    $data[$key_global]['medida_suporte'][$medida_suporte['type']]['80 - 89']++;
                                }
                            }
                        }
                        else if ($probabilidade_obito >=90 && $probabilidade_obito <= 100) {
                            if ($status == 'obito'){
                                $data[$key_global]['obito_alta']['90 - 100']['obito']++;
                            }
                            else if ($status == 'alta') {
                                $data[$key_global]['obito_alta']['90 - 100']['alta']++;
                            }

                            if($age >=0 && $age <= 9){
                                $data[$key_global]['gravidade_faixa_etaria']['90 - 100']['0 - 9']++;
                            }
                            else if($age >=10 && $age <= 19){
                                $data[$key_global]['gravidade_faixa_etaria']['90 - 100']['10 - 19']++;
                            }
                            else if($age >=20 && $age <= 29){
                                $data[$key_global]['gravidade_faixa_etaria']['90 - 100']['20 - 29']++;
                            }
                            else if($age >=30 && $age <= 39){
                                $data[$key_global]['gravidade_faixa_etaria']['90 - 100']['30 - 39']++;
                            }
                            else if ($age >=40 && $age <= 49) {
                                $data[$key_global]['gravidade_faixa_etaria']['90 - 100']['40 - 49']++;
                            }
                            else if ($age >=50 && $age <= 59) {
                                $data[$key_global]['gravidade_faixa_etaria']['90 - 100']['50 - 59']++;
                            }
                            else if ($age >=60 && $age <= 69) {
                                $data[$key_global]['gravidade_faixa_etaria']['90 - 100']['60 - 69']++;
                            }
                            else if ($age >=70 && $age <= 79) {
                                $data[$key_global]['gravidade_faixa_etaria']['90 - 100']['70 - 79']++;
                            }
                            else if ($age >=80 && $age <= 89) {
                                $data[$key_global]['gravidade_faixa_etaria']['90 - 100']['80 - 89']++;
                            }
                            else if ($age >=90 && $age <= 99) {
                                $data[$key_global]['gravidade_faixa_etaria']['90 - 100']['90 - 99']++;
                            }
                            else {
                                $data[$key_global]['gravidade_faixa_etaria']['90 - 100']['> 100']++;
                            }

                            if(isset($value->hospitalization->diagnostics)){
                                foreach ($value->hospitalization->diagnostics as $key => $diagnostic) {
                                    if(isset($data[$key_global]['comorbidades']['90 - 100'][count($diagnostic->comorbidities)])){
                                        $count_comorbidities = count($diagnostic->comorbidities);
                                        if($count_comorbidities != 0){
                                            $data[$key_global]['comorbidades']['90 - 100'][$count_comorbidities] = $data[$key_global]['comorbidades']['90 - 100'][$count_comorbidities] + 1 ;
                                        }
                                    }
                                    else{
                                        $data[$key_global]['comorbidades']['90 - 100'][count($diagnostic->comorbidities)] = 1 ;
                                    }
                                }
                            }

                            if(isset($value->hospitalization->discharges)){
                                foreach ($value->hospitalization->discharges as $key => $discharges) {
                                    if($value->hospitalization->status != 'internado' && $discharges['data_saida_unidade'] != ""){
                                        $data_saida_unidade = explode("/", $discharges['data_saida_unidade']);

                                        $data_entrada = new \Datetime($value->hospitalization->date_of_hospitalization->i18nFormat('dd-MM-yyyy'));
                                        $data_saida = new \Datetime($data_saida_unidade[0].'-'.$data_saida_unidade[1].'-'.$data_saida_unidade[2]);

                                        $data_intervalo = $data_saida->diff($data_entrada);

                                        if($data_intervalo->days > 12){
                                            $data[$key_global]['tempo_permanencia']['90 - 100']['> 12 dias']++;
                                        }
                                        else if($data_intervalo->days < 1 ){
                                            $data[$key_global]['tempo_permanencia']['90 - 100']['< 24h']++;
                                        }
                                        else if($data_intervalo->days < 3){
                                            $data[$key_global]['tempo_permanencia']['90 - 100']['< 72h']++;
                                        }

                                    }
                                }
                            }
                            if (isset($value->hospitalization->supportive_measures))
                            {
                                foreach ($value->hospitalization->supportive_measures as $key_suporte => $medida_suporte)
                                {
                                    //echo "<pre>";
                                    //print_r($medida_suporte);
                                    $data[$key_global]['medida_suporte'][$medida_suporte['type']]['90 - 100']++;
                                }
                            }
                        }
                    }
                }

                if ($value->pontuation)
                {
                    $total_score += $value->pontuation;

                    if ($value->pontuation > $data[$key_global]['maximo_score'])
                    {
                        $data[$key_global]['maximo_score'] = $value->pontuation;
                    }

                    array_push($data[$key_global]['escore']['valores'], $total_score);



                    switch ($key_global)
                    {
                        case 'curb':
                            if ($value->pontuation > 2)
                            {
                                $data[$key_global]['total_superior_2']++;
                            }
                            else if ($value->pontuation > 3)
                            {
                                $data[$key_global]['total_superior_3']++;
                            }
                            else if ($value->pontuation > 4)
                            {
                                $data[$key_global]['total_superior_4']++;
                            }
                            break;

                        case 'apache':
                            array_push($data[$key_global]['taxa_letalidade_america_latina']['arr_probabilidade_obito'], $value->probabilidade_de_obito);
                            //maximo

                            if($value->hospitalization->status == 'obito'){
                                $data[$key_global]['total_pacientes_obito']++;
                            }

                            if($data[$key_global]['taxa_letalidade_america_latina']['maximo'] < $value->probabilidade_de_obito){
                                $data[$key_global]['taxa_letalidade_america_latina']['maximo'] = $value->probabilidade_de_obito;
                            }

                            if ($value->probabilidade_de_obito > 40)
                            {
                                array_push($data[$key_global]['probabilidade_de_obito_acima_40']['arr_probabilidade_obito'], $value->probabilidade_de_obito);
                            }
                            break;

                        case 'saps':
                            array_push($data[$key_global]['taxa_letalidade'], $value->probabilidade_de_obito);
                            if ($value->probabilidade_de_obito > 40)
                            {
                                array_push($data[$key_global]['probabilidade_de_obito_acima_40']['arr_probabilidade_obito'], $value->probabilidade_de_obito);
                            }
                            break;

                        case 'pre_deliric':
                            //echo $value->pontuation . "<br>";
                            if ($value->pontuation > 40)
                            {
                                if (!in_array($value->hospitalization->patient_id, $data['pre_deliric']['probabilidade_de_obito_acima_40']['arr_probabilidade_obito']))
                                {
                                    array_push($data['pre_deliric']['probabilidade_de_obito_acima_40']['arr_probabilidade_obito'], $value->hospitalization->patient_id);
                                    //$data[$key_global]['total_pacientes']++;
                                }
                            }
                            break;

                        case 'sofa':

                            if(isset($value->pontuation)){
                                $data['sofa']['pacientes_aumento']['arr_pacientes_aumento']['pontuacao'][$value->hospitalization->patient_id][] = $value->pontuation;
                            }
                            break;

                        case 'nas':
                                $data['nas']['pacientes_superior_25_pontos']['arr_pacientes_superior_25_pontos']['pontuacao'][$value->hospitalization->patient_id][] = $value->pontuation;
                            break;

                        case 'crib':

                            //echo $value->pontuation. "<br>";
                            $pontuacao = $value->pontuation;
                            if( $pontuacao > 5){
                                if (!in_array($value->hospitalization->patient_id, $data['crib']['probabilidade_de_obito_acima_40']['arr_probabilidade_obito']))
                                {
                                    array_push($data['crib']['probabilidade_de_obito_acima_40']['arr_probabilidade_obito'], $value->hospitalization->patient_id);
                                    //$data[$key_global]['total_pacientes']++;
                                }

                                if($data[$key_global]['taxa_letalidade']['maximo'] < $value->probabilidade_obito){
                                    $data[$key_global]['taxa_letalidade']['maximo'] = $value->probabilidade_obito;
                                }
                                array_push($data[$key_global]['taxa_letalidade']['arr_probabilidade_obito'], $value->probabilidade_obito);

                                if($value->hospitalization->status == 'obito'){
                                $data[$key_global]['total_pacientes_obito']++;
                            }
                            }
                            break;


                        case 'snap':
                            array_push($data[$key_global]['taxa_letalidade']['arr_probabilidade_obito'], $value->probabilidade_obito_snap);
                            if($value->hospitalization->status == 'obito'){
                                $data[$key_global]['total_pacientes_obito']++;
                            }

                            if($data[$key_global]['taxa_letalidade']['maximo'] < $value->probabilidade_obito_snap){
                                $data[$key_global]['taxa_letalidade']['maximo'] = $value->probabilidade_obito_snap;
                            }
                            break;



                    }
                }

                if (!in_array($value->hospitalization->patient_id, $pacient_ids[$key_global]))
                {
                    array_push($pacient_ids[$key_global], $value->hospitalization->patient_id);
                    $data[$key_global]['total_pacientes']++;
                }
                $count++;
            }
        }

        $first = false;
        foreach ($data as $key => $value)
        {
            if (isset($data[$key]['percentual_pacientes']))
            {
                $data[$key]['percentual_pacientes'] = ($data[$key]['total_pacientes'] / $data['total_pacientes']) * 100;
            }

            if ($first)
            {
                $data[$key]['escore']['mediana'] = $calc_obj->calculate_median($value['escore']['valores']);
                $data[$key]['escore']['media'] = $calc_obj->calc_average($value['escore']['valores']);
                $data[$key]['escore']['desvio_padrao'] = $calc_obj->standard_deviation($value['escore']['valores']);
                if(count($value['escore']['valores']) > 0){
                    $data[$key]['minimo_score'] = min($value['escore']['valores']);
                }
            }

            $first = true;
            if($key == 'apache'){
                $data[$key]['taxa_letalidade_america_latina']['mediana'] = $calc_obj->calculate_median($value['taxa_letalidade_america_latina']['arr_probabilidade_obito']);
                $data[$key]['taxa_letalidade_america_latina']['media'] = $calc_obj->calc_average($value['taxa_letalidade_america_latina']['arr_probabilidade_obito']);
                $data[$key]['taxa_letalidade_america_latina']['desvio_padrao'] = $calc_obj->standard_deviation($value['taxa_letalidade_america_latina']['arr_probabilidade_obito']);
                if(count($value['taxa_letalidade_america_latina']['arr_probabilidade_obito']) > 0){
                    $data[$key]['taxa_letalidade_america_latina']['minimo'] = min($value['taxa_letalidade_america_latina']['arr_probabilidade_obito']);
                }

                //$data[$key]['taxa_letalidade']['taxa'] = $data[$key]['total_pacientes_obito'] /
                if($data[$key]['total_pacientes'] > 0){
                    $percentual_obito = ($data[$key]['total_pacientes_obito'] * 100) / $data[$key]['total_pacientes'];
                    $data[$key]['taxa_letalidade_america_latina']['taxa'] = round($percentual_obito / $data[$key]['taxa_letalidade_america_latina']['media'], 2);
                }

            }

            if($key == 'pre_deliric'){
                $data[$key]['probabilidade_de_obito_acima_40']['total'] = count($data['pre_deliric']['probabilidade_de_obito_acima_40']['arr_probabilidade_obito']);
                if($data[$key]['total_pacientes'] > 0){
                    $percentual = ($data[$key]['probabilidade_de_obito_acima_40']['total'] * 100) / $data[$key]['total_pacientes'];
                    $data[$key]['probabilidade_de_obito_acima_40']['percentual'] = round(($percentual), 2);
                }
            }

            if($key == 'sofa'){
                foreach ($value['pacientes_aumento']['arr_pacientes_aumento']['pontuacao'] as $key => $pontuacao_paciente) {
                    $pontuacao_anterior = 0;
                    $pontuacao_atual = 0;
                    foreach ($pontuacao_paciente as $key_pontuacao => $pontuacao) {
                        if($key_pontuacao == 0){
                            $pontuacao_anterior = $pontuacao;
                        }
                        else{
                            $pontuacao_atual = $pontuacao;

                            $diferenca = $pontuacao_atual - $pontuacao_anterior;
                            if($diferenca >= 2){
                                $data['sofa']['pacientes_aumento']['total']++;
                                break;
                            }
                            $pontuacao_anterior = $pontuacao_atual;
                        }
                    }
                }

                if($data['sofa']['total_pacientes'] > 0){
                    $percente = ($data['sofa']['pacientes_aumento']['total'] * 100) / $data['sofa']['total_pacientes'];
                    $data['sofa']['pacientes_aumento']['percentual'] = round($percente, 2);
                }
            }

            if($key == 'nas'){
                foreach ($value['pacientes_superior_25_pontos']['arr_pacientes_superior_25_pontos']['pontuacao'] as $key => $pontuacao_paciente) {
                    foreach ($pontuacao_paciente as $key_pontuacao => $pontuacao) {
                        if($pontuacao > 25){
                            $data['nas']['pacientes_superior_25_pontos']['total']++;
                            break;
                        }
                    }
                }

                if($data['nas']['total_pacientes'] > 0){
                    $percente = ($data['nas']['pacientes_superior_25_pontos']['total'] * 100) / $data['nas']['total_pacientes'];
                    $data['nas']['pacientes_superior_25_pontos']['percentual'] = round($percente, 2);
                }
            }

            if($key == 'crib'){
                $data[$key]['probabilidade_de_obito_acima_40']['total'] = count($data[$key]['probabilidade_de_obito_acima_40']['arr_probabilidade_obito']);
                if($data[$key]['total_pacientes'] > 0){
                    $percentual = ($data[$key]['probabilidade_de_obito_acima_40']['total'] * 100) / $data[$key]['total_pacientes'];
                    $data[$key]['probabilidade_de_obito_acima_40']['percentual'] = round(($percentual), 2);
                }

                $data[$key]['taxa_letalidade']['mediana'] = $calc_obj->calculate_median($value['taxa_letalidade']['arr_probabilidade_obito']);
                $data[$key]['taxa_letalidade']['media'] = $calc_obj->calc_average($value['taxa_letalidade']['arr_probabilidade_obito']);
                $data[$key]['taxa_letalidade']['desvio_padrao'] = $calc_obj->standard_deviation($value['taxa_letalidade']['arr_probabilidade_obito']);
                if(count($value['taxa_letalidade']['arr_probabilidade_obito']) > 0){
                    $data[$key]['taxa_letalidade']['minimo'] = min($value['taxa_letalidade']['arr_probabilidade_obito']);
                }

                if($data[$key]['total_pacientes'] > 0 && $data[$key]['taxa_letalidade']['media'] > 0){
                    $percentual_obito = ($data[$key]['total_pacientes_obito'] * 100) / $data[$key]['total_pacientes'];
                    $data[$key]['taxa_letalidade']['taxa'] = round($percentual_obito / $data[$key]['taxa_letalidade']['media'], 2);
                }
            }

            if($key == 'snap'){
                $data[$key]['taxa_letalidade']['mediana'] = $calc_obj->calculate_median($value['taxa_letalidade']['arr_probabilidade_obito']);
                $data[$key]['taxa_letalidade']['media'] = $calc_obj->calc_average($value['taxa_letalidade']['arr_probabilidade_obito']);
                $data[$key]['taxa_letalidade']['desvio_padrao'] = $calc_obj->standard_deviation($value['taxa_letalidade']['arr_probabilidade_obito']);
                if(count($value['taxa_letalidade']['arr_probabilidade_obito']) > 0){
                    $data[$key]['taxa_letalidade']['minimo'] = min($value['taxa_letalidade']['arr_probabilidade_obito']);
                }

                if($data[$key]['total_pacientes'] > 0){
                    $percentual_obito = ($data[$key]['total_pacientes_obito'] * 100) / $data[$key]['total_pacientes'];
                    $data[$key]['taxa_letalidade']['taxa'] = round($percentual_obito / $data[$key]['taxa_letalidade']['media'], 2);
                }
            }
        }

        //$data['$pacient_ids'] = $pacient_ids;

        //curb

        // $curb = $curb_scores_table

        //     ->find('all', [

        //         'contain'    => ['Hospitalizations'],

        //         'conditions' =>

        //         [

        //             'CurbScores.hospitalization_id in ' => $hospitalization_ids,

        //             'CurbScores.created >'              => $date_before,

        //             'CurbScores.created < '             => $date_after,

        //         ],

        //     ])->toArray();

        // $count_curb = 0;

        // $len        = count($curb);

        // foreach ($curb as $key => $value) {

        //     $total_score = 0;

        //     $total_superior_2 = 0;

        //     $total_superior_3 = 0;

        //     $total_superior_4 = 0;

        //     if ($value->pontuation) {

        //         $total_score += $value->pontuation;

        //         if ($value->pontuation < $data['curb']['minimo_score']) {

        //             $data['curb']['minimo_score'] = $value->pontuation;

        //         }

        //         if ($value->pontuation > $data['curb']['maximo_score']) {

        //             $data['curb']['maximo_score'] = $value->pontuation;

        //         }

        //         if ($value->pontuation > 4) {

        //             $total_superior_4++;

        //         } else if ($value->pontuation > 3) {

        //             $total_superior_3++;

        //         } else if ($value->pontuation > 2) {

        //             $total_superior_2++;

        //         }

        //     }

        //     if (!in_array($value->hospitalization->patient_id, $pacient_ids['curb'])) {

        //         array_push($pacient_ids['curb'], $value->hospitalization->patient_id);

        //         $data['curb']['total_pacientes']++;

        //     }

        //     if ($count_curb == $len - 1) {

        //         // last

        //         $data['curb']['media_score'] = $total_score / $count_curb;

        //         //$data['curb']['total_score'] = $total_score;

        //         if ($count_curb > 0) {

        //             if ($total_superior_2 > 0) {

        //                 $data['curb']['total_superior_2']      = $total_superior_2;

        //                 $data['curb']['percentual_superior_2'] = ($total_superior_2 / $count_curb) * 100;

        //             }

        //             if ($total_superior_3 > 0) {

        //                 $data['curb']['total_superior_3']      = $total_superior_3;

        //                 $data['curb']['percentual_superior_3'] = ($total_superior_3 / $count_curb) * 100;

        //             }

        //             if ($total_superior_4 > 0) {

        //                 $data['curb']['total_superior_4']      = $total_superior_4;

        //                 $data['curb']['percentual_superior_4'] = ($total_superior_4 / $count_curb) * 100;

        //             }

        //         }

        //     }

        //     $count_curb++;

        // }

        //sofa

        // $len        = count($sofa);

        // $count_sofa = 0;

        // $sofa       = $sofa_scores_table

        //     ->find('all', [

        //         'contain'    => ['Hospitalizations'],

        //         'conditions' =>

        //         [

        //             'SofaEscores.hospitalization_id in ' => $hospitalization_ids,

        //             'SofaEscores.created >'              => $date_before,

        //             'SofaEscores.created < '             => $date_after,

        //         ],

        //     ])->toArray();

        // foreach ($sofa as $key => $value) {

        //     $total_score      = 0;

        //     $total_superior_2 = 0;

        //     if ($value->pontuation) {

        //         $total_score += $value->pontuation;

        //         if ($value->pontuation < $data['sofa']['minimo_score']) {

        //             $data['sofa']['minimo_score'] = $value->pontuation;

        //         }

        //         if ($value->pontuation > $data['sofa']['maximo_score']) {

        //             $data['sofa']['maximo_score'] = $value->pontuation;

        //         }

        //         if ($value->pontuation > 4) {

        //             $total_superior_4++;

        //         } else if ($value->pontuation > 3) {

        //             $total_superior_3++;

        //         } else if ($value->pontuation > 2) {

        //             $total_superior_2++;

        //         }

        //     }

        //     if (!in_array($value->hospitalization->patient_id, $pacient_ids['sofa'])) {

        //         array_push($pacient_ids['sofa'], $value->hospitalization->patient_id);

        //         $data['sofa']['total_pacientes']++;

        //     }

        //     if ($count_sofa == $len - 1) {

        //         // last

        //         $data['sofa']['media_score'] = $total_score / $count_sofa;

        //         //$data['curb']['total_score'] = $total_score;

        //         if ($count_sofa > 0) {

        //             if ($total_superior_2 >= 0) {

        //                 $data['sofa']['total_superior_2']      = $total_superior_2;

        //                 $data['sofa']['percentual_superior_2'] = ($total_superior_2 / $count_sofa) * 100;

        //             }

        //         }

        //     }

        //     $count_sofa++;

        // }

        return $data;
    }

    /**
     * Returns a rules checker object that will be used for validating
     * application integrity.
     *
     * @param \Cake\ORM\RulesChecker $rules The rules object to be modified.
     * @return \Cake\ORM\RulesChecker
     */
    public function buildRules(RulesChecker $rules)
    {
        $rules->add($rules->existsIn(['hospitalization_id'], 'Hospitalizations'));
        return $rules;
    }
}
